/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.digest;

import com.sun.security.sasl.digest.DigestMD5Base;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class DigestMD5Client
extends DigestMD5Base
implements SaslClient {
    private static final String MY_CLASS_NAME = DigestMD5Client.class.getName();
    private static final String CIPHER_PROPERTY = "com.sun.security.sasl.digest.cipher";
    private static final String[] DIRECTIVE_KEY = new String[]{"realm", "qop", "algorithm", "nonce", "maxbuf", "charset", "cipher", "rspauth", "stale"};
    private static final int REALM = 0;
    private static final int QOP = 1;
    private static final int ALGORITHM = 2;
    private static final int NONCE = 3;
    private static final int MAXBUF = 4;
    private static final int CHARSET = 5;
    private static final int CIPHER = 6;
    private static final int RESPONSE_AUTH = 7;
    private static final int STALE = 8;
    private int nonceCount;
    private String specifiedCipher;
    private byte[] cnonce;
    private String username;
    private char[] passwd;
    private byte[] authzidBytes;

    DigestMD5Client(String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        super(map, MY_CLASS_NAME, 2, string2 + "/" + string3, callbackHandler);
        if (string != null) {
            this.authzid = string;
            try {
                this.authzidBytes = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SaslException("DIGEST-MD5: Error encoding authzid value into UTF-8", unsupportedEncodingException);
            }
        }
        if (map != null) {
            this.specifiedCipher = (String)map.get(CIPHER_PROPERTY);
            logger.log(Level.FINE, "DIGEST60:Explicitly specified cipher: {0}", this.specifiedCipher);
        }
    }

    @Override
    public boolean hasInitialResponse() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (byArray.length > 2048) {
            throw new SaslException("DIGEST-MD5: Invalid digest-challenge length. Got:  " + byArray.length + " Expected < " + 2048);
        }
        switch (this.step) {
            case 2: {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>(3);
                byte[][] byArray2 = DigestMD5Client.parseDirectives(byArray, DIRECTIVE_KEY, arrayList, 0);
                try {
                    this.processChallenge(byArray2, arrayList);
                    this.checkQopSupport(byArray2[1], byArray2[6]);
                    ++this.step;
                    return this.generateClientResponse(byArray2[5]);
                }
                catch (SaslException saslException) {
                    this.step = 0;
                    this.clearPassword();
                    throw saslException;
                }
                catch (IOException iOException) {
                    this.step = 0;
                    this.clearPassword();
                    throw new SaslException("DIGEST-MD5: Error generating digest response-value", iOException);
                }
            }
            case 3: {
                try {
                    byte[][] byArray3 = DigestMD5Client.parseDirectives(byArray, DIRECTIVE_KEY, null, 0);
                    this.validateResponseValue(byArray3[7]);
                    if (this.integrity && this.privacy) {
                        this.secCtx = new DigestMD5Base.DigestPrivacy(true);
                    } else if (this.integrity) {
                        this.secCtx = new DigestMD5Base.DigestIntegrity(true);
                    }
                    byte[] byArray4 = null;
                    return byArray4;
                }
                finally {
                    this.clearPassword();
                    this.step = 0;
                    this.completed = true;
                }
            }
        }
        throw new SaslException("DIGEST-MD5: Client at illegal state");
    }

    private void processChallenge(byte[][] byArray, List<byte[]> list) throws SaslException, UnsupportedEncodingException {
        if (byArray[5] != null) {
            if (!"utf-8".equals(new String(byArray[5], this.encoding))) {
                throw new SaslException("DIGEST-MD5: digest-challenge format violation. Unrecognised charset value: " + new String(byArray[5]));
            }
            this.encoding = "UTF8";
            this.useUTF8 = true;
        }
        if (byArray[2] == null) {
            throw new SaslException("DIGEST-MD5: Digest-challenge format violation: algorithm directive missing");
        }
        if (!"md5-sess".equals(new String(byArray[2], this.encoding))) {
            throw new SaslException("DIGEST-MD5: Digest-challenge format violation. Invalid value for 'algorithm' directive: " + byArray[2]);
        }
        if (byArray[3] == null) {
            throw new SaslException("DIGEST-MD5: Digest-challenge format violation: nonce directive missing");
        }
        this.nonce = byArray[3];
        try {
            String[] stringArray = null;
            if (byArray[0] != null) {
                if (list == null || list.size() <= 1) {
                    this.negotiatedRealm = new String(byArray[0], this.encoding);
                } else {
                    stringArray = new String[list.size()];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = new String(list.get(i), this.encoding);
                    }
                }
            }
            NameCallback nameCallback = this.authzid == null ? new NameCallback("DIGEST-MD5 authentication ID: ") : new NameCallback("DIGEST-MD5 authentication ID: ", this.authzid);
            PasswordCallback passwordCallback = new PasswordCallback("DIGEST-MD5 password: ", false);
            if (stringArray == null) {
                RealmCallback realmCallback = this.negotiatedRealm == null ? new RealmCallback("DIGEST-MD5 realm: ") : new RealmCallback("DIGEST-MD5 realm: ", this.negotiatedRealm);
                this.cbh.handle(new Callback[]{realmCallback, nameCallback, passwordCallback});
                this.negotiatedRealm = realmCallback.getText();
                if (this.negotiatedRealm == null) {
                    this.negotiatedRealm = "";
                }
            } else {
                RealmChoiceCallback realmChoiceCallback = new RealmChoiceCallback("DIGEST-MD5 realm: ", stringArray, 0, false);
                this.cbh.handle(new Callback[]{realmChoiceCallback, nameCallback, passwordCallback});
                this.negotiatedRealm = stringArray[realmChoiceCallback.getSelectedIndexes()[0]];
            }
            this.passwd = passwordCallback.getPassword();
            passwordCallback.clearPassword();
            this.username = nameCallback.getName();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("DIGEST-MD5: Cannot perform callback to acquire realm, authentication ID or password", unsupportedCallbackException);
        }
        catch (IOException iOException) {
            throw new SaslException("DIGEST-MD5: Error acquiring realm, authentication ID or password", iOException);
        }
        if (this.username == null || this.passwd == null) {
            throw new SaslException("DIGEST-MD5: authentication ID and password must be specified");
        }
        int n = byArray[4] == null ? 65536 : Integer.parseInt(new String(byArray[4], this.encoding));
        this.sendMaxBufSize = this.sendMaxBufSize == 0 ? n : Math.min(this.sendMaxBufSize, n);
    }

    private void checkQopSupport(byte[] byArray, byte[] byArray2) throws IOException {
        String string = byArray == null ? "auth" : new String(byArray, this.encoding);
        String[] stringArray = new String[3];
        byte[] byArray3 = DigestMD5Client.parseQop(string, stringArray, true);
        byte by = DigestMD5Client.combineMasks(byArray3);
        switch (DigestMD5Client.findPreferredMask(by, this.qop)) {
            case 0: {
                throw new SaslException("DIGEST-MD5: No common protection layer between client and server");
            }
            case 1: {
                this.negotiatedQop = "auth";
                break;
            }
            case 2: {
                this.negotiatedQop = "auth-int";
                this.integrity = true;
                this.rawSendSize = this.sendMaxBufSize - 16;
                break;
            }
            case 4: {
                this.negotiatedQop = "auth-conf";
                this.integrity = true;
                this.privacy = true;
                this.rawSendSize = this.sendMaxBufSize - 26;
                this.checkStrengthSupport(byArray2);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST61:Raw send size: {0}", new Integer(this.rawSendSize));
        }
    }

    private void checkStrengthSupport(byte[] byArray) throws IOException {
        int n;
        if (byArray == null) {
            throw new SaslException("DIGEST-MD5: server did not specify cipher to use for 'auth-conf'");
        }
        String string = new String(byArray, this.encoding);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n");
        int n2 = stringTokenizer.countTokens();
        String string2 = null;
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0};
        String[] stringArray = new String[byArray2.length];
        for (int i = 0; i < n2; ++i) {
            string2 = stringTokenizer.nextToken();
            for (n = 0; n < CIPHER_TOKENS.length; ++n) {
                if (!string2.equals(CIPHER_TOKENS[n])) continue;
                int n3 = n;
                byArray2[n3] = (byte)(byArray2[n3] | CIPHER_MASKS[n]);
                stringArray[n] = string2;
                logger.log(Level.FINE, "DIGEST62:Server supports {0}", string2);
            }
        }
        byte[] byArray3 = DigestMD5Client.getPlatformCiphers();
        n = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            int n4 = i;
            byArray2[n4] = (byte)(byArray2[n4] & byArray3[i]);
            n = (byte)(n | byArray2[i]);
        }
        if (n == 0) {
            throw new SaslException("DIGEST-MD5: Client supports none of these cipher suites: " + string);
        }
        this.negotiatedCipher = this.findCipherAndStrength(byArray2, stringArray);
        if (this.negotiatedCipher == null) {
            throw new SaslException("DIGEST-MD5: Unable to negotiate a strength level for 'auth-conf'");
        }
        logger.log(Level.FINE, "DIGEST63:Cipher suite: {0}", this.negotiatedCipher);
    }

    private String findCipherAndStrength(byte[] byArray, String[] stringArray) {
        for (int i = 0; i < this.strength.length; ++i) {
            byte by = this.strength[i];
            if (by == 0) continue;
            for (int j = 0; j < byArray.length; ++j) {
                if (by != byArray[j] || this.specifiedCipher != null && !this.specifiedCipher.equals(stringArray[j])) continue;
                switch (by) {
                    case 4: {
                        this.negotiatedStrength = "high";
                        break;
                    }
                    case 2: {
                        this.negotiatedStrength = "medium";
                        break;
                    }
                    case 1: {
                        this.negotiatedStrength = "low";
                    }
                }
                return stringArray[j];
            }
        }
        return null;
    }

    private byte[] generateClientResponse(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.useUTF8) {
            byteArrayOutputStream.write("charset=".getBytes(this.encoding));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(44);
        }
        byteArrayOutputStream.write(("username=\"" + DigestMD5Client.quotedStringValue(this.username) + "\",").getBytes(this.encoding));
        if (this.negotiatedRealm.length() > 0) {
            byteArrayOutputStream.write(("realm=\"" + DigestMD5Client.quotedStringValue(this.negotiatedRealm) + "\",").getBytes(this.encoding));
        }
        byteArrayOutputStream.write("nonce=\"".getBytes(this.encoding));
        DigestMD5Client.writeQuotedStringValue(byteArrayOutputStream, this.nonce);
        byteArrayOutputStream.write(34);
        byteArrayOutputStream.write(44);
        this.nonceCount = DigestMD5Client.getNonceCount(this.nonce);
        byteArrayOutputStream.write(("nc=" + DigestMD5Client.nonceCountToHex(this.nonceCount) + ",").getBytes(this.encoding));
        this.cnonce = DigestMD5Client.generateNonce();
        byteArrayOutputStream.write("cnonce=\"".getBytes(this.encoding));
        DigestMD5Client.writeQuotedStringValue(byteArrayOutputStream, this.cnonce);
        byteArrayOutputStream.write("\",".getBytes(this.encoding));
        byteArrayOutputStream.write(("digest-uri=\"" + this.digestUri + "\",").getBytes(this.encoding));
        byteArrayOutputStream.write("maxbuf=".getBytes(this.encoding));
        byteArrayOutputStream.write(String.valueOf(this.recvMaxBufSize).getBytes(this.encoding));
        byteArrayOutputStream.write(44);
        try {
            byteArrayOutputStream.write("response=".getBytes(this.encoding));
            byteArrayOutputStream.write(this.generateResponseValue("AUTHENTICATE", this.digestUri, this.negotiatedQop, this.username, this.negotiatedRealm, this.passwd, this.nonce, this.cnonce, this.nonceCount, this.authzidBytes));
            byteArrayOutputStream.write(44);
        }
        catch (Exception exception) {
            throw new SaslException("DIGEST-MD5: Error generating response value", exception);
        }
        byteArrayOutputStream.write(("qop=" + this.negotiatedQop).getBytes(this.encoding));
        if (this.negotiatedCipher != null) {
            byteArrayOutputStream.write((",cipher=\"" + this.negotiatedCipher + "\"").getBytes(this.encoding));
        }
        if (this.authzidBytes != null) {
            byteArrayOutputStream.write(",authzid=\"".getBytes(this.encoding));
            DigestMD5Client.writeQuotedStringValue(byteArrayOutputStream, this.authzidBytes);
            byteArrayOutputStream.write("\"".getBytes(this.encoding));
        }
        if (byteArrayOutputStream.size() > 4096) {
            throw new SaslException("DIGEST-MD5: digest-response size too large. Length: " + byteArrayOutputStream.size());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void validateResponseValue(byte[] byArray) throws SaslException {
        if (byArray == null) {
            throw new SaslException("DIGEST-MD5: Authenication failed. Expecting 'rspauth' authentication success message");
        }
        try {
            byte[] byArray2 = this.generateResponseValue("", this.digestUri, this.negotiatedQop, this.username, this.negotiatedRealm, this.passwd, this.nonce, this.cnonce, this.nonceCount, this.authzidBytes);
            if (!Arrays.equals(byArray2, byArray)) {
                throw new SaslException("Server's rspauth value does not match what client expects");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException("Problem generating response value for verification", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new SaslException("Problem generating response value for verification", iOException);
        }
    }

    private static int getNonceCount(byte[] byArray) {
        return 1;
    }

    private void clearPassword() {
        if (this.passwd != null) {
            for (int i = 0; i < this.passwd.length; ++i) {
                this.passwd[i] = '\u0000';
            }
            this.passwd = null;
        }
    }
}

