/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNBindingEnumeration;
import com.sun.jndi.cosnaming.CNNameParser;
import com.sun.jndi.cosnaming.CorbanameUrl;
import com.sun.jndi.cosnaming.ExceptionMapper;
import com.sun.jndi.cosnaming.IiopUrl;
import com.sun.jndi.cosnaming.OrbReuseTracker;
import com.sun.jndi.toolkit.corba.CorbaUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class CNCtx
implements Context {
    private static final boolean debug = false;
    private static ORB _defaultOrb;
    ORB _orb;
    public NamingContext _nc;
    private NameComponent[] _name = null;
    Hashtable<String, java.lang.Object> _env;
    static final CNNameParser parser;
    private static final String FED_PROP = "com.sun.jndi.cosnaming.federation";
    boolean federation = false;
    public static final boolean trustURLCodebase;
    OrbReuseTracker orbTracker = null;
    int enumCount;
    boolean isCloseCalled = false;

    private static synchronized ORB getDefaultOrb() {
        if (_defaultOrb == null) {
            _defaultOrb = CorbaUtils.getOrb(null, -1, new Hashtable());
        }
        return _defaultOrb;
    }

    CNCtx(Hashtable<?, ?> hashtable) throws NamingException {
        if (hashtable != null) {
            hashtable = (Hashtable)hashtable.clone();
        }
        this._env = hashtable;
        this.federation = "true".equals(hashtable != null ? hashtable.get(FED_PROP) : null);
        this.initOrbAndRootContext(hashtable);
    }

    private CNCtx() {
    }

    public static ResolveResult createUsingURL(String string, Hashtable<?, ?> hashtable) throws NamingException {
        CNCtx cNCtx = new CNCtx();
        if (hashtable != null) {
            hashtable = (Hashtable)hashtable.clone();
        }
        cNCtx._env = hashtable;
        String string2 = cNCtx.initUsingUrl(hashtable != null ? (ORB)hashtable.get("java.naming.corba.orb") : null, string, hashtable);
        return new ResolveResult((java.lang.Object)cNCtx, parser.parse(string2));
    }

    CNCtx(ORB oRB, OrbReuseTracker orbReuseTracker, NamingContext namingContext, Hashtable<String, java.lang.Object> hashtable, NameComponent[] nameComponentArray) throws NamingException {
        if (oRB == null || namingContext == null) {
            throw new ConfigurationException("Must supply ORB or NamingContext");
        }
        this._orb = oRB != null ? oRB : CNCtx.getDefaultOrb();
        this._nc = namingContext;
        this._env = hashtable;
        this._name = nameComponentArray;
        this.federation = "true".equals(hashtable != null ? hashtable.get(FED_PROP) : null);
    }

    NameComponent[] makeFullName(NameComponent[] nameComponentArray) {
        if (this._name == null || this._name.length == 0) {
            return nameComponentArray;
        }
        NameComponent[] nameComponentArray2 = new NameComponent[this._name.length + nameComponentArray.length];
        System.arraycopy(this._name, 0, nameComponentArray2, 0, this._name.length);
        System.arraycopy(nameComponentArray, 0, nameComponentArray2, this._name.length, nameComponentArray.length);
        return nameComponentArray2;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (this._name == null || this._name.length == 0) {
            return "";
        }
        return CNNameParser.cosNameToInsString(this._name);
    }

    private static boolean isCorbaUrl(String string) {
        return string.startsWith("iiop://") || string.startsWith("iiopname://") || string.startsWith("corbaname:");
    }

    private void initOrbAndRootContext(Hashtable<?, ?> hashtable) throws NamingException {
        ORB oRB = null;
        String string = null;
        if (oRB == null && hashtable != null) {
            oRB = (ORB)hashtable.get("java.naming.corba.orb");
        }
        if (oRB == null) {
            oRB = CNCtx.getDefaultOrb();
        }
        String string2 = null;
        if (hashtable != null) {
            string2 = (String)hashtable.get("java.naming.provider.url");
        }
        if (string2 != null && !CNCtx.isCorbaUrl(string2)) {
            string = this.getStringifiedIor(string2);
            this.setOrbAndRootContext(oRB, string);
        } else if (string2 != null) {
            String string3 = this.initUsingUrl(oRB, string2, hashtable);
            if (string3.length() > 0) {
                this._name = CNNameParser.nameToCosName(parser.parse(string3));
                try {
                    Object object = this._nc.resolve(this._name);
                    this._nc = NamingContextHelper.narrow(object);
                    if (this._nc == null) {
                        throw new ConfigurationException(string3 + " does not name a NamingContext");
                    }
                }
                catch (BAD_PARAM bAD_PARAM) {
                    throw new ConfigurationException(string3 + " does not name a NamingContext");
                }
                catch (Exception exception) {
                    throw ExceptionMapper.mapException(exception, this, this._name);
                }
            }
        } else {
            this.setOrbAndRootContext(oRB, (String)null);
        }
    }

    private String initUsingUrl(ORB oRB, String string, Hashtable<?, ?> hashtable) throws NamingException {
        if (string.startsWith("iiop://") || string.startsWith("iiopname://")) {
            return this.initUsingIiopUrl(oRB, string, hashtable);
        }
        return this.initUsingCorbanameUrl(oRB, string, hashtable);
    }

    private String initUsingIiopUrl(ORB oRB, String string, Hashtable<?, ?> hashtable) throws NamingException {
        if (oRB == null) {
            oRB = CNCtx.getDefaultOrb();
        }
        try {
            IiopUrl iiopUrl = new IiopUrl(string);
            NamingException namingException = null;
            for (IiopUrl.Address address : iiopUrl.getAddresses()) {
                try {
                    try {
                        String string2 = "corbaloc:iiop:" + address.host + ":" + address.port + "/NameService";
                        Object object = oRB.string_to_object(string2);
                        this.setOrbAndRootContext(oRB, object);
                        return iiopUrl.getStringName();
                    }
                    catch (Exception exception) {
                        this.setOrbAndRootContext(oRB, (String)null);
                        return iiopUrl.getStringName();
                    }
                }
                catch (NamingException namingException2) {
                    namingException = namingException2;
                }
            }
            if (namingException != null) {
                throw namingException;
            }
            throw new ConfigurationException("Problem with URL: " + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException(malformedURLException.getMessage());
        }
    }

    private String initUsingCorbanameUrl(ORB oRB, String string, Hashtable<?, ?> hashtable) throws NamingException {
        if (oRB == null) {
            oRB = CNCtx.getDefaultOrb();
        }
        try {
            CorbanameUrl corbanameUrl = new CorbanameUrl(string);
            String string2 = corbanameUrl.getLocation();
            String string3 = corbanameUrl.getStringName();
            this.setOrbAndRootContext(oRB, string2);
            return corbanameUrl.getStringName();
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException(malformedURLException.getMessage());
        }
    }

    private void setOrbAndRootContext(ORB oRB, String string) throws NamingException {
        this._orb = oRB;
        try {
            Object object = string != null ? this._orb.string_to_object(string) : this._orb.resolve_initial_references("NameService");
            this._nc = NamingContextHelper.narrow(object);
            if (this._nc == null) {
                if (string != null) {
                    throw new ConfigurationException("Cannot convert IOR to a NamingContext: " + string);
                }
                throw new ConfigurationException("ORB.resolve_initial_references(\"NameService\") does not return a NamingContext");
            }
        }
        catch (InvalidName invalidName) {
            ConfigurationException configurationException = new ConfigurationException("COS Name Service not registered with ORB under the name 'NameService'");
            configurationException.setRootCause(invalidName);
            throw configurationException;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            CommunicationException communicationException = new CommunicationException("Cannot connect to ORB");
            communicationException.setRootCause(cOMM_FAILURE);
            throw communicationException;
        }
        catch (BAD_PARAM bAD_PARAM) {
            ConfigurationException configurationException = new ConfigurationException("Invalid URL or IOR: " + string);
            configurationException.setRootCause(bAD_PARAM);
            throw configurationException;
        }
        catch (INV_OBJREF iNV_OBJREF) {
            ConfigurationException configurationException = new ConfigurationException("Invalid object reference: " + string);
            configurationException.setRootCause(iNV_OBJREF);
            throw configurationException;
        }
    }

    private void setOrbAndRootContext(ORB oRB, Object object) throws NamingException {
        this._orb = oRB;
        try {
            this._nc = NamingContextHelper.narrow(object);
            if (this._nc == null) {
                throw new ConfigurationException("Cannot convert object reference to NamingContext: " + object);
            }
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            CommunicationException communicationException = new CommunicationException("Cannot connect to ORB");
            communicationException.setRootCause(cOMM_FAILURE);
            throw communicationException;
        }
    }

    private String getStringifiedIor(String string) throws NamingException {
        if (string.startsWith("IOR:") || string.startsWith("corbaloc:")) {
            return string;
        }
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
            if (inputStream != null) {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.startsWith("IOR:")) continue;
                    String string3 = string2;
                    return string3;
                }
            }
        }
        catch (IOException iOException) {
            ConfigurationException configurationException = new ConfigurationException("Invalid URL: " + string);
            configurationException.setRootCause(iOException);
            throw configurationException;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                ConfigurationException configurationException = new ConfigurationException("Invalid URL: " + string);
                configurationException.setRootCause(iOException);
                throw configurationException;
            }
        }
        throw new ConfigurationException(string + " does not contain an IOR");
    }

    java.lang.Object callResolve(NameComponent[] nameComponentArray) throws NamingException {
        try {
            Object object = this._nc.resolve(nameComponentArray);
            try {
                NamingContext namingContext = NamingContextHelper.narrow(object);
                if (namingContext != null) {
                    return new CNCtx(this._orb, this.orbTracker, namingContext, this._env, this.makeFullName(nameComponentArray));
                }
                return object;
            }
            catch (SystemException systemException) {
                return object;
            }
        }
        catch (Exception exception) {
            throw ExceptionMapper.mapException(exception, this, nameComponentArray);
        }
    }

    @Override
    public java.lang.Object lookup(String string) throws NamingException {
        return this.lookup(new CompositeName(string));
    }

    @Override
    public java.lang.Object lookup(Name name) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (name.size() == 0) {
            return this;
        }
        NameComponent[] nameComponentArray = CNNameParser.nameToCosName(name);
        java.lang.Object object = null;
        try {
            object = this.callResolve(nameComponentArray);
            try {
                if (CorbaUtils.isObjectFactoryTrusted(object)) {
                    object = NamingManager.getObjectInstance(object, name, this, this._env);
                }
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            return context.lookup(cannotProceedException.getRemainingName());
        }
        return object;
    }

    private void callBindOrRebind(NameComponent[] nameComponentArray, Name name, java.lang.Object object, boolean bl) throws NamingException {
        block11: {
            if (this._nc == null) {
                throw new ConfigurationException("Context does not have a corresponding NamingContext");
            }
            try {
                object = NamingManager.getStateToBind(object, name, this, this._env);
                if (object instanceof CNCtx) {
                    object = ((CNCtx)object)._nc;
                }
                if (object instanceof NamingContext) {
                    NamingContext namingContext = NamingContextHelper.narrow((Object)object);
                    if (bl) {
                        this._nc.rebind_context(nameComponentArray, namingContext);
                    } else {
                        this._nc.bind_context(nameComponentArray, namingContext);
                    }
                    break block11;
                }
                if (object instanceof Object) {
                    if (bl) {
                        this._nc.rebind(nameComponentArray, (Object)object);
                    } else {
                        this._nc.bind(nameComponentArray, (Object)object);
                    }
                    break block11;
                }
                throw new IllegalArgumentException("Only instances of org.omg.CORBA.Object can be bound");
            }
            catch (BAD_PARAM bAD_PARAM) {
                NotContextException notContextException = new NotContextException(name.toString());
                notContextException.setRootCause(bAD_PARAM);
                throw notContextException;
            }
            catch (Exception exception) {
                throw ExceptionMapper.mapException(exception, this, nameComponentArray);
            }
        }
    }

    @Override
    public void bind(Name name, java.lang.Object object) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = CNNameParser.nameToCosName(name);
        try {
            this.callBindOrRebind(nameComponentArray, name, object, false);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            context.bind(cannotProceedException.getRemainingName(), object);
        }
    }

    private static Context getContinuationContext(CannotProceedException cannotProceedException) throws NamingException {
        try {
            return NamingManager.getContinuationContext(cannotProceedException);
        }
        catch (CannotProceedException cannotProceedException2) {
            Reference reference;
            RefAddr refAddr;
            java.lang.Object object = cannotProceedException2.getResolvedObj();
            if (object instanceof Reference && (refAddr = (reference = (Reference)object).get("nns")).getContent() instanceof Context) {
                NameNotFoundException nameNotFoundException = new NameNotFoundException("No object reference bound for specified name");
                nameNotFoundException.setRootCause(cannotProceedException.getRootCause());
                nameNotFoundException.setRemainingName(cannotProceedException.getRemainingName());
                throw nameNotFoundException;
            }
            throw cannotProceedException2;
        }
    }

    @Override
    public void bind(String string, java.lang.Object object) throws NamingException {
        this.bind(new CompositeName(string), object);
    }

    @Override
    public void rebind(Name name, java.lang.Object object) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = CNNameParser.nameToCosName(name);
        try {
            this.callBindOrRebind(nameComponentArray, name, object, true);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            context.rebind(cannotProceedException.getRemainingName(), object);
        }
    }

    @Override
    public void rebind(String string, java.lang.Object object) throws NamingException {
        this.rebind(new CompositeName(string), object);
    }

    private void callUnbind(NameComponent[] nameComponentArray) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        try {
            this._nc.unbind(nameComponentArray);
        }
        catch (NotFound notFound) {
            if (!this.leafNotFound(notFound, nameComponentArray[nameComponentArray.length - 1])) {
                throw ExceptionMapper.mapException(notFound, this, nameComponentArray);
            }
        }
        catch (Exception exception) {
            throw ExceptionMapper.mapException(exception, this, nameComponentArray);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean leafNotFound(NotFound notFound, NameComponent nameComponent) {
        if (notFound.why.value() != 0) return false;
        if (notFound.rest_of_name.length != 1) return false;
        NameComponent nameComponent2 = notFound.rest_of_name[0];
        if (!nameComponent2.id.equals(nameComponent.id)) return false;
        if (nameComponent2.kind == nameComponent.kind) return true;
        if (nameComponent2.kind == null) return false;
        if (!nameComponent2.kind.equals(nameComponent.kind)) return false;
        return true;
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.unbind(new CompositeName(string));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = CNNameParser.nameToCosName(name);
        try {
            this.callUnbind(nameComponentArray);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            context.unbind(cannotProceedException.getRemainingName());
        }
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.rename(new CompositeName(string), new CompositeName(string2));
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (name.size() == 0 || name2.size() == 0) {
            throw new InvalidNameException("One or both names empty");
        }
        java.lang.Object object = this.lookup(name);
        this.bind(name2, object);
        this.unbind(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.list(new CompositeName(string));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.listBindings(new CompositeName(string));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (name.size() > 0) {
            try {
                java.lang.Object object = this.lookup(name);
                if (object instanceof CNCtx) {
                    return new CNBindingEnumeration((CNCtx)object, true, this._env);
                }
                throw new NotContextException(name.toString());
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (BAD_PARAM bAD_PARAM) {
                NotContextException notContextException = new NotContextException(name.toString());
                notContextException.setRootCause(bAD_PARAM);
                throw notContextException;
            }
        }
        return new CNBindingEnumeration(this, false, this._env);
    }

    private void callDestroy(NamingContext namingContext) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        try {
            namingContext.destroy();
        }
        catch (Exception exception) {
            throw ExceptionMapper.mapException(exception, this, null);
        }
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(new CompositeName(string));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        NamingContext namingContext = this._nc;
        NameComponent[] nameComponentArray = CNNameParser.nameToCosName(name);
        if (name.size() > 0) {
            try {
                Context context = (Context)this.callResolve(nameComponentArray);
                CNCtx cNCtx = (CNCtx)context;
                namingContext = cNCtx._nc;
                cNCtx.close();
            }
            catch (ClassCastException classCastException) {
                throw new NotContextException(name.toString());
            }
            catch (CannotProceedException cannotProceedException) {
                Context context = CNCtx.getContinuationContext(cannotProceedException);
                context.destroySubcontext(cannotProceedException.getRemainingName());
                return;
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (nameNotFoundException.getRootCause() instanceof NotFound && this.leafNotFound((NotFound)nameNotFoundException.getRootCause(), nameComponentArray[nameComponentArray.length - 1])) {
                    return;
                }
                throw nameNotFoundException;
            }
            catch (NamingException namingException) {
                throw namingException;
            }
        }
        this.callDestroy(namingContext);
        this.callUnbind(nameComponentArray);
    }

    private Context callBindNewContext(NameComponent[] nameComponentArray) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        try {
            NamingContext namingContext = this._nc.bind_new_context(nameComponentArray);
            return new CNCtx(this._orb, this.orbTracker, namingContext, this._env, this.makeFullName(nameComponentArray));
        }
        catch (Exception exception) {
            throw ExceptionMapper.mapException(exception, this, nameComponentArray);
        }
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(new CompositeName(string));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = CNNameParser.nameToCosName(name);
        try {
            return this.callBindNewContext(nameComponentArray);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            return context.createSubcontext(cannotProceedException.getRemainingName());
        }
    }

    @Override
    public java.lang.Object lookupLink(String string) throws NamingException {
        return this.lookupLink(new CompositeName(string));
    }

    @Override
    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return parser;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return parser;
    }

    public Hashtable<String, java.lang.Object> getEnvironment() throws NamingException {
        if (this._env == null) {
            return new Hashtable<String, java.lang.Object>(5, 0.75f);
        }
        return (Hashtable)this._env.clone();
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        return this.composeName(new CompositeName(string), new CompositeName(string2)).toString();
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        return name3.addAll(name);
    }

    @Override
    public java.lang.Object addToEnvironment(String string, java.lang.Object object) throws NamingException {
        this._env = this._env == null ? new Hashtable(7, 0.75f) : (Hashtable)this._env.clone();
        return this._env.put(string, object);
    }

    @Override
    public java.lang.Object removeFromEnvironment(String string) throws NamingException {
        if (this._env != null && this._env.get(string) != null) {
            this._env = (Hashtable)this._env.clone();
            return this._env.remove(string);
        }
        return null;
    }

    public synchronized void incEnumCount() {
        ++this.enumCount;
    }

    public synchronized void decEnumCount() throws NamingException {
        --this.enumCount;
        if (this.enumCount == 0 && this.isCloseCalled) {
            this.close();
        }
    }

    @Override
    public synchronized void close() throws NamingException {
        if (this.enumCount > 0) {
            this.isCloseCalled = true;
            return;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    static {
        parser = new CNNameParser();
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.sun.jndi.cosnaming.object.trustURLCodebase", "false");
            }
        });
        trustURLCodebase = "true".equalsIgnoreCase(string);
    }
}

