/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.ClassReader;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.PackageWriter;
import com.sun.java.util.jar.pack.TLGlobals;
import com.sun.java.util.jar.pack.Utils;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Pack200;
import java.util.zip.ZipEntry;

public class PackerImpl
extends TLGlobals
implements Pack200.Packer {
    @Override
    public SortedMap<String, String> properties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pack(JarFile jarFile, OutputStream outputStream) throws IOException {
        assert (Utils.currentInstance.get() == null);
        TimeZone timeZone = this.props.getBoolean("com.sun.java.util.jar.pack.default.timezone") ? null : TimeZone.getDefault();
        try {
            Utils.currentInstance.set(this);
            if (timeZone != null) {
                TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            }
            if ("0".equals(this.props.getProperty("pack.effort"))) {
                Utils.copyJarFile(jarFile, outputStream);
            } else {
                new DoPack().run(jarFile, outputStream);
            }
        }
        finally {
            Utils.currentInstance.set(null);
            if (timeZone != null) {
                TimeZone.setDefault(timeZone);
            }
            jarFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pack(JarInputStream jarInputStream, OutputStream outputStream) throws IOException {
        assert (Utils.currentInstance.get() == null);
        TimeZone timeZone = this.props.getBoolean("com.sun.java.util.jar.pack.default.timezone") ? null : TimeZone.getDefault();
        try {
            Utils.currentInstance.set(this);
            if (timeZone != null) {
                TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            }
            if ("0".equals(this.props.getProperty("pack.effort"))) {
                Utils.copyJarFile(jarInputStream, outputStream);
            } else {
                new DoPack().run(jarInputStream, outputStream);
            }
        }
        finally {
            Utils.currentInstance.set(null);
            if (timeZone != null) {
                TimeZone.setDefault(timeZone);
            }
            jarInputStream.close();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.props.addListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.props.removeListener(propertyChangeListener);
    }

    private class DoPack {
        final int verbose;
        final Package pkg;
        final String unknownAttrCommand;
        final Map<Attribute.Layout, Attribute> attrDefs;
        final Map<Attribute.Layout, String> attrCommands;
        final boolean keepFileOrder;
        final boolean keepClassOrder;
        final boolean keepModtime;
        final boolean latestModtime;
        final boolean keepDeflateHint;
        long totalOutputSize;
        int segmentCount;
        long segmentTotalSize;
        long segmentSize;
        final long segmentLimit;
        final List<String> passFiles;
        private int nread;

        private DoPack() {
            int n;
            boolean bl;
            int n2;
            this.verbose = PackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.verbose");
            PackerImpl.this.props.setInteger("pack.progress", 0);
            if (this.verbose > 0) {
                Utils.log.info(PackerImpl.this.props.toString());
            }
            this.pkg = new Package();
            Object object = PackerImpl.this.props.getProperty("pack.unknown.attribute", "pass");
            if (!("strip".equals(object) || "pass".equals(object) || "error".equals(object))) {
                throw new RuntimeException("Bad option: pack.unknown.attribute = " + (String)object);
            }
            this.unknownAttrCommand = ((String)object).intern();
            object = new HashMap();
            Object object2 = new HashMap<Attribute.Layout, String>();
            String[] stringArray = new String[]{"pack.class.attribute.", "pack.field.attribute.", "pack.method.attribute.", "pack.code.attribute."};
            int[] nArray = new int[]{0, 1, 2, 3};
            for (int i = 0; i < nArray.length; ++i) {
                String string = stringArray[i];
                SortedMap<String, String> sortedMap = PackerImpl.this.props.prefixMap(string);
                for (String string2 : sortedMap.keySet()) {
                    assert (string2.startsWith(string));
                    String string3 = string2.substring(string.length());
                    String string4 = PackerImpl.this.props.getProperty(string2);
                    Attribute.Layout layout = Attribute.keyForLookup(nArray[i], string3);
                    if ("strip".equals(string4) || "pass".equals(string4) || "error".equals(string4)) {
                        object2.put((Attribute.Layout)layout, (String)string4.intern());
                        continue;
                    }
                    Attribute.define((Map<Attribute.Layout, Attribute>)object, nArray[i], string3, string4);
                    if (this.verbose > 1) {
                        Utils.log.fine("Added layout for " + Constants.ATTR_CONTEXT_NAME[i] + " attribute " + string3 + " = " + string4);
                    }
                    assert (object.containsKey(layout));
                }
            }
            this.attrDefs = object.isEmpty() ? null : object;
            this.attrCommands = object2.isEmpty() ? null : object2;
            this.keepFileOrder = PackerImpl.this.props.getBoolean("pack.keep.file.order");
            this.keepClassOrder = PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.keep.class.order");
            this.keepModtime = "keep".equals(PackerImpl.this.props.getProperty("pack.modification.time"));
            this.latestModtime = "latest".equals(PackerImpl.this.props.getProperty("pack.modification.time"));
            this.keepDeflateHint = "keep".equals(PackerImpl.this.props.getProperty("pack.deflate.hint"));
            if (!this.keepModtime && !this.latestModtime && (n2 = PackerImpl.this.props.getTime("pack.modification.time")) != 0) {
                this.pkg.default_modtime = n2;
            }
            if (!this.keepDeflateHint && (bl = PackerImpl.this.props.getBoolean("pack.deflate.hint"))) {
                this.pkg.default_options |= 0x20;
            }
            this.totalOutputSize = 0L;
            this.segmentCount = 0;
            this.segmentTotalSize = 0L;
            this.segmentSize = 0L;
            long l = PackerImpl.this.props.getProperty("pack.segment.limit", "").equals("") ? -1L : PackerImpl.this.props.getLong("pack.segment.limit");
            l = Math.min(Integer.MAX_VALUE, l);
            if ((l = Math.max(-1L, l)) == -1L) {
                l = Long.MAX_VALUE;
            }
            this.segmentLimit = l;
            this.passFiles = PackerImpl.this.props.getProperties("pack.pass.file.");
            ListIterator<String> listIterator = this.passFiles.listIterator();
            while (listIterator.hasNext()) {
                object2 = listIterator.next();
                if (object2 == null) {
                    listIterator.remove();
                    continue;
                }
                if (((String)(object2 = Utils.getJarEntryName((String)object2))).endsWith("/")) {
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                }
                listIterator.set((String)object2);
            }
            if (this.verbose > 0) {
                Utils.log.info("passFiles = " + this.passFiles);
            }
            if ((n = PackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.min.class.majver")) != 0) {
                this.pkg.min_class_majver = (short)n;
            }
            if ((n = PackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.min.class.minver")) != 0) {
                this.pkg.min_class_minver = (short)n;
            }
            if ((n = PackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.max.class.majver")) != 0) {
                this.pkg.max_class_majver = (short)n;
            }
            if ((n = PackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.max.class.minver")) != 0) {
                this.pkg.max_class_minver = (short)n;
            }
            if ((n = PackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.package.minver")) != 0) {
                this.pkg.package_minver = (short)n;
            }
            if ((n = PackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.package.majver")) != 0) {
                this.pkg.package_majver = (short)n;
            }
            if ((n = PackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.archive.options")) != 0) {
                this.pkg.default_options |= n;
            }
            this.nread = 0;
        }

        boolean isClassFile(String string) {
            if (!string.endsWith(".class")) {
                return false;
            }
            String string2 = string;
            while (true) {
                if (this.passFiles.contains(string2)) {
                    return false;
                }
                int n = string2.lastIndexOf(47);
                if (n < 0) break;
                string2 = string2.substring(0, n);
            }
            return true;
        }

        boolean isMetaInfFile(String string) {
            return string.startsWith("/META-INF") || string.startsWith("META-INF");
        }

        private void makeNextPackage() {
            this.pkg.reset();
        }

        private void noteRead(InFile inFile) {
            ++this.nread;
            if (this.verbose > 2) {
                Utils.log.fine("...read " + inFile.name);
            }
            if (this.verbose > 0 && this.nread % 1000 == 0) {
                Utils.log.info("Have read " + this.nread + " files...");
            }
        }

        void run(JarInputStream jarInputStream, OutputStream outputStream) throws IOException {
            Object object;
            Object object2;
            if (jarInputStream.getManifest() != null) {
                object2 = new ByteArrayOutputStream();
                jarInputStream.getManifest().write((OutputStream)object2);
                object = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
                this.pkg.addFile(this.readFile("META-INF/MANIFEST.MF", (InputStream)object));
            }
            while ((object2 = jarInputStream.getNextJarEntry()) != null) {
                long l;
                object = new InFile((JarEntry)object2);
                String string = ((InFile)object).name;
                Package.File file = this.readFile(string, jarInputStream);
                Package.File file2 = null;
                long l2 = l = this.isMetaInfFile(string) ? 0L : ((InFile)object).getInputLength();
                if ((this.segmentSize += l) > this.segmentLimit) {
                    this.segmentSize -= l;
                    int n = -1;
                    this.flushPartial(outputStream, n);
                }
                if (this.verbose > 1) {
                    Utils.log.fine("Reading " + string);
                }
                assert (((ZipEntry)object2).isDirectory() == string.endsWith("/"));
                if (this.isClassFile(string)) {
                    file2 = this.readClass(string, file.getInputStream());
                }
                if (file2 == null) {
                    file2 = file;
                    this.pkg.addFile(file2);
                }
                ((InFile)object).copyTo(file2);
                this.noteRead((InFile)object);
            }
            this.flushAll(outputStream);
        }

        void run(JarFile jarFile, OutputStream outputStream) throws IOException {
            List<InFile> list = this.scanJar(jarFile);
            if (this.verbose > 0) {
                Utils.log.info("Reading " + list.size() + " files...");
            }
            int n = 0;
            for (InFile inFile : list) {
                long l;
                String string = inFile.name;
                long l2 = l = this.isMetaInfFile(string) ? 0L : inFile.getInputLength();
                if ((this.segmentSize += l) > this.segmentLimit) {
                    this.segmentSize -= l;
                    float f = n + 1;
                    float f2 = this.segmentCount + 1;
                    float f3 = (float)list.size() - f;
                    float f4 = f3 * (f2 / f);
                    if (this.verbose > 1) {
                        Utils.log.fine("Estimated segments to do: " + f4);
                    }
                    this.flushPartial(outputStream, (int)Math.ceil(f4));
                }
                InputStream inputStream = inFile.getInputStream();
                if (this.verbose > 1) {
                    Utils.log.fine("Reading " + string);
                }
                Package.File file = null;
                if (this.isClassFile(string) && (file = this.readClass(string, inputStream)) == null) {
                    inputStream.close();
                    inputStream = inFile.getInputStream();
                }
                if (file == null) {
                    file = this.readFile(string, inputStream);
                    this.pkg.addFile(file);
                }
                inFile.copyTo(file);
                inputStream.close();
                this.noteRead(inFile);
                ++n;
            }
            this.flushAll(outputStream);
        }

        Package.File readClass(String string, InputStream inputStream) throws IOException {
            Package package_ = this.pkg;
            package_.getClass();
            Package.Class clazz = package_.new Package.Class(string);
            inputStream = new BufferedInputStream(inputStream);
            ClassReader classReader = new ClassReader(clazz, inputStream);
            classReader.setAttrDefs(this.attrDefs);
            classReader.setAttrCommands(this.attrCommands);
            classReader.unknownAttrCommand = this.unknownAttrCommand;
            try {
                classReader.read();
            }
            catch (IOException iOException) {
                String string2 = "Passing class file uncompressed due to";
                if (iOException instanceof Attribute.FormatException) {
                    Attribute.FormatException formatException = (Attribute.FormatException)iOException;
                    if (formatException.layout.equals("pass")) {
                        Utils.log.info(formatException.toString());
                        Utils.log.warning(string2 + " unrecognized attribute: " + string);
                        return null;
                    }
                } else if (iOException instanceof ClassReader.ClassFormatException) {
                    ClassReader.ClassFormatException classFormatException = (ClassReader.ClassFormatException)iOException;
                    if (this.unknownAttrCommand.equals("pass")) {
                        Utils.log.info(classFormatException.toString());
                        Utils.log.warning(string2 + " unknown class format: " + string);
                        return null;
                    }
                }
                throw iOException;
            }
            this.pkg.addClass(clazz);
            return clazz.file;
        }

        Package.File readFile(String string, InputStream inputStream) throws IOException {
            Package package_ = this.pkg;
            package_.getClass();
            Package.File file = package_.new Package.File(string);
            file.readFrom(inputStream);
            if (file.isDirectory() && file.getFileLength() != 0L) {
                throw new IllegalArgumentException("Non-empty directory: " + file.getFileName());
            }
            return file;
        }

        void flushPartial(OutputStream outputStream, int n) throws IOException {
            if (this.pkg.files.isEmpty() && this.pkg.classes.isEmpty()) {
                return;
            }
            this.flushPackage(outputStream, Math.max(1, n));
            PackerImpl.this.props.setInteger("pack.progress", 25);
            this.makeNextPackage();
            ++this.segmentCount;
            this.segmentTotalSize += this.segmentSize;
            this.segmentSize = 0L;
        }

        void flushAll(OutputStream outputStream) throws IOException {
            PackerImpl.this.props.setInteger("pack.progress", 50);
            this.flushPackage(outputStream, 0);
            outputStream.flush();
            PackerImpl.this.props.setInteger("pack.progress", 100);
            ++this.segmentCount;
            this.segmentTotalSize += this.segmentSize;
            this.segmentSize = 0L;
            if (this.verbose > 0 && this.segmentCount > 1) {
                Utils.log.info("Transmitted " + this.segmentTotalSize + " input bytes in " + this.segmentCount + " segments totaling " + this.totalOutputSize + " bytes");
            }
        }

        void flushPackage(OutputStream outputStream, int n) throws IOException {
            int n2 = this.pkg.files.size();
            if (!this.keepFileOrder) {
                if (this.verbose > 1) {
                    Utils.log.fine("Reordering files.");
                }
                boolean bl = true;
                this.pkg.reorderFiles(this.keepClassOrder, bl);
            } else {
                assert (this.pkg.files.containsAll(this.pkg.getClassStubs()));
                ArrayList<Package.File> arrayList = this.pkg.files;
                if ($assertionsDisabled || !(arrayList = new ArrayList<Package.File>(this.pkg.files)).retainAll(this.pkg.getClassStubs())) {
                    // empty if block
                }
                assert (arrayList.equals(this.pkg.getClassStubs()));
            }
            this.pkg.trimStubs();
            if (PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.strip.debug")) {
                this.pkg.stripAttributeKind("Debug");
            }
            if (PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.strip.compile")) {
                this.pkg.stripAttributeKind("Compile");
            }
            if (PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.strip.constants")) {
                this.pkg.stripAttributeKind("Constant");
            }
            if (PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.strip.exceptions")) {
                this.pkg.stripAttributeKind("Exceptions");
            }
            if (PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.strip.innerclasses")) {
                this.pkg.stripAttributeKind("InnerClasses");
            }
            if (this.pkg.package_majver <= 0) {
                this.pkg.choosePackageVersion();
            }
            PackageWriter packageWriter = new PackageWriter(this.pkg, outputStream);
            packageWriter.archiveNextCount = n;
            packageWriter.write();
            outputStream.flush();
            if (this.verbose > 0) {
                long l = packageWriter.archiveSize0 + packageWriter.archiveSize1;
                this.totalOutputSize += l;
                long l2 = this.segmentSize;
                Utils.log.info("Transmitted " + n2 + " files of " + l2 + " input bytes in a segment of " + l + " bytes");
            }
        }

        List<InFile> scanJar(JarFile jarFile) throws IOException {
            ArrayList<InFile> arrayList = new ArrayList<InFile>();
            try {
                for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                    InFile inFile = new InFile(jarFile, jarEntry);
                    assert (jarEntry.isDirectory() == inFile.name.endsWith("/"));
                    arrayList.add(inFile);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new IOException(illegalStateException.getLocalizedMessage(), illegalStateException);
            }
            return arrayList;
        }

        final class InFile {
            final String name;
            final JarFile jf;
            final JarEntry je;
            final File f;
            int modtime = 0;
            int options;

            InFile(String string) {
                this.name = Utils.getJarEntryName(string);
                this.f = new File(string);
                this.jf = null;
                this.je = null;
                int n = this.getModtime(this.f.lastModified());
                if (DoPack.this.keepModtime && n != 0) {
                    this.modtime = n;
                } else if (DoPack.this.latestModtime && n > DoPack.this.pkg.default_modtime) {
                    DoPack.this.pkg.default_modtime = n;
                }
            }

            InFile(JarFile jarFile, JarEntry jarEntry) {
                this.name = Utils.getJarEntryName(jarEntry.getName());
                this.f = null;
                this.jf = jarFile;
                this.je = jarEntry;
                int n = this.getModtime(jarEntry.getTime());
                if (DoPack.this.keepModtime && n != 0) {
                    this.modtime = n;
                } else if (DoPack.this.latestModtime && n > DoPack.this.pkg.default_modtime) {
                    DoPack.this.pkg.default_modtime = n;
                }
                if (DoPack.this.keepDeflateHint && jarEntry.getMethod() == 8) {
                    this.options |= 1;
                }
            }

            InFile(JarEntry jarEntry) {
                this(null, jarEntry);
            }

            long getInputLength() {
                long l;
                long l2 = l = this.je != null ? this.je.getSize() : this.f.length();
                assert (l >= 0L) : this + ".len=" + l;
                return Math.max(0L, l) + (long)this.name.length() + 5L;
            }

            int getModtime(long l) {
                long l2 = (l + 500L) / 1000L;
                if ((long)((int)l2) == l2) {
                    return (int)l2;
                }
                Utils.log.warning("overflow in modtime for " + this.f);
                return 0;
            }

            void copyTo(Package.File file) {
                if (this.modtime != 0) {
                    file.modtime = this.modtime;
                }
                file.options |= this.options;
            }

            InputStream getInputStream() throws IOException {
                if (this.jf != null) {
                    return this.jf.getInputStream(this.je);
                }
                return new FileInputStream(this.f);
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

