/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt.FullScreenHandler;
import com.apple.eawt.FullScreenListener;
import java.awt.Window;
import javax.swing.RootPaneContainer;

public final class FullScreenUtilities {
    FullScreenUtilities() {
    }

    public static void setWindowCanFullScreen(Window window, boolean bl) {
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Can't mark a non-RootPaneContainer as full screen-able");
        }
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
        rootPaneContainer.getRootPane().putClientProperty("apple.awt.fullscreenable", bl);
    }

    public static void addFullScreenListenerTo(Window window, FullScreenListener fullScreenListener) {
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Can't attach FullScreenListener to a non-RootPaneContainer");
        }
        if (fullScreenListener == null) {
            throw new NullPointerException();
        }
        FullScreenHandler.addFullScreenListenerTo((RootPaneContainer)((Object)window), fullScreenListener);
    }

    public static void removeFullScreenListenerFrom(Window window, FullScreenListener fullScreenListener) {
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Can't remove FullScreenListener from non-RootPaneContainer");
        }
        if (fullScreenListener == null) {
            throw new NullPointerException();
        }
        FullScreenHandler.removeFullScreenListenerFrom((RootPaneContainer)((Object)window), fullScreenListener);
    }
}

