/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_es extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "av\u00e9stico";
        final String metaValue_ar = "\u00e1rabe";
        final String metaValue_bn = "bengal\u00ed";
        final String metaValue_bo = "tibetano";
        final String metaValue_el = "griego";
        final String metaValue_he = "hebreo";
        final String metaValue_hy = "armenio";
        final String metaValue_ja = "japon\u00e9s";
        final String metaValue_jv = "javan\u00e9s";
        final String metaValue_ka = "georgiano";
        final String metaValue_km = "jemer";
        final String metaValue_kn = "canar\u00e9s";
        final String metaValue_ko = "coreano";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmano";
        final String metaValue_or = "oriya";
        final String metaValue_si = "cingal\u00e9s";
        final String metaValue_su = "sundan\u00e9s";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailand\u00e9s";
        final String metaValue_tl = "tagalo";
        final String metaValue_ban = "balin\u00e9s";
        final String metaValue_bug = "bugin\u00e9s";
        final String metaValue_cop = "copto";
        final String metaValue_got = "g\u00f3tico";
        final String metaValue_mni = "manipuri";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_peo = "persa antiguo";
        final String metaValue_phn = "fenicio";
        final String metaValue_syr = "siriaco";
        final String metaValue_uga = "ugar\u00edtico";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lsch" },
            { "Ogam", "ogham" },
            { "mwl", "mirand\u00e9s" },
            { "Zsym", "s\u00edmbolos" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "Tagb", "tagban\u00faa" },
            { "Zsye", "emojis" },
            { "egy", "egipcio antiguo" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Isla de la Ascensi\u00f3n" },
            { "rar", "rarotongano" },
            { "tet", "tet\u00fan" },
            { "AD", "Andorra" },
            { "AE", "Emiratos \u00c1rabes Unidos" },
            { "nl_BE", "flamenco" },
            { "AF", "Afganist\u00e1n" },
            { "AG", "Antigua y Barbuda" },
            { "type.ca.ethiopic", "calendario et\u00edope" },
            { "AI", "Anguila" },
            { "key.tz", "Zona horaria" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e1rtida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "ingl\u00e9s estadounidense" },
            { "AX", "Islas \u00c5land" },
            { "mye", "myene" },
            { "AZ", "Azerbaiy\u00e1n" },
            { "%%AREVELA", "Armenio oriental" },
            { "BA", "Bosnia y Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Banglad\u00e9s" },
            { "kum", "kumyk" },
            { "BE", "B\u00e9lgica" },
            { "gmh", "alto alem\u00e1n medio" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bar\u00e9in" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "San Bartolom\u00e9" },
            { "BM", "Bermudas" },
            { "kut", "kutenai" },
            { "myv", "erzya" },
            { "BN", "Brun\u00e9i" },
            { "BO", "Bolivia" },
            { "BQ", "Caribe neerland\u00e9s" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "But\u00e1n" },
            { "BV", "Isla Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Bielorrusia" },
            { "BZ", "Belice" },
            { "Visp", "lenguaje visible" },
            { "type.ca.persian", "calendario persa" },
            { "type.nu.hebr", "n\u00fameros en hebreo" },
            { "CA", "Canad\u00e1" },
            { "CC", "Islas Cocos" },
            { "mzn", "mazandaran\u00ed" },
            { "CD", "Rep\u00fablica Democr\u00e1tica del Congo" },
            { "CF", "Rep\u00fablica Centroafricana" },
            { "CG", "Congo" },
            { "CH", "Suiza" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Islas Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u00fan" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Isla Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Curazao" },
            { "CX", "Isla de Navidad" },
            { "CY", "Chipre" },
            { "CZ", "Chequia" },
            { "eka", "ekajuk" },
            { "DE", "Alemania" },
            { "goh", "alto alem\u00e1n antiguo" },
            { "ace", "acehn\u00e9s" },
            { "cgg", "chiga" },
            { "DG", "Diego Garc\u00eda" },
            { "type.nu.deva", "d\u00edgitos en devanagari" },
            { "DJ", "Yibuti" },
            { "DK", "Dinamarca" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "braille" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "n\u00fameros en armenio en min\u00fascula" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "Mtei", metaValue_mni },
            { "zun", "zu\u00f1i" },
            { "tig", "tigr\u00e9" },
            { "DZ", "Argelia" },
            { "pag", "pangasin\u00e1n" },
            { "type.d0.hwidth", "ancho medio" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta y Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonia" },
            { "tiv", "tiv" },
            { "EG", "Egipto" },
            { "EH", "S\u00e1hara Occidental" },
            { "chg", "chagat\u00e1i" },
            { "pau", "palauano" },
            { "chk", "truk\u00e9s" },
            { "chn", "jerga chinuk" },
            { "chm", "mar\u00ed" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", "cheroqui" },
            { "ER", "Eritrea" },
            { "ES", "Espa\u00f1a" },
            { "ET", "Etiop\u00eda" },
            { "EU", "Uni\u00f3n Europea" },
            { "elx", "elamita" },
            { "type.ca.gregorian", "calendario gregoriano" },
            { "EZ", "zona euro" },
            { "chy", "cheyene" },
            { "type.nu.gujr", "d\u00edgitos en guyarat\u00ed" },
            { "Inds", "Indio (harappan)" },
            { "ady", "adigu\u00e9" },
            { "FI", "Finlandia" },
            { "FJ", "Fiyi" },
            { "FK", "Islas Malvinas" },
            { "FM", "Micronesia" },
            { "key.va", "Variante local" },
            { "FO", "Islas Feroe" },
            { "Taml", metaValue_ta },
            { "FR", "Francia" },
            { "tkl", "tokelauano" },
            { "grb", "grebo" },
            { "root", "ra\u00edz" },
            { "type.ca.indian", "calendario nacional hind\u00fa" },
            { "grc", "griego antiguo" },
            { "GA", "Gab\u00f3n" },
            { "vot", "v\u00f3tico" },
            { "GB", "Reino Unido" },
            { "pcm", "pidgin de Nigeria" },
            { "GD", "Granada" },
            { "GE", "Georgia" },
            { "GF", "Guayana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Groenlandia" },
            { "enm", "ingl\u00e9s medio" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Islas Georgia del Sur y Sandwich del Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bis\u00e1u" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "nuevo tai lue" },
            { "GY", "Guyana" },
            { "ckb", "kurdo sorani" },
            { "zxx", "sin contenido ling\u00fc\u00edstico" },
            { "de_AT", "alem\u00e1n austr\u00edaco" },
            { "Vaii", metaValue_vai },
            { "HK", "RAE de Hong Kong (China)" },
            { "HM", "Islas Heard y McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croacia" },
            { "agq", "aghem" },
            { "gsw", "alem\u00e1n suizo" },
            { "type.ca.islamic-umalqura", "calendario isl\u00e1mico umalqura" },
            { "HT", "Hait\u00ed" },
            { "HU", "Hungr\u00eda" },
            { "tmh", "tamashek" },
            { "IC", "Canarias" },
            { "nan", "chino min nan" },
            { "peo", metaValue_peo },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "nap", "napolitano" },
            { "naq", "nama" },
            { "zza", "zazaki" },
            { "IL", "Israel" },
            { "IM", "Isla de Man" },
            { "IN", "India" },
            { "type.co.eor", "reglas de ordenaci\u00f3n europeas" },
            { "IO", "Territorio Brit\u00e1nico del Oc\u00e9ano \u00cdndico" },
            { "IQ", "Irak" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "Zmth", "notaci\u00f3n matem\u00e1tica" },
            { "type.nu.thai", "d\u00edgitos en tailand\u00e9s" },
            { "%%POSIX", "Ordenador" },
            { "type.nu.beng", "d\u00edgitos en bengal\u00ed" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "calendario isl\u00e1mico" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jordania" },
            { "JP", "Jap\u00f3n" },
            { "ain", "ainu" },
            { "guz", "gusii" },
            { "tog", "tonga del Nyasa" },
            { "type.nu.knda", "d\u00edgitos en canar\u00e9s" },
            { "Kali", "kayah li" },
            { "de_CH", "alto alem\u00e1n suizo" },
            { "type.co.phonetic", "Orden de clasificaci\u00f3n fon\u00e9tico" },
            { "type.ca.buddhist", "calendario budista" },
            { "KE", "Kenia" },
            { "419", "Latinoam\u00e9rica" },
            { "KG", "Kirguist\u00e1n" },
            { "KH", "Camboya" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "Knda", metaValue_kn },
            { "KN", "San Crist\u00f3bal y Nieves" },
            { "Zinh", "heredado" },
            { "fr_CA", "franc\u00e9s canadiense" },
            { "KP", "Corea del Norte" },
            { "KR", "Corea del Sur" },
            { "Plrd", "Pollard Miao" },
            { "fr_CH", "franc\u00e9s suizo" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Islas Caim\u00e1n" },
            { "KZ", "Kazajist\u00e1n" },
            { "Cyrl", "cir\u00edlico" },
            { "LA", "Laos" },
            { "LB", "L\u00edbano" },
            { "phn", metaValue_phn },
            { "LC", "Santa Luc\u00eda" },
            { "Cyrs", "cir\u00edlico del antiguo eslavo eclesi\u00e1stico" },
            { "gwi", "kutchin" },
            { "nds", "bajo alem\u00e1n" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "acadio" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgo" },
            { "LV", "Letonia" },
            { "Kana", "katakana" },
            { "LY", "Libia" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marruecos" },
            { "MC", "M\u00f3naco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "San Mart\u00edn" },
            { "lam", "lamba" },
            { "MG", "Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "Islas Marshall" },
            { "ale", "aleutiano" },
            { "type.nu.vaii", "D\u00edgitos vai" },
            { "MK", "Macedonia del Norte" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "RAE de Macao (China)" },
            { "MP", "Islas Marianas del Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "transliteraci\u00f3n UNGEGN" },
            { "MU", "Mauricio" },
            { "alt", "alt\u00e1i meridional" },
            { "MV", "Maldivas" },
            { "MW", "Malaui" },
            { "MX", "M\u00e9xico" },
            { "type.ca.japanese", "calendario japon\u00e9s" },
            { "MY", "Malasia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "202", "\u00c1frica subsahariana" },
            { "type.ca.hebrew", "calendario hebreo" },
            { "type.co.dictionary", "orden de clasificaci\u00f3n del diccionario" },
            { "NC", "Nueva Caledonia" },
            { "%%WADEGILE", "Romanizaci\u00f3n Wade-Giles" },
            { "NE", "N\u00edger" },
            { "NF", "Isla Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Pa\u00edses Bajos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshiano" },
            { "NZ", "Nueva Zelanda" },
            { "rom", "roman\u00ed" },
            { "Mero", "mero\u00edtico" },
            { "crh", "t\u00e1rtaro de Crimea" },
            { "ang", "ingl\u00e9s antiguo" },
            { "OM", "Om\u00e1n" },
            { "anp", "angika" },
            { "crs", "criollo seychelense" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panam\u00e1" },
            { "type.ca.islamic-civil", "calendario civil isl\u00e1mico" },
            { "csb", "casubio" },
            { "en_GB", "ingl\u00e9s brit\u00e1nico" },
            { "PE", "Per\u00fa" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Pap\u00faa Nueva Guinea" },
            { "PH", "Filipinas" },
            { "PK", "Pakist\u00e1n" },
            { "PL", "Polonia" },
            { "ewo", "ewondo" },
            { "PM", "San Pedro y Miquel\u00f3n" },
            { "PN", "Islas Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Territorios Palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palaos" },
            { "nia", "nias" },
            { "type.nu.greklow", "n\u00fameros en griego en min\u00fascula" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Catar" },
            { "%%SCOTLAND", "Ingl\u00e9s escoc\u00e9s est\u00e1ndar" },
            { "niu", "niueano" },
            { "QO", "Territorios alejados de Ocean\u00eda" },
            { "lez", "lezgiano" },
            { "tvl", "tuvaluano" },
            { "001", "Mundo" },
            { "002", "\u00c1frica" },
            { "003", "Am\u00e9rica del Norte" },
            { "RE", "Reuni\u00f3n" },
            { "005", "Sudam\u00e9rica" },
            { "jbo", "lojban" },
            { "Rjng", "rejang" },
            { "009", "Ocean\u00eda" },
            { "RO", "Ruman\u00eda" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "Ugar", metaValue_uga },
            { "Khar", "kharosthi" },
            { "SA", "Arabia Saud\u00ed" },
            { "pon", "pohnpeiano" },
            { "Mand", "mandeo" },
            { "SB", "Islas Salom\u00f3n" },
            { "twq", "tasawaq" },
            { "011", "\u00c1frica occidental" },
            { "SC", "Seychelles" },
            { "SD", "Sud\u00e1n" },
            { "013", "Centroam\u00e9rica" },
            { "SE", "Suecia" },
            { "014", "\u00c1frica oriental" },
            { "arc", "arameo" },
            { "015", "\u00c1frica septentrional" },
            { "SG", "Singapur" },
            { "SH", "Santa Elena" },
            { "type.lb.strict", "estilo de salto de l\u00ednea estricto" },
            { "017", "\u00c1frica central" },
            { "SI", "Eslovenia" },
            { "018", "\u00c1frica meridional" },
            { "SJ", "Svalbard y Jan Mayen" },
            { "019", "Am\u00e9rica" },
            { "SK", "Eslovaquia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "type.nu.taml", "n\u00fameros en tamil tradicional" },
            { "SR", "Surinam" },
            { "SS", "Sud\u00e1n del Sur" },
            { "ST", "Santo Tom\u00e9 y Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "ars", "\u00e1rabe najd\u00ed" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "yao", "yao" },
            { "SZ", "Esuatini" },
            { "arw", "arahuaco" },
            { "yap", "yap\u00e9s" },
            { "TA", "Trist\u00e1n de Acu\u00f1a" },
            { "asa", "asu" },
            { "type.ms.ussystem", "sistema estadounidense" },
            { "021", "Norteam\u00e9rica" },
            { "TC", "Islas Turcas y Caicos" },
            { "yav", "yangben" },
            { "TD", "Chad" },
            { "TF", "Territorios Australes Franceses" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Tayikist\u00e1n" },
            { "029", "Caribe" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "Buscar por consonante inicial de hangul" },
            { "TM", "Turkmenist\u00e1n" },
            { "TN", "T\u00fanez" },
            { "TO", "Tonga" },
            { "TR", "Turqu\u00eda" },
            { "TT", "Trinidad y Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e1n" },
            { "ast", "asturiano" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "alfabeto desconocido" },
            { "UA", "Ucrania" },
            { "rup", "arrumano" },
            { "030", "Asia oriental" },
            { "tyv", "tuviniano" },
            { "sw_CD", "suajili del Congo" },
            { "034", "Asia meridional" },
            { "hai", "haida" },
            { "035", "Sudeste asi\u00e1tico" },
            { "UG", "Uganda" },
            { "hak", "chino hakka" },
            { "type.co.pinyin", "orden pinyin" },
            { "039", "Europa meridional" },
            { "Sinh", metaValue_si },
            { "UM", "Islas menores alejadas de EE. UU." },
            { "UN", "Naciones Unidas" },
            { "US", "Estados Unidos" },
            { "haw", "hawaiano" },
            { "type.co.gb2312han", "orden del chino simplificado - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "prusiano" },
            { "UZ", "Uzbekist\u00e1n" },
            { "tzm", "tamazight del Atlas Central" },
            { "type.co.stroke", "orden de los trazos" },
            { "nnh", "ngiemboon" },
            { "VA", "Ciudad del Vaticano" },
            { "pro", "provenzal antiguo" },
            { "VC", "San Vicente y las Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Islas V\u00edrgenes Brit\u00e1nicas" },
            { "VI", "Islas V\u00edrgenes de EE. UU." },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "n\u00f3rdico antiguo" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis y Futuna" },
            { "type.co.traditional", "orden tradicional" },
            { "057", "Regi\u00f3n de Micronesia" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "type.nu.finance", "N\u00fameros financieros" },
            { "type.co.compat", "orden de clasificaci\u00f3n anterior, para compatibilidad" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "wal", "wolayta" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "avadhi" },
            { "061", "Polinesia" },
            { "XK", "Kosovo" },
            { "Gujr", "gujarati" },
            { "Zxxx", "no escrito" },
            { "Olck", "ol ciki" },
            { "wbp", "warlpiri" },
            { "Batk", "batak" },
            { "Blis", "s\u00edmbolos blis" },
            { "YE", "Yemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "orden est\u00e1ndar" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "Sgnw", "SignWriting" },
            { "YT", "Mayotte" },
            { "ZA", "Sud\u00e1frica" },
            { "type.lb.loose", "estilo de salto de l\u00ednea flexible" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "n\u00fameros en georgiano" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "Romanizaci\u00f3n pinyin" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Regi\u00f3n desconocida" },
            { "Runr", "r\u00fanico" },
            { "type.ms.metric", "sistema m\u00e9trico" },
            { "type.ca.iso8601", "calendario ISO-8601" },
            { "lol", "mongo" },
            { "nso", "sotho septentrional" },
            { "type.nu.telu", "d\u00edgitos en telugu" },
            { "lou", "criollo de Luisiana" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "type.nu.hansfin", "n\u00fameros financieros en chino simplificado" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "d\u00edgitos indoar\u00e1bigos extendidos" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "d\u00edgitos de ancho completo" },
            { "hit", "hitita" },
            { "dar", "dargva" },
            { "dav", "taita" },
            { "Maya", "jerogl\u00edficos mayas" },
            { "lrc", "lor\u00ed septentrional" },
            { "Copt", metaValue_cop },
            { "nwc", "newari cl\u00e1sico" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "type.nu.roman", "n\u00fameros romanos" },
            { "sah", "sakha" },
            { "sam", "arameo samaritano" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "jpr", "judeo-persa" },
            { "type.d0.npinyin", "Num\u00e9rico" },
            { "type.nu.native", "D\u00edgitos nativos" },
            { "sba", "ngambay" },
            { "Guru", "gurmuji" },
            { "lua", "luba-lulua" },
            { "type.d0.fwidth", "ancho completo" },
            { "sbp", "sangu" },
            { "lui", "luise\u00f1o" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipino" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "mizo" },
            { "bal", "baluchi" },
            { "den", "slave" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "luy", "luyia" },
            { "bas", "basaa" },
            { "bax", "bam\u00fan" },
            { "jrb", "judeo-\u00e1rabe" },
            { "es_ES", "espa\u00f1ol de Espa\u00f1a" },
            { "nzi", "nzima" },
            { "sco", "escoc\u00e9s" },
            { "scn", "siciliano" },
            { "aa", "afar" },
            { "ab", "abjasio" },
            { "ae", metaValue_ae },
            { "af", "afrik\u00e1ans" },
            { "ak", "akan" },
            { "bbj", "ghomala" },
            { "am", "am\u00e1rico" },
            { "Arab", metaValue_ar },
            { "an", "aragon\u00e9s" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "silabarios japoneses" },
            { "as", "asam\u00e9s" },
            { "Lina", "lineal A" },
            { "av", "avar" },
            { "Linb", "lineal B" },
            { "sdh", "kurdo meridional" },
            { "ay", "aimara" },
            { "az", "azerbaiyano" },
            { "ba", "baskir" },
            { "type.co.unihan", "orden de clasificaci\u00f3n de trazos radicales" },
            { "be", "bielorruso" },
            { "bg", "b\u00falgaro" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bret\u00f3n" },
            { "bs", "bosnio" },
            { "see", "seneca" },
            { "Mymr", metaValue_my },
            { "type.nu.laoo", "d\u00edgitos en lao" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkup" },
            { "ca", "catal\u00e1n" },
            { "ses", "koyraboro senni" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "%%REVISED", "Ortograf\u00eda revisada" },
            { "co", "corso" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "checo" },
            { "cu", "eslavo eclesi\u00e1stico" },
            { "cv", "chuvasio" },
            { "cy", "gal\u00e9s" },
            { "type.nu.ethi", "n\u00fameros en et\u00edope" },
            { "Yiii", "yi" },
            { "da", "dan\u00e9s" },
            { "pt_PT", "portugu\u00e9s de Portugal" },
            { "de", "alem\u00e1n" },
            { "type.cf.standard", "formato de moneda est\u00e1ndar" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "Bugi", metaValue_bug },
            { "bem", "bemba" },
            { "sga", "irland\u00e9s antiguo" },
            { "type.nu.mong", "d\u00edgitos en mongol" },
            { "dv", "divehi" },
            { "es_419", "espa\u00f1ol latinoamericano" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "calendario chino" },
            { "dje", "zarma" },
            { "type.nu.grek", "n\u00fameros en griego" },
            { "ee", "ew\u00e9" },
            { "bfd", "bafut" },
            { "type.lb.normal", "estilo de salto de l\u00ednea normal" },
            { "ro_MD", "moldavo" },
            { "el", metaValue_el },
            { "en", "ingl\u00e9s" },
            { "eo", "esperanto" },
            { "type.co.big5han", "orden del chino tradicional - Big5" },
            { "es", "espa\u00f1ol" },
            { "et", "estonio" },
            { "Hanb", "hanb" },
            { "eu", "euskera" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "shi", "tashelhit" },
            { "hsb", "alto sorbio" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "Hano", "hanunoo" },
            { "fa", "persa" },
            { "Hans", "simplificado" },
            { "type.nu.latn", "d\u00edgitos occidentales" },
            { "Hant", "tradicional" },
            { "ff", "fula" },
            { "shu", "\u00e1rabe chadiano" },
            { "hsn", "chino xiang" },
            { "fi", "fin\u00e9s" },
            { "fj", "fiyiano" },
            { "fon", "fon" },
            { "bgn", "baluchi occidental" },
            { "yue", "canton\u00e9s" },
            { "fo", "fero\u00e9s" },
            { "type.m0.bgn", "transliteraci\u00f3n USBGN" },
            { "umb", "umbundu" },
            { "fr", "franc\u00e9s" },
            { "sid", "sidamo" },
            { "fy", "fris\u00f3n occidental" },
            { "ga", "irland\u00e9s" },
            { "gd", "ga\u00e9lico escoc\u00e9s" },
            { "gl", "gallego" },
            { "gn", "guaran\u00ed" },
            { "bho", "bhoyapur\u00ed" },
            { "und", "lengua desconocida" },
            { "type.ca.ethiopic-amete-alem", "calendario et\u00edope Amete Alem" },
            { "gu", "guyarat\u00ed" },
            { "gv", "man\u00e9s" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bicol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "criollo haitiano" },
            { "hu", "h\u00fangaro" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "frc", "franc\u00e9s caj\u00fan" },
            { "%%FONIPA", "Alfabeto fon\u00e9tico internacional IPA" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indonesio" },
            { "type.nu.tibt", "d\u00edgitos en tibetano" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi de Sichu\u00e1n" },
            { "frm", "franc\u00e9s medio" },
            { "ik", "inupiaq" },
            { "fro", "franc\u00e9s antiguo" },
            { "io", "ido" },
            { "frs", "fris\u00f3n oriental" },
            { "frr", "fris\u00f3n septentrional" },
            { "is", "island\u00e9s" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", "malay\u00e1lam" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "bkm", "kom" },
            { "sma", "sami meridional" },
            { "jv", metaValue_jv },
            { "Shaw", "shaviano" },
            { "mad", "madur\u00e9s" },
            { "smj", "sami lule" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "sami inari" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "macasar" },
            { "wuu", "chino wu" },
            { "sms", "sami skolt" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "mas\u00e1i" },
            { "kj", "kuanyama" },
            { "kk", "kazajo" },
            { "kl", "groenland\u00e9s" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "cachemiro" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "kurdo" },
            { "kv", "komi" },
            { "kw", "c\u00f3rnico" },
            { "ky", "kirgu\u00eds" },
            { "snk", "sonink\u00e9" },
            { "la", "lat\u00edn" },
            { "lb", "luxemburgu\u00e9s" },
            { "type.nu.mlym", "d\u00edgitos en malayalam" },
            { "lg", "ganda" },
            { "Roro", "rongo-rongo" },
            { "li", "limburgu\u00e9s" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulano" },
            { "lo", "lao" },
            { "type.ms.uksystem", "sistema imperial" },
            { "lt", "lituano" },
            { "lu", "luba-katanga" },
            { "lv", "let\u00f3n" },
            { "sog", "sogdiano" },
            { "mg", "malgache" },
            { "mh", "marshal\u00e9s" },
            { "type.co.ducet", "orden predeterminado de Unicode" },
            { "mi", "maor\u00ed" },
            { "mk", "macedonio" },
            { "ml", "malayalam" },
            { "mn", metaValue_mn },
            { "mr", "marat\u00ed" },
            { "ms", "malayo" },
            { "mt", "malt\u00e9s" },
            { "my", metaValue_my },
            { "Saur", "saurashtra" },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "mde", "maba" },
            { "dsb", "bajo sorbio" },
            { "na", "nauruano" },
            { "type.co.search", "b\u00fasqueda de uso general" },
            { "nb", "noruego bokmal" },
            { "nd", "ndebele septentrional" },
            { "ne", "nepal\u00ed" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "neerland\u00e9s" },
            { "nn", "noruego nynorsk" },
            { "no", "noruego" },
            { "nr", "ndebele meridional" },
            { "nv", "navajo" },
            { "kaa", "karakalpako" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "cabila" },
            { "%%POLYTON", "Polit\u00f3nico" },
            { "oc", "occitano" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "type.nu.armn", "n\u00fameros en armenio" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "or", metaValue_or },
            { "os", "os\u00e9tico" },
            { "kbd", "kabardiano" },
            { "mfe", "criollo mauriciano" },
            { "srn", "sranan tongo" },
            { "pa", "panyab\u00ed" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "pl", "polaco" },
            { "dum", "neerland\u00e9s medio" },
            { "type.ca.dangi", "calendario dangi" },
            { "ps", "past\u00fan" },
            { "pt", "portugu\u00e9s" },
            { "mga", "irland\u00e9s medio" },
            { "key.co", "orden" },
            { "pt_BR", "portugu\u00e9s de Brasil" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "key.cf", "formato de moneda" },
            { "bra", "braj" },
            { "key.ca", "calendario" },
            { "Laoo", "laosiano" },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "sistema de 24 horas (0\u201323)" },
            { "type.hc.h24", "sistema de 24 horas (1\u201324)" },
            { "ssy", "saho" },
            { "type.nu.mymr", "d\u00edgitos en birmano" },
            { "qu", "quechua" },
            { "zap", "zapoteco" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "Ethi", "eti\u00f3pico" },
            { "type.hc.h12", "sistema de 12 horas (1\u201312)" },
            { "type.hc.h11", "sistema de 12 horas (0\u201311)" },
            { "rm", "romanche" },
            { "rn", "kirundi" },
            { "key.cu", "moneda" },
            { "ro", "rumano" },
            { "type.nu.orya", "d\u00edgitos en oriya" },
            { "type.nu.hanidec", "n\u00fameros decimales en chino" },
            { "ru", "ruso" },
            { "bss", "akoose" },
            { "rw", "kinyarwanda" },
            { "zbl", "s\u00edmbolos Bliss" },
            { "kea", "criollo caboverdiano" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "ingl\u00e9s australiano" },
            { "sa", "s\u00e1nscrito" },
            { "sc", "sardo" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "sami septentrional" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbocroata" },
            { "si", metaValue_si },
            { "sux", "sumerio" },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somal\u00ed" },
            { "type.nu.arab", "d\u00edgitos indoar\u00e1bigos" },
            { "sq", "alban\u00e9s" },
            { "sr", "serbio" },
            { "ss", "suazi" },
            { "type.cf.account", "formato de moneda de contabilidad" },
            { "Java", metaValue_jv },
            { "st", "sotho meridional" },
            { "su", metaValue_su },
            { "sv", "sueco" },
            { "sw", "suajili" },
            { "type.nu.hantfin", "n\u00fameros financieros en chino tradicional" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "bua", "buriato" },
            { "143", "Asia central" },
            { "te", metaValue_te },
            { "145", "Asia occidental" },
            { "tg", "tayiko" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "tigri\u00f1a" },
            { "kfo", "koro" },
            { "en_CA", "ingl\u00e9s canadiense" },
            { "tk", "turcomano" },
            { "tl", metaValue_tl },
            { "tn", "setsuana" },
            { "to", "tongano" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "n\u00fameros en japon\u00e9s" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "swb", "comorense" },
            { "tt", "t\u00e1rtaro" },
            { "dyu", "diula" },
            { "tw", "twi" },
            { "ty", "tahitiano" },
            { "150", "Europa" },
            { "151", "Europa oriental" },
            { "154", "Europa septentrional" },
            { "dzg", "dazaga" },
            { "155", "Europa occidental" },
            { "ug", "uigur" },
            { "Kore", metaValue_ko },
            { "Ital", "antigua bastardilla" },
            { "Zyyy", "com\u00fan" },
            { "uk", "ucraniano" },
            { "type.ca.coptic", "calendario c\u00f3ptico" },
            { "ur", "urdu" },
            { "xal", "kalmyk" },
            { "zen", "zenaga" },
            { "uz", "uzbeko" },
            { "kha", "khasi" },
            { "%%1996", "Ortograf\u00eda alemana de 1996" },
            { "nds_NL", "bajo saj\u00f3n" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "type.ca.roc", "calendario de la Rep\u00fablica de China" },
            { "vi", "vietnamita" },
            { "kho", "kotan\u00e9s" },
            { "khq", "koyra chiini" },
            { "key.hc", "ciclo horario (12 o 24 horas)" },
            { "vo", "volap\u00fck" },
            { "syc", "sir\u00edaco cl\u00e1sico" },
            { "Osma", "osmaniya" },
            { "quc", "quich\u00e9" },
            { "gaa", "ga" },
            { "wa", "val\u00f3n" },
            { "gag", "gagauzo" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "chino gan" },
            { "Lydi", "lidio" },
            { "Xsux", "cuneiforme sumerio-acadio" },
            { "wo", "w\u00f3lof" },
            { "zgh", "tamazight est\u00e1ndar marroqu\u00ed" },
            { "ar_001", "\u00e1rabe est\u00e1ndar moderno" },
            { "Cans", "silabarios abor\u00edgenes canadienses unificados" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "manch\u00fa" },
            { "Latf", "latino fraktur" },
            { "gba", "gbaya" },
            { "mni", metaValue_mni },
            { "Latn", "latino" },
            { "Latg", "latino ga\u00e9lico" },
            { "type.nu.hans", "n\u00fameros en chino simplificado" },
            { "type.nu.hant", "n\u00fameros en chino tradicional" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "n\u00fameros romanos en min\u00fascula" },
            { "byn", "blin" },
            { "Lyci", "licio" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "Syrc", metaValue_syr },
            { "yi", "yidis" },
            { "mos", "mossi" },
            { "Dsrt", "deseret" },
            { "yo", "yoruba" },
            { "type.nu.traditional", "N\u00fameros tradicionales" },
            { "es_MX", "espa\u00f1ol de M\u00e9xico" },
            { "Syrj", "siriaco occidental" },
            { "ota", "turco otomano" },
            { "Syre", "siriaco estrangelo" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "cario" },
            { "kln", "kalenjin" },
            { "zh", "chino" },
            { "Bopo", "bopomofo" },
            { "Perm", "permiano antiguo" },
            { "key.lb", "estilo de salto de l\u00ednea" },
            { "zu", "zul\u00fa" },
            { "type.co.phonebook", "orden de list\u00edn telef\u00f3nico" },
            { "%%MONOTON", "Monot\u00f3nico" },
            { "Geor", metaValue_ka },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "n\u00fameros financieros en japon\u00e9s" },
            { "Cham", "cham" },
            { "gez", "geez" },
            { "Syrn", "siriaco oriental" },
            { "type.co.reformed", "orden de clasificaci\u00f3n reformado" },
            { "Tglg", metaValue_tl },
            { "Egyd", "egipcio dem\u00f3tico" },
            { "Egyh", "egipcio hier\u00e1tico" },
            { "ebu", "embu" },
            { "Egyp", "jerogl\u00edficos egipcios" },
            { "Geok", "georgiano eclesi\u00e1stico" },
            { "zh_Hans", "chino simplificado" },
            { "koi", "komi permio" },
            { "Hung", "h\u00fangaro antiguo" },
            { "kok", "konkan\u00ed" },
            { "%%1901", "Ortograf\u00eda alemana tradicional" },
            { "kos", "kosraeano" },
            { "zh_Hant", "chino tradicional" },
            { "Sund", metaValue_su },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "d\u00edgitos en jemer" },
            { "ilo", "ilocano" },
            { "%%VALENCIA", "Valenciano" },
            { "Cprt", "chipriota" },
            { "mua", "mundang" },
            { "type.nu.guru", "d\u00edgitos en gurmuji" },
            { "mul", "varios idiomas" },
            { "cad", "caddo" },
            { "key.ms", "sistema de medici\u00f3n" },
            { "mus", "creek" },
            { "Glag", "glagol\u00edtico" },
            { "gil", "gilbert\u00e9s" },
            { "Cher", "cherokee" },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "type.nu.tamldec", "d\u00edgitos en tamil" },
            { "krc", "karachay-balkar" },
            { "inh", "ingush" },
            { "krl", "carelio" },
            { "efi", "efik" },
            { "key.nu", "n\u00fameros" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
