/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.unicodeconvert;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.net.URI;
import java.util.List;
import net.sourceforge.unicodeconvert.Gui;

class FileDropTargetListener
extends DropTargetAdapter {
    private Gui unicon;
    private File[] files;

    public FileDropTargetListener(Gui gui) {
        this.unicon = gui;
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.files == null) {
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i].isFlavorTextType()) {
                    dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                    return;
                }
                if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
                dropTargetDragEvent.acceptDrag(1);
                return;
            }
        }
        dropTargetDragEvent.rejectDrag();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        boolean bl = System.getProperty("os.name").equals("Linux");
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            try {
                if (!dataFlavorArray[i].equals(DataFlavor.javaFileListFlavor) && (!bl || !dataFlavorArray[i].getPrimaryType().equals("text") || !dataFlavorArray[i].getSubType().equals("uri-list"))) continue;
                dropTargetDropEvent.acceptDrop(1);
                if (dataFlavorArray[i].equals(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    this.files = (File[])list.toArray();
                } else {
                    String string = transferable.getTransferData(DataFlavor.stringFlavor).toString().replaceAll("\r\n?", "\n");
                    String[] stringArray = string.split("\\n");
                    this.files = new File[stringArray.length];
                    for (int j = 0; j < stringArray.length; ++j) {
                        this.files[j] = new File(new URI(stringArray[j]));
                    }
                }
                new Thread(){

                    @Override
                    public void run() {
                        if (FileDropTargetListener.this.files.length == 1 && FileDropTargetListener.this.files[0].isDirectory()) {
                            FileDropTargetListener.this.unicon.runTask(FileDropTargetListener.this.files[0]);
                        } else {
                            FileDropTargetListener.this.unicon.runTask(FileDropTargetListener.this.files);
                        }
                        FileDropTargetListener.access$002(FileDropTargetListener.this, null);
                    }
                }.start();
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
        }
        dropTargetDropEvent.dropComplete(false);
    }

    static /* synthetic */ File[] access$002(FileDropTargetListener fileDropTargetListener, File[] fileArray) {
        fileDropTargetListener.files = fileArray;
        return fileArray;
    }
}

