/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.AbstractTypePreparator;
import org.jetbrains.kotlin.types.AbstractTypeRefiner;
import org.jetbrains.kotlin.types.model.CapturedTypeMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContext;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0002DEB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ)\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\b\b\u0002\u0010*\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010+J<\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u001b2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00030/2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002010/H\u0086\b\u00f8\u0001\u0000J\u0006\u00102\u001a\u000203J\u0018\u00104\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J\u0018\u00105\u001a\u0002062\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010)\u001a\u000207H\u0016J\u0006\u00108\u001a\u000203J\u000e\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020(J\u000e\u0010;\u001a\u00020(2\u0006\u0010:\u001a\u00020(J\u000e\u0010<\u001a\u00020(2\u0006\u0010:\u001a\u00020(J:\u0010=\u001a\u0002H>\"\u0004\b\u0000\u0010>2\u0006\u0010?\u001a\u00020(2\u0017\u0010@\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H>0/\u00a2\u0006\u0002\bAH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\bB\u0010CR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R.\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010!\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010 2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/types/TypeCheckerState;", "", "isErrorTypeEqualsToAnything", "", "isStubTypeEqualsToAnything", "allowedTypeVariable", "typeSystemContext", "Lorg/jetbrains/kotlin/types/model/TypeSystemContext;", "kotlinTypePreparator", "Lorg/jetbrains/kotlin/types/AbstractTypePreparator;", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/AbstractTypeRefiner;", "(ZZZLorg/jetbrains/kotlin/types/model/TypeSystemContext;Lorg/jetbrains/kotlin/types/AbstractTypePreparator;Lorg/jetbrains/kotlin/types/AbstractTypeRefiner;)V", "getAllowedTypeVariable", "()Z", "argumentsDepth", "", "getArgumentsDepth", "()I", "setArgumentsDepth", "(I)V", "getKotlinTypePreparator", "()Lorg/jetbrains/kotlin/types/AbstractTypePreparator;", "getKotlinTypeRefiner", "()Lorg/jetbrains/kotlin/types/AbstractTypeRefiner;", "<set-?>", "Ljava/util/ArrayDeque;", "Lorg/jetbrains/kotlin/types/model/SimpleTypeMarker;", "supertypesDeque", "getSupertypesDeque", "()Ljava/util/ArrayDeque;", "supertypesLocked", "", "supertypesSet", "getSupertypesSet", "()Ljava/util/Set;", "getTypeSystemContext", "()Lorg/jetbrains/kotlin/types/model/TypeSystemContext;", "addSubtypeConstraint", "subType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "superType", "isFromNullabilityConstraint", "(Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Z)Ljava/lang/Boolean;", "anySupertype", "start", "predicate", "Lkotlin/Function1;", "supertypesPolicy", "Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy;", "clear", "", "customIsSubtypeOf", "getLowerCapturedTypePolicy", "Lorg/jetbrains/kotlin/types/TypeCheckerState$LowerCapturedTypePolicy;", "Lorg/jetbrains/kotlin/types/model/CapturedTypeMarker;", "initialize", "isAllowedTypeVariable", "type", "prepareType", "refineType", "runWithArgumentsSettings", "T", "subArgument", "f", "Lkotlin/ExtensionFunctionType;", "runWithArgumentsSettings$compiler_common", "(Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "LowerCapturedTypePolicy", "SupertypesPolicy", "compiler.common"})
public class TypeCheckerState {
    private final boolean isErrorTypeEqualsToAnything;
    private final boolean isStubTypeEqualsToAnything;
    private final boolean allowedTypeVariable;
    @NotNull
    private final TypeSystemContext typeSystemContext;
    @NotNull
    private final AbstractTypePreparator kotlinTypePreparator;
    @NotNull
    private final AbstractTypeRefiner kotlinTypeRefiner;
    private int argumentsDepth;
    private boolean supertypesLocked;
    @Nullable
    private ArrayDeque<SimpleTypeMarker> supertypesDeque;
    @Nullable
    private Set<SimpleTypeMarker> supertypesSet;

    public TypeCheckerState(boolean isErrorTypeEqualsToAnything, boolean isStubTypeEqualsToAnything, boolean allowedTypeVariable, @NotNull TypeSystemContext typeSystemContext2, @NotNull AbstractTypePreparator kotlinTypePreparator, @NotNull AbstractTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)typeSystemContext2, (String)"typeSystemContext");
        Intrinsics.checkNotNullParameter((Object)kotlinTypePreparator, (String)"kotlinTypePreparator");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        this.isErrorTypeEqualsToAnything = isErrorTypeEqualsToAnything;
        this.isStubTypeEqualsToAnything = isStubTypeEqualsToAnything;
        this.allowedTypeVariable = allowedTypeVariable;
        this.typeSystemContext = typeSystemContext2;
        this.kotlinTypePreparator = kotlinTypePreparator;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
    }

    public final boolean isErrorTypeEqualsToAnything() {
        return this.isErrorTypeEqualsToAnything;
    }

    public final boolean isStubTypeEqualsToAnything() {
        return this.isStubTypeEqualsToAnything;
    }

    public final boolean getAllowedTypeVariable() {
        return this.allowedTypeVariable;
    }

    @NotNull
    public final TypeSystemContext getTypeSystemContext() {
        return this.typeSystemContext;
    }

    @NotNull
    public final AbstractTypePreparator getKotlinTypePreparator() {
        return this.kotlinTypePreparator;
    }

    @NotNull
    public final AbstractTypeRefiner getKotlinTypeRefiner() {
        return this.kotlinTypeRefiner;
    }

    @NotNull
    public final KotlinTypeMarker refineType(@NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return this.kotlinTypeRefiner.refineType(type2);
    }

    @NotNull
    public final KotlinTypeMarker prepareType(@NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return this.kotlinTypePreparator.prepareType(type2);
    }

    public boolean customIsSubtypeOf(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType2) {
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
        return true;
    }

    protected final int getArgumentsDepth() {
        return this.argumentsDepth;
    }

    protected final void setArgumentsDepth(int n) {
        this.argumentsDepth = n;
    }

    public final <T> T runWithArgumentsSettings$compiler_common(@NotNull KotlinTypeMarker subArgument, @NotNull Function1<? super TypeCheckerState, ? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)subArgument, (String)"subArgument");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$runWithArgumentsSettings$compiler_common = false;
        if (this.argumentsDepth > 100) {
            throw new IllegalStateException(("Arguments depth is too high. Some related argument: " + subArgument).toString());
        }
        int n = this.argumentsDepth;
        this.argumentsDepth = n + 1;
        Object result2 = f.invoke((Object)this);
        int n2 = this.argumentsDepth;
        this.argumentsDepth = n2 + -1;
        return (T)result2;
    }

    @NotNull
    public LowerCapturedTypePolicy getLowerCapturedTypePolicy(@NotNull SimpleTypeMarker subType, @NotNull CapturedTypeMarker superType2) {
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
        return LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER;
    }

    @Nullable
    public Boolean addSubtypeConstraint(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType2, boolean isFromNullabilityConstraint) {
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
        return null;
    }

    public static /* synthetic */ Boolean addSubtypeConstraint$default(TypeCheckerState typeCheckerState, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSubtypeConstraint");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return typeCheckerState.addSubtypeConstraint(kotlinTypeMarker, kotlinTypeMarker2, bl);
    }

    @Nullable
    public final ArrayDeque<SimpleTypeMarker> getSupertypesDeque() {
        return this.supertypesDeque;
    }

    @Nullable
    public final Set<SimpleTypeMarker> getSupertypesSet() {
        return this.supertypesSet;
    }

    public final void initialize() {
        boolean bl;
        boolean bl2 = bl = !this.supertypesLocked;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Supertypes were locked for " + Reflection.getOrCreateKotlinClass(this.getClass());
            throw new AssertionError((Object)string2);
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque(4);
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = SmartSet.Companion.create();
        }
    }

    public final void clear() {
        ArrayDeque<SimpleTypeMarker> arrayDeque = this.supertypesDeque;
        Intrinsics.checkNotNull(arrayDeque);
        arrayDeque.clear();
        Set<SimpleTypeMarker> set = this.supertypesSet;
        Intrinsics.checkNotNull(set);
        set.clear();
        this.supertypesLocked = false;
    }

    public final boolean anySupertype(@NotNull SimpleTypeMarker start, @NotNull Function1<? super SimpleTypeMarker, Boolean> predicate, @NotNull Function1<? super SimpleTypeMarker, ? extends SupertypesPolicy> supertypesPolicy) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter(supertypesPolicy, (String)"supertypesPolicy");
        boolean $i$f$anySupertype = false;
        if (((Boolean)predicate.invoke((Object)start)).booleanValue()) {
            return true;
        }
        this.initialize();
        ArrayDeque<SimpleTypeMarker> arrayDeque = this.getSupertypesDeque();
        Intrinsics.checkNotNull(arrayDeque);
        ArrayDeque<SimpleTypeMarker> deque = arrayDeque;
        Set<SimpleTypeMarker> set = this.getSupertypesSet();
        Intrinsics.checkNotNull(set);
        Set<SimpleTypeMarker> visitedSupertypes = set;
        deque.push(start);
        while (!((Collection)deque).isEmpty()) {
            if (visitedSupertypes.size() > 1000) {
                throw new IllegalStateException(("Too many supertypes for type: " + start + ". Supertypes = " + CollectionsKt.joinToString$default((Iterable)visitedSupertypes, null, null, null, (int)0, null, null, (int)63, null)).toString());
            }
            SimpleTypeMarker current = deque.pop();
            Intrinsics.checkNotNullExpressionValue((Object)current, (String)"current");
            if (!visitedSupertypes.add(current)) continue;
            Iterator<KotlinTypeMarker> iterator2 = supertypesPolicy.invoke((Object)current);
            SupertypesPolicy it = (SupertypesPolicy)((Object)iterator2);
            boolean bl = false;
            if ((SupertypesPolicy)((Object)(!Intrinsics.areEqual((Object)it, (Object)SupertypesPolicy.None.INSTANCE) ? iterator2 : null)) == null) continue;
            TypeSystemContext $this$anySupertype_u24lambda_u2d2 = this.getTypeSystemContext();
            boolean bl2 = false;
            Collection<KotlinTypeMarker> supertypes2 = $this$anySupertype_u24lambda_u2d2.supertypes($this$anySupertype_u24lambda_u2d2.typeConstructor(current));
            for (KotlinTypeMarker supertype2 : supertypes2) {
                SupertypesPolicy policy;
                SimpleTypeMarker newType = policy.transformType(this, supertype2);
                if (((Boolean)predicate.invoke((Object)newType)).booleanValue()) {
                    this.clear();
                    return true;
                }
                deque.add(newType);
            }
        }
        this.clear();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAllowedTypeVariable(@NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!this.allowedTypeVariable) return false;
        TypeSystemContext $this$isAllowedTypeVariable_u24lambda_u2d3 = this.typeSystemContext;
        boolean bl = false;
        if (!$this$isAllowedTypeVariable_u24lambda_u2d3.isTypeVariableType(type2)) return false;
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/types/TypeCheckerState$LowerCapturedTypePolicy;", "", "(Ljava/lang/String;I)V", "CHECK_ONLY_LOWER", "CHECK_SUBTYPE_AND_LOWER", "SKIP_LOWER", "compiler.common"})
    public static final class LowerCapturedTypePolicy
    extends Enum<LowerCapturedTypePolicy> {
        public static final /* enum */ LowerCapturedTypePolicy CHECK_ONLY_LOWER = new LowerCapturedTypePolicy();
        public static final /* enum */ LowerCapturedTypePolicy CHECK_SUBTYPE_AND_LOWER = new LowerCapturedTypePolicy();
        public static final /* enum */ LowerCapturedTypePolicy SKIP_LOWER = new LowerCapturedTypePolicy();
        private static final /* synthetic */ LowerCapturedTypePolicy[] $VALUES;

        public static LowerCapturedTypePolicy[] values() {
            return (LowerCapturedTypePolicy[])$VALUES.clone();
        }

        public static LowerCapturedTypePolicy valueOf(String value2) {
            return Enum.valueOf(LowerCapturedTypePolicy.class, value2);
        }

        static {
            $VALUES = lowerCapturedTypePolicyArray = new LowerCapturedTypePolicy[]{LowerCapturedTypePolicy.CHECK_ONLY_LOWER, LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER, LowerCapturedTypePolicy.SKIP_LOWER};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\t\n\u000b\fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u0082\u0001\u0004\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy;", "", "()V", "transformType", "Lorg/jetbrains/kotlin/types/model/SimpleTypeMarker;", "state", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "type", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "DoCustomTransform", "LowerIfFlexible", "None", "UpperIfFlexible", "Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$None;", "Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$UpperIfFlexible;", "Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$LowerIfFlexible;", "Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$DoCustomTransform;", "compiler.common"})
    public static abstract class SupertypesPolicy {
        private SupertypesPolicy() {
        }

        @NotNull
        public abstract SimpleTypeMarker transformType(@NotNull TypeCheckerState var1, @NotNull KotlinTypeMarker var2);

        public /* synthetic */ SupertypesPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$None;", "Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy;", "()V", "transformType", "", "state", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "type", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "compiler.common"})
        public static final class None
        extends SupertypesPolicy {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }

            @NotNull
            public Void transformType(@NotNull TypeCheckerState state, @NotNull KotlinTypeMarker type2) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                throw new UnsupportedOperationException("Should not be called");
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$UpperIfFlexible;", "Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy;", "()V", "transformType", "Lorg/jetbrains/kotlin/types/model/SimpleTypeMarker;", "state", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "type", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "compiler.common"})
        public static final class UpperIfFlexible
        extends SupertypesPolicy {
            @NotNull
            public static final UpperIfFlexible INSTANCE = new UpperIfFlexible();

            private UpperIfFlexible() {
                super(null);
            }

            @Override
            @NotNull
            public SimpleTypeMarker transformType(@NotNull TypeCheckerState state, @NotNull KotlinTypeMarker type2) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                TypeSystemContext $this$transformType_u24lambda_u2d0 = state.getTypeSystemContext();
                boolean bl = false;
                return $this$transformType_u24lambda_u2d0.upperBoundIfFlexible(type2);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$LowerIfFlexible;", "Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy;", "()V", "transformType", "Lorg/jetbrains/kotlin/types/model/SimpleTypeMarker;", "state", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "type", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "compiler.common"})
        public static final class LowerIfFlexible
        extends SupertypesPolicy {
            @NotNull
            public static final LowerIfFlexible INSTANCE = new LowerIfFlexible();

            private LowerIfFlexible() {
                super(null);
            }

            @Override
            @NotNull
            public SimpleTypeMarker transformType(@NotNull TypeCheckerState state, @NotNull KotlinTypeMarker type2) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                TypeSystemContext $this$transformType_u24lambda_u2d0 = state.getTypeSystemContext();
                boolean bl = false;
                return $this$transformType_u24lambda_u2d0.lowerBoundIfFlexible(type2);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$DoCustomTransform;", "Lorg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy;", "()V", "compiler.common"})
        public static abstract class DoCustomTransform
        extends SupertypesPolicy {
            public DoCustomTransform() {
                super(null);
            }
        }
    }
}

