/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\u001b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001c*\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001eH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkParameterBounds", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkSupertypes", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "findVisibilityExposure", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "checkers"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration2, reporter, context2);
        }
    }

    private final void checkClass(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        this.checkSupertypes(declaration2, reporter, context2);
        this.checkParameterBounds(declaration2, reporter, context2);
    }

    private final void checkSupertypes(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        Object object2 = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
            object2 = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(classVisibility = object2), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes2 = declaration2.getSuperTypeRefs();
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        object = supertypes2.iterator();
        while (object.hasNext()) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
            FirRegularClassSymbol classSymbol;
            boolean superIsInterface;
            ConeClassLikeType supertype2;
            FirTypeRef supertypeRef;
            FirTypeRef $this$coneTypeSafe$iv = supertypeRef = (FirTypeRef)object.next();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null || FirHelpersKt.toRegularClassSymbol(supertype2, context2.getSession()) == null || (superIsInterface = classSymbol.getClassKind() == ClassKind.INTERFACE) != isInterface || this.findVisibilityExposure(supertype2, context2, (EffectiveVisibility)classVisibility) == null) continue;
            FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
            KtSourceElement ktSourceElement = supertypeRef.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = declaration2.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), classVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
        }
    }

    private final void checkParameterBounds(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(classVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        for (FirTypeParameterRef parameter : declaration2.getTypeParameters()) {
            for (FirResolvedTypeRef bound : parameter.getSymbol().getResolvedBounds()) {
                Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
                if (this.findVisibilityExposure(FirTypeUtilsKt.getConeType(bound), context2, (EffectiveVisibility)classVisibility) == null) continue;
                FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
                EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND(), classVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
        }
    }

    private final void checkTypeAlias(FirTypeAlias declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object typeAliasVisibility;
        Pair<FirBasedSymbol<?>, EffectiveVisibility> expandedType2 = FirDeclarationUtilKt.getExpandedConeType(declaration2);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(typeAliasVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = expandedType2;
        if (pair == null || (pair = this.findVisibilityExposure((ConeKotlinType)pair, context2, (EffectiveVisibility)typeAliasVisibility)) == null) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2 = pair;
        FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), typeAliasVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunction(FirFunction declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object restrictingVisibility;
        Object functionVisibility;
        Object $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = ((FirMemberDeclaration)$this$effectiveVisibility$iv).getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(functionVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        if (!(declaration2 instanceof FirConstructor) && !(declaration2 instanceof FirPropertyAccessor)) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> $this$coneTypeSafe$iv = declaration2.getReturnTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            if (($this$effectiveVisibility$iv = coneKotlinType) != null && ($this$coneTypeSafe$iv = this.findVisibilityExposure((ConeKotlinType)$this$effectiveVisibility$iv, context2, (EffectiveVisibility)functionVisibility)) != null) {
                Iterator iterator2 = $this$coneTypeSafe$iv;
                boolean bl = false;
                FirBasedSymbol restricting = (FirBasedSymbol)iterator2.component1();
                restrictingVisibility = (EffectiveVisibility)iterator2.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), functionVisibility, (Object)restricting, restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
        }
        if (!(declaration2 instanceof FirPropertyAccessor)) {
            Iterable $this$forEachIndexed$iv = declaration2.getValueParameters();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                ConeKotlinType coneKotlinType;
                void valueParameter2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                restrictingVisibility = (FirValueParameter)item$iv;
                int i = n;
                boolean bl = false;
                if (i >= declaration2.getValueParameters().size()) continue;
                Pair<FirBasedSymbol<?>, EffectiveVisibility> $this$coneTypeSafe$iv = valueParameter2.getReturnTypeRef();
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                    coneKotlinType2 = null;
                }
                if ((coneKotlinType = coneKotlinType2) == null || ($this$coneTypeSafe$iv = INSTANCE.findVisibilityExposure(coneKotlinType, context2, (EffectiveVisibility)functionVisibility)) == null) continue;
                Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = $this$coneTypeSafe$iv;
                FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
                EffectiveVisibility restrictingVisibility2 = (EffectiveVisibility)pair.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), functionVisibility, (Object)restricting, (Object)restrictingVisibility2, (DiagnosticContext)context2, null, 64, null);
            }
        }
        this.checkMemberReceiver(declaration2.getReceiverTypeRef(), declaration2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration2 : null, reporter, context2);
    }

    private final void checkProperty(FirProperty declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
        ConeKotlinType coneKotlinType;
        Object propertyVisibility;
        if (declaration2.isLocal()) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(propertyVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = declaration2.getReturnTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) != null && (pair = this.findVisibilityExposure(coneKotlinType, context2, (EffectiveVisibility)propertyVisibility)) != null) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2 = pair;
            boolean bl = false;
            FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair2.component2();
            if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor(declaration2), (Object)true)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR(), propertyVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), propertyVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
        }
        this.checkMemberReceiver(declaration2.getReceiverTypeRef(), declaration2, reporter, context2);
    }

    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableDeclaration memberDeclaration, DiagnosticReporter reporter, CheckerContext context2) {
        Object memberVisibility;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(memberVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair = this.findVisibilityExposure(receiverParameterType, context2, (EffectiveVisibility)memberVisibility);
        if (pair == null) {
            return;
        }
        Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2 = pair;
        FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), memberVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
    }

    private final Pair<FirBasedSymbol<?>, EffectiveVisibility> findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context2, EffectiveVisibility base) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        FirClassLikeSymbol $this$effectiveVisibility$iv;
        ConeClassLikeType coneClassLikeType = $this$findVisibilityExposure instanceof ConeClassLikeType ? (ConeClassLikeType)$this$findVisibilityExposure : null;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        ConeTypeProjection[] coneTypeProjectionArray = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null).getLookupTag(), context2.getSession());
        if (coneTypeProjectionArray == null) {
            return null;
        }
        ConeTypeProjection[] classSymbol = coneTypeProjectionArray;
        ConeTypeProjection[] coneTypeProjectionArray2 = classSymbol;
        if (coneTypeProjectionArray2 instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = (FirClassSymbol)classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = ((FirClassSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else if (coneTypeProjectionArray2 instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = (FirTypeAliasSymbol)classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = ((FirTypeAliasSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (effectiveVisibility != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[effectiveVisibility.relation(base, TypeComponentsKt.getTypeContext(context2.getSession())).ordinal()]) {
                case 1: 
                case 2: {
                    return TuplesKt.to((Object)classSymbol, (Object)effectiveVisibility);
                }
            }
        }
        coneTypeProjectionArray2 = type2.getTypeArguments();
        int n = coneTypeProjectionArray2.length;
        for (int i = 0; i < n; ++i) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
            ConeClassLikeType coneClassLikeType2;
            ConeTypeProjection it;
            ConeTypeProjection $this$safeAs$iv = it = coneTypeProjectionArray2[i];
            boolean $i$f$safeAs = false;
            ConeTypeProjection coneTypeProjection = $this$safeAs$iv;
            if (!(coneTypeProjection instanceof ConeClassLikeType)) {
                coneTypeProjection = null;
            }
            if ((coneClassLikeType2 = (ConeClassLikeType)coneTypeProjection) == null || (pair = this.findVisibilityExposure(coneClassLikeType2, context2, base)) == null) continue;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> it2 = pair;
            boolean bl = false;
            return it2;
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

