/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FieldAccessTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "oldToNew", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "(Ljava/util/Map;)V", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "backend.jvm.lower"})
final class FieldAccessTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final Map<IrField, IrFieldSymbol> oldToNew;

    public FieldAccessTransformer(@NotNull Map<IrField, ? extends IrFieldSymbol> oldToNew) {
        Intrinsics.checkNotNullParameter(oldToNew, (String)"oldToNew");
        this.oldToNew = oldToNew;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrFieldSymbol irFieldSymbol = this.oldToNew.get(expression2.getSymbol().getOwner());
        if (irFieldSymbol == null) {
            return super.visitGetField(expression2);
        }
        IrFieldSymbol newSymbol = irFieldSymbol;
        IrExpression irExpression = expression2.getReceiver();
        return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), newSymbol, expression2.getType(), (IrExpression)(irExpression != null ? irExpression.transform((IrElementTransformer)this, (Object)null) : null), expression2.getOrigin(), expression2.getSuperQualifierSymbol());
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrFieldSymbol irFieldSymbol = this.oldToNew.get(expression2.getSymbol().getOwner());
        if (irFieldSymbol == null) {
            return super.visitSetField(expression2);
        }
        IrFieldSymbol newSymbol = irFieldSymbol;
        IrExpression irExpression = expression2.getReceiver();
        return new IrSetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), newSymbol, (IrExpression)(irExpression != null ? irExpression.transform((IrElementTransformer)this, (Object)null) : null), (IrExpression)expression2.getValue().transform((IrElementTransformer)this, (Object)null), expression2.getType(), expression2.getOrigin(), expression2.getSuperQualifierSymbol());
    }
}

