/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.ling.HasOffset;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.sequences.ExactBestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.Extractors;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.ConfusionMatrix;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class TestSentence
implements SequenceModel {
    private static final Redwood.RedwoodChannels log = Redwood.channels(TestSentence.class);
    protected final boolean VERBOSE;
    protected static final String naTag = "NA";
    private static final String[] naTagArr = new String[]{"NA"};
    protected static final boolean DBG = false;
    protected static final int kBestSize = 1;
    protected final String tagSeparator;
    protected final String encoding;
    protected final int minWordsLockTags;
    protected final PairsHolder pairs = new PairsHolder();
    protected List<String> sent;
    private List<String> originalTags;
    protected List<HasWord> origWords;
    protected int size;
    private String[] correctTags;
    protected String[] finalTags;
    int numRight;
    int numWrong;
    int numUnknown;
    int numWrongUnknown;
    private int endSizePairs;
    private volatile History history;
    private volatile Map<String, double[]> localScores = Generics.newHashMap();
    private volatile double[][] localContextScores;
    protected final MaxentTagger maxentTagger;
    private double[][] fullScores;

    public TestSentence(MaxentTagger maxentTagger) {
        assert (maxentTagger != null);
        assert (maxentTagger.getLambdaSolve() != null);
        this.maxentTagger = maxentTagger;
        if (maxentTagger.config != null) {
            this.tagSeparator = maxentTagger.config.getTagSeparator();
            this.encoding = maxentTagger.config.getEncoding();
            this.VERBOSE = maxentTagger.config.getVerbose();
            this.minWordsLockTags = maxentTagger.config.getMinWordsLockTags();
        } else {
            this.tagSeparator = TaggerConfig.getDefaultTagSeparator();
            this.encoding = "utf-8";
            this.VERBOSE = false;
            this.minWordsLockTags = 1;
        }
        this.history = new History(this.pairs, maxentTagger.extractors);
    }

    public void setCorrectTags(List<? extends HasTag> sentence) {
        int len = sentence.size();
        this.correctTags = new String[len];
        for (int i = 0; i < len; ++i) {
            this.correctTags[i] = sentence.get(i).tag();
        }
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<TaggedWord> tagSentence(List<? extends HasWord> s, boolean reuseTags) {
        this.origWords = new ArrayList<HasWord>(s);
        int sz = s.size();
        this.sent = new ArrayList<String>(sz + 1);
        for (HasWord hasWord : s) {
            if (this.maxentTagger.wordFunction != null) {
                this.sent.add(this.maxentTagger.wordFunction.apply(hasWord.word()));
                continue;
            }
            this.sent.add(hasWord.word());
        }
        this.sent.add(".$.");
        if (reuseTags) {
            this.originalTags = new ArrayList<String>(sz + 1);
            for (HasWord hasWord : s) {
                if (hasWord instanceof HasTag) {
                    this.originalTags.add(((HasTag)((Object)hasWord)).tag());
                    continue;
                }
                this.originalTags.add(null);
            }
            this.originalTags.add(".$$.");
        }
        this.size = sz + 1;
        if (this.VERBOSE) {
            log.info("Sentence: " + SentenceUtils.listToString(this.sent, false, this.tagSeparator));
        }
        this.init();
        ArrayList<TaggedWord> result = this.testTagInference();
        if (this.maxentTagger.wordFunction != null) {
            void var5_9;
            boolean bl = false;
            while (var5_9 < sz) {
                result.get((int)var5_9).setWord(s.get((int)var5_9).word());
                ++var5_9;
            }
        }
        return result;
    }

    protected void revert(int prevSize) {
        this.endSizePairs = prevSize;
    }

    protected void init() {
        this.localContextScores = new double[this.size][];
        for (int i = 0; i < this.size - 1; ++i) {
            if (!this.maxentTagger.dict.isUnknown(this.sent.get(i))) continue;
            ++this.numUnknown;
        }
    }

    String getTaggedNice() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size - 1; ++i) {
            sb.append(TestSentence.toNice(this.sent.get(i))).append(this.tagSeparator).append(TestSentence.toNice(this.finalTags[i]));
            sb.append(' ');
        }
        return sb.toString();
    }

    private ArrayList<TaggedWord> getTaggedSentence() {
        boolean hasOffset = this.origWords != null && !this.origWords.isEmpty() && this.origWords.get(0) instanceof HasOffset;
        ArrayList<TaggedWord> taggedSentence = new ArrayList<TaggedWord>();
        for (int j = 0; j < this.size - 1; ++j) {
            String tag = this.finalTags[j];
            TaggedWord w = new TaggedWord(this.sent.get(j), tag);
            if (hasOffset) {
                HasOffset offset = (HasOffset)((Object)this.origWords.get(j));
                w.setBeginPosition(offset.beginPosition());
                w.setEndPosition(offset.endPosition());
            }
            taggedSentence.add(w);
        }
        return taggedSentence;
    }

    static String toNice(String s) {
        if (s == null) {
            return naTag;
        }
        return s;
    }

    protected void calculateProbs(double[][][] probabilities) {
        ArrayUtils.fill(probabilities, Double.NEGATIVE_INFINITY);
        for (int hyp = 0; hyp < 1; ++hyp) {
            this.pairs.setSize(this.size);
            for (int i = 0; i < this.size; ++i) {
                this.pairs.setWord(i, this.sent.get(i));
                this.pairs.setTag(i, this.finalTags[i]);
            }
            int start = this.endSizePairs;
            int end = this.endSizePairs + this.size - 1;
            this.endSizePairs += this.size;
            for (int current = 0; current < this.size; ++current) {
                History h = new History(start, end, current + start, this.pairs, this.maxentTagger.extractors);
                String[] tags = this.stringTagsAt(h.current - h.start + this.leftWindow());
                double[] probs = this.getHistories(tags, h);
                ArrayMath.logNormalize(probs);
                for (int j = 0; j < tags.length; ++j) {
                    int tagindex = this.maxentTagger.hasApproximateScoring() ? this.maxentTagger.tags.getIndex(tags[j]) : j;
                    probabilities[current][hyp][tagindex] = probs[j];
                }
            }
        }
        this.revert(0);
    }

    protected void writeTagsAndErrors(String[] finalTags, PrintFile pf, boolean verboseResults) {
        StringWriter sw = new StringWriter(200);
        for (int i = 0; i < this.correctTags.length; ++i) {
            sw.write(TestSentence.toNice(this.sent.get(i)));
            sw.write(this.tagSeparator);
            sw.write(finalTags[i]);
            sw.write(32);
            if (pf != null) {
                pf.print(TestSentence.toNice(this.sent.get(i)));
                pf.print(this.tagSeparator);
                pf.print(finalTags[i]);
            }
            if (this.correctTags[i].equals(finalTags[i])) {
                ++this.numRight;
            } else {
                ++this.numWrong;
                if (pf != null) {
                    pf.print('|' + this.correctTags[i]);
                }
                if (verboseResults) {
                    log.info((this.maxentTagger.dict.isUnknown(this.sent.get(i)) ? "Unk" : "") + "Word: " + this.sent.get(i) + "; correct: " + this.correctTags[i] + "; guessed: " + finalTags[i]);
                }
                if (this.maxentTagger.dict.isUnknown(this.sent.get(i))) {
                    ++this.numWrongUnknown;
                    if (pf != null) {
                        pf.print("*");
                    }
                }
            }
            if (pf == null) continue;
            pf.print(' ');
        }
        if (pf != null) {
            pf.println();
        }
        if (verboseResults) {
            PrintWriter pw;
            try {
                pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, this.encoding), true);
            }
            catch (UnsupportedEncodingException uee) {
                pw = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
            }
            pw.println(sw);
        }
    }

    protected void updateConfusionMatrix(String[] finalTags, ConfusionMatrix<String> confusionMatrix) {
        for (int i = 0; i < this.correctTags.length; ++i) {
            confusionMatrix.add(finalTags[i], this.correctTags[i]);
        }
    }

    private ArrayList<TaggedWord> testTagInference() {
        this.runTagInference();
        return this.getTaggedSentence();
    }

    private void runTagInference() {
        this.initializeScorer();
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        ExactBestSequenceFinder ti = new ExactBestSequenceFinder();
        int[] bestTags = ti.bestSequence(this);
        this.finalTags = new String[bestTags.length];
        for (int j = 0; j < this.size; ++j) {
            this.finalTags[j] = this.maxentTagger.tags.getTag(bestTags[j + this.leftWindow()]);
        }
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        this.cleanUpScorer();
    }

    private void setHistory(int current, History h, int[] tags) {
        int left = this.leftWindow();
        int right = this.rightWindow();
        TTags ttags = this.maxentTagger.tags;
        int s = Math.max(current - left, left);
        int e = Math.min(current + right, this.size + left - 1);
        for (int j = s; j <= e; ++j) {
            h.setTag(j - left, ttags.getTag(tags[j]));
        }
    }

    private void initializeScorer() {
        this.pairs.setSize(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.pairs.setWord(i, this.sent.get(i));
        }
        this.endSizePairs += this.size;
    }

    private void cleanUpScorer() {
        this.revert(0);
    }

    private double[] getScores(History h) {
        return this.maxentTagger.hasApproximateScoring() ? this.getApproximateScores(h) : this.getExactScores(h);
    }

    private double[] getExactScores(History h) {
        String[] tags = this.stringTagsAt(h.current - h.start + this.leftWindow());
        double[] histories = this.getHistories(tags, h);
        ArrayMath.logNormalize(histories);
        double[] scores = new double[tags.length];
        for (int j = 0; j < tags.length; ++j) {
            String tag = tags[j];
            int tagindex = this.maxentTagger.tags.getIndex(tag);
            scores[j] = histories[tagindex];
        }
        return scores;
    }

    private double[] getApproximateScores(History h) {
        String[] tags = this.stringTagsAt(h.current - h.start + this.leftWindow());
        double[] scores = this.getHistories(tags, h);
        int nDefault = this.maxentTagger.ySize - tags.length;
        double logScore = ArrayMath.logSum(scores);
        double logScoreInactiveTags = this.maxentTagger.getInactiveTagDefaultScore(nDefault);
        double logTotal = SloppyMath.logAdd(logScore, logScoreInactiveTags);
        ArrayMath.addInPlace(scores, -logTotal);
        return scores;
    }

    protected double[] getHistories(String[] tags, History h) {
        boolean rare = this.maxentTagger.isRare(ExtractorFrames.cWord.extract(h));
        Extractors ex = this.maxentTagger.extractors;
        Extractors exR = this.maxentTagger.extractorsRare;
        String w = this.pairs.getWord(h.current);
        if (this.VERBOSE) {
            String val;
            Extractor e;
            int kf;
            int extractorsSize = rare ? ex.size() + exR.size() : ex.size();
            this.fullScores = new double[extractorsSize][this.maxentTagger.ySize];
            ArrayList<Pair<Integer, Extractor>> allEx = new ArrayList<Pair<Integer, Extractor>>(ex.local);
            allEx.addAll(ex.localContext);
            allEx.addAll(ex.dynamic);
            ArrayList<Pair<Integer, Extractor>> allExR = new ArrayList<Pair<Integer, Extractor>>();
            if (rare) {
                allExR.addAll(exR.local);
                allExR.addAll(exR.localContext);
                allExR.addAll(exR.dynamic);
            }
            ArrayList<String> extractorVals = new ArrayList<String>();
            for (int i = 0; i < extractorsSize; ++i) {
                extractorVals.add("foo");
            }
            for (Pair pair : allEx) {
                kf = (Integer)pair.first();
                e = (Extractor)pair.second();
                val = e.extract(h);
                extractorVals.set(kf, e + " " + val);
            }
            for (Pair pair : allExR) {
                kf = (Integer)pair.first();
                e = (Extractor)pair.second();
                val = e.extract(h);
                extractorVals.set(kf + ex.size(), e + " " + val);
            }
            double[] totalS = this.getHistories(tags, h, allEx, rare ? allExR : null);
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            Object[] colNames = IntStream.range(0, this.maxentTagger.ySize).mapToObj(k -> this.maxentTagger.tags.getTag(k)).toArray();
            System.err.println(ArrayMath.toString(this.fullScores, 6, extractorVals.toArray(), colNames, 48, decimalFormat, false, true, w));
            return totalS;
        }
        double[] lS = this.localScores.get(w);
        if (lS == null) {
            lS = this.getHistories(tags, h, ex.local, rare ? exR.local : null);
            this.localScores.put(w, lS);
        } else if (lS.length != tags.length) {
            lS = this.getHistories(tags, h, ex.local, rare ? exR.local : null);
            if (tags.length > 1) {
                this.localScores.put(w, lS);
            }
        }
        double[] lcS = this.localContextScores[h.current];
        if (lcS == null) {
            lcS = this.getHistories(tags, h, ex.localContext, rare ? exR.localContext : null);
            this.localContextScores[h.current] = lcS;
            ArrayMath.pairwiseAddInPlace(lcS, lS);
        }
        double[] totalS = this.getHistories(tags, h, ex.dynamic, rare ? exR.dynamic : null);
        ArrayMath.pairwiseAddInPlace(totalS, lcS);
        return totalS;
    }

    private double[] getHistories(String[] tags, History h, List<Pair<Integer, Extractor>> extractors, List<Pair<Integer, Extractor>> extractorsRare) {
        return this.maxentTagger.hasApproximateScoring() ? this.getApproximateHistories(tags, h, extractors, extractorsRare) : this.getExactHistories(h, extractors, extractorsRare);
    }

    private double[] getExactHistories(History h, List<Pair<Integer, Extractor>> extractors, List<Pair<Integer, Extractor>> extractorsRare) {
        double[] scores = new double[this.maxentTagger.ySize];
        if (this.VERBOSE) {
            System.err.println("Calling exact histories");
        }
        double[] lambda = this.maxentTagger.getLambdaSolve().lambda;
        for (Pair<Integer, Extractor> e : extractors) {
            this.runExactExtractor(e.first(), e.second(), h, scores, lambda);
        }
        if (extractorsRare != null) {
            int szCommon = this.maxentTagger.extractors.size();
            for (Pair<Integer, Extractor> e : extractorsRare) {
                this.runExactExtractor(szCommon + e.first(), e.second(), h, scores, lambda);
            }
        }
        return scores;
    }

    private void runExactExtractor(int kf, Extractor ex, History h, double[] scores, double[] lambda) {
        int[] fAssociations = this.maxentTagger.fAssociations.get(kf).get(ex.extract(h));
        if (fAssociations != null) {
            for (int j = 0; j < this.maxentTagger.ySize; ++j) {
                int fNum = fAssociations[j];
                if (fNum < 0) continue;
                int n = j;
                scores[n] = scores[n] + lambda[fNum];
                if (!this.VERBOSE) continue;
                this.fullScores[kf][j] = lambda[fNum];
            }
        }
    }

    private double[] getApproximateHistories(String[] tags, History h, List<Pair<Integer, Extractor>> extractors, List<Pair<Integer, Extractor>> extractorsRare) {
        double[] scores = new double[tags.length];
        if (this.VERBOSE) {
            System.err.println("Calling approx histories");
        }
        double[] lambda = this.maxentTagger.getLambdaSolve().lambda;
        for (Pair<Integer, Extractor> e : extractors) {
            this.runApproximateExtractor(e.first(), e.second(), h, tags, scores, lambda);
        }
        if (extractorsRare != null) {
            int szCommon = this.maxentTagger.extractors.size();
            for (Pair<Integer, Extractor> e : extractorsRare) {
                this.runApproximateExtractor(szCommon + e.first(), e.second(), h, tags, scores, lambda);
            }
        }
        return scores;
    }

    private void runApproximateExtractor(int kf, Extractor extractor, History h, String[] tags, double[] scores, double[] lambda) {
        int[] fAssociations = this.maxentTagger.fAssociations.get(kf).get(extractor.extract(h));
        if (fAssociations == null) {
            return;
        }
        TTags ttags = this.maxentTagger.tags;
        for (int j = 0; j < tags.length; ++j) {
            int fNum = fAssociations[ttags.getIndex(tags[j])];
            if (fNum < 0) continue;
            int n = j;
            scores[n] = scores[n] + lambda[fNum];
            if (!this.VERBOSE) continue;
            this.fullScores[kf][j] = lambda[fNum];
        }
    }

    void printUnknown(int numSent, PrintFile pfu) {
        DecimalFormat nf = new DecimalFormat("0.0000");
        int numTags = this.maxentTagger.numTags();
        double[][][] probabilities = new double[this.size][1][numTags];
        this.calculateProbs(probabilities);
        for (int current = 0; current < this.size; ++current) {
            int rank;
            if (!this.maxentTagger.dict.isUnknown(this.sent.get(current))) continue;
            pfu.print(this.sent.get(current));
            pfu.print(':');
            pfu.print(numSent);
            double[] probs = new double[3];
            String[] tag3 = new String[3];
            this.getTop3(probabilities, current, probs, tag3);
            for (int i = 0; i < 3; ++i) {
                if (!(probs[i] > Double.NEGATIVE_INFINITY)) continue;
                pfu.print('\t');
                pfu.print(tag3[i]);
                pfu.print(' ');
                pfu.print(nf.format(Math.exp(probs[i])));
            }
            String correctTag = TestSentence.toNice(this.correctTags[current]);
            for (rank = 0; rank < 3 && !correctTag.equals(tag3[rank]); ++rank) {
            }
            pfu.print('\t');
            switch (rank) {
                case 0: {
                    pfu.print("Correct");
                    break;
                }
                case 1: {
                    pfu.print("2nd");
                    break;
                }
                case 2: {
                    pfu.print("3rd");
                    break;
                }
                default: {
                    pfu.print("Not top 3");
                }
            }
            pfu.println();
        }
    }

    void printTop(PrintFile pfu) {
        DecimalFormat nf = new DecimalFormat("0.0000");
        int numTags = this.maxentTagger.numTags();
        double[][][] probabilities = new double[this.size][1][numTags];
        this.calculateProbs(probabilities);
        for (int current = 0; current < this.correctTags.length; ++current) {
            int rank;
            pfu.print(this.sent.get(current));
            double[] probs = new double[3];
            String[] tag3 = new String[3];
            this.getTop3(probabilities, current, probs, tag3);
            for (int i = 0; i < 3; ++i) {
                if (!(probs[i] > Double.NEGATIVE_INFINITY)) continue;
                pfu.print('\t');
                pfu.print(tag3[i]);
                pfu.print(' ');
                pfu.print(nf.format(Math.exp(probs[i])));
            }
            String correctTag = TestSentence.toNice(this.correctTags[current]);
            for (rank = 0; rank < 3 && !correctTag.equals(tag3[rank]); ++rank) {
            }
            pfu.print('\t');
            switch (rank) {
                case 0: {
                    pfu.print("Correct");
                    break;
                }
                case 1: {
                    pfu.print("2nd");
                    break;
                }
                case 2: {
                    pfu.print("3rd");
                    break;
                }
                default: {
                    pfu.print("Not top 3");
                }
            }
            pfu.println();
        }
    }

    private void getTop3(double[][][] probabilities, int current, double[] probs, String[] tags) {
        int[] topIds = new int[3];
        double[] probTags = probabilities[current][0];
        Arrays.fill(probs, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < probTags.length; ++i) {
            if (probTags[i] > probs[0]) {
                probs[2] = probs[1];
                probs[1] = probs[0];
                probs[0] = probTags[i];
                topIds[2] = topIds[1];
                topIds[1] = topIds[0];
                topIds[0] = i;
                continue;
            }
            if (probTags[i] > probs[1]) {
                probs[2] = probs[1];
                probs[1] = probTags[i];
                topIds[2] = topIds[1];
                topIds[1] = i;
                continue;
            }
            if (!(probTags[i] > probs[2])) continue;
            probs[2] = probTags[i];
            topIds[2] = i;
        }
        for (int j = 0; j < 3; ++j) {
            tags[j] = TestSentence.toNice(this.maxentTagger.tags.getTag(topIds[j]));
        }
    }

    @Override
    public int length() {
        return this.sent.size();
    }

    @Override
    public int leftWindow() {
        return this.maxentTagger.leftContext;
    }

    @Override
    public int rightWindow() {
        return this.maxentTagger.rightContext;
    }

    @Override
    public int[] getPossibleValues(int pos) {
        String[] arr1 = this.stringTagsAt(pos);
        int[] arr = new int[arr1.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.maxentTagger.tags.getIndex(arr1[i]);
        }
        return arr;
    }

    @Override
    public double scoreOf(int[] tags, int pos) {
        double[] scores = this.scoresOf(tags, pos);
        double score = Double.NEGATIVE_INFINITY;
        int[] pv = this.getPossibleValues(pos);
        int search = tags[pos];
        for (int i = 0; i < scores.length; ++i) {
            if (pv[i] != search) continue;
            score = scores[i];
        }
        return score;
    }

    @Override
    public double scoreOf(int[] sequence) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] scoresOf(int[] tags, int pos) {
        this.history.init(this.endSizePairs - this.size, this.endSizePairs - 1, this.endSizePairs - this.size + pos - this.leftWindow());
        this.setHistory(pos, this.history, tags);
        return this.getScores(this.history);
    }

    protected String[] stringTagsAt(int pos) {
        String orig;
        if ((pos -= this.leftWindow()) < 0 || pos >= this.size) {
            return naTagArr;
        }
        if (this.originalTags != null && (orig = this.originalTags.get(pos)) != null) {
            return new String[]{orig};
        }
        String word = this.sent.get(pos);
        int count = this.maxentTagger.dict.sum(word);
        String[] arr1 = count == 0 || count < this.minWordsLockTags ? this.maxentTagger.tags.getOpenTagsArray() : this.maxentTagger.dict.getTags(word);
        return this.maxentTagger.tags.deterministicallyExpandTags(arr1);
    }
}

