/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parameter;

import de.jollyday.parameter.BaseManagerParameter;
import de.jollyday.util.ResourceUtil;
import java.net.URL;
import java.util.Properties;

public class CalendarPartManagerParameter
extends BaseManagerParameter {
    private static final String FILE_PREFIX = "holidays/Holidays";
    private static final String FILE_SUFFIX = ".xml";
    private ResourceUtil resourceUtil = new ResourceUtil();
    private String calendarPart;

    public CalendarPartManagerParameter(String calendarPart, Properties properties) {
        super(properties);
        this.calendarPart = calendarPart;
    }

    public String createCacheKey() {
        return this.calendarPart;
    }

    public String getDisplayName() {
        return this.calendarPart;
    }

    public URL createResourceUrl() {
        String configurationFileName = CalendarPartManagerParameter.getConfigurationFileName(this.calendarPart);
        return this.resourceUtil.getResource(configurationFileName);
    }

    public String getManangerImplClassName() {
        String className = this.getProperty("manager.impl." + this.calendarPart);
        if (className == null) {
            className = super.getManangerImplClassName();
        }
        return className;
    }

    public static String getConfigurationFileName(String country) {
        return "holidays/Holidays_" + country + FILE_SUFFIX;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.calendarPart;
    }
}

