/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.Alignment;
import edu.stanford.nlp.semgraph.semgrex.VariableStrings;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class SemgrexMatcher {
    private static final Redwood.RedwoodChannels log = Redwood.channels(SemgrexMatcher.class);
    final SemanticGraph sg;
    final Map<String, IndexedWord> namesToNodes;
    final Map<String, String> namesToRelations;
    final VariableStrings variableStrings;
    IndexedWord node;
    final Alignment alignment;
    final SemanticGraph sg_aligned;
    final boolean hyp;
    private Iterator<IndexedWord> findIterator;
    private IndexedWord findCurrent;
    private static final WeakHashMap<Integer, List<IndexedWord>> topologicalSortCache = new WeakHashMap();

    SemgrexMatcher(SemanticGraph sg, Alignment alignment, SemanticGraph sg_aligned, boolean hyp, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, VariableStrings variableStrings) {
        this.sg = sg;
        this.alignment = alignment;
        this.sg_aligned = sg_aligned;
        this.hyp = hyp;
        this.node = node;
        this.namesToNodes = namesToNodes;
        this.namesToRelations = namesToRelations;
        this.variableStrings = variableStrings;
    }

    SemgrexMatcher(SemanticGraph sg, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, VariableStrings variableStrings) {
        this(sg, null, null, true, node, namesToNodes, namesToRelations, variableStrings);
    }

    public void reset() {
        this.findIterator = null;
        this.namesToNodes.clear();
        this.namesToRelations.clear();
    }

    void resetChildIter(IndexedWord node) {
        this.node = node;
        this.resetChildIter();
    }

    void resetChildIter() {
    }

    public abstract boolean matches();

    public boolean matchesAt(IndexedWord node) {
        this.resetChildIter(node);
        return this.matches();
    }

    public abstract IndexedWord getMatch();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFindIterator() {
        block14: {
            try {
                if (this.hyp) {
                    WeakHashMap<Integer, List<IndexedWord>> weakHashMap = topologicalSortCache;
                    synchronized (weakHashMap) {
                        List<IndexedWord> topoSort = topologicalSortCache.get(System.identityHashCode(this.sg));
                        if (topoSort == null || topoSort.size() != this.sg.size()) {
                            topoSort = this.sg.topologicalSort();
                            topologicalSortCache.put(System.identityHashCode(this.sg), topoSort);
                        }
                        this.findIterator = topoSort.iterator();
                        break block14;
                    }
                }
                if (this.sg_aligned == null) {
                    return;
                }
                WeakHashMap<Integer, List<IndexedWord>> weakHashMap = topologicalSortCache;
                synchronized (weakHashMap) {
                    List<IndexedWord> topoSort = topologicalSortCache.get(System.identityHashCode(this.sg_aligned));
                    if (topoSort == null || topoSort.size() != this.sg_aligned.size()) {
                        topoSort = this.sg_aligned.topologicalSort();
                        topologicalSortCache.put(System.identityHashCode(this.sg_aligned), topoSort);
                    }
                    this.findIterator = topoSort.iterator();
                }
            }
            catch (Exception ex) {
                if (this.hyp) {
                    this.findIterator = this.sg.vertexSet().iterator();
                }
                if (this.sg_aligned == null) {
                    return;
                }
                this.findIterator = this.sg_aligned.vertexSet().iterator();
            }
        }
    }

    public boolean find() {
        if (this.findIterator == null) {
            this.setupFindIterator();
        }
        if (this.findIterator == null) {
            return false;
        }
        if (this.findCurrent != null && this.matches()) {
            return true;
        }
        while (this.findIterator.hasNext()) {
            this.findCurrent = this.findIterator.next();
            this.resetChildIter(this.findCurrent);
            if (!this.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean findNextMatchingNode() {
        IndexedWord lastMatchingNode = this.getMatch();
        while (this.find()) {
            if (this.getMatch() == lastMatchingNode) continue;
            return true;
        }
        return false;
    }

    public IndexedWord getNode(String name) {
        return this.namesToNodes.get(name);
    }

    public String getRelnString(String name) {
        return this.namesToRelations.get(name);
    }

    public Set<String> getNodeNames() {
        return this.namesToNodes.keySet();
    }

    public Set<String> getRelationNames() {
        return this.namesToRelations.keySet();
    }

    public abstract String toString();

    public SemanticGraph getGraph() {
        return this.sg;
    }
}

