/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.BasicSequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.ComplexNodePattern;
import edu.stanford.nlp.ling.tokensregex.CoreMapNodePattern;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.MultiCoreMapNodePattern;
import edu.stanford.nlp.ling.tokensregex.MultiNodePattern;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.NodePatternTransformer;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchAction;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Factory;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.ValuedInterval;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;

public class SequencePattern<T>
implements Serializable {
    private static final long serialVersionUID = 3484918485303693833L;
    private String patternStr;
    private PatternExpr patternExpr;
    private SequenceMatchAction<T> action;
    State root;
    int totalGroups = 0;
    VarGroupBindings varGroupBindings;
    double priority = 0.0;
    double weight = 0.0;
    public static final NodesMatchChecker<Object> NODES_EQUAL_CHECKER = new NodesMatchChecker<Object>(){

        @Override
        public boolean matches(Object o1, Object o2) {
            return o1.equals(o2);
        }
    };
    public static final PatternExpr ANY_NODE_PATTERN_EXPR = new NodePatternExpr(NodePattern.ANY_NODE);
    public static final PatternExpr SEQ_BEGIN_PATTERN_EXPR = new SequenceStartPatternExpr();
    public static final PatternExpr SEQ_END_PATTERN_EXPR = new SequenceEndPatternExpr();
    protected static final State MATCH_STATE = new MatchState();

    protected SequencePattern(PatternExpr nodeSequencePattern) {
        this(null, nodeSequencePattern);
    }

    protected SequencePattern(String patternStr, PatternExpr nodeSequencePattern) {
        this(patternStr, nodeSequencePattern, null);
    }

    protected SequencePattern(String patternStr, PatternExpr nodeSequencePattern, SequenceMatchAction<T> action) {
        this.patternStr = patternStr;
        this.patternExpr = nodeSequencePattern;
        this.action = action;
        nodeSequencePattern = new GroupPatternExpr(nodeSequencePattern, true);
        nodeSequencePattern = nodeSequencePattern.optimize();
        this.totalGroups = nodeSequencePattern.assignGroupIds(0);
        Frag f = nodeSequencePattern.build();
        f.connect(MATCH_STATE);
        this.root = f.start;
        this.varGroupBindings = new VarGroupBindings(this.totalGroups + 1);
        nodeSequencePattern.updateBindings(this.varGroupBindings);
    }

    public String toString() {
        return this.pattern();
    }

    public <T2> SequencePattern<T2> transform(NodePatternTransformer<T, T2> transformer) {
        if (this.action != null) {
            throw new UnsupportedOperationException("transform on actions not yet implemented");
        }
        PatternExpr transformedPattern = this.patternExpr.transform(transformer);
        return new SequencePattern<T>(this.patternStr, transformedPattern, null);
    }

    public String pattern() {
        return this.patternStr;
    }

    protected PatternExpr getPatternExpr() {
        return this.patternExpr;
    }

    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public SequenceMatchAction<T> getAction() {
        return this.action;
    }

    public void setAction(SequenceMatchAction<T> action) {
        this.action = action;
    }

    public int getTotalGroups() {
        return this.totalGroups;
    }

    public static <T> SequencePattern<T> compile(Env env, String string) {
        try {
            Pair p = env.parser.parseSequenceWithAction(env, string);
            return new SequencePattern(string, p.first(), p.second());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error compiling " + string + " using environment " + env);
        }
    }

    protected static <T> SequencePattern<T> compile(PatternExpr nodeSequencePattern) {
        return new SequencePattern<T>(nodeSequencePattern);
    }

    public SequenceMatcher<T> getMatcher(List<? extends T> tokens) {
        return new SequenceMatcher<T>(this, tokens);
    }

    public <OUT> OUT findNodePattern(Function<NodePattern<T>, OUT> filter) {
        LinkedList<State> todo = new LinkedList<State>();
        HashSet<State> seen = new HashSet<State>();
        todo.add(this.root);
        seen.add(this.root);
        while (!todo.isEmpty()) {
            NodePattern pattern;
            OUT res;
            State state = (State)todo.poll();
            if (state instanceof NodePatternState && (res = filter.apply(pattern = ((NodePatternState)state).pattern)) != null) {
                return res;
            }
            if (state.next == null) continue;
            for (State s : state.next) {
                if (seen.contains(s)) continue;
                seen.add(s);
                todo.add(s);
            }
        }
        return null;
    }

    public <OUT> Collection<OUT> findNodePatterns(Function<NodePattern<T>, OUT> filter, boolean allowOptional, boolean allowBranching) {
        ArrayList<OUT> outList = new ArrayList<OUT>();
        LinkedList<State> todo = new LinkedList<State>();
        HashSet<State> seen = new HashSet<State>();
        todo.add(this.root);
        seen.add(this.root);
        while (!todo.isEmpty()) {
            boolean addNext;
            NodePattern pattern;
            OUT res;
            State state = (State)todo.poll();
            if ((allowOptional || !state.isOptional) && state instanceof NodePatternState && (res = filter.apply(pattern = ((NodePatternState)state).pattern)) != null) {
                outList.add(res);
            }
            if (state.next == null || !(addNext = allowBranching || state.next.size() == 1)) continue;
            for (State s : state.next) {
                if (seen.contains(s)) continue;
                seen.add(s);
                todo.add(s);
            }
        }
        return outList;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.patternStr = (String)ois.readObject();
        this.patternExpr = (PatternExpr)ois.readObject();
        this.action = (SequenceMatchAction)ois.readObject();
        this.patternExpr = new GroupPatternExpr(this.patternExpr, true);
        this.patternExpr = this.patternExpr.optimize();
        this.totalGroups = this.patternExpr.assignGroupIds(0);
        Frag f = this.patternExpr.build();
        f.connect(MATCH_STATE);
        this.root = f.start;
        this.varGroupBindings = new VarGroupBindings(this.totalGroups + 1);
        this.patternExpr.updateBindings(this.varGroupBindings);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.toString());
        oos.writeObject(this.getPatternExpr());
        oos.writeObject(this.getAction());
    }

    private static class Frag {
        State start;
        Set<State> out;

        protected Frag() {
        }

        protected Frag(State start) {
            this.start = start;
            this.out = new LinkedHashSet<State>();
            start.updateOutStates(this.out);
        }

        protected Frag(State start, Set<State> out2) {
            this.start = start;
            this.out = out2;
        }

        protected void add(State outState) {
            if (this.out == null) {
                this.out = new LinkedHashSet<State>();
            }
            this.out.add(outState);
        }

        protected void add(Collection<State> outStates) {
            if (this.out == null) {
                this.out = new LinkedHashSet<State>();
            }
            this.out.addAll(outStates);
        }

        protected void connect(Frag f) {
            for (State s : this.out) {
                s.add(f.start);
            }
            this.out = f.out;
        }

        protected void connect(State state) {
            for (State s : this.out) {
                s.add(state);
            }
            this.out = new LinkedHashSet<State>();
            state.updateOutStates(this.out);
        }
    }

    static class SeqEndState
    extends State {
        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            if (!consume && matchedStates.curPosition == matchedStates.elements().size() - 1) {
                return super.match(bid, matchedStates, consume, this);
            }
            return false;
        }
    }

    static class SeqStartState
    extends State {
        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            if (consume && matchedStates.curPosition == 0) {
                return super.match(bid, matchedStates, consume, this);
            }
            return false;
        }
    }

    static class ConjEndState
    extends State {
        private final ConjStartState startState;
        private final int childIndex;

        public ConjEndState(ConjStartState startState, int childIndex) {
            this.startState = startState;
            this.childIndex = childIndex;
        }

        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            if (consume) {
                return false;
            }
            ConjMatchStateInfo stateInfo = (ConjMatchStateInfo)matchedStates.getBranchStates().getMatchStateInfo(bid, this.startState);
            if (stateInfo != null) {
                stateInfo.addChildBid(this.childIndex, bid, matchedStates.curPosition);
                int[] matchedBids = stateInfo.getAllChildMatchedBids(this.childIndex, bid, matchedStates.curPosition);
                if (matchedBids != null) {
                    matchedStates.getBranchStates().addBidsToCollapse(bid, matchedBids);
                    return super.match(bid, matchedStates, consume, prevState);
                }
            }
            return false;
        }
    }

    static class ConjStartState
    extends State {
        private final int childCount;

        public ConjStartState(int childCount) {
            this.childCount = childCount;
        }

        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            matchedStates.getBranchStates().setMatchStateInfo(bid, this, new ConjMatchStateInfo(bid, this.childCount, matchedStates.curPosition));
            boolean allMatch = true;
            if (this.next != null) {
                int i = 0;
                for (State s : this.next) {
                    boolean m = s.match(matchedStates.getBranchStates().getBranchId(bid, ++i, this.next.size()), matchedStates, consume);
                    if (m) continue;
                    allMatch = false;
                    break;
                }
            }
            return allMatch;
        }
    }

    static class ConjMatchStateInfo {
        private final int startBid;
        private final int startPos;
        private final int childCount;
        private final Set<Pair<Integer, Integer>>[] reachableChildBids;

        private ConjMatchStateInfo(int startBid, int childCount, int startPos) {
            this.startBid = startBid;
            this.startPos = startPos;
            this.childCount = childCount;
            this.reachableChildBids = new Set[childCount];
        }

        private void addChildBid(int i, int bid, int pos) {
            if (this.reachableChildBids[i] == null) {
                this.reachableChildBids[i] = new ArraySet<Pair<Integer, Integer>>();
            }
            this.reachableChildBids[i].add(new Pair<Integer, Integer>(bid, pos));
        }

        private boolean isAllChildMatched() {
            for (Set<Pair<Integer, Integer>> v : this.reachableChildBids) {
                if (v != null && !v.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private boolean isAllChildMatched(int index, int bid, int pos) {
            for (int i = 0; i < this.reachableChildBids.length; ++i) {
                Set<Pair<Integer, Integer>> v = this.reachableChildBids[i];
                if (v == null || v.isEmpty()) {
                    return false;
                }
                if (i == index) continue;
                boolean ok = false;
                for (Pair<Integer, Integer> p : v) {
                    if (p.second() != pos) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                return false;
            }
            return true;
        }

        private int[] getAllChildMatchedBids(int index, int bid, int pos) {
            int[] matchedBids = new int[this.reachableChildBids.length];
            for (int i = 0; i < this.reachableChildBids.length; ++i) {
                Set<Pair<Integer, Integer>> v = this.reachableChildBids[i];
                if (v == null || v.isEmpty()) {
                    return null;
                }
                if (i != index) {
                    boolean ok = false;
                    for (Pair<Integer, Integer> p : v) {
                        if (p.second() != pos) continue;
                        ok = true;
                        matchedBids[i] = p.first();
                        break;
                    }
                    if (ok) continue;
                    return null;
                }
                matchedBids[i] = bid;
            }
            return matchedBids;
        }

        protected void updateKeepBids(BitSet bids) {
            for (Set<Pair<Integer, Integer>> v : this.reachableChildBids) {
                if (v == null) continue;
                for (Pair<Integer, Integer> p : v) {
                    bids.set(p.first());
                }
            }
        }
    }

    static class GroupEndState
    extends State {
        private final int captureGroupId;

        public GroupEndState(int captureGroupId) {
            this.captureGroupId = captureGroupId;
        }

        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            Object v;
            Object object = v = prevState != null ? prevState.value(bid, matchedStates) : null;
            if (consume) {
                matchedStates.setGroupEnd(bid, this.captureGroupId, matchedStates.curPosition - 1, v);
            } else {
                matchedStates.setGroupEnd(bid, this.captureGroupId, v);
            }
            return super.match(bid, matchedStates, consume, prevState);
        }
    }

    static class GroupStartState
    extends State {
        private final int captureGroupId;

        public GroupStartState(int captureGroupId, State startState) {
            this.captureGroupId = captureGroupId;
            this.add(startState);
        }

        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            if (consume) {
                matchedStates.setGroupStart(bid, this.captureGroupId);
                return super.match(bid, matchedStates, consume, prevState);
            }
            matchedStates.addState(bid, this);
            return false;
        }
    }

    static class BackRefState
    extends State {
        private final NodesMatchChecker matcher;
        private final int captureGroupId;

        public BackRefState(NodesMatchChecker matcher, int captureGroupId) {
            this.matcher = matcher;
            this.captureGroupId = captureGroupId;
        }

        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, BasicSequenceMatchResult.MatchedGroup matchedGroup, int matchedNodes) {
            T node = matchedStates.get();
            if (this.matcher.matches(node, matchedStates.elements().get(matchedGroup.matchBegin + matchedNodes))) {
                matchedStates.getBranchStates().setMatchStateInfo(bid, this, new Pair<BasicSequenceMatchResult.MatchedGroup, Integer>(matchedGroup, ++matchedNodes));
                int len = matchedGroup.matchEnd - matchedGroup.matchBegin;
                if (len == matchedNodes) {
                    matchedStates.addStates(bid, this.next);
                } else {
                    matchedStates.addState(bid, this);
                }
                return true;
            }
            return false;
        }

        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            if (consume) {
                Pair backRefState = (Pair)matchedStates.getBranchStates().getMatchStateInfo(bid, this);
                if (backRefState == null) {
                    BasicSequenceMatchResult.MatchedGroup matchedGroup = matchedStates.getBranchStates().getMatchedGroup(bid, this.captureGroupId);
                    if (matchedGroup != null) {
                        if (matchedGroup.matchEnd > matchedGroup.matchBegin) {
                            boolean matched = this.match(bid, matchedStates, matchedGroup, 0);
                            return matched;
                        }
                        return super.match(bid, matchedStates, consume, prevState);
                    }
                    return false;
                }
                BasicSequenceMatchResult.MatchedGroup matchedGroup = (BasicSequenceMatchResult.MatchedGroup)backRefState.first();
                int matchedNodes = (Integer)backRefState.second();
                boolean matched = this.match(bid, matchedStates, matchedGroup, matchedNodes);
                return matched;
            }
            matchedStates.addState(bid, this);
            return false;
        }
    }

    private static class RepeatState
    extends State {
        private final State repeatStart;
        private final int minMatch;
        private final int maxMatch;
        private final boolean greedyMatch;

        public RepeatState(State start, int minMatch, int maxMatch, boolean greedyMatch) {
            this.repeatStart = start;
            this.minMatch = minMatch;
            this.maxMatch = maxMatch;
            this.greedyMatch = greedyMatch;
            if (minMatch < 0) {
                throw new IllegalArgumentException("Invalid minMatch=" + minMatch);
            }
            if (maxMatch >= 0 && minMatch > maxMatch) {
                throw new IllegalArgumentException("Invalid minMatch=" + minMatch + ", maxMatch=" + maxMatch);
            }
            this.isOptional = this.minMatch <= 0;
        }

        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            int maxMatchLeft;
            int matchedCount = matchedStates.getBranchStates().endMatchedCountInc(bid, this);
            int minMatchLeft = this.minMatch - matchedCount;
            if (minMatchLeft < 0) {
                minMatchLeft = 0;
            }
            if (this.maxMatch < 0) {
                maxMatchLeft = this.maxMatch;
            } else {
                maxMatchLeft = this.maxMatch - matchedCount;
                if (this.maxMatch < 0) {
                    return false;
                }
            }
            boolean match = false;
            int totalBranches = 0;
            if (minMatchLeft == 0 && this.next != null) {
                totalBranches += this.next.size();
            }
            if (maxMatchLeft != 0) {
                ++totalBranches;
            }
            int i = 0;
            if (minMatchLeft == 0 && this.next != null) {
                for (State s : this.next) {
                    int pi = this.greedyMatch && maxMatchLeft != 0 ? i + 1 : ++i;
                    int bid2 = matchedStates.getBranchStates().getBranchId(bid, pi, totalBranches);
                    matchedStates.getBranchStates().clearMatchedCount(bid2, this);
                    boolean m = s.match(bid2, matchedStates, consume);
                    if (!m) continue;
                    match = true;
                }
            }
            if (maxMatchLeft != 0) {
                int pi = this.greedyMatch ? 1 : ++i;
                int bid2 = matchedStates.getBranchStates().getBranchId(bid, pi, totalBranches);
                if (consume) {
                    matchedStates.getBranchStates().startMatchedCountInc(bid2, this);
                    boolean m = this.repeatStart.match(bid2, matchedStates, consume);
                    if (m) {
                        match = true;
                    } else {
                        matchedStates.getBranchStates().startMatchedCountDec(bid2, this);
                    }
                } else {
                    matchedStates.addState(bid2, this);
                }
            }
            return match;
        }
    }

    private static class MultiNodePatternState
    extends State {
        private final MultiNodePattern pattern;

        protected MultiNodePatternState(MultiNodePattern p) {
            this.pattern = p;
        }

        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            if (consume) {
                HasInterval<Integer> matchedInterval = matchedStates.getBranchStates().getMatchedInterval(bid, this);
                int cur = matchedStates.curPosition;
                if (matchedInterval == null) {
                    List<T> nodes = matchedStates.elements();
                    Collection<Interval<Integer>> matched = this.pattern.match(nodes, cur);
                    matched = this.pattern.isGreedyMatch() ? CollectionUtils.sorted(matched, Interval.LENGTH_GT_COMPARATOR) : CollectionUtils.sorted(matched, Interval.LENGTH_LT_COMPARATOR);
                    if (matched != null && matched.size() > 0) {
                        int nBranches = matched.size();
                        int i = 0;
                        for (HasInterval hasInterval : matched) {
                            int bid2 = matchedStates.getBranchStates().getBranchId(bid, ++i, nBranches);
                            matchedStates.getBranchStates().setMatchedInterval(bid2, this, hasInterval);
                            if ((Integer)hasInterval.getInterval().getEnd() - 1 <= cur) {
                                matchedStates.addStates(bid2, this.next);
                                continue;
                            }
                            matchedStates.addState(bid2, this);
                        }
                        return true;
                    }
                    return false;
                }
                if (matchedInterval.getInterval().getEnd() - 1 <= cur) {
                    matchedStates.addStates(bid, this.next);
                } else {
                    matchedStates.addState(bid, this);
                }
                return true;
            }
            matchedStates.addState(bid, this);
            return false;
        }
    }

    private static class NodePatternState
    extends State {
        final NodePattern pattern;

        protected NodePatternState(NodePattern p) {
            this.pattern = p;
        }

        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            if (consume) {
                T node = matchedStates.get();
                if (matchedStates.matcher.matchWithResult) {
                    Object obj = this.pattern.matchWithResult(node);
                    if (obj != null) {
                        if (obj != Boolean.TRUE) {
                            matchedStates.branchStates.setMatchedResult(bid, matchedStates.curPosition, obj);
                        }
                        matchedStates.addStates(bid, this.next);
                        return true;
                    }
                    return false;
                }
                if (node != null && this.pattern.match(node)) {
                    matchedStates.addStates(bid, this.next);
                    return true;
                }
                return false;
            }
            matchedStates.addState(bid, this);
            return false;
        }
    }

    private static class ValueState
    extends State {
        final Object value;

        private ValueState(Object value) {
            this.value = value;
        }

        @Override
        public <T> Object value(int bid, SequenceMatcher.MatchedStates<T> matchedStates) {
            return this.value;
        }
    }

    private static class MatchState
    extends State {
        private MatchState() {
        }

        @Override
        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            matchedStates.addState(bid, this);
            return false;
        }
    }

    static class State {
        Set<State> next;
        boolean hasSavedValue;
        boolean isOptional;

        protected State() {
        }

        protected void updateOutStates(Set<State> out2) {
            if (this.next == null) {
                out2.add(this);
            } else {
                for (State s : this.next) {
                    s.updateOutStates(out2);
                }
            }
        }

        protected <T> boolean match0(int bid, SequenceMatcher.MatchedStates<T> matchedStates) {
            return this.match(bid, matchedStates, false);
        }

        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates) {
            return this.match(bid, matchedStates, true);
        }

        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume) {
            return this.match(bid, matchedStates, consume, null);
        }

        protected <T> boolean match(int bid, SequenceMatcher.MatchedStates<T> matchedStates, boolean consume, State prevState) {
            boolean match = false;
            if (this.next != null) {
                int i = 0;
                for (State s : this.next) {
                    boolean m = s.match(matchedStates.branchStates.getBranchId(bid, ++i, this.next.size()), matchedStates, consume, this);
                    if (!m) continue;
                    match = true;
                }
            }
            return match;
        }

        protected void add(State nextState) {
            if (this.next == null) {
                this.next = Collections.singleton(nextState);
            } else if (this.next.size() == 1) {
                this.next = new LinkedHashSet<State>(this.next);
                this.next.add(nextState);
            } else {
                this.next.add(nextState);
            }
        }

        public <T> Object value(int bid, SequenceMatcher.MatchedStates<T> matchedStates) {
            HasInterval<Integer> matchedInterval;
            if (this.hasSavedValue && (matchedInterval = matchedStates.getBranchStates().getMatchedInterval(bid, this)) != null && matchedInterval instanceof ValuedInterval) {
                return ((ValuedInterval)matchedInterval).getValue();
            }
            return null;
        }

        public void markOptional(boolean propagate) {
            this.isOptional = true;
            if (propagate && this.next != null) {
                Stack<State> todo = new Stack<State>();
                HashSet<State> seen = new HashSet<State>();
                todo.addAll(this.next);
                while (!todo.empty()) {
                    State s = (State)todo.pop();
                    s.isOptional = true;
                    seen.add(s);
                    if (this.next == null) continue;
                    for (State n : this.next) {
                        if (seen.contains(n)) continue;
                        todo.push(n);
                    }
                }
            }
        }
    }

    public static class AndPatternExpr
    extends PatternExpr {
        private static final long serialVersionUID = -5470437627660213806L;
        private final List<PatternExpr> patterns;

        public AndPatternExpr(List<PatternExpr> patterns) {
            this.patterns = patterns;
        }

        public AndPatternExpr(PatternExpr ... patterns) {
            this.patterns = Arrays.asList(patterns);
        }

        @Override
        protected Frag build() {
            ConjStartState conjStart = new ConjStartState(this.patterns.size());
            Frag frag = new Frag();
            frag.start = conjStart;
            for (int i = 0; i < this.patterns.size(); ++i) {
                PatternExpr pattern = this.patterns.get(i);
                Frag f = pattern.build();
                frag.start.add(f.start);
                f.connect(new ConjEndState(conjStart, i));
                frag.add(f.out);
            }
            return frag;
        }

        @Override
        protected int assignGroupIds(int start) {
            int nextId = start;
            for (PatternExpr pattern : this.patterns) {
                nextId = pattern.assignGroupIds(nextId);
            }
            return nextId;
        }

        @Override
        protected void updateBindings(VarGroupBindings bindings) {
            for (PatternExpr pattern : this.patterns) {
                pattern.updateBindings(bindings);
            }
        }

        @Override
        protected PatternExpr copy() {
            ArrayList<PatternExpr> newPatterns = new ArrayList<PatternExpr>(this.patterns.size());
            for (PatternExpr p : this.patterns) {
                newPatterns.add(p.copy());
            }
            return new AndPatternExpr(newPatterns);
        }

        @Override
        protected PatternExpr optimize() {
            ArrayList<PatternExpr> newPatterns = new ArrayList<PatternExpr>(this.patterns.size());
            for (PatternExpr p : this.patterns) {
                newPatterns.add(p.optimize());
            }
            return new AndPatternExpr(newPatterns);
        }

        @Override
        protected PatternExpr transform(NodePatternTransformer transformer) {
            ArrayList<PatternExpr> newPatterns = new ArrayList<PatternExpr>(this.patterns.size());
            for (PatternExpr p : this.patterns) {
                newPatterns.add(p.transform(transformer));
            }
            return new AndPatternExpr(newPatterns);
        }

        public String toString() {
            return StringUtils.join(this.patterns, " & ");
        }
    }

    public static class OrPatternExpr
    extends PatternExpr {
        private static final long serialVersionUID = 2566259662702631896L;
        private final List<PatternExpr> patterns;
        private static final int OPTIMIZE_MIN_SIZE = 5;

        public OrPatternExpr(List<PatternExpr> patterns) {
            this.patterns = patterns;
        }

        public OrPatternExpr(PatternExpr ... patterns) {
            this.patterns = Arrays.asList(patterns);
        }

        @Override
        protected Frag build() {
            Frag frag = new Frag();
            frag.start = new State();
            for (PatternExpr pattern : this.patterns) {
                Frag f = pattern.build();
                if (pattern.value() != null) {
                    f.connect(new ValueState(pattern.value()));
                }
                frag.start.add(f.start);
                frag.add(f.out);
            }
            frag.start.markOptional(true);
            return frag;
        }

        @Override
        protected int assignGroupIds(int start) {
            int nextId = start;
            for (PatternExpr pattern : this.patterns) {
                nextId = pattern.assignGroupIds(nextId);
            }
            return nextId;
        }

        @Override
        protected void updateBindings(VarGroupBindings bindings) {
            for (PatternExpr pattern : this.patterns) {
                pattern.updateBindings(bindings);
            }
        }

        @Override
        protected PatternExpr copy() {
            ArrayList<PatternExpr> newPatterns = new ArrayList<PatternExpr>(this.patterns.size());
            for (PatternExpr p : this.patterns) {
                newPatterns.add(p.copy());
            }
            return new OrPatternExpr(newPatterns);
        }

        @Override
        protected PatternExpr transform(NodePatternTransformer transformer) {
            ArrayList<PatternExpr> newPatterns = new ArrayList<PatternExpr>(this.patterns.size());
            for (PatternExpr p : this.patterns) {
                newPatterns.add(p.transform(transformer));
            }
            return new OrPatternExpr(newPatterns);
        }

        public String toString() {
            return StringUtils.join(this.patterns, " | ");
        }

        @Override
        protected PatternExpr optimize() {
            if (this.patterns.size() <= 5) {
                ArrayList<PatternExpr> newPatterns = new ArrayList<PatternExpr>(this.patterns.size());
                for (PatternExpr p : this.patterns) {
                    newPatterns.add(p.optimize());
                }
                return new OrPatternExpr(newPatterns);
            }
            return this.optimizeOr();
        }

        private PatternExpr optimizeOr() {
            PatternExpr optimizedStringSeqs = this.optimizeOrStringSeqs();
            return optimizedStringSeqs;
        }

        private PatternExpr optimizeOrStringSeqs() {
            PatternExpr optimized;
            Set set;
            Pair saved;
            ArrayList<PatternExpr> opts = new ArrayList<PatternExpr>(this.patterns.size());
            HashMap stringPatterns = new HashMap();
            HashMap stringSeqPatterns = new HashMap();
            for (PatternExpr p : this.patterns) {
                Pair saved2;
                PatternExpr opt = p.optimize();
                opts.add(opt);
                if (opt instanceof NodePatternExpr) {
                    Pair<Class, ComplexNodePattern.StringAnnotationPattern> pair = OrPatternExpr._getStringAnnotation_(opt);
                    if (pair == null) continue;
                    Boolean ignoreCase = ((ComplexNodePattern.StringAnnotationPattern)pair.second).ignoreCase();
                    String target = ((ComplexNodePattern.StringAnnotationPattern)pair.second).target;
                    Pair key = Pair.makePair(pair.first, ignoreCase);
                    saved2 = (Pair)stringPatterns.get(key);
                    if (saved2 == null) {
                        saved2 = new Pair(new ArrayList(), new HashSet());
                        stringPatterns.put(key, saved2);
                    }
                    ((Collection)saved2.first).add(opt);
                    ((Set)saved2.second).add(target);
                    continue;
                }
                if (!(opt instanceof SequencePatternExpr)) continue;
                SequencePatternExpr seq = (SequencePatternExpr)opt;
                if (seq.patterns.size() <= 0) continue;
                boolean isStringSeq = true;
                Pair key = null;
                ArrayList<String> strings = null;
                for (PatternExpr sp : seq.patterns) {
                    Pair<Class, ComplexNodePattern.StringAnnotationPattern> pair = OrPatternExpr._getStringAnnotation_(sp);
                    if (pair != null) {
                        if (key != null) {
                            if (!((Class)key.first).equals(pair.first) || !((Boolean)key.second).equals(((ComplexNodePattern.StringAnnotationPattern)pair.second).ignoreCase())) {
                                isStringSeq = false;
                                break;
                            }
                        } else {
                            key = Pair.makePair(pair.first, ((ComplexNodePattern.StringAnnotationPattern)pair.second).ignoreCase());
                            strings = new ArrayList<String>();
                        }
                        strings.add(((ComplexNodePattern.StringAnnotationPattern)pair.second).target);
                        continue;
                    }
                    isStringSeq = false;
                    break;
                }
                if (!isStringSeq) continue;
                saved2 = (Pair)stringSeqPatterns.get(key);
                if (saved2 == null) {
                    saved2 = new Pair(new ArrayList(), new HashSet());
                    stringSeqPatterns.put(key, saved2);
                }
                ((Collection)saved2.first).add(opt);
                ((Set)saved2.second).add(strings);
            }
            IdentityHashMap<PatternExpr, Boolean> alreadyOptimized = new IdentityHashMap<PatternExpr, Boolean>();
            ArrayList<PatternExpr> finalOptimizedPatterns = new ArrayList<PatternExpr>(this.patterns.size());
            for (Map.Entry entry : stringPatterns.entrySet()) {
                int flags;
                saved = (Pair)entry.getValue();
                set = (Set)saved.second;
                int n = flags = (Boolean)((Pair)entry.getKey()).second != false ? 66 : 0;
                if (set.size() <= 5) continue;
                optimized = new NodePatternExpr(new CoreMapNodePattern((Class)((Pair)entry.getKey()).first, new ComplexNodePattern.StringInSetAnnotationPattern(set, flags)));
                finalOptimizedPatterns.add(optimized);
                for (PatternExpr p : (Collection)saved.first) {
                    alreadyOptimized.put(p, true);
                }
            }
            for (Map.Entry entry : stringSeqPatterns.entrySet()) {
                saved = (Pair)entry.getValue();
                set = (Set)saved.second;
                if (set.size() <= 5) continue;
                Pair key = (Pair)entry.getKey();
                optimized = new MultiNodePatternExpr(new MultiCoreMapNodePattern.StringSequenceAnnotationPattern((Class)key.first(), set, (boolean)((Boolean)key.second())));
                finalOptimizedPatterns.add(optimized);
                for (PatternExpr p : (Collection)saved.first) {
                    alreadyOptimized.put(p, true);
                }
            }
            for (PatternExpr p : opts) {
                Boolean included = (Boolean)alreadyOptimized.get(p);
                if (included != null && included.booleanValue()) continue;
                finalOptimizedPatterns.add(p);
            }
            return new OrPatternExpr(finalOptimizedPatterns);
        }

        private static Pair<Class, ComplexNodePattern.StringAnnotationPattern> _getStringAnnotation_(PatternExpr p) {
            List annotationPatterns;
            NodePattern nodePattern;
            if (p instanceof NodePatternExpr && (nodePattern = ((NodePatternExpr)p).nodePattern) instanceof CoreMapNodePattern && (annotationPatterns = ((CoreMapNodePattern)nodePattern).getAnnotationPatterns()).size() == 1) {
                Pair pair = annotationPatterns.get(0);
                if (pair.second instanceof ComplexNodePattern.StringAnnotationPattern) {
                    return Pair.makePair(pair.first, (ComplexNodePattern.StringAnnotationPattern)pair.second);
                }
            }
            return null;
        }
    }

    public static class RepeatPatternExpr
    extends PatternExpr {
        private static final long serialVersionUID = 3935482630250147745L;
        private final PatternExpr pattern;
        private final int minMatch;
        private final int maxMatch;
        private final boolean greedyMatch;

        public RepeatPatternExpr(PatternExpr pattern, int minMatch, int maxMatch) {
            this(pattern, minMatch, maxMatch, true);
        }

        public RepeatPatternExpr(PatternExpr pattern, int minMatch, int maxMatch, boolean greedy) {
            if (minMatch < 0) {
                throw new IllegalArgumentException("Invalid minMatch=" + minMatch);
            }
            if (maxMatch >= 0 && minMatch > maxMatch) {
                throw new IllegalArgumentException("Invalid minMatch=" + minMatch + ", maxMatch=" + maxMatch);
            }
            this.pattern = pattern;
            this.minMatch = minMatch;
            this.maxMatch = maxMatch;
            this.greedyMatch = greedy;
        }

        @Override
        protected Frag build() {
            Frag f = this.pattern.build();
            if (this.minMatch == 1 && this.maxMatch == 1) {
                return f;
            }
            if (this.minMatch <= 5 && this.maxMatch <= 5 && this.greedyMatch) {
                Frag f2;
                int i;
                if (this.minMatch > 0) {
                    for (i = 0; i < this.minMatch - 1; ++i) {
                        f2 = this.pattern.build();
                        f.connect(f2);
                    }
                } else {
                    f = new Frag(new State());
                }
                if (this.maxMatch < 0) {
                    Set<State> curOut = f.out;
                    f2 = this.pattern.build();
                    f2.connect(f2);
                    f.connect(f2);
                    f.add(curOut);
                } else {
                    for (i = this.minMatch; i < this.maxMatch; ++i) {
                        Set<State> curOut = f.out;
                        Frag f22 = this.pattern.build();
                        f.connect(f22);
                        f.add(curOut);
                    }
                }
                if (this.minMatch == 0) {
                    f.start.markOptional(true);
                }
                return f;
            }
            RepeatState s = new RepeatState(f.start, this.minMatch, this.maxMatch, this.greedyMatch);
            f.connect(s);
            return new Frag(s);
        }

        @Override
        protected int assignGroupIds(int start) {
            return this.pattern.assignGroupIds(start);
        }

        @Override
        protected void updateBindings(VarGroupBindings bindings) {
            this.pattern.updateBindings(bindings);
        }

        @Override
        protected PatternExpr copy() {
            return new RepeatPatternExpr(this.pattern.copy(), this.minMatch, this.maxMatch, this.greedyMatch);
        }

        @Override
        protected PatternExpr optimize() {
            return new RepeatPatternExpr(this.pattern.optimize(), this.minMatch, this.maxMatch, this.greedyMatch);
        }

        @Override
        protected PatternExpr transform(NodePatternTransformer transformer) {
            return new RepeatPatternExpr(this.pattern.transform(transformer), this.minMatch, this.maxMatch, this.greedyMatch);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.pattern);
            sb.append('{').append(this.minMatch).append(',').append(this.maxMatch).append('}');
            if (!this.greedyMatch) {
                sb.append('?');
            }
            return sb.toString();
        }
    }

    public static class GroupPatternExpr
    extends PatternExpr {
        private static final long serialVersionUID = -6477601300665620926L;
        private final PatternExpr pattern;
        private final boolean capture;
        private int captureGroupId;
        private final String varname;

        public GroupPatternExpr(PatternExpr pattern) {
            this(pattern, true);
        }

        public GroupPatternExpr(PatternExpr pattern, boolean capture) {
            this(pattern, capture, -1, null);
        }

        public GroupPatternExpr(PatternExpr pattern, String varname) {
            this(pattern, true, -1, varname);
        }

        private GroupPatternExpr(PatternExpr pattern, boolean capture, int captureGroupId, String varname) {
            this.pattern = pattern;
            this.capture = capture;
            this.captureGroupId = captureGroupId;
            this.varname = varname;
        }

        @Override
        protected Frag build() {
            Frag f = this.pattern.build();
            Frag frag = new Frag(new GroupStartState(this.captureGroupId, f.start), f.out);
            frag.connect(new GroupEndState(this.captureGroupId));
            return frag;
        }

        @Override
        protected int assignGroupIds(int start) {
            int nextId = start;
            if (this.capture) {
                this.captureGroupId = nextId++;
            }
            return this.pattern.assignGroupIds(nextId);
        }

        @Override
        protected void updateBindings(VarGroupBindings bindings) {
            if (this.varname != null) {
                bindings.set(this.captureGroupId, this.varname);
            }
            this.pattern.updateBindings(bindings);
        }

        @Override
        protected PatternExpr copy() {
            return new GroupPatternExpr(this.pattern.copy(), this.capture, this.captureGroupId, this.varname);
        }

        @Override
        protected PatternExpr optimize() {
            return new GroupPatternExpr(this.pattern.optimize(), this.capture, this.captureGroupId, this.varname);
        }

        @Override
        protected PatternExpr transform(NodePatternTransformer transformer) {
            return new GroupPatternExpr(this.pattern.transform(transformer), this.capture, this.captureGroupId, this.varname);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            if (!this.capture) {
                sb.append("?: ");
            } else if (this.varname != null) {
                sb.append('?').append(this.varname).append(' ');
            }
            sb.append(this.pattern);
            sb.append(')');
            return sb.toString();
        }
    }

    public static class ValuePatternExpr
    extends PatternExpr {
        private final PatternExpr expr;
        private final Object value;

        public ValuePatternExpr(PatternExpr expr, Object value) {
            this.expr = expr;
            this.value = value;
        }

        @Override
        protected Frag build() {
            Frag frag = this.expr.build();
            frag.connect(new ValueState(this.value));
            return frag;
        }

        @Override
        protected int assignGroupIds(int start) {
            return this.expr.assignGroupIds(start);
        }

        @Override
        protected PatternExpr copy() {
            return new ValuePatternExpr(this.expr.copy(), this.value);
        }

        @Override
        protected PatternExpr optimize() {
            return new ValuePatternExpr(this.expr.optimize(), this.value);
        }

        @Override
        protected PatternExpr transform(NodePatternTransformer transformer) {
            return new ValuePatternExpr(this.expr.transform(transformer), this.value);
        }

        @Override
        protected void updateBindings(VarGroupBindings bindings) {
            this.expr.updateBindings(bindings);
        }
    }

    public static class BackRefPatternExpr
    extends PatternExpr {
        private static final long serialVersionUID = -4649629486266561619L;
        private final NodesMatchChecker matcher;
        private final int captureGroupId;

        public BackRefPatternExpr(NodesMatchChecker matcher, int captureGroupId) {
            if (captureGroupId <= 0) {
                throw new IllegalArgumentException("Invalid captureGroupId=" + captureGroupId);
            }
            this.captureGroupId = captureGroupId;
            this.matcher = matcher;
        }

        @Override
        protected Frag build() {
            BackRefState s = new BackRefState(this.matcher, this.captureGroupId);
            return new Frag(s);
        }

        @Override
        protected int assignGroupIds(int start) {
            return start;
        }

        @Override
        protected void updateBindings(VarGroupBindings bindings) {
        }

        @Override
        protected PatternExpr copy() {
            return new BackRefPatternExpr(this.matcher, this.captureGroupId);
        }

        @Override
        protected PatternExpr transform(NodePatternTransformer transformer) {
            throw new UnsupportedOperationException("BackRefPatternExpr.transform not implemented yet!!! Please implement me!!!");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.captureGroupId >= 0) {
                sb.append('\\').append(this.captureGroupId);
            } else {
                sb.append('\\');
            }
            sb.append('{').append(this.matcher).append('}');
            return sb.toString();
        }
    }

    public static class SequencePatternExpr
    extends PatternExpr {
        private static final long serialVersionUID = 7446769896088599604L;
        final List<PatternExpr> patterns;

        public SequencePatternExpr(List<PatternExpr> patterns) {
            this.patterns = patterns;
        }

        public SequencePatternExpr(PatternExpr ... patterns) {
            this.patterns = Arrays.asList(patterns);
        }

        @Override
        protected Frag build() {
            Frag frag = null;
            if (this.patterns.size() > 0) {
                PatternExpr first = this.patterns.get(0);
                frag = first.build();
                for (int i = 1; i < this.patterns.size(); ++i) {
                    PatternExpr pattern = this.patterns.get(i);
                    Frag f = pattern.build();
                    frag.connect(f);
                }
            }
            return frag;
        }

        @Override
        protected int assignGroupIds(int start) {
            int nextId = start;
            for (PatternExpr pattern : this.patterns) {
                nextId = pattern.assignGroupIds(nextId);
            }
            return nextId;
        }

        @Override
        protected void updateBindings(VarGroupBindings bindings) {
            for (PatternExpr pattern : this.patterns) {
                pattern.updateBindings(bindings);
            }
        }

        @Override
        protected PatternExpr copy() {
            ArrayList<PatternExpr> newPatterns = new ArrayList<PatternExpr>(this.patterns.size());
            for (PatternExpr p : this.patterns) {
                newPatterns.add(p.copy());
            }
            return new SequencePatternExpr(newPatterns);
        }

        @Override
        public PatternExpr optimize() {
            ArrayList<PatternExpr> newPatterns = new ArrayList<PatternExpr>(this.patterns.size());
            for (PatternExpr p : this.patterns) {
                newPatterns.add(p.optimize());
            }
            return new SequencePatternExpr(newPatterns);
        }

        @Override
        protected PatternExpr transform(NodePatternTransformer transformer) {
            ArrayList<PatternExpr> newPatterns = new ArrayList<PatternExpr>(this.patterns.size());
            for (PatternExpr p : this.patterns) {
                newPatterns.add(p.transform(transformer));
            }
            return new SequencePatternExpr(newPatterns);
        }

        public String toString() {
            return StringUtils.join(this.patterns, " ");
        }
    }

    public static class SequenceEndPatternExpr
    extends SpecialNodePatternExpr
    implements Factory<State> {
        public SequenceEndPatternExpr() {
            super("SEQ_END");
            this.stateFactory = this;
        }

        @Override
        public State create() {
            return new SeqEndState();
        }
    }

    public static class SequenceStartPatternExpr
    extends SpecialNodePatternExpr
    implements Factory<State> {
        public SequenceStartPatternExpr() {
            super("SEQ_START");
            this.stateFactory = this;
        }

        @Override
        public State create() {
            return new SeqStartState();
        }
    }

    public static class SpecialNodePatternExpr
    extends PatternExpr {
        private static final long serialVersionUID = 3347587132602082616L;
        private final String name;
        Factory<State> stateFactory;

        public SpecialNodePatternExpr(String name) {
            this(name, null);
        }

        public SpecialNodePatternExpr(String name, Factory<State> stateFactory) {
            this.name = name;
            this.stateFactory = stateFactory;
        }

        @Override
        protected Frag build() {
            State s = this.stateFactory.create();
            return new Frag(s);
        }

        @Override
        protected PatternExpr copy() {
            return new SpecialNodePatternExpr(this.name, this.stateFactory);
        }

        @Override
        protected int assignGroupIds(int start) {
            return start;
        }

        @Override
        protected void updateBindings(VarGroupBindings bindings) {
        }

        @Override
        protected PatternExpr transform(NodePatternTransformer transformer) {
            return new SpecialNodePatternExpr(this.name, this.stateFactory);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class MultiNodePatternExpr
    extends PatternExpr {
        private final MultiNodePattern multiNodePattern;

        public MultiNodePatternExpr(MultiNodePattern nodePattern) {
            this.multiNodePattern = nodePattern;
        }

        @Override
        protected Frag build() {
            MultiNodePatternState s = new MultiNodePatternState(this.multiNodePattern);
            return new Frag(s);
        }

        @Override
        protected PatternExpr copy() {
            return new MultiNodePatternExpr(this.multiNodePattern);
        }

        @Override
        protected int assignGroupIds(int start) {
            return start;
        }

        @Override
        protected void updateBindings(VarGroupBindings bindings) {
        }

        @Override
        protected PatternExpr transform(NodePatternTransformer transformer) {
            return new MultiNodePatternExpr(transformer.transform(this.multiNodePattern));
        }

        public String toString() {
            return this.multiNodePattern.toString();
        }
    }

    public static class NodePatternExpr
    extends PatternExpr {
        final NodePattern nodePattern;

        public NodePatternExpr(NodePattern nodePattern) {
            this.nodePattern = nodePattern;
        }

        @Override
        protected Frag build() {
            NodePatternState s = new NodePatternState(this.nodePattern);
            return new Frag(s);
        }

        @Override
        protected PatternExpr copy() {
            return new NodePatternExpr(this.nodePattern);
        }

        @Override
        protected int assignGroupIds(int start) {
            return start;
        }

        @Override
        protected void updateBindings(VarGroupBindings bindings) {
        }

        @Override
        protected PatternExpr transform(NodePatternTransformer transformer) {
            return new NodePatternExpr(transformer.transform(this.nodePattern));
        }

        public String toString() {
            return this.nodePattern.toString();
        }
    }

    public static abstract class PatternExpr
    implements Serializable {
        private static final long serialVersionUID = 7610237291757954879L;

        protected abstract Frag build();

        protected abstract int assignGroupIds(int var1);

        protected abstract PatternExpr copy();

        protected abstract void updateBindings(VarGroupBindings var1);

        protected Object value() {
            return null;
        }

        protected PatternExpr optimize() {
            return this;
        }

        protected abstract PatternExpr transform(NodePatternTransformer var1);
    }

    protected static interface NodesMatchChecker<T> {
        public boolean matches(T var1, T var2);
    }

    static class VarGroupBindings {
        final String[] varnames;

        protected VarGroupBindings(int size) {
            this.varnames = new String[size];
        }

        protected void set(int index, String name) {
            this.varnames[index] = name;
        }
    }

    public static interface Parser<T> {
        public PatternExpr parseSequence(Env var1, String var2) throws Exception;

        public Pair<PatternExpr, SequenceMatchAction<T>> parseSequenceWithAction(Env var1, String var2) throws Exception;

        public PatternExpr parseNode(Env var1, String var2) throws Exception;
    }
}

