/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.maxent.CGRunner;
import edu.stanford.nlp.maxent.Problem;
import edu.stanford.nlp.maxent.iis.LambdaSolve;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.objectbank.ReaderIteratorFactory;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.process.ListProcessor;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.process.TransformXML;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.tagger.common.Tagger;
import edu.stanford.nlp.tagger.io.TaggedFileRecord;
import edu.stanford.nlp.tagger.maxent.AmbiguityClasses;
import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.ExtractorFramesRare;
import edu.stanford.nlp.tagger.maxent.Extractors;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.LambdaSolveTagger;
import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.tagger.maxent.TaggerExperiments;
import edu.stanford.nlp.tagger.maxent.TaggerFeatures;
import edu.stanford.nlp.tagger.maxent.TestClassifier;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import edu.stanford.nlp.util.DataFilePaths;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.XMLUtils;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

public class MaxentTagger
extends Tagger
implements ListProcessor<List<? extends HasWord>, List<TaggedWord>>,
Serializable {
    private static final Redwood.RedwoodChannels log = Redwood.channels(MaxentTagger.class);
    public static final String BASE_TAGGER_HOME = "$NLP_DATA_HOME/data/pos-tagger/distrib";
    public static final String TAGGER_HOME = DataFilePaths.convert("$NLP_DATA_HOME/data/pos-tagger/distrib");
    public static final String DEFAULT_NLP_GROUP_MODEL_PATH = new File(TAGGER_HOME, "english-left3words-distsim.tagger").getPath();
    public static final String DEFAULT_JAR_PATH = "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger";
    public static final String DEFAULT_DISTRIBUTION_PATH = "models/english-left3words-distsim.tagger";
    final Dictionary dict = new Dictionary();
    TTags tags;
    private LambdaSolveTagger prob;
    List<Map<String, int[]>> fAssociations = Generics.newArrayList();
    Extractors extractors;
    Extractors extractorsRare;
    AmbiguityClasses ambClasses;
    final boolean alltags = false;
    final Map<String, Set<String>> tagTokens = Generics.newHashMap();
    private static final int RARE_WORD_THRESH = Integer.parseInt("5");
    private static final int MIN_FEATURE_THRESH = Integer.parseInt("5");
    private static final int CUR_WORD_MIN_FEATURE_THRESH = Integer.parseInt("2");
    private static final int RARE_WORD_MIN_FEATURE_THRESH = Integer.parseInt("10");
    private static final int VERY_COMMON_WORD_THRESH = Integer.parseInt("250");
    private static final boolean OCCURRING_TAGS_ONLY = Boolean.parseBoolean("false");
    private static final boolean POSSIBLE_TAGS_ONLY = Boolean.parseBoolean("false");
    private double defaultScore;
    private double[] defaultScores;
    int leftContext;
    int rightContext;
    TaggerConfig config;
    private int rareWordThresh = RARE_WORD_THRESH;
    int minFeatureThresh = MIN_FEATURE_THRESH;
    int curWordMinFeatureThresh = CUR_WORD_MIN_FEATURE_THRESH;
    int rareWordMinFeatureThresh = RARE_WORD_MIN_FEATURE_THRESH;
    int veryCommonWordThresh = VERY_COMMON_WORD_THRESH;
    int xSize;
    int ySize;
    boolean occurringTagsOnly = OCCURRING_TAGS_ONLY;
    boolean possibleTagsOnly = POSSIBLE_TAGS_ONLY;
    private boolean initted = false;
    boolean VERBOSE = false;
    Function<String, String> wordFunction;
    private static final Pattern formatPattern = Pattern.compile("format=[a-zA-Z]+,");
    private static final long serialVersionUID = 2L;

    public MaxentTagger() {
    }

    public MaxentTagger(TaggerConfig config) {
        this(config.getModel(), config);
    }

    public MaxentTagger(String modelFile) {
        this(modelFile, StringUtils.argsToProperties("-model", modelFile), true);
    }

    public MaxentTagger(InputStream modelStream) {
        this(modelStream, new Properties(), true);
    }

    public MaxentTagger(String modelFile, Properties config) {
        this(modelFile, config, true);
    }

    public MaxentTagger(String modelFile, Properties config, boolean printLoading) {
        this.readModelAndInit(config, modelFile, printLoading);
    }

    public MaxentTagger(InputStream modelStream, Properties config, boolean printLoading) {
        this.readModelAndInit(config, modelStream, printLoading);
    }

    public int addTag(String tag) {
        return this.tags.add(tag);
    }

    public int getTagIndex(String tag) {
        return this.tags.getIndex(tag);
    }

    public int numTags() {
        return this.tags.getSize();
    }

    public String getTag(int index) {
        return this.tags.getTag(index);
    }

    public Set<String> tagSet() {
        return this.tags.tagSet();
    }

    LambdaSolve getLambdaSolve() {
        return this.prob;
    }

    void init(TaggerConfig config) {
        Object[] closedClassTags;
        Object[] openClassTags;
        String arch;
        String lang;
        if (this.initted) {
            return;
        }
        this.config = config;
        if (config == null) {
            lang = "english";
            arch = "left3words";
            openClassTags = StringUtils.EMPTY_STRING_ARRAY;
            closedClassTags = StringUtils.EMPTY_STRING_ARRAY;
            this.wordFunction = null;
        } else {
            this.VERBOSE = config.getVerbose();
            lang = config.getLang();
            arch = config.getArch();
            openClassTags = config.getOpenClassTags();
            closedClassTags = config.getClosedClassTags();
            if (!config.getWordFunction().equals("")) {
                this.wordFunction = (Function)ReflectionLoading.loadByReflection(config.getWordFunction(), new Object[0]);
            }
            if (openClassTags.length > 0 && !lang.equals("") || closedClassTags.length > 0 && !lang.equals("") || closedClassTags.length > 0 && openClassTags.length > 0) {
                throw new RuntimeException("At least two of lang (\"" + lang + "\"), openClassTags (length " + openClassTags.length + ": " + Arrays.toString(openClassTags) + "),and closedClassTags (length " + closedClassTags.length + ": " + Arrays.toString(closedClassTags) + ") specified---you must choose one!");
            }
            if (openClassTags.length == 0 && lang.equals("") && closedClassTags.length == 0 && !config.getLearnClosedClassTags()) {
                log.info("warning: no language set, no open-class tags specified, and no closed-class tags specified; assuming ALL tags are open class tags");
            }
        }
        if (openClassTags.length > 0) {
            this.tags = new TTags();
            this.tags.setOpenClassTags((String[])openClassTags);
        } else if (closedClassTags.length > 0) {
            this.tags = new TTags();
            this.tags.setClosedClassTags((String[])closedClassTags);
        } else {
            this.tags = new TTags(lang);
        }
        double d = this.defaultScore = lang.equals("english") ? 1.0 : 0.0;
        if (config != null) {
            this.rareWordThresh = config.getRareWordThresh();
            this.minFeatureThresh = config.getMinFeatureThresh();
            this.curWordMinFeatureThresh = config.getCurWordMinFeatureThresh();
            this.rareWordMinFeatureThresh = config.getRareWordMinFeatureThresh();
            this.veryCommonWordThresh = config.getVeryCommonWordThresh();
            this.occurringTagsOnly = config.occurringTagsOnly();
            this.possibleTagsOnly = config.possibleTagsOnly();
            if (config.getDefaultScore() >= 0.0) {
                this.defaultScore = config.getDefaultScore();
            }
        }
        this.defaultScores = null;
        if (config == null || config.getMode() == TaggerConfig.Mode.TRAIN) {
            this.extractors = new Extractors(ExtractorFrames.getExtractorFrames(arch));
            this.extractorsRare = new Extractors(ExtractorFramesRare.getExtractorFramesRare(arch, this.tags));
            this.setExtractorsGlobal();
        }
        this.ambClasses = new AmbiguityClasses(this.tags);
        this.initted = true;
    }

    private synchronized void initDefaultScores() {
        if (this.defaultScores == null) {
            this.defaultScores = new double[this.ySize + 1];
            for (int i = 0; i < this.ySize + 1; ++i) {
                this.defaultScores[i] = Math.log((double)i * this.defaultScore);
            }
        }
    }

    double getInactiveTagDefaultScore(int nDefault) {
        if (this.defaultScores == null) {
            this.initDefaultScores();
        }
        return this.defaultScores[nDefault];
    }

    boolean hasApproximateScoring() {
        return this.defaultScore > 0.0;
    }

    protected TokenizerFactory<? extends HasWord> chooseTokenizerFactory() {
        return MaxentTagger.chooseTokenizerFactory(this.config.getTokenize(), this.config.getTokenizerFactory(), this.config.getTokenizerOptions(), this.config.getTokenizerInvertible());
    }

    protected static TokenizerFactory<? extends HasWord> chooseTokenizerFactory(boolean tokenize, String tokenizerFactory, String tokenizerOptions, boolean invertible) {
        if (tokenize && tokenizerFactory.trim().length() != 0) {
            try {
                Class<?> clazz = Class.forName(tokenizerFactory.trim());
                Method factoryMethod = clazz.getMethod("newTokenizerFactory", new Class[0]);
                TokenizerFactory factory = (TokenizerFactory)factoryMethod.invoke((Object)tokenizerOptions, new Object[0]);
                return factory;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load tokenizer factory", e);
            }
        }
        if (tokenize) {
            if (invertible) {
                if (tokenizerOptions.equals("")) {
                    tokenizerOptions = "invertible=true";
                } else if (!tokenizerOptions.matches("(^|.*,)invertible=true")) {
                    tokenizerOptions = tokenizerOptions + ",invertible=true";
                }
                return PTBTokenizer.PTBTokenizerFactory.newCoreLabelTokenizerFactory(tokenizerOptions);
            }
            return PTBTokenizer.PTBTokenizerFactory.newWordTokenizerFactory(tokenizerOptions);
        }
        return WhitespaceTokenizer.factory();
    }

    private void saveExtractors(OutputStream os) throws IOException {
        ObjectOutputStream out2 = new ObjectOutputStream(os);
        out2.writeObject(this.extractors);
        out2.writeObject(this.extractorsRare);
        out2.flush();
    }

    private void readExtractors(InputStream file) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(file);
        this.extractors = (Extractors)in.readObject();
        this.extractorsRare = (Extractors)in.readObject();
        this.extractors.initTypes();
        this.extractorsRare.initTypes();
        int left = this.extractors.leftContext();
        int left_u = this.extractorsRare.leftContext();
        if (left_u > left) {
            left = left_u;
        }
        this.leftContext = left;
        int right = this.extractors.rightContext();
        int right_u = this.extractorsRare.rightContext();
        if (right_u > right) {
            right = right_u;
        }
        this.rightContext = right;
        this.setExtractorsGlobal();
    }

    private void setExtractorsGlobal() {
        this.extractors.setGlobalHolder(this);
        this.extractorsRare.setGlobalHolder(this);
    }

    private void removeDeadRules() {
        for (Map<String, int[]> fAssociation : this.fAssociations) {
            ArrayList<String> deadRules = Generics.newArrayList();
            for (Map.Entry<String, int[]> entry : fAssociation.entrySet()) {
                String value = entry.getKey();
                int[] fAssociations = entry.getValue();
                boolean found = false;
                for (int index = 0; index < this.ySize; ++index) {
                    int fNum = fAssociations[index];
                    if (fNum <= -1 || this.getLambdaSolve().lambda[fNum] == 0.0) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                deadRules.add(value);
            }
            for (String rule : deadRules) {
                fAssociation.remove(rule);
            }
        }
    }

    private void simplifyLambda() {
        double[] lambda = this.getLambdaSolve().lambda;
        int[] map = new int[lambda.length];
        int current = 0;
        for (int index = 0; index < lambda.length; ++index) {
            map[index] = lambda[index] == 0.0 ? -1 : current++;
        }
        double[] condensedLambda = new double[current];
        for (int i = 0; i < lambda.length; ++i) {
            if (map[i] == -1) continue;
            condensedLambda[map[i]] = lambda[i];
        }
        for (Map<String, int[]> featureMap : this.fAssociations) {
            for (Map.Entry<String, int[]> entry : featureMap.entrySet()) {
                int[] fAssociations = entry.getValue();
                for (int index = 0; index < this.ySize; ++index) {
                    if (fAssociations[index] < 0) continue;
                    fAssociations[index] = map[fAssociations[index]];
                }
            }
        }
        this.prob = new LambdaSolveTagger(condensedLambda);
    }

    protected void saveModel(String filename) {
        try {
            DataOutputStream file = IOUtils.getDataOutputStream(filename);
            this.saveModel(file);
            file.close();
        }
        catch (IOException ioe) {
            log.info("Error saving tagger to file " + filename);
            throw new RuntimeIOException(ioe);
        }
    }

    protected void saveModel(DataOutputStream file) throws IOException {
        this.config.saveConfig(file);
        file.writeInt(this.xSize);
        file.writeInt(this.ySize);
        this.dict.save(file);
        this.tags.save(file, this.tagTokens);
        this.saveExtractors(file);
        int sizeAssoc = 0;
        for (Map<String, int[]> fValueAssociations : this.fAssociations) {
            for (int[] nArray : fValueAssociations.values()) {
                for (int association : nArray) {
                    if (association < 0) continue;
                    ++sizeAssoc;
                }
            }
        }
        file.writeInt(sizeAssoc);
        for (int i = 0; i < this.fAssociations.size(); ++i) {
            Map<String, int[]> fValueAssociations;
            fValueAssociations = this.fAssociations.get(i);
            for (Map.Entry entry : fValueAssociations.entrySet()) {
                String featureValue = (String)entry.getKey();
                int[] fTagAssociations = (int[])entry.getValue();
                for (int j = 0; j < fTagAssociations.length; ++j) {
                    int association;
                    association = fTagAssociations[j];
                    if (association < 0) continue;
                    file.writeInt(association);
                    FeatureKey fk = new FeatureKey(i, featureValue, this.tags.getTag(j));
                    fk.save(file);
                }
            }
        }
        LambdaSolve.save_lambdas(file, this.prob.lambda);
    }

    protected void readModelAndInit(Properties config, String modelFileOrUrl, boolean printLoading) {
        try (InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(modelFileOrUrl);){
            this.readModelAndInit(config, is, printLoading);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error while loading a tagger model (probably missing model file)", e);
        }
    }

    protected void readModelAndInit(Properties config, InputStream modelStream, boolean printLoading) {
        try {
            DataInputStream rf = new DataInputStream(modelStream);
            this.readModelAndInit(config, rf, printLoading);
            rf.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error while loading a tagger model (probably missing model file)", e);
        }
    }

    protected void readModelAndInit(Properties config, DataInputStream rf, boolean printLoading) {
        try {
            Timing t = new Timing();
            String source = null;
            if (printLoading) {
                if (config != null) {
                    source = config.getProperty("model");
                }
                if (source == null) {
                    source = "data stream";
                }
            }
            TaggerConfig taggerConfig = TaggerConfig.readConfig(rf);
            if (config != null) {
                taggerConfig.setProperties(config);
            }
            this.init(taggerConfig);
            this.xSize = rf.readInt();
            this.ySize = rf.readInt();
            this.dict.read(rf);
            if (this.VERBOSE) {
                log.info("Tagger dictionary read.");
            }
            this.tags.read(rf);
            this.readExtractors(rf);
            this.dict.setAmbClasses(this.ambClasses, this.veryCommonWordThresh, this.tags);
            int[] numFA = new int[this.extractors.size() + this.extractorsRare.size()];
            int sizeAssoc = rf.readInt();
            this.fAssociations = Generics.newArrayList();
            for (int i = 0; i < this.extractors.size() + this.extractorsRare.size(); ++i) {
                this.fAssociations.add(Generics.newHashMap());
            }
            if (this.VERBOSE) {
                log.info("Reading %d feature keys...%n", sizeAssoc);
            }
            PrintFile pfVP = null;
            if (this.VERBOSE) {
                pfVP = new PrintFile("pairs.txt");
            }
            for (int i = 0; i < sizeAssoc; ++i) {
                int numF = rf.readInt();
                FeatureKey fK = new FeatureKey();
                fK.read(rf);
                int n = fK.num;
                numFA[n] = numFA[n] + 1;
                Map<String, int[]> fValueAssociations = this.fAssociations.get(fK.num);
                int[] fTagAssociations = fValueAssociations.get(fK.val);
                if (fTagAssociations == null) {
                    fTagAssociations = new int[this.ySize];
                    for (int j = 0; j < this.ySize; ++j) {
                        fTagAssociations[j] = -1;
                    }
                    fValueAssociations.put(fK.val, fTagAssociations);
                }
                fTagAssociations[this.tags.getIndex((String)fK.tag)] = numF;
            }
            if (this.VERBOSE) {
                IOUtils.closeIgnoringExceptions(pfVP);
            }
            if (this.VERBOSE) {
                for (int k = 0; k < numFA.length; ++k) {
                    log.info("Number of features of kind " + k + ' ' + numFA[k]);
                }
            }
            this.prob = new LambdaSolveTagger(rf);
            if (this.VERBOSE) {
                log.info("prob read ");
            }
            if (printLoading) {
                t.done(log, "Loading POS tagger from " + source);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeIOException("Error while loading a tagger model (probably missing model file)", e);
        }
    }

    protected void dumpModel(PrintStream out2) {
        out2.println("Features: template featureValue tag: lambda");
        DecimalFormat nf = new DecimalFormat(" 0.000000;-0.000000");
        for (int i = 0; i < this.fAssociations.size(); ++i) {
            Map<String, int[]> fValueAssociations = this.fAssociations.get(i);
            ArrayList<String> features = Generics.newArrayList();
            Collections.sort(features);
            for (String featureValue : features) {
                int[] fTagAssociations = fValueAssociations.get(featureValue);
                for (int j = 0; j < fTagAssociations.length; ++j) {
                    int association = fTagAssociations[j];
                    if (association < 0) continue;
                    FeatureKey fk = new FeatureKey(i, featureValue, this.tags.getTag(j));
                    out2.println((fk.num < this.extractors.size() ? this.extractors.get(fk.num) : this.extractorsRare.get(fk.num - this.extractors.size())) + " " + fk.val + " " + fk.tag + ": " + nf.format(this.getLambdaSolve().lambda[association]));
                }
            }
        }
    }

    boolean isRare(String word) {
        return this.dict.sum(word) < this.rareWordThresh;
    }

    public String tagTokenizedString(String toTag) {
        ArrayList<Word> sent = SentenceUtils.toUntaggedList(Arrays.asList(toTag.split("\\s+")));
        TestSentence testSentence = new TestSentence(this);
        testSentence.tagSentence(sent, false);
        return testSentence.getTaggedNice();
    }

    public String tagString(String toTag) {
        TaggerWrapper tw = new TaggerWrapper(this);
        return tw.apply(toTag);
    }

    @Override
    public List<TaggedWord> apply(List<? extends HasWord> in) {
        TestSentence testSentence = new TestSentence(this);
        return testSentence.tagSentence(in, false);
    }

    @Override
    public List<List<TaggedWord>> process(List<? extends List<? extends HasWord>> sentences) {
        ArrayList<List<TaggedWord>> taggedSentences = Generics.newArrayList();
        TestSentence testSentence = new TestSentence(this);
        for (List<? extends HasWord> list : sentences) {
            taggedSentences.add(testSentence.tagSentence(list, false));
        }
        return taggedSentences;
    }

    public List<TaggedWord> tagSentence(List<? extends HasWord> sentence) {
        TestSentence testSentence = new TestSentence(this);
        return testSentence.tagSentence(sentence, false);
    }

    public List<TaggedWord> tagSentence(List<? extends HasWord> sentence, boolean reuseTags) {
        TestSentence testSentence = new TestSentence(this);
        return testSentence.tagSentence(sentence, reuseTags);
    }

    public void tagCoreLabels(List<CoreLabel> sentence) {
        this.tagCoreLabels(sentence, false);
    }

    public void tagCoreLabels(List<CoreLabel> sentence, boolean reuseTags) {
        List<TaggedWord> taggedWords = this.tagSentence(sentence, reuseTags);
        if (taggedWords.size() != sentence.size()) {
            throw new AssertionError((Object)"Tagged word list not the same length as the original sentence");
        }
        int size = sentence.size();
        for (int i = 0; i < size; ++i) {
            sentence.get(i).setTag(taggedWords.get(i).tag());
        }
    }

    public static void lemmatize(List<CoreLabel> sentence, Morphology morpha) {
        for (CoreLabel label : sentence) {
            morpha.stem(label);
        }
    }

    private static List<CoreLabel> castCoreLabels(List<? extends HasWord> sent) {
        ArrayList<CoreLabel> coreLabels = Generics.newArrayList();
        for (HasWord hasWord : sent) {
            if (!(hasWord instanceof CoreLabel)) {
                throw new ClassCastException("Expected CoreLabels");
            }
            coreLabels.add((CoreLabel)hasWord);
        }
        return coreLabels;
    }

    public static List<List<HasWord>> tokenizeText(Reader r) {
        return MaxentTagger.tokenizeText(r, null);
    }

    public static List<List<HasWord>> tokenizeText(Reader r, TokenizerFactory<? extends HasWord> tokenizerFactory) {
        DocumentPreprocessor documentPreprocessor = new DocumentPreprocessor(r);
        if (tokenizerFactory != null) {
            documentPreprocessor.setTokenizerFactory(tokenizerFactory);
        }
        ArrayList<List<HasWord>> out2 = Generics.newArrayList();
        for (List<HasWord> item : documentPreprocessor) {
            out2.add(item);
        }
        return out2;
    }

    private static void dumpModel(TaggerConfig config) {
        try {
            MaxentTagger tagger = new MaxentTagger(config.getModel(), (Properties)config, false);
            System.out.println("Serialized tagger built with config:");
            tagger.config.dump(System.out);
            tagger.dumpModel(System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void runTest(TaggerConfig config) {
        if (config.getVerbose()) {
            log.info("## tagger testing invoked at " + new Date() + " with arguments:");
            config.dump();
        }
        try {
            MaxentTagger tagger = new MaxentTagger(config.getModel(), config);
            Timing t = new Timing();
            TestClassifier testClassifier = new TestClassifier(tagger);
            long millis = t.stop();
            MaxentTagger.printErrWordsPerSec(millis, testClassifier.getNumWords());
            testClassifier.printModelAndAccuracy(tagger);
        }
        catch (Exception e) {
            log.info("An error occurred while testing the tagger.");
            e.printStackTrace();
        }
    }

    private static void trainAndSaveModel(TaggerConfig config) throws IOException {
        LambdaSolveTagger prob;
        String modelName = config.getModel();
        MaxentTagger maxentTagger = new MaxentTagger();
        maxentTagger.init(config);
        TaggerExperiments samples = new TaggerExperiments(config, maxentTagger);
        TaggerFeatures feats = samples.getTaggerFeatures();
        byte[][] fnumArr = samples.getFnumArr();
        log.info("Samples from " + config.getFile());
        log.info("Number of features: " + feats.size());
        log.info("Tag set: " + maxentTagger.tags.tagSet());
        Problem p = new Problem(samples, feats);
        maxentTagger.prob = prob = new LambdaSolveTagger(p, 1.0E-4, fnumArr);
        if (config.getSearch().equals("owlqn")) {
            CGRunner runner = new CGRunner(prob, config.getModel(), config.getSigmaSquared());
            runner.solveL1(config.getRegL1());
        } else if (config.getSearch().equals("owlqn2")) {
            CGRunner runner = new CGRunner(prob, config.getModel(), config.getSigmaSquared());
            runner.solveOWLQN2(config.getRegL1());
        } else if (config.getSearch().equals("cg")) {
            CGRunner runner = new CGRunner(prob, config.getModel(), config.getSigmaSquared());
            runner.solveCG();
        } else if (config.getSearch().equals("qn")) {
            CGRunner runner = new CGRunner(prob, config.getModel(), config.getSigmaSquared());
            runner.solveQN();
        } else {
            prob.improvedIterative(config.getIterations());
        }
        if (prob.checkCorrectness()) {
            log.info("Model is correct [empirical expec = model expec]");
        } else {
            log.info("Model is not correct");
        }
        maxentTagger.removeDeadRules();
        maxentTagger.simplifyLambda();
        maxentTagger.saveModel(modelName);
        log.info("Extractors list:");
        log.info(maxentTagger.extractors.toString() + "\nrare" + maxentTagger.extractorsRare.toString());
    }

    private static void runTraining(TaggerConfig config) throws IOException {
        Date now = new Date();
        log.info("## tagger training invoked at " + now + " with arguments:");
        config.dump();
        Timing tim = new Timing();
        PrintFile log = new PrintFile(config.getModel() + ".props");
        log.println("## tagger training invoked at " + now + " with arguments:");
        config.dump(log);
        log.close();
        MaxentTagger.trainAndSaveModel(config);
        tim.done("Training POS tagger");
    }

    private static void printErrWordsPerSec(long milliSec, int numWords) {
        double wordsPerSec = (double)numWords / ((double)milliSec / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        log.info("Tagged " + numWords + " words at " + nf.format(wordsPerSec) + " words per second.");
    }

    private static String getXMLWords(List<? extends HasWord> sentence, int sentNum, boolean outputLemmas) {
        boolean hasCoreLabels = sentence != null && sentence.size() > 0 && sentence.get(0) instanceof CoreLabel;
        StringBuilder sb = new StringBuilder();
        sb.append("<sentence id=\"").append(sentNum).append("\">\n");
        int wordIndex = 0;
        for (HasWord hasWord : sentence) {
            String word = hasWord.word();
            if (!(hasWord instanceof HasTag)) {
                throw new IllegalArgumentException("Expected HasTags, got " + hasWord.getClass());
            }
            String tag = ((HasTag)((Object)hasWord)).tag();
            sb.append("  <word wid=\"").append(wordIndex).append("\" pos=\"").append(XMLUtils.escapeAttributeXML(tag)).append("\"");
            if (outputLemmas && hasCoreLabels) {
                if (!(hasWord instanceof CoreLabel)) {
                    throw new IllegalArgumentException("You mixed CoreLabels with " + hasWord.getClass() + "?  Why would you do that?");
                }
                CoreLabel label = (CoreLabel)hasWord;
                String lemma = label.lemma();
                if (lemma != null) {
                    sb.append(" lemma=\"").append(XMLUtils.escapeElementXML(lemma)).append('\"');
                }
            }
            sb.append(">").append(XMLUtils.escapeElementXML(word)).append("</word>\n");
            ++wordIndex;
        }
        sb.append("</sentence>\n");
        return sb.toString();
    }

    private static String getTsvWords(boolean verbose, boolean outputLemmas, List<? extends HasWord> sentence) {
        StringBuilder sb = new StringBuilder();
        if (verbose && sentence.size() > 0 && sentence.get(0) instanceof CoreLabel) {
            for (HasWord hasWord : sentence) {
                if (!(hasWord instanceof CoreLabel)) {
                    throw new IllegalArgumentException("You mixed CoreLabels with " + hasWord.getClass() + "?  Why would you do that?");
                }
                CoreLabel label = (CoreLabel)hasWord;
                sb.append(label.word());
                sb.append("\t");
                sb.append(label.originalText());
                sb.append("\t");
                if (outputLemmas) {
                    sb.append(label.lemma());
                    sb.append("\t");
                }
                sb.append(label.tag());
                sb.append("\t");
                sb.append(label.beginPosition());
                sb.append("\t");
                sb.append(label.endPosition());
                sb.append("\n");
            }
            sb.append('\n');
            return sb.toString();
        }
        for (HasWord hasWord : sentence) {
            String word = hasWord.word();
            if (!(hasWord instanceof HasTag)) {
                throw new IllegalArgumentException("Expected HasTags, got " + hasWord.getClass());
            }
            String tag = ((HasTag)((Object)hasWord)).tag();
            sb.append(word).append('\t').append(tag).append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    private static void writeXMLSentence(Writer w, List<? extends HasWord> sent, int sentNum, boolean outputLemmas) {
        try {
            w.write(MaxentTagger.getXMLWords(sent, sentNum, outputLemmas));
        }
        catch (IOException e) {
            log.info("Error writing sentence " + sentNum + ": " + SentenceUtils.listToString(sent));
            throw new RuntimeIOException(e);
        }
    }

    public void tagFromXML(InputStream input, Writer writer, String ... xmlTags) {
        PlainTextDocumentReaderAndWriter.OutputStyle outputStyle = PlainTextDocumentReaderAndWriter.OutputStyle.fromShortName(this.config.getOutputFormat());
        TransformXML<String> txml = new TransformXML<String>();
        switch (outputStyle) {
            case XML: 
            case INLINE_XML: {
                txml.transformXML(xmlTags, new TaggerWrapper(this), input, writer, new TransformXML.NoEscapingSAXInterface());
                break;
            }
            case SLASH_TAGS: 
            case TSV: {
                txml.transformXML(xmlTags, new TaggerWrapper(this), input, writer, new TransformXML.SAXInterface());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected format " + (Object)((Object)outputStyle));
            }
        }
    }

    public void tagFromXML(Reader input, Writer writer, String ... xmlTags) {
        PlainTextDocumentReaderAndWriter.OutputStyle outputStyle = PlainTextDocumentReaderAndWriter.OutputStyle.fromShortName(this.config.getOutputFormat());
        TransformXML<String> txml = new TransformXML<String>();
        switch (outputStyle) {
            case XML: 
            case INLINE_XML: {
                txml.transformXML(xmlTags, new TaggerWrapper(this), input, writer, new TransformXML.NoEscapingSAXInterface());
                break;
            }
            case SLASH_TAGS: 
            case TSV: {
                txml.transformXML(xmlTags, new TaggerWrapper(this), input, writer, new TransformXML.SAXInterface());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected format " + (Object)((Object)outputStyle));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void tagFromXML() {
        block7: {
            BufferedReader reader = null;
            BufferedWriter w = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.config.getFile()), this.config.getEncoding()));
                String outFile = this.config.getOutputFile();
                w = outFile.length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), this.config.getEncoding())) : new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, this.config.getEncoding()));
                w.write("<?xml version=\"1.0\" encoding=\"" + this.config.getEncoding() + "\"?>\n");
                this.tagFromXML(reader, (Writer)w, this.config.getXMLInput());
                IOUtils.closeIgnoringExceptions(reader);
            }
            catch (FileNotFoundException e) {
                log.info("Input file not found: " + this.config.getFile());
                e.printStackTrace();
                IOUtils.closeIgnoringExceptions(reader);
                IOUtils.closeIgnoringExceptions(w);
                break block7;
            }
            catch (IOException ioe) {
                log.info("tagFromXML: mysterious IO Exception");
                ioe.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeIgnoringExceptions(reader);
                IOUtils.closeIgnoringExceptions(w);
            }
            IOUtils.closeIgnoringExceptions(w);
        }
    }

    private static void runTagger(TaggerConfig config) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (config.getVerbose()) {
            Date now = new Date();
            log.info("## tagger invoked at " + now + " with arguments:");
            config.dump();
        }
        MaxentTagger tagger = new MaxentTagger(config.getModel(), config);
        tagger.runTagger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTagger() throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        BufferedReader br;
        BufferedWriter writer;
        block6: {
            String[] xmlInput = this.config.getXMLInput();
            if (!(xmlInput.length <= 0 || xmlInput.length <= 1 && xmlInput[0].equals("null"))) {
                this.tagFromXML();
                return;
            }
            writer = null;
            br = null;
            try {
                String outFile = this.config.getOutputFile();
                writer = outFile.length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), this.config.getEncoding())) : new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, this.config.getEncoding()));
                boolean stdin = this.config.useStdin();
                PlainTextDocumentReaderAndWriter.OutputStyle outputStyle = PlainTextDocumentReaderAndWriter.OutputStyle.fromShortName(this.config.getOutputFormat());
                if (!stdin) {
                    String filename = this.config.getFile();
                    if (formatPattern.matcher(filename).find()) {
                        TaggedFileRecord record = TaggedFileRecord.createRecord(this.config, filename);
                        this.runTagger(record.reader(), writer, outputStyle);
                    } else {
                        br = IOUtils.readerFromString(this.config.getFile(), this.config.getEncoding());
                        this.runTagger(br, writer, this.config.getTagInside(), outputStyle);
                    }
                    break block6;
                }
                log.info("Type some text to tag, then EOF.");
                log.info("  (For EOF, use Return, Ctrl-D on Unix; Enter, Ctrl-Z, Enter on Windows.)");
                br = new BufferedReader(new InputStreamReader(System.in));
                this.runTaggerStdin(br, writer, outputStyle);
            }
            catch (Throwable throwable) {
                IOUtils.closeIgnoringExceptions(br);
                IOUtils.closeIgnoringExceptions(writer);
                throw throwable;
            }
        }
        IOUtils.closeIgnoringExceptions(br);
        IOUtils.closeIgnoringExceptions(writer);
    }

    public void runTaggerStdin(BufferedReader reader, BufferedWriter writer, PlainTextDocumentReaderAndWriter.OutputStyle outputStyle) throws IOException {
        String line;
        String sentenceDelimiter;
        Morphology morpha;
        TokenizerFactory<? extends HasWord> tokenizerFactory = this.chooseTokenizerFactory();
        long totalMillis = 0L;
        int numWords = 0;
        int numSentences = 0;
        boolean outputVerbosity = this.config.getOutputVerbosity();
        boolean outputLemmas = this.config.getOutputLemmas();
        Morphology morphology = morpha = outputLemmas ? new Morphology() : null;
        if (outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.XML || outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.INLINE_XML) {
            writer.write("<?xml version=\"1.0\" encoding=\"" + this.config.getEncoding() + "\"?>\n");
            writer.write("<pos>\n");
        }
        if ((sentenceDelimiter = this.config.getSentenceDelimiter()) != null && sentenceDelimiter.equals("newline")) {
            sentenceDelimiter = "\n";
        }
        while ((line = reader.readLine()) != null) {
            DocumentPreprocessor docProcessor = new DocumentPreprocessor(new StringReader(line));
            docProcessor.setTokenizerFactory(tokenizerFactory);
            docProcessor.setSentenceDelimiter(sentenceDelimiter);
            if (this.config.keepEmptySentences()) {
                docProcessor.setKeepEmptySentences(true);
            }
            for (List<HasWord> sentence : docProcessor) {
                numWords += sentence.size();
                Timing t = new Timing();
                this.tagAndOutputSentence(sentence, outputLemmas, morpha, outputStyle, outputVerbosity, numSentences, "", writer);
                totalMillis += t.stop();
                writer.newLine();
                writer.flush();
                ++numSentences;
            }
        }
        if (outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.XML || outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.INLINE_XML) {
            writer.write("</pos>\n");
        }
        writer.flush();
        MaxentTagger.printErrWordsPerSec(totalMillis, numWords);
    }

    public void runTaggerSGML(BufferedReader reader, BufferedWriter writer, PlainTextDocumentReaderAndWriter.OutputStyle outputStyle) throws IOException {
        Timing t = new Timing();
        int numWords = 0;
        int numSentences = 0;
        if (outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.XML || outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.INLINE_XML) {
            writer.write("<?xml version=\"1.0\" encoding=\"" + this.config.getEncoding() + "\"?>\n");
            writer.write("<pos>\n");
        }
        PlainTextDocumentReaderAndWriter readerAndWriter = new PlainTextDocumentReaderAndWriter();
        ObjectBank ob = new ObjectBank(new ReaderIteratorFactory(reader), readerAndWriter);
        PrintWriter pw = new PrintWriter(writer);
        for (List sentence : ob) {
            ArrayList s = Generics.newArrayList();
            numWords += s.size();
            List<TaggedWord> taggedSentence = this.tagSentence(s, false);
            Iterator origIter = sentence.iterator();
            for (TaggedWord tw : taggedSentence) {
                CoreLabel cl = (CoreLabel)origIter.next();
                cl.set(CoreAnnotations.AnswerAnnotation.class, tw.tag());
            }
            readerAndWriter.printAnswers(sentence, pw, outputStyle, true);
            ++numSentences;
        }
        if (outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.XML || outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.INLINE_XML) {
            writer.write("</pos>\n");
        }
        writer.flush();
        long millis = t.stop();
        MaxentTagger.printErrWordsPerSec(millis, numWords);
    }

    public <X extends HasWord> void runTagger(Iterable<List<X>> document, BufferedWriter writer, PlainTextDocumentReaderAndWriter.OutputStyle outputStyle) throws IOException {
        Timing t = new Timing();
        int numWords = 0;
        int numSentences = 0;
        boolean outputVerbosity = this.config.getOutputVerbosity();
        boolean outputLemmas = this.config.getOutputLemmas();
        if (outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.XML || outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.INLINE_XML) {
            writer.write("<?xml version=\"1.0\" encoding=\"" + this.config.getEncoding() + "\"?>\n");
            writer.write("<pos>\n");
        }
        if (this.config.getNThreads() != 1) {
            MulticoreWrapper<List<? extends HasWord>, List<? extends HasWord>> wrapper = new MulticoreWrapper<List<? extends HasWord>, List<? extends HasWord>>(this.config.getNThreads(), new SentenceTaggingProcessor(this, outputLemmas));
            for (List<X> sentence : document) {
                wrapper.put(sentence);
                while (wrapper.peek()) {
                    List<? extends HasWord> taggedSentence = wrapper.poll();
                    numWords += taggedSentence.size();
                    this.outputTaggedSentence(taggedSentence, outputLemmas, outputStyle, outputVerbosity, numSentences, "\n", writer);
                    ++numSentences;
                }
            }
            wrapper.join();
            while (wrapper.peek()) {
                List<? extends HasWord> taggedSentence = wrapper.poll();
                numWords += taggedSentence.size();
                this.outputTaggedSentence(taggedSentence, outputLemmas, outputStyle, outputVerbosity, numSentences, "\n", writer);
                ++numSentences;
            }
        } else {
            Morphology morpha = outputLemmas ? new Morphology() : null;
            for (List<X> sentence : document) {
                numWords += sentence.size();
                this.tagAndOutputSentence(sentence, outputLemmas, morpha, outputStyle, outputVerbosity, numSentences, "\n", writer);
                ++numSentences;
            }
        }
        if (outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.XML || outputStyle == PlainTextDocumentReaderAndWriter.OutputStyle.INLINE_XML) {
            writer.write("</pos>\n");
        }
        writer.flush();
        long millis = t.stop();
        MaxentTagger.printErrWordsPerSec(millis, numWords);
    }

    public void runTagger(BufferedReader reader, BufferedWriter writer, String tagInside, PlainTextDocumentReaderAndWriter.OutputStyle outputStyle) throws IOException {
        DocumentPreprocessor docProcessor;
        String sentenceDelimiter = this.config.getSentenceDelimiter();
        if (sentenceDelimiter != null && sentenceDelimiter.equals("newline")) {
            sentenceDelimiter = "\n";
        }
        TokenizerFactory<? extends HasWord> tokenizerFactory = this.chooseTokenizerFactory();
        if (tagInside.length() > 0) {
            docProcessor = new DocumentPreprocessor(reader, DocumentPreprocessor.DocType.XML);
            docProcessor.setElementDelimiter(tagInside);
            if (this.config.keepEmptySentences()) {
                docProcessor.setKeepEmptySentences(true);
            }
        } else {
            docProcessor = new DocumentPreprocessor(reader);
            docProcessor.setSentenceDelimiter(sentenceDelimiter);
            if (this.config.keepEmptySentences()) {
                docProcessor.setKeepEmptySentences(true);
            }
        }
        docProcessor.setTokenizerFactory(tokenizerFactory);
        this.runTagger(docProcessor, writer, outputStyle);
    }

    public List<? extends HasWord> tagCoreLabelsOrHasWords(List<? extends HasWord> sentence, Morphology morpha, boolean outputLemmas) {
        if (sentence.size() > 0 && sentence.get(0) instanceof CoreLabel) {
            List<CoreLabel> coreLabels = MaxentTagger.castCoreLabels(sentence);
            this.tagCoreLabels(coreLabels);
            if (outputLemmas) {
                if (morpha == null) {
                    morpha = new Morphology();
                }
                MaxentTagger.lemmatize(coreLabels, morpha);
            }
            return coreLabels;
        }
        List<TaggedWord> taggedSentence = this.tagSentence(sentence, false);
        return taggedSentence;
    }

    public void tagAndOutputSentence(List<? extends HasWord> sentence, boolean outputLemmas, Morphology morpha, PlainTextDocumentReaderAndWriter.OutputStyle outputStyle, boolean outputVerbosity, int numSentences, String separator, Writer writer) {
        sentence = this.tagCoreLabelsOrHasWords(sentence, morpha, outputLemmas);
        this.outputTaggedSentence(sentence, outputLemmas, outputStyle, outputVerbosity, numSentences, separator, writer);
    }

    public void outputTaggedSentence(List<? extends HasWord> sentence, boolean outputLemmas, PlainTextDocumentReaderAndWriter.OutputStyle outputStyle, boolean outputVerbosity, int numSentences, String separator, Writer writer) {
        try {
            switch (outputStyle) {
                case TSV: {
                    writer.write(MaxentTagger.getTsvWords(outputVerbosity, outputLemmas, sentence));
                    break;
                }
                case XML: 
                case INLINE_XML: {
                    MaxentTagger.writeXMLSentence(writer, sentence, numSentences, outputLemmas);
                    break;
                }
                case SLASH_TAGS: {
                    writer.write(SentenceUtils.listToString(sentence, false, this.config.getTagSeparator()));
                    writer.write(separator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported output style " + (Object)((Object)outputStyle));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        TaggerConfig config = new TaggerConfig(args);
        if (config.getMode() == TaggerConfig.Mode.TRAIN) {
            MaxentTagger.runTraining(config);
        } else if (config.getMode() == TaggerConfig.Mode.TAG) {
            MaxentTagger.runTagger(config);
        } else if (config.getMode() == TaggerConfig.Mode.TEST) {
            MaxentTagger.runTest(config);
        } else if (config.getMode() == TaggerConfig.Mode.DUMP) {
            MaxentTagger.dumpModel(config);
        } else {
            log.info("Impossible: nothing to do. None of train, tag, test, or dump was specified.");
        }
    }

    static class SentenceTaggingProcessor
    implements ThreadsafeProcessor<List<? extends HasWord>, List<? extends HasWord>> {
        MaxentTagger maxentTagger;
        boolean outputLemmas;

        SentenceTaggingProcessor(MaxentTagger maxentTagger, boolean outputLemmas) {
            this.maxentTagger = maxentTagger;
            this.outputLemmas = outputLemmas;
        }

        @Override
        public List<? extends HasWord> process(List<? extends HasWord> sentence) {
            return this.maxentTagger.tagCoreLabelsOrHasWords(sentence, null, this.outputLemmas);
        }

        @Override
        public ThreadsafeProcessor<List<? extends HasWord>, List<? extends HasWord>> newInstance() {
            return this;
        }
    }

    static class TaggerWrapper
    implements Function<String, String> {
        private final TaggerConfig config;
        private final MaxentTagger tagger;
        private TokenizerFactory<? extends HasWord> tokenizerFactory;
        private int sentNum;
        private final boolean tokenize;
        private final boolean outputVerbosity;
        private final boolean outputLemmas;
        private final PlainTextDocumentReaderAndWriter.OutputStyle outputStyle;
        private final Morphology morpha;

        protected TaggerWrapper(MaxentTagger tagger) {
            this.tagger = tagger;
            this.config = tagger.config;
            try {
                this.tokenizerFactory = MaxentTagger.chooseTokenizerFactory(this.config.getTokenize(), this.config.getTokenizerFactory(), this.config.getTokenizerOptions(), this.config.getTokenizerInvertible());
            }
            catch (Exception e) {
                log.info("Error in tokenizer factory instantiation for class: " + this.config.getTokenizerFactory());
                e.printStackTrace();
                this.tokenizerFactory = PTBTokenizer.PTBTokenizerFactory.newWordTokenizerFactory(this.config.getTokenizerOptions());
            }
            this.outputStyle = PlainTextDocumentReaderAndWriter.OutputStyle.fromShortName(this.config.getOutputFormat());
            this.outputVerbosity = this.config.getOutputVerbosity();
            this.outputLemmas = this.config.getOutputLemmas();
            this.morpha = this.outputLemmas ? new Morphology() : null;
            this.tokenize = this.config.getTokenize();
        }

        @Override
        public String apply(String o) {
            List<Object> sentences;
            StringWriter taggedResults = new StringWriter();
            if (this.tokenize) {
                sentences = MaxentTagger.tokenizeText(new StringReader(o), this.tokenizerFactory);
            } else {
                sentences = Generics.newArrayList();
                sentences.add(SentenceUtils.toWordList(o.split("\\s+")));
            }
            if (this.config.getNThreads() != 1) {
                MulticoreWrapper<List<? extends HasWord>, List<? extends HasWord>> wrapper = new MulticoreWrapper<List<? extends HasWord>, List<? extends HasWord>>(this.config.getNThreads(), new SentenceTaggingProcessor(this.tagger, this.outputLemmas));
                for (List list : sentences) {
                    wrapper.put(list);
                    while (wrapper.peek()) {
                        List<? extends HasWord> taggedSentence = wrapper.poll();
                        this.tagger.outputTaggedSentence(taggedSentence, this.outputLemmas, this.outputStyle, this.outputVerbosity, this.sentNum++, " ", taggedResults);
                    }
                }
                wrapper.join();
                while (wrapper.peek()) {
                    List<? extends HasWord> list = wrapper.poll();
                    this.tagger.outputTaggedSentence(list, this.outputLemmas, this.outputStyle, this.outputVerbosity, this.sentNum++, " ", taggedResults);
                }
            } else {
                for (List list : sentences) {
                    List<? extends HasWord> list2 = this.tagger.tagCoreLabelsOrHasWords(list, this.morpha, this.outputLemmas);
                    this.tagger.outputTaggedSentence(list2, this.outputLemmas, this.outputStyle, this.outputVerbosity, this.sentNum++, " ", taggedResults);
                }
            }
            return taggedResults.toString();
        }
    }
}

