/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import java.util.ArrayList;
import java.util.List;

class DependencyTree {
    int n;
    final List<Integer> head;
    final List<String> label;
    private int counter;

    public DependencyTree() {
        this.n = 0;
        this.head = new ArrayList<Integer>();
        this.head.add(-1);
        this.label = new ArrayList<String>();
        this.label.add("-UNKNOWN-");
    }

    public DependencyTree(DependencyTree tree) {
        this.n = tree.n;
        this.head = new ArrayList<Integer>(tree.head);
        this.label = new ArrayList<String>(tree.label);
    }

    public void add(int h, String l) {
        ++this.n;
        this.head.add(h);
        this.label.add(l);
    }

    public void set(int k, int h, String l) {
        this.head.set(k, h);
        this.label.set(k, l);
    }

    public int getHead(int k) {
        if (k <= 0 || k > this.n) {
            return -1;
        }
        return this.head.get(k);
    }

    public String getLabel(int k) {
        if (k <= 0 || k > this.n) {
            return "-NULL-";
        }
        return this.label.get(k);
    }

    public int getRoot() {
        for (int k = 1; k <= this.n; ++k) {
            if (this.getHead(k) != 0) continue;
            return k;
        }
        return 0;
    }

    public boolean isSingleRoot() {
        int roots = 0;
        for (int k = 1; k <= this.n; ++k) {
            if (this.getHead(k) != 0) continue;
            ++roots;
        }
        return roots == 1;
    }

    public boolean isTree() {
        int i;
        ArrayList<Integer> h = new ArrayList<Integer>();
        h.add(-1);
        for (i = 1; i <= this.n; ++i) {
            if (this.getHead(i) < 0 || this.getHead(i) > this.n) {
                return false;
            }
            h.add(-1);
        }
        for (i = 1; i <= this.n; ++i) {
            int k = i;
            while (k > 0 && ((Integer)h.get(k) < 0 || (Integer)h.get(k) >= i)) {
                if ((Integer)h.get(k) == i) {
                    return false;
                }
                h.set(k, i);
                k = this.getHead(k);
            }
        }
        return true;
    }

    public boolean isProjective() {
        if (!this.isTree()) {
            return false;
        }
        this.counter = -1;
        return this.visitTree(0);
    }

    private boolean visitTree(int w) {
        int i;
        for (i = 1; i < w; ++i) {
            if (this.getHead(i) != w || this.visitTree(i)) continue;
            return false;
        }
        ++this.counter;
        if (w != this.counter) {
            return false;
        }
        for (i = w + 1; i <= this.n; ++i) {
            if (this.getHead(i) != w || this.visitTree(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equal(DependencyTree t) {
        if (t.n != this.n) {
            return false;
        }
        for (int i = 1; i <= this.n; ++i) {
            if (this.getHead(i) != t.getHead(i)) {
                return false;
            }
            if (this.getLabel(i).equals(t.getLabel(i))) continue;
            return false;
        }
        return true;
    }

    public void print() {
        for (int i = 1; i <= this.n; ++i) {
            System.out.println(i + " " + this.getHead(i) + " " + this.getLabel(i));
        }
        System.out.println();
    }
}

