/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.parser.lexparser.TregexPoweredTreebankParserParams;
import edu.stanford.nlp.process.SerializableFunction;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.spanish.SpanishHeadFinder;
import edu.stanford.nlp.trees.international.spanish.SpanishTreeReaderFactory;
import edu.stanford.nlp.trees.international.spanish.SpanishTreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.List;

public class SpanishTreebankParserParams
extends TregexPoweredTreebankParserParams {
    private static Redwood.RedwoodChannels log = Redwood.channels(SpanishTreebankParserParams.class);
    private static final long serialVersionUID = -8734165273482119424L;
    private final StringBuilder optionsString;
    private HeadFinder headFinder;
    private static final String PODER_FORM = "(?iu)^(?:pued(?:o|[ea][sn]?)|pod(?:e[dr]|ido|[ea]mos|[\u00e9\u00e1]is|r(?:\u00e9(?:is)?|\u00e1[sn]?|emos)|r?\u00eda(?:s|mos|is|n)?)|pud(?:[eo]|i(?:ste(?:is)?|mos|eron|er[ea](?:[sn]|is)?|\u00e9r[ea]mos|endo)))$";
    private static final String HACER_TIME_FORM = "(?iu)^(?:hac(?:er|\u00eda))$";

    public SpanishTreebankParserParams() {
        super(new SpanishTreebankLanguagePack());
        this.setInputEncoding(this.treebankLanguagePack().getEncoding());
        this.setHeadFinder(new SpanishHeadFinder());
        this.optionsString = new StringBuilder();
        this.optionsString.append(this.getClass().getSimpleName() + "\n");
        this.buildAnnotations();
    }

    private void buildAnnotations() {
        this.annotations.put("-markInf", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("/^(S|grup\\.verb|infinitiu|gerundi)/ < @infinitiu", new TregexPoweredTreebankParserParams.SimpleStringFunction("-infinitive")));
        this.annotations.put("-markGer", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("/^(S|grup\\.verb|infinitiu|gerundi)/ < @gerundi", new TregexPoweredTreebankParserParams.SimpleStringFunction("-gerund")));
        this.annotations.put("-markRelative", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@S <, @relatiu", new TregexPoweredTreebankParserParams.SimpleStringFunction("-relative")));
        this.annotations.put("-markPPHeads", new Pair<String, TregexPoweredTreebankParserParams.AnnotateHeadFunction>("@sp", new TregexPoweredTreebankParserParams.AnnotateHeadFunction(this.headFinder)));
        this.annotations.put("-markComo", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@cs < /(?iu)^como$/", new TregexPoweredTreebankParserParams.SimpleStringFunction("[como]")));
        this.annotations.put("-markSpecHeads", new Pair<String, TregexPoweredTreebankParserParams.AnnotateHeadFunction>("@spec", new TregexPoweredTreebankParserParams.AnnotateHeadFunction(this.headFinder)));
        this.annotations.put("-markSingleChildNPs", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("/^(sn|grup\\.nom)/ <: __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-singleChild")));
        this.annotations.put("-markPPFriendlyVerbs", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("/^v/ > /^grup\\.prep/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-PPFriendly")));
        this.annotations.put("-markConjTypes", new Pair<String, MarkConjTypeFunction>("@conj <: /^c[cs]/=c", new MarkConjTypeFunction()));
        this.annotations.put("-markPronounNPs", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("/^(sn|grup\\.nom)/ <<: /^p[0p]/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-pronoun")));
        this.annotations.put("-markParticipleAdjs", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@aq0000 < /(?iu)([aei\u00ed]d|puest|biert|vist|(ben|mal)dit|[fh]ech|scrit|muert|[sv]uelt|[rl]ect|frit|^(rot|dich|impres|desnud|sujet|exent))[oa]s?$/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-part")));
        this.annotations.put("-markSentenceInitialClauses", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@S !, __", new TregexPoweredTreebankParserParams.SimpleStringFunction("-init")));
        this.annotations.put("-markPoder", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>(String.format("/^(infinitiu|gerundi|grup\\.verb)/ <<: /%s/", PODER_FORM), new TregexPoweredTreebankParserParams.SimpleStringFunction("-poder")));
        this.annotations.put("-markBaseNPs", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("/^grup\\.nom/ !< (__ < (__ < __))", new TregexPoweredTreebankParserParams.SimpleStringFunction("-base")));
        this.annotations.put("-markVerbless", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@S|sentence !<< /^(v|participi$)/", new TregexPoweredTreebankParserParams.SimpleStringFunction("-verbless")));
        this.annotations.put("-markDominatesVerb", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("__ << (/^(v|participi$)/ < __)", new TregexPoweredTreebankParserParams.SimpleStringFunction("-dominatesV")));
        this.annotations.put("-markNonRecSPs", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@sp !<< @sp", new TregexPoweredTreebankParserParams.SimpleStringFunction("-nonRec")));
        this.annotations.put("-markRightRecVPPrefixes", new Pair<String, MarkPrefixFunction>("/^v/ $+ @infinitiu|gerundi >, /^(grup.verb|infinitiu|gerundi)/", new MarkPrefixFunction(3)));
        this.annotations.put("-markParentheticalNPs", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@sn <<, fpa <<` fpt", new TregexPoweredTreebankParserParams.SimpleStringFunction("-paren")));
        this.annotations.put("-markNumericNPs", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@sn << (/^z/ < __) !<< @sn", new TregexPoweredTreebankParserParams.SimpleStringFunction("-num")));
        this.annotations.put("-markCoordinatedNPs", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>("@sn <, (/^(sn|grup\\.nom)/ $+ (@conj < /^(cc|grup\\.cc)/ $+ /^(sn|grup\\.nom)/=last))<` =last", new TregexPoweredTreebankParserParams.SimpleStringFunction("-coord")));
        this.annotations.put("-markHacerTime", new Pair<String, TregexPoweredTreebankParserParams.SimpleStringFunction>(String.format("/^vm/ < /%s/ $+ /^d/", HACER_TIME_FORM), new TregexPoweredTreebankParserParams.SimpleStringFunction("-hacerTime")));
        this.compileAnnotations(this.headFinder);
    }

    @Override
    protected String[] baselineAnnotationFeatures() {
        return new String[]{"-markInf", "-markGer", "-markRightRecVPPrefixes", "-markSingleChildNPs", "-markBaseNPs", "-markPronounNPs", "-markRelative", "-markComo", "-markSpecHeads", "-markPPFriendlyVerbs", "-markParticipleAdjs", "-markHacerTime", "-markConjTypes", "-markVerbless", "-markDominatesVerb"};
    }

    @Override
    public HeadFinder headFinder() {
        return this.headFinder;
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return null;
    }

    @Override
    public Lexicon lex(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        if (op.lexOptions.uwModelTrainer == null) {
            op.lexOptions.uwModelTrainer = "edu.stanford.nlp.parser.lexparser.SpanishUnknownWordModelTrainer";
        }
        return new BaseLexicon(op, wordIndex, tagIndex);
    }

    @Override
    public String[] sisterSplitters() {
        return new String[0];
    }

    @Override
    public TreeTransformer collinizer() {
        return new TreeCollinizer(this.treebankLanguagePack());
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return new TreeCollinizer(this.treebankLanguagePack());
    }

    @Override
    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory(), this.inputEncoding);
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory(), this.inputEncoding);
    }

    @Override
    public int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-headFinder") && i + 1 < args.length) {
            try {
                HeadFinder hf = (HeadFinder)Class.forName(args[i + 1]).newInstance();
                this.setHeadFinder(hf);
                this.optionsString.append("HeadFinder: " + args[i + 1] + "\n");
            }
            catch (Exception e) {
                log.info(e);
                log.info(this.getClass().getName() + ": Could not load head finder " + args[i + 1]);
            }
            i += 2;
        }
        return i;
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return new SpanishTreeReaderFactory();
    }

    public List<HasWord> defaultTestSentence() {
        String[] sent = new String[]{"\u00c9sto", "es", "s\u00f3lo", "una", "prueba", "."};
        return SentenceUtils.toWordList(sent);
    }

    @Override
    public void display() {
        log.info(this.optionsString.toString());
        super.display();
    }

    public void setHeadFinder(HeadFinder hf) {
        this.headFinder = hf;
        this.compileAnnotations(this.headFinder);
    }

    private static class MarkPrefixFunction
    implements SerializableFunction<TregexMatcher, String> {
        private static final long serialVersionUID = -3275700521562916350L;
        private static final int DEFAULT_PREFIX_LENGTH = 3;
        private final int prefixLength;

        public MarkPrefixFunction() {
            this(3);
        }

        public MarkPrefixFunction(int prefixLength) {
            this.prefixLength = prefixLength;
        }

        @Override
        public String apply(TregexMatcher m) {
            Tree tagNode = m.getMatch();
            String yield = tagNode.firstChild().value();
            String prefix = yield.substring(0, Math.min(yield.length(), this.prefixLength));
            return "[p," + prefix + ']';
        }
    }

    private static class MarkConjTypeFunction
    implements SerializableFunction<TregexMatcher, String> {
        private static final long serialVersionUID = 403406212736445856L;

        private MarkConjTypeFunction() {
        }

        @Override
        public String apply(TregexMatcher m) {
            String type = m.getNode("c").value().toUpperCase();
            return "-conj" + type;
        }
    }
}

