/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.ListInstances;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.TaggerExperiments;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Map;

public class TemplateHash {
    private static Redwood.RedwoodChannels log = Redwood.channels(TemplateHash.class);
    private final Map<Pair<Integer, String>, ListInstances> tempHash = Generics.newHashMap();
    private final MaxentTagger maxentTagger;

    public TemplateHash(MaxentTagger maxentTagger) {
        this.maxentTagger = maxentTagger;
    }

    protected void addPositions(int start, int end, FeatureKey fK) {
        Pair<Integer, String> key = new Pair<Integer, String>(fK.num, fK.val);
        this.tempHash.get(key).addPositions(start, end);
    }

    protected int[] getPositions(FeatureKey s) {
        Pair<Integer, String> p = new Pair<Integer, String>(s.num, s.val);
        return this.tempHash.get(p).getPositions();
    }

    protected void release() {
        this.tempHash.clear();
    }

    protected void add(int nFeatFrame, History history, int number) {
        int general = this.maxentTagger.extractors.size();
        Pair<Integer, String> wT = nFeatFrame < general ? new Pair<Integer, String>(nFeatFrame, this.maxentTagger.extractors.extract(nFeatFrame, history)) : new Pair<Integer, String>(nFeatFrame, this.maxentTagger.extractorsRare.extract(nFeatFrame - general, history));
        if (this.tempHash.containsKey(wT)) {
            ListInstances li = this.tempHash.get(wT);
            if (TaggerExperiments.isPopulated(nFeatFrame, li.getNum(), this.maxentTagger)) {
                li.add(number);
            }
        } else {
            ListInstances li = new ListInstances();
            li.add(number);
            this.tempHash.put(wT, li);
        }
    }

    protected void addPrev(int nFeatFrame, History history) {
        int general = this.maxentTagger.extractors.size();
        Pair<Integer, String> wT = nFeatFrame < general ? new Pair<Integer, String>(nFeatFrame, this.maxentTagger.extractors.extract(nFeatFrame, history)) : new Pair<Integer, String>(nFeatFrame, this.maxentTagger.extractorsRare.extract(nFeatFrame - general, history));
        if (this.tempHash.containsKey(wT)) {
            this.tempHash.get(wT).inc();
        } else {
            ListInstances li = new ListInstances();
            li.inc();
            this.tempHash.put(wT, li);
        }
    }

    protected int[] getXValues(Pair<Integer, String> key) {
        if (this.tempHash.containsKey(key)) {
            return this.tempHash.get(key).getInstances();
        }
        return null;
    }
}

