/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import java.io.Serializable;

public class Extractor
implements Serializable {
    private static final long serialVersionUID = -4694133872973560083L;
    static final String zeroSt = "0";
    final int position;
    private final boolean isTag;
    public static final Extractor[] EMPTY_EXTRACTOR_ARRAY = new Extractor[0];

    public Extractor() {
        this(Integer.MAX_VALUE, false);
    }

    protected Extractor(int position, boolean isTag) {
        this.position = position;
        this.isTag = isTag;
    }

    protected void setGlobalHolder(MaxentTagger tagger) {
    }

    public boolean precondition(String tag) {
        return true;
    }

    public int leftContext() {
        if (this.isTag && this.position < 0) {
            return -this.position;
        }
        return 0;
    }

    public int rightContext() {
        if (this.isTag && this.position > 0) {
            return this.position;
        }
        return 0;
    }

    final String extract(History h) {
        return this.extract(h, h.pairs);
    }

    public boolean isDynamic() {
        return this.isTag;
    }

    public boolean isLocal() {
        return !this.isTag && this.position == 0;
    }

    String extract(History h, PairsHolder pH) {
        return this.isTag ? pH.getTag(h, this.position) : pH.getWord(h, this.position);
    }

    String extractLV(History h, PairsHolder pH) {
        int start = h.start;
        String lastverb = "NA";
        int current = h.current;
        for (int index = current - 1; index >= start; --index) {
            String tag = pH.getTag(index);
            if (tag.startsWith("VB")) {
                lastverb = pH.getWord(index);
                break;
            }
            if (tag.startsWith(",")) break;
        }
        return lastverb;
    }

    String extractLV(History h, PairsHolder pH, int bound) {
        int start = h.start;
        String lastverb = "NA";
        int current = h.current;
        for (int index = current - 1; index >= start && index >= current - bound; --index) {
            String tag = pH.getTag(index);
            if (tag.startsWith("VB")) {
                lastverb = pH.getWord(index);
                break;
            }
            if (tag.startsWith(",")) break;
        }
        return lastverb;
    }

    String extract(History h, PairsHolder pH, int bound) {
        return this.extract(h, pH);
    }

    public String toString() {
        String cl = this.getClass().getName();
        int ind = cl.lastIndexOf(46);
        String args = this.position == Integer.MAX_VALUE ? "" : this.position + "," + (this.isTag ? "tag" : "word");
        return cl.substring(ind + 1) + '(' + args + ')';
    }

    static String getParenthesizedArg(String str, int num) {
        String[] args = str.split("\\s*[,()]\\s*");
        if (args.length <= num) {
            return null;
        }
        return args[num];
    }

    static int getParenthesizedNum(String str, int num) {
        String[] args = str.split("\\s*[,()]\\s*");
        int ans = 0;
        try {
            ans = Integer.parseInt(args[num]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return ans;
    }
}

