/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.ArraySet;
import java.util.Collections;
import java.util.Set;

public interface Annotator {
    public static final String STANFORD_TOKENIZE = "tokenize";
    public static final String STANFORD_CLEAN_XML = "cleanxml";
    public static final String STANFORD_SSPLIT = "ssplit";
    public static final String STANFORD_POS = "pos";
    public static final String STANFORD_LEMMA = "lemma";
    public static final String STANFORD_NER = "ner";
    public static final String STANFORD_REGEXNER = "regexner";
    public static final String STANFORD_ENTITY_MENTIONS = "entitymentions";
    public static final String STANFORD_GENDER = "gender";
    public static final String STANFORD_TRUECASE = "truecase";
    public static final String STANFORD_PARSE = "parse";
    public static final String STANFORD_DETERMINISTIC_COREF = "dcoref";
    public static final String STANFORD_COREF = "hcoref";
    public static final String STANFORD_RELATION = "relation";
    public static final String STANFORD_SENTIMENT = "sentiment";
    public static final String STANFORD_COLUMN_DATA_CLASSIFIER = "cdc";
    public static final String STANFORD_DEPENDENCIES = "depparse";
    public static final String STANFORD_NATLOG = "natlog";
    public static final String STANFORD_QUOTE = "quote";
    public static final Requirement TOKENIZE_REQUIREMENT = new Requirement("tokenize");
    public static final Requirement CLEAN_XML_REQUIREMENT = new Requirement("cleanxml");
    public static final Requirement SSPLIT_REQUIREMENT = new Requirement("ssplit");
    public static final Requirement POS_REQUIREMENT = new Requirement("pos");
    public static final Requirement LEMMA_REQUIREMENT = new Requirement("lemma");
    public static final Requirement NER_REQUIREMENT = new Requirement("ner");
    public static final Requirement GENDER_REQUIREMENT = new Requirement("gender");
    public static final Requirement TRUECASE_REQUIREMENT = new Requirement("truecase");
    public static final Requirement PARSE_REQUIREMENT = new Requirement("parse");
    public static final Requirement DEPENDENCY_REQUIREMENT = new Requirement("depparse");
    public static final Requirement DETERMINISTIC_COREF_REQUIREMENT = new Requirement("dcoref");
    public static final Requirement COREF_REQUIREMENT = new Requirement("hcoref");
    public static final Requirement RELATION_EXTRACTOR_REQUIREMENT = new Requirement("relation");
    public static final Requirement NATLOG_REQUIREMENT = new Requirement("natlog");
    public static final Requirement QUOTE_REQUIREMENT = new Requirement("quote");
    public static final Requirement GUTIME_REQUIREMENT = new Requirement("gutime");
    public static final Requirement SUTIME_REQUIREMENT = new Requirement("sutime");
    public static final Requirement HEIDELTIME_REQUIREMENT = new Requirement("heideltime");
    public static final Requirement STEM_REQUIREMENT = new Requirement("stem");
    public static final Requirement NUMBER_REQUIREMENT = new Requirement("number");
    public static final Requirement TIME_WORDS_REQUIREMENT = new Requirement("timewords");
    public static final Requirement QUANTIFIABLE_ENTITY_NORMALIZATION_REQUIREMENT = new Requirement("quantifiable_entity_normalization");
    public static final Requirement COLUMN_DATA_CLASSIFIER = new Requirement("column_data_classifer");
    public static final Requirement BINARIZED_TREES_REQUIREMENT = new Requirement("binarized_trees");
    public static final Set<Requirement> TOKENIZE_AND_SSPLIT = Collections.unmodifiableSet(new ArraySet<Requirement>(TOKENIZE_REQUIREMENT, SSPLIT_REQUIREMENT));
    public static final Set<Requirement> TOKENIZE_SSPLIT_POS = Collections.unmodifiableSet(new ArraySet<Requirement>(TOKENIZE_REQUIREMENT, SSPLIT_REQUIREMENT, POS_REQUIREMENT));
    public static final Set<Requirement> TOKENIZE_SSPLIT_NER = Collections.unmodifiableSet(new ArraySet<Requirement>(TOKENIZE_REQUIREMENT, SSPLIT_REQUIREMENT, NER_REQUIREMENT));
    public static final Set<Requirement> TOKENIZE_SSPLIT_PARSE = Collections.unmodifiableSet(new ArraySet<Requirement>(TOKENIZE_REQUIREMENT, SSPLIT_REQUIREMENT, PARSE_REQUIREMENT));
    public static final Set<Requirement> TOKENIZE_SSPLIT_PARSE_NER = Collections.unmodifiableSet(new ArraySet<Requirement>(TOKENIZE_REQUIREMENT, SSPLIT_REQUIREMENT, PARSE_REQUIREMENT, NER_REQUIREMENT));
    public static final Set<Requirement> TOKENIZE_SSPLIT_POS_LEMMA = Collections.unmodifiableSet(new ArraySet<Requirement>(TOKENIZE_REQUIREMENT, SSPLIT_REQUIREMENT, POS_REQUIREMENT, LEMMA_REQUIREMENT));
    public static final Set<Requirement> PARSE_AND_TAG = Collections.unmodifiableSet(new ArraySet<Requirement>(POS_REQUIREMENT, PARSE_REQUIREMENT));
    public static final Set<Requirement> PARSE_TAG_BINARIZED_TREES = Collections.unmodifiableSet(new ArraySet<Requirement>(POS_REQUIREMENT, PARSE_REQUIREMENT, BINARIZED_TREES_REQUIREMENT));

    public void annotate(Annotation var1);

    public Set<Requirement> requirementsSatisfied();

    public Set<Requirement> requires();

    public static class Requirement {
        private final String name;

        public Requirement(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

