/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.ner.CMMClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassifierCombiner<IN extends CoreMap & HasWord>
extends AbstractSequenceClassifier<IN> {
    private static final boolean DEBUG = false;
    private List<AbstractSequenceClassifier<IN>> baseClassifiers;
    static final CombinationMode DEFAULT_COMBINATION_MODE = CombinationMode.NORMAL;
    static final String COMBINATION_MODE_PROPERTY = "ner.combinationMode";
    final CombinationMode combinationMode;
    public Properties initProps;
    private List<String> initLoadPaths = new ArrayList<String>();

    public ClassifierCombiner(Properties p) throws IOException {
        super(p);
        String loadPath2;
        this.combinationMode = ClassifierCombiner.extractCombinationModeSafe(p);
        ArrayList<String> paths = new ArrayList<String>();
        String loadPath1 = p.getProperty("loadClassifier1");
        if (loadPath1 != null && (loadPath2 = p.getProperty("loadClassifier2")) != null) {
            paths.add(loadPath1);
            paths.add(loadPath2);
            for (int i = 3; i <= 10; ++i) {
                String path = p.getProperty("loadClassifier" + i);
                if (path == null) continue;
                paths.add(path);
            }
            this.loadClassifiers(paths);
        } else {
            loadPath1 = p.getProperty("loadClassifier");
            if (loadPath1 != null && (loadPath2 = p.getProperty("loadAuxClassifier")) != null) {
                paths.add(loadPath1);
                paths.add(loadPath2);
                this.loadClassifiers(paths);
            } else {
                paths.add("edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz");
                paths.add("edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz");
                this.loadClassifiers(paths);
            }
        }
        this.initLoadPaths = new ArrayList<String>(paths);
        this.initProps = p;
    }

    public ClassifierCombiner(Properties props, CombinationMode combinationMode, String ... loadPaths) throws IOException {
        super(props);
        this.combinationMode = combinationMode;
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(loadPaths));
        this.loadClassifiers(paths);
        this.initLoadPaths = new ArrayList<String>(paths);
        this.initProps = props;
    }

    public ClassifierCombiner(CombinationMode combinationMode, String ... loadPaths) throws IOException {
        this(new Properties(), combinationMode, loadPaths);
    }

    public ClassifierCombiner(String ... loadPaths) throws IOException {
        this(DEFAULT_COMBINATION_MODE, loadPaths);
    }

    @SafeVarargs
    public ClassifierCombiner(AbstractSequenceClassifier<IN> ... classifiers) {
        super(new Properties());
        this.combinationMode = DEFAULT_COMBINATION_MODE;
        this.baseClassifiers = new ArrayList<AbstractSequenceClassifier<IN>>(Arrays.asList(classifiers));
        this.flags.backgroundSymbol = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
        this.initProps = new Properties();
    }

    public ClassifierCombiner(ObjectInputStream ois, Properties props) throws IOException, ClassNotFoundException, ClassCastException {
        super(PropertiesUtils.overWriteProperties((Properties)ois.readObject(), props));
        CombinationMode newCM;
        this.initProps = PropertiesUtils.overWriteProperties((Properties)ois.readObject(), props);
        this.initLoadPaths = (ArrayList)ois.readObject();
        String cm = (String)ois.readObject();
        if (props.getProperty(COMBINATION_MODE_PROPERTY) != null) {
            try {
                newCM = CombinationMode.valueOf(props.getProperty(COMBINATION_MODE_PROPERTY));
            }
            catch (IllegalArgumentException e) {
                newCM = CombinationMode.valueOf(cm);
            }
        } else {
            newCM = CombinationMode.valueOf(cm);
        }
        this.combinationMode = newCM;
        Integer numClassifiers = ois.readInt();
        this.baseClassifiers = new ArrayList<AbstractSequenceClassifier<IN>>();
        int i = 0;
        while (i < numClassifiers) {
            try {
                System.err.println("loading CRF...");
                CRFClassifier newCRF = (CRFClassifier)ErasureUtils.uncheckedCast(CRFClassifier.getClassifier(ois));
                this.baseClassifiers.add(newCRF);
                ++i;
            }
            catch (Exception e) {
                try {
                    System.err.println("loading CMM...");
                    CMMClassifier newCMM = (CMMClassifier)ErasureUtils.uncheckedCast(CMMClassifier.getClassifier(ois));
                    this.baseClassifiers.add(newCMM);
                    ++i;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new IOException("Couldn't load classifier!");
                }
            }
        }
    }

    public static CombinationMode extractCombinationMode(Properties p) {
        String mode = p.getProperty(COMBINATION_MODE_PROPERTY);
        if (mode == null) {
            return DEFAULT_COMBINATION_MODE;
        }
        return CombinationMode.valueOf(mode.toUpperCase());
    }

    public static CombinationMode extractCombinationModeSafe(Properties p) {
        try {
            return ClassifierCombiner.extractCombinationMode(p);
        }
        catch (IllegalArgumentException e) {
            System.err.print("Illegal value of ner.combinationMode: " + p.getProperty(COMBINATION_MODE_PROPERTY));
            System.err.print("  Legal values:");
            for (CombinationMode mode : CombinationMode.values()) {
                System.err.print("  " + (Object)((Object)mode));
            }
            System.err.println();
            return CombinationMode.NORMAL;
        }
    }

    private void loadClassifiers(List<String> paths) throws IOException {
        this.baseClassifiers = new ArrayList<AbstractSequenceClassifier<IN>>();
        for (String path : paths) {
            AbstractSequenceClassifier cls = ClassifierCombiner.loadClassifierFromPath(path);
            this.baseClassifiers.add(cls);
        }
        if (this.baseClassifiers.size() > 0) {
            this.flags.backgroundSymbol = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
        }
    }

    public static <INN extends CoreMap & HasWord> AbstractSequenceClassifier<INN> loadClassifierFromPath(String path) throws IOException {
        try {
            return (AbstractSequenceClassifier)ErasureUtils.uncheckedCast(CRFClassifier.getClassifier(path));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                return (AbstractSequenceClassifier)ErasureUtils.uncheckedCast(CMMClassifier.getClassifier(path));
            }
            catch (Exception e2) {
                throw new IOException("Couldn't load classifier from " + path, e2);
            }
        }
    }

    @Override
    public Set<String> labels() {
        Set<String> labs = Generics.newHashSet();
        for (AbstractSequenceClassifier<IN> cls : this.baseClassifiers) {
            labs.addAll(cls.labels());
        }
        return labs;
    }

    private List<IN> mergeDocuments(List<List<IN>> baseDocuments) {
        assert (!this.baseClassifiers.isEmpty() && !baseDocuments.isEmpty());
        for (int i = 1; i < baseDocuments.size(); ++i) {
            assert (baseDocuments.get(0).size() == baseDocuments.get(i).size());
        }
        String background = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
        ArrayList<Set<String>> baseLabels = new ArrayList<Set<String>>();
        Set<String> seenLabels = Generics.newHashSet();
        for (AbstractSequenceClassifier<IN> baseClassifier : this.baseClassifiers) {
            Set<String> labs = baseClassifier.labels();
            if (this.combinationMode != CombinationMode.HIGH_RECALL) {
                labs.removeAll(seenLabels);
            } else {
                labs.remove(baseClassifier.flags.backgroundSymbol);
                labs.remove(background);
            }
            seenLabels.addAll(labs);
            baseLabels.add(labs);
        }
        List<IN> mainDocument = baseDocuments.get(0);
        for (int i = 1; i < baseDocuments.size(); ++i) {
            ClassifierCombiner.mergeTwoDocuments(mainDocument, baseDocuments.get(i), (Set)baseLabels.get(i), background);
        }
        return mainDocument;
    }

    static <INN extends CoreMap & HasWord> void mergeTwoDocuments(List<INN> mainDocument, List<INN> auxDocument, Set<String> auxLabels, String background) {
        boolean insideAuxTag = false;
        boolean auxTagValid = true;
        String prevAnswer = background;
        ArrayList<CoreMap> constituents = new ArrayList<CoreMap>();
        ListIterator<INN> auxIterator = auxDocument.listIterator();
        for (CoreMap wMain : mainDocument) {
            boolean insideMainTag;
            String mainAnswer = (String)wMain.get(CoreAnnotations.AnswerAnnotation.class);
            CoreMap wAux = (CoreMap)auxIterator.next();
            String auxAnswer = (String)wAux.get(CoreAnnotations.AnswerAnnotation.class);
            boolean bl = insideMainTag = !mainAnswer.equals(background);
            if (auxLabels.contains(auxAnswer)) {
                if (!prevAnswer.equals(auxAnswer) && !prevAnswer.equals(background)) {
                    if (auxTagValid) {
                        for (CoreMap wi : constituents) {
                            wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
                        }
                    }
                    auxTagValid = true;
                    constituents = new ArrayList();
                }
                insideAuxTag = true;
                if (insideMainTag) {
                    auxTagValid = false;
                }
                prevAnswer = auxAnswer;
                constituents.add(wMain);
                continue;
            }
            if (insideAuxTag) {
                if (auxTagValid) {
                    for (CoreMap wi : constituents) {
                        wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
                    }
                }
                constituents = new ArrayList();
            }
            insideAuxTag = false;
            auxTagValid = true;
            prevAnswer = background;
        }
        if (auxTagValid) {
            for (CoreMap wi : constituents) {
                wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
            }
        }
    }

    @Override
    public List<IN> classify(List<IN> tokens) {
        int i;
        if (this.baseClassifiers.isEmpty()) {
            return tokens;
        }
        ArrayList<List<IN>> baseOutputs = new ArrayList<List<IN>>();
        List<IN> output = this.baseClassifiers.get(0).classifySentence(tokens);
        int sz = output.size();
        for (i = 0; i < sz; ++i) {
            ((CoreMap)tokens.get(i)).set(CoreAnnotations.AnswerAnnotation.class, ((CoreMap)output.get(i)).get(CoreAnnotations.AnswerAnnotation.class));
        }
        baseOutputs.add(tokens);
        sz = this.baseClassifiers.size();
        for (i = 1; i < sz; ++i) {
            output = this.baseClassifiers.get(i).classifySentence(tokens);
            baseOutputs.add(output);
        }
        assert (baseOutputs.size() == this.baseClassifiers.size());
        List<IN> finalAnswer = this.mergeDocuments(baseOutputs);
        return finalAnswer;
    }

    @Override
    public void train(Collection<List<IN>> docs, DocumentReaderAndWriter<IN> readerAndWriter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serializeClassifier(String serializePath) {
        System.err.print("Serializing classifier to " + serializePath + "...");
        ObjectOutputStream oos = null;
        try {
            oos = IOUtils.writeStreamFromString(serializePath);
            this.serializeClassifier(oos);
            System.err.println("done.");
        }
        catch (Exception e) {
            throw new RuntimeIOException("Failed to save classifier", e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
    }

    @Override
    public void serializeClassifier(ObjectOutputStream oos) {
        try {
            oos.writeObject(this.initProps);
            oos.writeObject(this.initProps);
            oos.writeObject(this.initLoadPaths);
            String combinationModeString = this.combinationMode.name();
            oos.writeObject(combinationModeString);
            Integer numClassifiers = this.baseClassifiers.size();
            oos.writeInt(numClassifiers);
            System.err.println("");
            for (AbstractSequenceClassifier<IN> asc : this.baseClassifiers) {
                asc.serializeClassifier(oos);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void loadClassifier(ObjectInputStream in, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IN> classifyWithGlobalInformation(List<IN> tokenSeq, CoreMap doc, CoreMap sent) {
        return this.classify(tokenSeq);
    }

    public static ClassifierCombiner getClassifier(String loadPath, Properties props) throws IOException, ClassNotFoundException, ClassCastException {
        ObjectInputStream ois = IOUtils.readStreamFromString(loadPath);
        ClassifierCombiner returnCC = ClassifierCombiner.getClassifier(ois, props);
        IOUtils.closeIgnoringExceptions(ois);
        return returnCC;
    }

    public static ClassifierCombiner getClassifier(ObjectInputStream ois, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        return new ClassifierCombiner(ois, props);
    }

    public static void examineCRF(ClassifierCombiner cc, String crfNameOrIndex, SeqClassifierFlags flags, String testFile, String testFiles, DocumentReaderAndWriter readerAndWriter) throws Exception {
        int ci;
        try {
            ci = Integer.parseInt(crfNameOrIndex);
            if (ci < 0 || ci >= cc.baseClassifiers.size()) {
                ci = cc.initLoadPaths.indexOf(crfNameOrIndex);
            }
        }
        catch (NumberFormatException e) {
            ci = cc.initLoadPaths.indexOf(crfNameOrIndex);
        }
        CRFClassifier crf = ci >= 0 && ci < cc.baseClassifiers.size() ? (CRFClassifier)cc.baseClassifiers.get(ci) : null;
        if (crf != null) {
            if (testFile != null) {
                if (flags.searchGraphPrefix != null) {
                    crf.classifyAndWriteViterbiSearchGraph(testFile, flags.searchGraphPrefix, crf.makeReaderAndWriter());
                } else if (flags.printFirstOrderProbs) {
                    crf.printFirstOrderProbs(testFile, readerAndWriter);
                } else if (flags.printFactorTable) {
                    crf.printFactorTable(testFile, readerAndWriter);
                } else if (flags.printProbs) {
                    crf.printProbs(testFile, readerAndWriter);
                } else if (flags.useKBest) {
                    int k = flags.kBest;
                    crf.classifyAndWriteAnswersKBest(testFile, k, readerAndWriter);
                } else if (flags.printLabelValue) {
                    crf.printLabelInformation(testFile, readerAndWriter);
                } else {
                    System.err.println("Warning: no crf test flag was provided, running classify and write answers");
                    crf.classifyAndWriteAnswers(testFile, readerAndWriter, true);
                }
            } else if (testFiles != null) {
                List<File> files = Arrays.asList(testFiles.split(",")).stream().map(File::new).collect(Collectors.toList());
                if (flags.printProbs) {
                    crf.printProbs(files, crf.defaultReaderAndWriter());
                } else {
                    System.err.println("Warning: no crf test flag was provided, running classify files and write answers");
                    crf.classifyFilesAndWriteAnswers(files, crf.defaultReaderAndWriter(), true);
                }
            }
        }
    }

    public static void showCCInfo(ClassifierCombiner cc) {
        System.err.println("");
        System.err.println("classifiers used:");
        System.err.println("");
        if (cc.initLoadPaths.size() == cc.baseClassifiers.size()) {
            for (int i = 0; i < cc.initLoadPaths.size(); ++i) {
                System.err.println("baseClassifiers index " + i + " : " + cc.initLoadPaths.get(i));
            }
        } else {
            for (int i = 0; i < cc.initLoadPaths.size(); ++i) {
                System.err.println("baseClassifiers index " + i);
            }
        }
        System.err.println("");
        System.err.println("combinationMode: " + (Object)((Object)cc.combinationMode));
        System.err.println("");
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        ClassifierCombiner ec = new ClassifierCombiner(props);
        System.err.println(ec.classifyToString("Marketing : Sony Hopes to Win Much Bigger Market For Wide Range of Small-Video Products --- By Andrew B. Cohen Staff Reporter of The Wall Street Journal"));
    }

    static enum CombinationMode {
        NORMAL,
        HIGH_RECALL;

    }
}

