/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.impl;

import de.jollyday.Holiday;
import de.jollyday.holidaytype.LocalizedHolidayType;
import de.jollyday.impl.XMLManager;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLManagerJapan
extends XMLManager {
    private static final String BRIDGING_HOLIDAY_PROPERTIES_KEY = "BRIDGING_HOLIDAY";

    @Override
    public Set<Holiday> getHolidays(int year, String ... args) {
        Set<Holiday> holidays = super.getHolidays(year, args);
        HashSet<Holiday> additionalHolidays = new HashSet<Holiday>();
        for (Holiday d : holidays) {
            LocalDate twoDaysLater = d.getDate().plusDays(2);
            if (!this.calendarUtil.contains(holidays, twoDaysLater)) continue;
            LocalDate bridgingDate = twoDaysLater.minusDays(1);
            additionalHolidays.add(new Holiday(bridgingDate, BRIDGING_HOLIDAY_PROPERTIES_KEY, LocalizedHolidayType.OFFICIAL_HOLIDAY));
        }
        holidays.addAll(additionalHolidays);
        return holidays;
    }
}

