/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.RowD1Matrix64F;

public class MatrixMultProduct {
    public static void outer(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2) {
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            int n;
            int n2 = n = i * rowD1Matrix64F2.numCols + i;
            int n3 = i;
            while (n3 < rowD1Matrix64F.numRows) {
                int n4 = i * rowD1Matrix64F.numCols;
                int n5 = n3 * rowD1Matrix64F.numCols;
                double d = 0.0;
                int n6 = n4 + rowD1Matrix64F.numCols;
                while (n4 < n6) {
                    d += rowD1Matrix64F.data[n4] * rowD1Matrix64F.data[n5];
                    ++n4;
                    ++n5;
                }
                int n7 = n++;
                double d2 = d;
                rowD1Matrix64F2.data[n7] = d2;
                rowD1Matrix64F2.data[n2] = d2;
                ++n3;
                n2 += rowD1Matrix64F2.numCols;
            }
        }
    }

    public static void inner_small(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2) {
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            for (int j = i; j < rowD1Matrix64F.numCols; ++j) {
                int n = i * rowD1Matrix64F2.numCols + j;
                int n2 = j * rowD1Matrix64F2.numCols + i;
                int n3 = i;
                int n4 = j;
                double d = 0.0;
                int n5 = n3 + rowD1Matrix64F.numRows * rowD1Matrix64F.numCols;
                while (n3 < n5) {
                    d += rowD1Matrix64F.data[n3] * rowD1Matrix64F.data[n4];
                    n3 += rowD1Matrix64F.numCols;
                    n4 += rowD1Matrix64F.numCols;
                }
                rowD1Matrix64F2.data[n] = rowD1Matrix64F2.data[n2] = d;
            }
        }
    }

    public static void inner_reorder(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2) {
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n;
            int n2;
            int n3 = i * rowD1Matrix64F2.numCols + i;
            double d = rowD1Matrix64F.data[i];
            for (n2 = i; n2 < rowD1Matrix64F.numCols; ++n2) {
                rowD1Matrix64F2.data[n3++] = d * rowD1Matrix64F.data[n2];
            }
            for (n2 = 1; n2 < rowD1Matrix64F.numRows; ++n2) {
                n3 = i * rowD1Matrix64F2.numCols + i;
                n = n2 * rowD1Matrix64F.numCols + i;
                d = rowD1Matrix64F.data[n];
                for (int j = i; j < rowD1Matrix64F.numCols; ++j) {
                    int n4 = n3++;
                    rowD1Matrix64F2.data[n4] = rowD1Matrix64F2.data[n4] + d * rowD1Matrix64F.data[n++];
                }
            }
            n2 = n3 = i * rowD1Matrix64F2.numCols + i;
            n = i;
            while (n < rowD1Matrix64F.numCols) {
                rowD1Matrix64F2.data[n2] = rowD1Matrix64F2.data[n3++];
                ++n;
                n2 += rowD1Matrix64F2.numCols;
            }
        }
    }

    public static void inner_reorder_upper(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2) {
        for (int i = 0; i < rowD1Matrix64F.numCols; ++i) {
            int n;
            int n2 = i * rowD1Matrix64F2.numCols + i;
            double d = rowD1Matrix64F.data[i];
            for (n = i; n < rowD1Matrix64F.numCols; ++n) {
                rowD1Matrix64F2.data[n2++] = d * rowD1Matrix64F.data[n];
            }
            for (n = 1; n < rowD1Matrix64F.numRows; ++n) {
                n2 = i * rowD1Matrix64F2.numCols + i;
                int n3 = n * rowD1Matrix64F.numCols + i;
                d = rowD1Matrix64F.data[n3];
                for (int j = i; j < rowD1Matrix64F.numCols; ++j) {
                    int n4 = n2++;
                    rowD1Matrix64F2.data[n4] = rowD1Matrix64F2.data[n4] + d * rowD1Matrix64F.data[n3++];
                }
            }
        }
    }
}

