/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.decomposition.qr;

import org.ejml.alg.block.BlockInnerMultiplication;
import org.ejml.alg.block.BlockVectorOps;
import org.ejml.data.D1Submatrix64F;

public class BlockHouseHolder {
    public static boolean decomposeQR_block_col(int n, D1Submatrix64F d1Submatrix64F, double[] dArray) {
        int n2 = d1Submatrix64F.col1 - d1Submatrix64F.col0;
        int n3 = d1Submatrix64F.row1 - d1Submatrix64F.row0;
        int n4 = Math.min(n2, n3);
        for (int i = 0; i < n4; ++i) {
            if (!BlockHouseHolder.computeHouseHolderCol(n, d1Submatrix64F, dArray, i)) {
                return false;
            }
            BlockHouseHolder.rank1UpdateMultR_Col(n, d1Submatrix64F, i, dArray[d1Submatrix64F.col0 + i]);
        }
        return true;
    }

    public static boolean computeHouseHolderCol(int n, D1Submatrix64F d1Submatrix64F, double[] dArray, int n2) {
        double d = BlockHouseHolder.findMaxCol(n, d1Submatrix64F, n2);
        if (d == 0.0) {
            return false;
        }
        double d2 = BlockHouseHolder.computeTauAndDivideCol(n, d1Submatrix64F, n2, d);
        double d3 = d1Submatrix64F.get(n2, n2) + d2;
        BlockHouseHolder.divideElementsCol(n, d1Submatrix64F, n2, d3);
        dArray[d1Submatrix64F.col0 + n2] = d3 / d2;
        d1Submatrix64F.set(n2, n2, -(d2 *= d));
        return true;
    }

    public static boolean computeHouseHolderRow(int n, D1Submatrix64F d1Submatrix64F, double[] dArray, int n2) {
        double d = BlockHouseHolder.findMaxRow(n, d1Submatrix64F, n2, n2 + 1);
        if (d == 0.0) {
            return false;
        }
        double d2 = BlockHouseHolder.computeTauAndDivideRow(n, d1Submatrix64F, n2, n2 + 1, d);
        double d3 = d1Submatrix64F.get(n2, n2 + 1) + d2;
        BlockVectorOps.div_row(n, d1Submatrix64F, n2, d3, d1Submatrix64F, n2, n2 + 1, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        dArray[d1Submatrix64F.row0 + n2] = d3 / d2;
        d1Submatrix64F.set(n2, n2 + 1, -d2 * d);
        return true;
    }

    public static void rank1UpdateMultR_Col(int n, D1Submatrix64F d1Submatrix64F, int n2, double d) {
        int n3 = Math.min(n, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        double[] dArray = d1Submatrix64F.original.data;
        for (int i = n2 + 1; i < n3; ++i) {
            double d2 = BlockHouseHolder.innerProdCol(n, d1Submatrix64F, n2, n3, i, n3);
            d2 *= d;
            for (int j = d1Submatrix64F.row0; j < d1Submatrix64F.row1; j += n) {
                int n4;
                int n5 = Math.min(n, d1Submatrix64F.row1 - j);
                int n6 = j * d1Submatrix64F.original.numCols + n5 * d1Submatrix64F.col0 + n2;
                int n7 = j * d1Submatrix64F.original.numCols + n5 * d1Submatrix64F.col0 + i;
                if (j == d1Submatrix64F.row0) {
                    n6 += n3 * (n2 + 1);
                    int n8 = n7 += n3 * n2;
                    dArray[n8] = dArray[n8] - d2;
                    n7 += n3;
                    n4 = n2 + 1;
                    while (n4 < n5) {
                        int n9 = n7;
                        dArray[n9] = dArray[n9] - d2 * dArray[n6];
                        ++n4;
                        n6 += n3;
                        n7 += n3;
                    }
                    continue;
                }
                n4 = n6 + n3 * n5;
                while (n6 != n4) {
                    int n10 = n7;
                    dArray[n10] = dArray[n10] - d2 * dArray[n6];
                    n6 += n3;
                    n7 += n3;
                }
            }
        }
    }

    public static void rank1UpdateMultR_TopRow(int n, D1Submatrix64F d1Submatrix64F, int n2, double d) {
        double[] dArray = d1Submatrix64F.original.data;
        int n3 = Math.min(n, d1Submatrix64F.col1 - n2);
        for (int i = d1Submatrix64F.col0 + n; i < d1Submatrix64F.col1; i += n) {
            int n4 = Math.min(n, d1Submatrix64F.col1 - i);
            for (int j = 0; j < n4; ++j) {
                double d2 = BlockHouseHolder.innerProdCol(n, d1Submatrix64F, n2, n3, i - d1Submatrix64F.col0 + j, n4) * d;
                int n5 = d1Submatrix64F.row0;
                int n6 = Math.min(n, d1Submatrix64F.row1 - n5);
                int n7 = n5 * d1Submatrix64F.original.numCols + n6 * d1Submatrix64F.col0 + n2;
                int n8 = n5 * d1Submatrix64F.original.numCols + n6 * i + j;
                n7 += n3 * (n2 + 1);
                int n9 = n8 += n4 * n2;
                dArray[n9] = dArray[n9] - d2;
                n8 += n4;
                int n10 = n2 + 1;
                while (n10 < n6) {
                    int n11 = n8;
                    dArray[n11] = dArray[n11] - d2 * dArray[n7];
                    ++n10;
                    n7 += n3;
                    n8 += n4;
                }
            }
        }
    }

    public static void rank1UpdateMultL_Row(int n, D1Submatrix64F d1Submatrix64F, int n2, int n3, double d) {
        int n4 = Math.min(n, d1Submatrix64F.row1 - d1Submatrix64F.row0);
        double[] dArray = d1Submatrix64F.original.data;
        int n5 = n3 - n2;
        for (int i = n2 + 1; i < n4; ++i) {
            double d2 = BlockHouseHolder.innerProdRow(n, d1Submatrix64F, n2, d1Submatrix64F, i, n5);
            d2 *= d;
            for (int j = d1Submatrix64F.col0; j < d1Submatrix64F.col1; j += n) {
                int n6;
                int n7 = Math.min(n, d1Submatrix64F.col1 - j);
                int n8 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + n4 * j + n2 * n7;
                int n9 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + n4 * j + i * n7;
                if (j == d1Submatrix64F.col0) {
                    n8 += n3 + 1;
                    n9 += n3;
                    int n10 = n9++;
                    dArray[n10] = dArray[n10] - d2;
                    for (n6 = n3 + 1; n6 < n7; ++n6) {
                        int n11 = n9++;
                        dArray[n11] = dArray[n11] - d2 * dArray[n8++];
                    }
                    continue;
                }
                for (n6 = 0; n6 < n7; ++n6) {
                    int n12 = n9++;
                    dArray[n12] = dArray[n12] - d2 * dArray[n8++];
                }
            }
        }
    }

    public static void rank1UpdateMultL_LeftCol(int n, D1Submatrix64F d1Submatrix64F, int n2, double d, int n3) {
        int n4 = Math.min(n, d1Submatrix64F.row1 - d1Submatrix64F.row0);
        int n5 = Math.min(n, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        double[] dArray = d1Submatrix64F.original.data;
        for (int i = d1Submatrix64F.row0 + n; i < d1Submatrix64F.row1; i += n) {
            int n6 = Math.min(n, d1Submatrix64F.row1 - i);
            for (int j = 0; j < n6; ++j) {
                double d2 = BlockHouseHolder.innerProdRow(n, d1Submatrix64F, n2, d1Submatrix64F, j + (i - d1Submatrix64F.row0), n3);
                d2 *= d;
                int n7 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + n4 * d1Submatrix64F.col0 + n2 * n5;
                int n8 = i * d1Submatrix64F.original.numCols + n6 * d1Submatrix64F.col0 + j * n5;
                n7 += n3 + 1;
                n8 += n3;
                int n9 = n8++;
                dArray[n9] = dArray[n9] - d2;
                for (int k = n3 + 1; k < n5; ++k) {
                    int n10 = n8++;
                    dArray[n10] = dArray[n10] - d2 * dArray[n7++];
                }
            }
        }
    }

    public static double innerProdCol(int n, D1Submatrix64F d1Submatrix64F, int n2, int n3, int n4, int n5) {
        double d = 0.0;
        double[] dArray = d1Submatrix64F.original.data;
        int n6 = d1Submatrix64F.col0 + n2 - n2 % n;
        int n7 = d1Submatrix64F.col0 + n4 - n4 % n;
        n2 %= n;
        n4 %= n;
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            int n8;
            int n9 = Math.min(n, d1Submatrix64F.row1 - i);
            int n10 = i * d1Submatrix64F.original.numCols + n9 * n6 + n2;
            int n11 = i * d1Submatrix64F.original.numCols + n9 * n7 + n4;
            if (i == d1Submatrix64F.row0) {
                d = dArray[n11 += n5 * n2];
                n11 += n5;
                n8 = (n10 += n3 * (n2 + 1)) + (n9 - n2 - 1) * n3;
                while (n10 != n8) {
                    d += dArray[n10] * dArray[n11];
                    n10 += n3;
                    n11 += n5;
                }
                continue;
            }
            n8 = n10 + n3 * n9;
            while (n10 != n8) {
                d += dArray[n10] * dArray[n11];
                n10 += n3;
                n11 += n5;
            }
        }
        return d;
    }

    public static double innerProdRow(int n, D1Submatrix64F d1Submatrix64F, int n2, D1Submatrix64F d1Submatrix64F2, int n3, int n4) {
        int n5 = n2 + n4;
        if (n5 + d1Submatrix64F2.col0 >= d1Submatrix64F2.col1) {
            return 0.0;
        }
        double d = d1Submatrix64F2.get(n3, n5);
        return d += BlockVectorOps.dot_row(n, d1Submatrix64F, n2, d1Submatrix64F2, n3, n5 + 1, d1Submatrix64F.col1 - d1Submatrix64F.col0);
    }

    public static void add_row(int n, D1Submatrix64F d1Submatrix64F, int n2, double d, D1Submatrix64F d1Submatrix64F2, int n3, double d2, D1Submatrix64F d1Submatrix64F3, int n4, int n5, int n6) {
        int n7 = n2 + n5;
        if (d1Submatrix64F3.col0 + n7 >= d1Submatrix64F3.col1) {
            return;
        }
        d1Submatrix64F3.set(n4, n7, d + d1Submatrix64F2.get(n3, n7) * d2);
        BlockVectorOps.add_row(n, d1Submatrix64F, n2, d, d1Submatrix64F2, n3, d2, d1Submatrix64F3, n4, n7 + 1, n6);
    }

    public static void divideElementsCol(int n, D1Submatrix64F d1Submatrix64F, int n2, double d) {
        int n3 = Math.min(n, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        double[] dArray = d1Submatrix64F.original.data;
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            int n4;
            int n5;
            int n6 = Math.min(n, d1Submatrix64F.row1 - i);
            if (i == d1Submatrix64F.row0) {
                n4 += n3 * (n2 + 1);
                n5 = n2 + 1;
                while (n5 < n6) {
                    int n7 = n4;
                    dArray[n7] = dArray[n7] / d;
                    ++n5;
                    n4 += n3;
                }
                continue;
            }
            n5 = n4 + n3 * n6;
            for (n4 = i * d1Submatrix64F.original.numCols + n6 * d1Submatrix64F.col0 + n2; n4 != n5; n4 += n3) {
                int n8 = n4;
                dArray[n8] = dArray[n8] / d;
            }
        }
    }

    public static void scale_row(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, int n2, int n3, double d) {
        int n4 = n2 + n3;
        if (n4 >= d1Submatrix64F2.col1 - d1Submatrix64F2.col0) {
            return;
        }
        d1Submatrix64F2.set(n2, n4, d);
        BlockVectorOps.scale_row(n, d1Submatrix64F, n2, d, d1Submatrix64F2, n2, n4 + 1, d1Submatrix64F.col1 - d1Submatrix64F.col0);
    }

    public static double computeTauAndDivideCol(int n, D1Submatrix64F d1Submatrix64F, int n2, double d) {
        int n3 = Math.min(n, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        double[] dArray = d1Submatrix64F.original.data;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            double d4;
            int n4;
            int n5 = Math.min(n, d1Submatrix64F.row1 - i);
            int n6 = i * d1Submatrix64F.original.numCols + n5 * d1Submatrix64F.col0 + n2;
            if (i == d1Submatrix64F.row0) {
                int n7 = n6 += n3 * n2;
                double d5 = dArray[n7] / d;
                dArray[n7] = d5;
                d2 = d5;
                d3 += d2 * d2;
                n6 += n3;
                n4 = n2 + 1;
                while (n4 < n5) {
                    int n8 = n6;
                    double d6 = dArray[n8] / d;
                    dArray[n8] = d6;
                    d4 = d6;
                    d3 += d4 * d4;
                    ++n4;
                    n6 += n3;
                }
                continue;
            }
            n4 = 0;
            while (n4 < n5) {
                int n9 = n6;
                double d7 = dArray[n9] / d;
                dArray[n9] = d7;
                d4 = d7;
                d3 += d4 * d4;
                ++n4;
                n6 += n3;
            }
        }
        d3 = Math.sqrt(d3);
        if (d2 < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public static double computeTauAndDivideRow(int n, D1Submatrix64F d1Submatrix64F, int n2, int n3, double d) {
        int n4 = Math.min(n, d1Submatrix64F.row1 - d1Submatrix64F.row0);
        double[] dArray = d1Submatrix64F.original.data;
        double d2 = 0.0;
        double d3 = 0.0;
        int n5 = d1Submatrix64F.col0 + n3 - n3 % n;
        n3 %= n;
        for (int i = n5; i < d1Submatrix64F.col1; i += n) {
            double d4;
            int n6;
            int n7 = Math.min(n, d1Submatrix64F.col1 - i);
            int n8 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + n4 * i + n2 * n7;
            if (i == n5) {
                n8 += n3;
                int n9 = n8++;
                double d5 = dArray[n9] / d;
                dArray[n9] = d5;
                d2 = d5;
                d3 += d2 * d2;
                for (n6 = n3 + 1; n6 < n7; ++n6) {
                    int n10 = n8++;
                    double d6 = dArray[n10] / d;
                    dArray[n10] = d6;
                    d4 = d6;
                    d3 += d4 * d4;
                }
                continue;
            }
            for (n6 = 0; n6 < n7; ++n6) {
                int n11 = n8++;
                double d7 = dArray[n11] / d;
                dArray[n11] = d7;
                d4 = d7;
                d3 += d4 * d4;
            }
        }
        d3 = Math.sqrt(d3);
        if (d2 < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public static double findMaxCol(int n, D1Submatrix64F d1Submatrix64F, int n2) {
        int n3 = Math.min(n, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        double[] dArray = d1Submatrix64F.original.data;
        double d = 0.0;
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            double d2;
            int n4;
            int n5 = Math.min(n, d1Submatrix64F.row1 - i);
            int n6 = i * d1Submatrix64F.original.numCols + n5 * d1Submatrix64F.col0 + n2;
            if (i == d1Submatrix64F.row0) {
                n6 += n3 * n2;
                n4 = n2;
                while (n4 < n5) {
                    d2 = Math.abs(dArray[n6]);
                    if (d2 > d) {
                        d = d2;
                    }
                    ++n4;
                    n6 += n3;
                }
                continue;
            }
            n4 = 0;
            while (n4 < n5) {
                d2 = Math.abs(dArray[n6]);
                if (d2 > d) {
                    d = d2;
                }
                ++n4;
                n6 += n3;
            }
        }
        return d;
    }

    public static double findMaxRow(int n, D1Submatrix64F d1Submatrix64F, int n2, int n3) {
        int n4 = Math.min(n, d1Submatrix64F.row1 - d1Submatrix64F.row0);
        double[] dArray = d1Submatrix64F.original.data;
        double d = 0.0;
        for (int i = d1Submatrix64F.col0; i < d1Submatrix64F.col1; i += n) {
            double d2;
            int n5;
            int n6 = Math.min(n, d1Submatrix64F.col1 - i);
            int n7 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + n4 * i + n2 * n6;
            if (i == d1Submatrix64F.col0) {
                n7 += n3;
                for (n5 = n3; n5 < n6; ++n5) {
                    int n8 = n7++;
                    d2 = Math.abs(dArray[n8]);
                    if (!(d2 > d)) continue;
                    d = d2;
                }
                continue;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                int n9 = n7++;
                d2 = Math.abs(dArray[n9]);
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public static void computeW_Column(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, double[] dArray, double[] dArray2, int n2) {
        int n3 = d1Submatrix64F2.col1 - d1Submatrix64F2.col0;
        BlockHouseHolder.initializeW(n, d1Submatrix64F2, d1Submatrix64F, n3, dArray2[n2++]);
        int n4 = Math.min(n3, d1Submatrix64F2.row1 - d1Submatrix64F2.row0);
        for (int i = 1; i < n4; ++i) {
            BlockHouseHolder.computeY_t_V(n, d1Submatrix64F, i, dArray);
            BlockHouseHolder.computeZ(n, d1Submatrix64F, d1Submatrix64F2, i, dArray, dArray2[n2++]);
        }
    }

    public static void initializeW(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, int n2, double d) {
        double[] dArray = d1Submatrix64F.original.data;
        double[] dArray2 = d1Submatrix64F2.original.data;
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            int n3;
            int n4 = Math.min(n, d1Submatrix64F.row1 - i);
            int n5 = i * d1Submatrix64F.original.numCols + n4 * d1Submatrix64F.col0;
            int n6 = i * d1Submatrix64F2.original.numCols + n4 * d1Submatrix64F2.col0;
            if (i == d1Submatrix64F.row0) {
                dArray[n5] = -d;
                n5 += n2;
                n6 += n2;
                n3 = 1;
                while (n3 < n4) {
                    dArray[n5] = -d * dArray2[n6];
                    ++n3;
                    n5 += n2;
                    n6 += n2;
                }
                continue;
            }
            n3 = 0;
            while (n3 < n4) {
                dArray[n5] = -d * dArray2[n6];
                ++n3;
                n5 += n2;
                n6 += n2;
            }
        }
    }

    public static void computeZ(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, int n2, double[] dArray, double d) {
        int n3 = d1Submatrix64F.col1 - d1Submatrix64F.col0;
        double[] dArray2 = d1Submatrix64F2.original.data;
        double[] dArray3 = d1Submatrix64F.original.data;
        int n4 = d1Submatrix64F2.original.numCols;
        double d2 = -d;
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            int n5;
            double d3;
            int n6;
            int n7 = Math.min(n, d1Submatrix64F.row1 - i);
            int n8 = i * n4 + n7 * d1Submatrix64F2.col0;
            int n9 = i * n4 + n7 * d1Submatrix64F2.col0 + n2;
            int n10 = i * d1Submatrix64F.original.numCols + n7 * d1Submatrix64F.col0 + n2;
            if (i == d1Submatrix64F.row0) {
                n6 = 0;
                while (n6 < n7) {
                    d3 = 0.0;
                    for (n5 = 0; n5 < n2; ++n5) {
                        d3 += dArray2[n8 + n5] * dArray[n5];
                    }
                    dArray2[n9] = n6 < n2 ? -d * d3 : (n6 == n2 ? d2 * (1.0 + d3) : d2 * (dArray3[n10] + d3));
                    ++n6;
                    n9 += n3;
                    n8 += n3;
                    n10 += n3;
                }
                continue;
            }
            n6 = n9 + n3 * n7;
            while (n9 != n6) {
                d3 = 0.0;
                for (n5 = 0; n5 < n2; ++n5) {
                    d3 += dArray2[n8 + n5] * dArray[n5];
                }
                dArray2[n9] = d2 * (dArray3[n10] + d3);
                n9 += n3;
                n8 += n3;
                n10 += n3;
            }
        }
    }

    public static void computeY_t_V(int n, D1Submatrix64F d1Submatrix64F, int n2, double[] dArray) {
        int n3 = d1Submatrix64F.col1 - d1Submatrix64F.col0;
        for (int i = 0; i < n2; ++i) {
            dArray[i] = BlockHouseHolder.innerProdCol(n, d1Submatrix64F, n2, n3, i, n3);
        }
    }

    public static void multAdd_zeros(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        int n2 = d1Submatrix64F.col1 - d1Submatrix64F.col0;
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            int n3 = Math.min(n, d1Submatrix64F.row1 - i);
            for (int j = d1Submatrix64F2.col0; j < d1Submatrix64F2.col1; j += n) {
                int n4 = Math.min(n, d1Submatrix64F2.col1 - j);
                int n5 = (i - d1Submatrix64F.row0 + d1Submatrix64F3.row0) * d1Submatrix64F3.original.numCols + (j - d1Submatrix64F2.col0 + d1Submatrix64F3.col0) * n3;
                for (int k = d1Submatrix64F.col0; k < d1Submatrix64F.col1; k += n) {
                    int n6 = i * d1Submatrix64F.original.numCols + k * n3;
                    int n7 = (k - d1Submatrix64F.col0 + d1Submatrix64F2.row0) * d1Submatrix64F2.original.numCols + j * n2;
                    if (i == d1Submatrix64F.row0) {
                        BlockHouseHolder.multBlockAdd_zerosone(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n5, n3, n2, n4);
                        continue;
                    }
                    BlockInnerMultiplication.blockMultPlus(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n5, n3, n2, n4);
                }
            }
        }
    }

    public static void multBlockAdd_zerosone(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n6; ++j) {
                double d = i < n5 ? dArray2[i * n6 + j + n2] : 0.0;
                int n7 = Math.min(i, n5);
                for (int k = 0; k < n7; ++k) {
                    d += dArray[i * n5 + k + n] * dArray2[k * n6 + j + n2];
                }
                int n8 = i * n6 + j + n3;
                dArray3[n8] = dArray3[n8] + d;
            }
        }
    }

    public static void multTransA_vecCol(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        int n2 = d1Submatrix64F.col1 - d1Submatrix64F.col0;
        if (n2 > n) {
            throw new IllegalArgumentException("A is expected to be at most one block wide.");
        }
        for (int i = d1Submatrix64F2.col0; i < d1Submatrix64F2.col1; i += n) {
            int n3 = Math.min(n, d1Submatrix64F2.col1 - i);
            int n4 = d1Submatrix64F3.row0 * d1Submatrix64F3.original.numCols + (i - d1Submatrix64F2.col0 + d1Submatrix64F3.col0) * n2;
            for (int j = d1Submatrix64F.row0; j < d1Submatrix64F.row1; j += n) {
                int n5 = Math.min(n, d1Submatrix64F.row1 - j);
                int n6 = j * d1Submatrix64F.original.numCols + d1Submatrix64F.col0 * n5;
                int n7 = (j - d1Submatrix64F.row0 + d1Submatrix64F2.row0) * d1Submatrix64F2.original.numCols + i * n5;
                if (j == d1Submatrix64F.row0) {
                    BlockHouseHolder.multTransABlockSet_lowerTriag(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n5, n2, n3);
                    continue;
                }
                BlockInnerMultiplication.blockMultPlusTransA(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n5, n2, n3);
            }
        }
    }

    protected static void multTransABlockSet_lowerTriag(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                double d = i < n4 ? dArray2[i * n6 + j + n2] : 0.0;
                for (int k = i + 1; k < n4; ++k) {
                    d += dArray[k * n5 + i + n] * dArray2[k * n6 + j + n2];
                }
                dArray3[i * n6 + j + n3] = d;
            }
        }
    }
}

