/*
 * Decompiled with CFR 0.152.
 */
package org.javaruntype.type;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.javaruntype.cache.ConcurrentCache;
import org.javaruntype.type.Type;
import org.javaruntype.type.TypeAssignation;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeRegistry {
    private final ConcurrentCache<String, Type<?>> types = new ConcurrentCache(200);
    private final ConcurrentCache<String, Type<?>> typesByPossibleNames = new ConcurrentCache(100);
    private final ConcurrentCache<Class<?>, Type<?>> rawTypesByClass = new ConcurrentCache(100);
    private final ConcurrentCache<Type<?>, Set<Type<?>>> extendedTypesByType = new ConcurrentCache(300);
    protected final ConcurrentCache<TypeAssignation, Boolean> typeAssignabilities = new ConcurrentCache(200);
    protected final ConcurrentCache<java.lang.reflect.Type, Type<?>> typesbyJavaLangReflectType = new ConcurrentCache(100);
    private static final TypeRegistry instance = new TypeRegistry();

    static TypeRegistry getInstance() {
        return instance;
    }

    private TypeRegistry() {
    }

    Type<?> forName(String typeName) {
        Type<?> type = this.typesByPossibleNames.get(typeName);
        if (type != null) {
            return type;
        }
        return this.typesByPossibleNames.computeAndGet(typeName, TypeUtil.forName(typeName));
    }

    Type<?> getRawTypeForClass(Class<?> typeClass) {
        Type<?> type = this.rawTypesByClass.get(typeClass);
        if (type != null) {
            return type;
        }
        return this.rawTypesByClass.computeAndGet(typeClass, TypeUtil.getRawTypeForClass(typeClass));
    }

    Type<?> getType(Class<?> componentClass, TypeParameter<?>[] typeParameters, int arrayDimensions) {
        String identifier = TypeUtil.createName(componentClass, typeParameters, arrayDimensions);
        Type<?> type = this.types.get(identifier);
        if (type != null) {
            return type;
        }
        return this.types.computeAndGet(identifier, Type.createType(componentClass, typeParameters, arrayDimensions));
    }

    Type<?> getTypeWithoutValidation(Class<?> componentClass, TypeParameter<?>[] typeParameters, int arrayDimensions) {
        String identifier = TypeUtil.createName(componentClass, typeParameters, arrayDimensions);
        Type<?> type = this.types.get(identifier);
        if (type != null) {
            return type;
        }
        return Type.createTypeWithoutValidation(componentClass, typeParameters, arrayDimensions);
    }

    Set<Type<?>> getExtendedTypes(Type<?> type) {
        Set<Type<?>> extendedTypes = this.extendedTypesByType.get(type);
        if (extendedTypes != null) {
            return extendedTypes;
        }
        return this.extendedTypesByType.computeAndGet(type, TypeUtil.getExtendedTypes(type));
    }

    Type<?> forJavaLangReflectType(java.lang.reflect.Type javaLangReflectType) {
        Type<?> type = this.typesbyJavaLangReflectType.get(javaLangReflectType);
        if (type != null) {
            return type;
        }
        return this.typesbyJavaLangReflectType.computeAndGet(javaLangReflectType, TypeUtil.createFromJavaLangReflectType(javaLangReflectType, javaLangReflectType, Collections.EMPTY_MAP));
    }

    Type<?> forJavaLangReflectType(java.lang.reflect.Type javaLangReflectType, Map<String, Type<?>> variableSubstitutions) {
        return TypeUtil.createFromJavaLangReflectType(javaLangReflectType, javaLangReflectType, variableSubstitutions);
    }

    boolean isAssignableFrom(Type<?> type, Type<?> fromType) {
        TypeAssignation assignation = new TypeAssignation(type, fromType);
        Boolean assignable = this.typeAssignabilities.get(assignation);
        if (assignable != null) {
            return assignable;
        }
        return this.typeAssignabilities.computeAndGet(assignation, TypeUtil.isAssignableFrom(type, fromType));
    }
}

