/*
 * Decompiled with CFR 0.152.
 */
package org.javaruntype.type;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.TypeRegistry;
import org.javaruntype.type.TypeUtil;
import org.javaruntype.type.WildcardTypeParameter;
import org.javaruntype.typedef.TypeDef;
import org.javaruntype.typedef.TypeDefVariable;
import org.javaruntype.typedef.TypeDefs;
import org.javaruntype.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Type<T>
implements Serializable {
    private static final long serialVersionUID = 2376256493847227243L;
    private final Class<?> componentClass;
    private final int arrayDimensions;
    private final TypeParameter<?>[] typeParameters;
    private final Class<? super T> rawClass;
    private final TypeDef typeDef;
    private final String name;
    private final String simpleName;
    private final int hashCode;

    static Type<?> createType(Class<?> componentClass, TypeParameter<?>[] typeParameters, int arrayDimensions) {
        Type type = new Type(componentClass, typeParameters, arrayDimensions);
        TypeUtil.validateTypeParameters(type);
        return type;
    }

    static Type<?> createTypeWithoutValidation(Class<?> componentClass, TypeParameter<?>[] typeParameters, int arrayDimensions) {
        Type type = new Type(componentClass, typeParameters, arrayDimensions);
        return type;
    }

    private Type(Class<?> componentClass, TypeParameter<?>[] typeParameters, int arrayDimensions) {
        this.componentClass = componentClass;
        this.typeParameters = (TypeParameter[])typeParameters.clone();
        this.arrayDimensions = arrayDimensions;
        this.rawClass = TypeUtil.computeRawClass(componentClass, arrayDimensions);
        this.name = TypeUtil.createName(componentClass, typeParameters, arrayDimensions);
        this.simpleName = TypeUtil.createSimpleName(componentClass, typeParameters, arrayDimensions);
        this.typeDef = TypeDefs.forClass(componentClass);
        this.hashCode = this.name.hashCode();
    }

    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    public boolean isInterface() {
        return !this.isArray() && this.componentClass.isInterface();
    }

    public boolean isAbstract() {
        return !this.isArray() && (this.componentClass.getModifiers() & 0x400) != 0;
    }

    TypeParameter<?>[] getTypeParametersArray() {
        return this.typeParameters;
    }

    public List<TypeParameter<?>> getTypeParameters() {
        return Collections.unmodifiableList(Arrays.asList(this.typeParameters));
    }

    TypeDef getTypeDef() {
        return this.typeDef;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public Class<? super T> getRawClass() {
        return this.rawClass;
    }

    public boolean isAssignableFrom(Type<?> type) {
        Utils.validateNotNull(type, "Type cannot be null");
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        return typeRegistry.isAssignableFrom(this, type);
    }

    TypeParameter<?> getTypeParameterForVariable(String variableName) {
        TypeDefVariable[] typeDefVariables = this.typeDef.getVariables();
        for (int i = 0; i < typeDefVariables.length; ++i) {
            if (!typeDefVariables[i].getVariableName().equals(variableName)) continue;
            return this.typeParameters[i];
        }
        return null;
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        if (this.arrayDimensions == 0) {
            return this.componentClass.newInstance();
        }
        int[] zeroDims = new int[this.arrayDimensions];
        Arrays.fill(zeroDims, 0);
        return Array.newInstance(this.componentClass, zeroDims);
    }

    public Set<Type<?>> getAllTypesAssignableFromThis() {
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        return typeRegistry.getExtendedTypes(this);
    }

    public Type<?> getRawEquivalent() {
        return TypeUtil.getRawTypeForType(this);
    }

    public boolean isRaw() {
        if (this.typeParameters.length == 0) {
            return true;
        }
        int n = this.typeParameters.length;
        for (int i = 0; i < n; ++i) {
            if (this.typeParameters[i].equals(WildcardTypeParameter.UNKNOWN)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() throws ObjectStreamException {
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        return typeRegistry.getType(this.componentClass, this.typeParameters, this.arrayDimensions);
    }
}

