/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.internal.model;

import org.springframework.config.java.internal.parsing.ConfigurationParser;
import org.springframework.config.java.internal.parsing.asm.AsmConfigurationParser;
import org.springframework.config.java.internal.parsing.asm.AsmUtils;
import org.springframework.util.ClassUtils;


/**
 * Unit test proving that {@link AsmConfigurationParser} correctly detects
 * circular use of the {@link Import @Import} annotation.
 *
 * @author Chris Beams
 */
public class AsmCircularImportDetectionTests extends AbstractCircularImportDetectionTests {
    @Override
    protected ConfigurationParser newParser(ConfigurationModel model) {
        return new AsmConfigurationParser(model);
    }

    @Override
    protected Object loadAsConfigurationSource(Class<?> clazz) throws Exception {
        String fqClassName = clazz.getName();
        String resourcePath = ClassUtils.convertClassNameToResourcePath(fqClassName);
        return AsmUtils.newClassReader(resourcePath);
    }

}
