/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.internal.parsing.asm;

import org.springframework.config.java.annotation.Configuration;

/**
 * Unchecked exception representing an unrecoverable fault
 * that occurred in the process of parsing a {@link Configuration}
 * class using ASM.  These faults are usually a result of programmer
 * error. Used to catch/wrap/rethrow reflection exceptions and
 * IOExceptions coming out of ASMs ClassReader API.
 *
 * @author Chris Beams
 */
@SuppressWarnings("serial")
class AsmParsingException extends RuntimeException {

    public AsmParsingException(Throwable t) {
        super(t);
    }

}
