/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.internal.enhancement;

import net.sf.cglib.proxy.Callback;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;


/** TODO: JAVADOC */
class CglibCallbackThreadLocalCleanup implements DisposableBean {

    public void destroy() throws Exception {
        new ThreadLocalReader().accept(new CglibCallbackThreadLocalCleanupVisitor());
    }

}

class CglibCallbackThreadLocalCleanupVisitor implements ThreadLocalVisitor {

    private static final String TARGET_VALUE_TYPE_NAME = Callback[].class.getName();

    public void visit(ThreadLocalMapEntryData entryData) throws Exception {
        Assert.notNull(entryData, "entryData must not be non-null");

        Object value = entryData.value;

        if(value != null && (value.getClass().getName().equals(TARGET_VALUE_TYPE_NAME)))
            entryData.removeFromOwningMap();
    }

}
