/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mimetypes {
    private static final Log log = LogFactory.getLog((Class)Mimetypes.class);
    public static final String MIMETYPE_XML = "application/xml";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIMETYPE_GZIP = "application/x-gzip";
    public static final String MIMETYPE_JETS3T_DIRECTORY = "application/x-directory";
    private static Mimetypes mimetypes = null;
    private HashMap extensionToMimetypeMap = new HashMap();

    private Mimetypes() {
    }

    public static Mimetypes getInstance() {
        if (mimetypes != null) {
            return mimetypes;
        }
        mimetypes = new Mimetypes();
        InputStream mimetypesFile = mimetypes.getClass().getResourceAsStream("/mime.types");
        if (mimetypesFile != null) {
            log.debug((Object)"Loading mime types from file in the classpath: mime.types");
            try {
                mimetypes.loadAndReplaceMimetypes(mimetypesFile);
            }
            catch (IOException e) {
                log.error((Object)"Failed to load mime types from file in the classpath: mime.types", (Throwable)e);
            }
        } else {
            log.warn((Object)"Unable to find 'mime.types' file in classpath");
        }
        return mimetypes;
    }

    public void loadAndReplaceMimetypes(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, " \t");
            if (st.countTokens() > 1) {
                String mimetype = st.nextToken();
                while (st.hasMoreTokens()) {
                    String extension = st.nextToken();
                    this.extensionToMimetypeMap.put(extension, mimetype);
                    log.debug((Object)("Setting mime type for extension '" + extension + "' to '" + mimetype + "'"));
                }
                continue;
            }
            log.debug((Object)("Ignoring mimetype with no associated file extensions: '" + line + "'"));
        }
    }

    public String getMimetype(String fileName) {
        int lastPeriodIndex = fileName.lastIndexOf(".");
        if (lastPeriodIndex > 0 && lastPeriodIndex + 1 < fileName.length()) {
            String ext = fileName.substring(lastPeriodIndex + 1);
            if (this.extensionToMimetypeMap.keySet().contains(ext)) {
                String mimetype = (String)this.extensionToMimetypeMap.get(ext);
                log.debug((Object)("Recognised extension '" + ext + "', mimetype is: '" + mimetype + "'"));
                return mimetype;
            }
            log.debug((Object)("Extension '" + ext + "' is unrecognized in mime type listing" + ", using default mime type: '" + MIMETYPE_OCTET_STREAM + "'"));
        } else {
            log.debug((Object)("File name has no extension, mime type cannot be recognised for: " + fileName));
        }
        return MIMETYPE_OCTET_STREAM;
    }

    public String getMimetype(File file) {
        return this.getMimetype(file.getName());
    }
}

