/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.UnrecoverableIOException;

public class InterruptableInputStream
extends InputStream
implements InputStreamWrapper {
    private final Log log = LogFactory.getLog((Class)InterruptableInputStream.class);
    private InputStream inputStream = null;
    private boolean interrupted = false;

    public InterruptableInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    private void maybeInterruptInputStream() throws IOException {
        if (this.interrupted) {
            this.log.debug((Object)("Input stream interrupted, closing underlying input stream " + this.inputStream.getClass()));
            try {
                this.close();
            }
            catch (IOException ioe) {
                this.log.warn((Object)"Unable to close underlying InputStream on interrupt");
            }
            throw new UnrecoverableIOException("Reading from input stream deliberately interrupted");
        }
    }

    public int read() throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.read(b, off, len);
    }

    public int available() throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }

    public void interrupt() {
        this.interrupted = true;
    }
}

