/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.contrib.proxy.PluginProxyUtil;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.HttpException;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.HttpMethodReleaseInputStream;
import org.jets3t.service.impl.rest.httpclient.RepeatableRequestEntity;
import org.jets3t.service.io.UnrecoverableIOException;
import org.jets3t.service.model.CreateBucketConfiguration;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketLoggingStatus;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.signedurl.SignedUrlHandler;

public class RestS3Service
extends S3Service
implements SignedUrlHandler {
    private static final long serialVersionUID = 3838005476674207543L;
    private final Log log = LogFactory.getLog((Class)RestS3Service.class);
    private static final String PROTOCOL_SECURE = "https";
    private static final String PROTOCOL_INSECURE = "http";
    private static final int PORT_SECURE = 443;
    private static final int PORT_INSECURE = 80;
    private HttpClient httpClient = null;
    private MultiThreadedHttpConnectionManager connectionManager = null;

    public RestS3Service(AWSCredentials awsCredentials) throws S3ServiceException {
        this(awsCredentials, null, null);
    }

    public RestS3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider) throws S3ServiceException {
        super(awsCredentials, invokingApplicationDescription);
        Jets3tProperties jets3tProperties = Jets3tProperties.getInstance("jets3t.properties");
        HostConfiguration hostConfig = new HostConfiguration();
        HttpConnectionManagerParams connectionParams = new HttpConnectionManagerParams();
        connectionParams.setConnectionTimeout(jets3tProperties.getIntProperty("httpclient.connection-timeout-ms", 60000));
        connectionParams.setSoTimeout(jets3tProperties.getIntProperty("httpclient.socket-timeout-ms", 60000));
        connectionParams.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, jets3tProperties.getIntProperty("httpclient.max-connections", 4));
        connectionParams.setStaleCheckingEnabled(jets3tProperties.getBoolProperty("httpclient.stale-checking-enabled", true));
        if (jets3tProperties.containsKey("httpclient.socket-receive-buffer")) {
            connectionParams.setReceiveBufferSize(jets3tProperties.getIntProperty("httpclient.socket-receive-buffer", 0));
        }
        if (jets3tProperties.containsKey("httpclient.socket-send-buffer")) {
            connectionParams.setSendBufferSize(jets3tProperties.getIntProperty("httpclient.socket-send-buffer", 0));
        }
        connectionParams.setTcpNoDelay(true);
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.connectionManager.setParams(connectionParams);
        HttpClientParams clientParams = new HttpClientParams();
        String userAgent = jets3tProperties.getStringProperty("httpclient.useragent", null);
        if (userAgent == null) {
            userAgent = ServiceUtils.getUserAgentDescription(this.getInvokingApplicationDescription());
        }
        this.log.debug((Object)("Setting user agent string: " + userAgent));
        clientParams.setParameter("http.useragent", (Object)userAgent);
        clientParams.setBooleanParameter("http.protocol.expect-continue", true);
        final int retryMaxCount = jets3tProperties.getIntProperty("httpclient.retry-max", 5);
        clientParams.setParameter("http.method.retry-handler", (Object)new HttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod httpMethod, IOException ioe, int executionCount) {
                if (executionCount > retryMaxCount) {
                    RestS3Service.this.log.warn((Object)("Retried connection " + executionCount + " times, which exceeds the maximum retry count of " + retryMaxCount));
                    return false;
                }
                if (ioe instanceof UnrecoverableIOException) {
                    RestS3Service.this.log.debug((Object)"Deliberate interruption, will not retry");
                    return false;
                }
                RestS3Service.this.log.warn((Object)("Retrying " + httpMethod.getName() + " request with path '" + httpMethod.getPath() + "' - attempt " + executionCount + " of " + retryMaxCount));
                try {
                    RestS3Service.this.buildAuthorizationString(httpMethod);
                }
                catch (S3ServiceException e) {
                    RestS3Service.this.log.warn((Object)"Unable to generate updated authorization string for retried request", (Throwable)e);
                }
                return true;
            }
        });
        this.httpClient = new HttpClient(clientParams, (HttpConnectionManager)this.connectionManager);
        this.httpClient.setHostConfiguration(hostConfig);
        boolean proxyAutodetect = jets3tProperties.getBoolProperty("httpclient.proxy-autodetect", true);
        String proxyHostAddress = jets3tProperties.getStringProperty("httpclient.proxy-host", null);
        int proxyPort = jets3tProperties.getIntProperty("httpclient.proxy-port", -1);
        if (proxyHostAddress != null && proxyPort != -1) {
            this.log.info((Object)("Using Proxy: " + proxyHostAddress + ":" + proxyPort));
            hostConfig.setProxy(proxyHostAddress, proxyPort);
        } else if (proxyAutodetect) {
            ProxyHost proxyHost = null;
            try {
                proxyHost = PluginProxyUtil.detectProxy(new URL("http://" + Constants.S3_HOSTNAME));
                if (proxyHost != null) {
                    this.log.info((Object)("Using Proxy: " + proxyHost.getHostName() + ":" + proxyHost.getPort()));
                    hostConfig.setProxyHost(proxyHost);
                }
            }
            catch (Throwable t) {
                this.log.debug((Object)"Unable to set proxy configuration", t);
            }
        }
        if (credentialsProvider != null) {
            this.log.debug((Object)("Using credentials provider class: " + credentialsProvider.getClass().getName()));
            this.httpClient.getParams().setParameter("http.authentication.credential-provider", (Object)credentialsProvider);
            this.httpClient.getParams().setAuthenticationPreemptive(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRequest(HttpMethodBase httpMethod, int expectedResponseCode) throws S3ServiceException {
        try {
            this.log.debug((Object)("Performing " + httpMethod.getName() + " request for '" + httpMethod.getURI().toString() + "', expecting response code " + expectedResponseCode));
            boolean completedWithoutRecoverableError = true;
            int internalErrorCount = 0;
            int requestTimeoutErrorCount = 0;
            int redirectCount = 0;
            boolean wasRecentlyRedirected = false;
            int responseCode = -1;
            do {
                if (!wasRecentlyRedirected) {
                    this.buildAuthorizationString((HttpMethod)httpMethod);
                } else {
                    wasRecentlyRedirected = false;
                }
                responseCode = this.httpClient.executeMethod((HttpMethod)httpMethod);
                if (responseCode == 307) {
                    Header locationHeader = httpMethod.getResponseHeader("location");
                    httpMethod.setURI(new URI(locationHeader.getValue(), true));
                    completedWithoutRecoverableError = false;
                    wasRecentlyRedirected = true;
                    if (++redirectCount > 5) {
                        throw new S3ServiceException("Encountered too many 307 Redirects, aborting request.");
                    }
                } else if (responseCode == 500) {
                    completedWithoutRecoverableError = false;
                    this.sleepOnInternalError(++internalErrorCount);
                } else {
                    completedWithoutRecoverableError = true;
                }
                String contentType = "";
                if (httpMethod.getResponseHeader("Content-Type") != null) {
                    contentType = httpMethod.getResponseHeader("Content-Type").getValue();
                }
                this.log.debug((Object)("Response for '" + httpMethod.getPath() + "'. Content-Type: " + contentType + ", Headers: " + Arrays.asList(httpMethod.getResponseHeaders())));
                if (responseCode == expectedResponseCode) continue;
                this.log.warn((Object)("Response '" + httpMethod.getPath() + "' - Unexpected response code " + responseCode + ", expected " + expectedResponseCode));
                if ("application/xml".equals(contentType) && httpMethod.getResponseBodyAsStream() != null && httpMethod.getResponseContentLength() != 0L) {
                    this.log.warn((Object)("Response '" + httpMethod.getPath() + "' - Received error response with XML message"));
                    StringBuffer sb = new StringBuffer();
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            sb.append(line + "\n");
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    httpMethod.releaseConnection();
                    S3ServiceException exception = new S3ServiceException("S3 " + httpMethod.getName() + " failed for '" + httpMethod.getPath() + "'", sb.toString());
                    if ("RequestTimeout".equals(exception.getS3ErrorCode())) {
                        int retryMaxCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("httpclient.retry-max", 5);
                        if (requestTimeoutErrorCount < retryMaxCount) {
                            this.log.warn((Object)("Response '" + httpMethod.getPath() + "' - Retrying connection that failed with RequestTimeout error" + ", attempt number " + ++requestTimeoutErrorCount + " of " + retryMaxCount));
                            completedWithoutRecoverableError = false;
                            continue;
                        }
                        this.log.warn((Object)("Response '" + httpMethod.getPath() + "' - Exceeded maximum number of retries for RequestTimeout errors: " + retryMaxCount));
                        throw exception;
                    }
                    if ("RequestTimeTooSkewed".equals(exception.getS3ErrorCode())) {
                        long timeDifferenceMS = this.adjustTime();
                        this.log.warn((Object)("Adjusted time offset in response to RequestTimeTooSkewed error. Local machine and S3 server disagree on the time by approximately " + timeDifferenceMS / 1000L + " seconds. Retrying connection."));
                        completedWithoutRecoverableError = false;
                        continue;
                    }
                    if (responseCode == 500) continue;
                    if (responseCode == 307) {
                        this.log.debug((Object)("Following Temporary Redirect to: " + httpMethod.getURI().toString()));
                        continue;
                    }
                    throw exception;
                }
                String responseText = null;
                byte[] responseBody = httpMethod.getResponseBody();
                if (responseBody != null && responseBody.length > 0) {
                    responseText = new String(responseBody);
                }
                this.log.debug((Object)"Releasing error response without XML content");
                httpMethod.releaseConnection();
                if (responseCode == 500) continue;
                HttpException httpException = new HttpException(httpMethod.getStatusCode(), httpMethod.getStatusText());
                throw new S3ServiceException("S3 " + httpMethod.getName() + " request failed for '" + httpMethod.getPath() + "' - " + "ResponseCode=" + httpMethod.getStatusCode() + ", ResponseMessage=" + httpMethod.getStatusText() + (responseText != null ? "\n" + responseText : ""), httpException);
            } while (!completedWithoutRecoverableError);
            if ((httpMethod.getResponseBodyAsStream() == null || httpMethod.getResponseBodyAsStream().available() == 0) && httpMethod.getResponseContentLength() == 0L) {
                this.log.debug((Object)"Releasing response without content");
                byte[] responseBody = httpMethod.getResponseBody();
                if (responseBody != null && responseBody.length > 0) {
                    throw new S3ServiceException("Oops, too keen to release connection with a non-empty response body");
                }
                httpMethod.releaseConnection();
            }
        }
        catch (S3ServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            this.log.debug((Object)("Releasing method after error: " + t.getMessage()));
            httpMethod.releaseConnection();
            throw new S3ServiceException("S3 " + httpMethod.getName() + " connection failed for '" + httpMethod.getPath() + "'", t);
        }
    }

    protected String addRequestParametersToUrlPath(String urlPath, Map requestParameters) throws S3ServiceException {
        if (requestParameters != null) {
            Iterator reqPropIter = requestParameters.entrySet().iterator();
            while (reqPropIter.hasNext()) {
                Map.Entry entry = reqPropIter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                urlPath = urlPath + (urlPath.indexOf("?") < 0 ? "?" : "&") + RestUtils.encodeUrlString(key.toString());
                if (value != null && value.toString().length() > 0) {
                    urlPath = urlPath + "=" + RestUtils.encodeUrlString(value.toString());
                    this.log.debug((Object)("Added request parameter: " + key + "=" + value));
                    continue;
                }
                this.log.debug((Object)("Added request parameter without value: " + key));
            }
        }
        return urlPath;
    }

    protected void addRequestHeadersToConnection(HttpMethodBase httpMethod, Map requestHeaders) {
        if (requestHeaders != null) {
            Iterator reqHeaderIter = requestHeaders.entrySet().iterator();
            while (reqHeaderIter.hasNext()) {
                Map.Entry entry = reqHeaderIter.next();
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                httpMethod.setRequestHeader(key, value);
                this.log.debug((Object)("Added request header to connection: " + key + "=" + value));
            }
        }
    }

    private Map convertHeadersToMap(Header[] headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; headers != null && i < headers.length; ++i) {
            map.put(headers[i].getName(), headers[i].getValue());
        }
        return map;
    }

    private void addMetadataToHeaders(HttpMethodBase httpMethod, Map metadata) {
        Iterator metaDataIter = metadata.entrySet().iterator();
        while (metaDataIter.hasNext()) {
            Map.Entry entry = metaDataIter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || !(value instanceof String)) continue;
            httpMethod.setRequestHeader(key, (String)value);
        }
    }

    protected HttpMethodBase performRestHead(String bucketName, String objectKey, Map requestParameters, Map requestHeaders) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("HEAD", bucketName, objectKey, requestParameters);
        this.addRequestHeadersToConnection(httpMethod, requestHeaders);
        this.performRequest(httpMethod, 200);
        return httpMethod;
    }

    protected HttpMethodBase performRestGet(String bucketName, String objectKey, Map requestParameters, Map requestHeaders) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("GET", bucketName, objectKey, requestParameters);
        this.addRequestHeadersToConnection(httpMethod, requestHeaders);
        int expectedStatusCode = 200;
        if (requestHeaders != null && requestHeaders.containsKey("Range")) {
            expectedStatusCode = 206;
        }
        this.performRequest(httpMethod, expectedStatusCode);
        return httpMethod;
    }

    protected HttpMethodAndByteCount performRestPut(String bucketName, String objectKey, Map metadata, Map requestParameters, RequestEntity requestEntity) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("PUT", bucketName, objectKey, requestParameters);
        Map renamedMetadata = RestUtils.renameMetadataKeys(metadata);
        this.addMetadataToHeaders(httpMethod, renamedMetadata);
        long contentLength = 0L;
        if (requestEntity != null) {
            ((PutMethod)httpMethod).setRequestEntity(requestEntity);
        } else {
            httpMethod.setRequestHeader("Content-Length", "0");
        }
        this.performRequest(httpMethod, 200);
        if (requestEntity != null) {
            contentLength = ((PutMethod)httpMethod).getRequestEntity().getContentLength();
        }
        httpMethod.releaseConnection();
        return new HttpMethodAndByteCount(httpMethod, contentLength);
    }

    protected HttpMethodBase performRestDelete(String bucketName, String objectKey) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("DELETE", bucketName, objectKey, null);
        this.performRequest(httpMethod, 204);
        this.log.debug((Object)"Releasing HttpMethod after delete");
        httpMethod.releaseConnection();
        return httpMethod;
    }

    protected HttpMethodBase setupConnection(String method, String bucketName, String objectKey, Map requestParameters) throws S3ServiceException {
        if (bucketName == null) {
            throw new S3ServiceException("Cannot connect to S3 Service with a null path");
        }
        String hostname = RestS3Service.generateS3HostnameForBucket(bucketName);
        String resourceString = "/";
        if (hostname.equals(Constants.S3_HOSTNAME) && bucketName != null && bucketName.length() > 0) {
            resourceString = resourceString + bucketName + "/";
        }
        resourceString = resourceString + (objectKey != null ? RestUtils.encodeUrlString(objectKey) : "");
        String url = null;
        url = this.isHttpsOnly() ? "https://" + hostname + ":" + 443 + resourceString : "http://" + hostname + ":" + 80 + resourceString;
        this.log.debug((Object)("S3 URL: " + url));
        url = this.addRequestParametersToUrlPath(url, requestParameters);
        PutMethod httpMethod = null;
        if ("PUT".equals(method)) {
            httpMethod = new PutMethod(url);
        } else if ("HEAD".equals(method)) {
            httpMethod = new HeadMethod(url);
        } else if ("GET".equals(method)) {
            httpMethod = new GetMethod(url);
        } else if ("DELETE".equals(method)) {
            httpMethod = new DeleteMethod(url);
        } else {
            throw new IllegalArgumentException("Unrecognised HTTP method name: " + method);
        }
        if (httpMethod.getRequestHeader("Date") == null) {
            httpMethod.setRequestHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        }
        if (httpMethod.getRequestHeader("Content-Type") == null) {
            httpMethod.setRequestHeader("Content-Type", "");
        }
        return httpMethod;
    }

    protected void buildAuthorizationString(HttpMethod httpMethod) throws S3ServiceException {
        String queryString;
        if (!this.isAuthenticatedConnection()) {
            this.log.debug((Object)"Service has no AWS Credential and is un-authenticated, skipping authorization");
            return;
        }
        this.log.debug((Object)("Adding authorization for AWS Access Key '" + this.getAWSCredentials().getAccessKey() + "'."));
        String hostname = null;
        try {
            hostname = httpMethod.getURI().getHost();
        }
        catch (URIException e) {
            this.log.error((Object)"Unable to determine hostname target for request", (Throwable)e);
        }
        String fullUrl = httpMethod.getPath();
        if (!Constants.S3_HOSTNAME.equals(hostname)) {
            int subdomainOffset = hostname.indexOf("." + Constants.S3_HOSTNAME);
            fullUrl = subdomainOffset > 0 ? "/" + hostname.substring(0, subdomainOffset) + httpMethod.getPath() : "/" + hostname + httpMethod.getPath();
        }
        if ((queryString = httpMethod.getQueryString()) != null && queryString.length() > 0) {
            fullUrl = fullUrl + "?" + queryString;
        }
        httpMethod.setRequestHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        String canonicalString = RestUtils.makeCanonicalString(httpMethod.getName(), fullUrl, this.convertHeadersToMap(httpMethod.getRequestHeaders()), null);
        this.log.debug((Object)("Canonical string ('|' is a newline): " + canonicalString.replace('\n', '|')));
        String signedCanonical = ServiceUtils.signWithHmacSha1(this.getAWSCredentials().getSecretKey(), canonicalString);
        String authorizationString = "AWS " + this.getAWSCredentials().getAccessKey() + ":" + signedCanonical;
        httpMethod.setRequestHeader("Authorization", authorizationString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBucketAccessible(String bucketName) throws S3ServiceException {
        this.log.debug((Object)("Checking existence of bucket: " + bucketName));
        HttpMethodBase httpMethod = null;
        try {
            httpMethod = this.performRestHead(bucketName, null, null, null);
            if (httpMethod.getResponseBodyAsStream() != null) {
                httpMethod.getResponseBodyAsStream().close();
            }
        }
        catch (S3ServiceException e) {
            this.log.debug((Object)("Bucket does not exist: " + bucketName), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.log.warn((Object)"Unable to close response body input stream", (Throwable)e);
        }
        finally {
            this.log.debug((Object)"Releasing un-wanted bucket HEAD response");
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
        return true;
    }

    protected S3Bucket[] listAllBucketsImpl() throws S3ServiceException {
        this.log.debug((Object)("Listing all buckets for AWS user: " + this.getAWSCredentials().getAccessKey()));
        String bucketName = "";
        HttpMethodBase httpMethod = this.performRestGet(bucketName, null, null, null);
        String contentType = httpMethod.getResponseHeader("Content-Type").getValue();
        if (!"application/xml".equals(contentType)) {
            throw new S3ServiceException("Expected XML document response from S3 but received content type " + contentType);
        }
        S3Bucket[] buckets = new XmlResponsesSaxParser().parseListMyBucketsResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getBuckets();
        return buckets;
    }

    protected S3Object[] listObjectsImpl(String bucketName, String prefix, String delimiter, long maxListingLength) throws S3ServiceException {
        return this.listObjectsInternal(bucketName, prefix, delimiter, maxListingLength, true, null).getObjects();
    }

    protected S3ObjectsChunk listObjectsChunkedImpl(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey) throws S3ServiceException {
        return this.listObjectsInternal(bucketName, prefix, delimiter, maxListingLength, false, priorLastKey);
    }

    protected S3ObjectsChunk listObjectsInternal(String bucketName, String prefix, String delimiter, long maxListingLength, boolean automaticallyMergeChunks, String priorLastKey) throws S3ServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (prefix != null) {
            parameters.put("prefix", prefix);
        }
        if (delimiter != null) {
            parameters.put("delimiter", delimiter);
        }
        if (maxListingLength > 0L) {
            parameters.put("max-keys", String.valueOf(maxListingLength));
        }
        ArrayList<S3Object> objects = new ArrayList<S3Object>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        boolean incompleteListing = true;
        int ioErrorRetryCount = 0;
        while (incompleteListing) {
            if (priorLastKey != null) {
                parameters.put("marker", priorLastKey);
            } else {
                parameters.remove("marker");
            }
            HttpMethodBase httpMethod = this.performRestGet(bucketName, null, parameters, null);
            XmlResponsesSaxParser.ListBucketHandler listBucketHandler = null;
            try {
                listBucketHandler = new XmlResponsesSaxParser().parseListBucketObjectsResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod));
                ioErrorRetryCount = 0;
            }
            catch (S3ServiceException e) {
                if (e.getCause() instanceof IOException && ioErrorRetryCount < 5) {
                    ++ioErrorRetryCount;
                    this.log.warn((Object)"Retrying bucket listing failure due to IO error", (Throwable)e);
                    continue;
                }
                throw e;
            }
            S3Object[] partialObjects = listBucketHandler.getObjects();
            this.log.debug((Object)("Found " + partialObjects.length + " objects in one batch"));
            objects.addAll(Arrays.asList(partialObjects));
            String[] partialCommonPrefixes = listBucketHandler.getCommonPrefixes();
            this.log.debug((Object)("Found " + partialCommonPrefixes.length + " common prefixes in one batch"));
            commonPrefixes.addAll(Arrays.asList(partialCommonPrefixes));
            incompleteListing = listBucketHandler.isListingTruncated();
            if (incompleteListing) {
                priorLastKey = listBucketHandler.getMarkerForNextListing();
                this.log.debug((Object)("Yet to receive complete listing of bucket contents, last key for prior chunk: " + priorLastKey));
            } else {
                priorLastKey = null;
            }
            if (automaticallyMergeChunks) continue;
            break;
        }
        if (automaticallyMergeChunks) {
            this.log.debug((Object)("Found " + objects.size() + " objects in total"));
            return new S3ObjectsChunk(objects.toArray(new S3Object[objects.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), null);
        }
        return new S3ObjectsChunk(objects.toArray(new S3Object[objects.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), priorLastKey);
    }

    protected void deleteObjectImpl(String bucketName, String objectKey) throws S3ServiceException {
        this.performRestDelete(bucketName, objectKey);
    }

    protected AccessControlList getObjectAclImpl(String bucketName, String objectKey) throws S3ServiceException {
        this.log.debug((Object)("Retrieving Access Control List for bucketName=" + bucketName + ", objectKkey=" + objectKey));
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, objectKey, requestParameters, null);
        return new XmlResponsesSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getAccessControlList();
    }

    protected AccessControlList getBucketAclImpl(String bucketName) throws S3ServiceException {
        this.log.debug((Object)("Retrieving Access Control List for Bucket: " + bucketName));
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
        return new XmlResponsesSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getAccessControlList();
    }

    protected void putObjectAclImpl(String bucketName, String objectKey, AccessControlList acl) throws S3ServiceException {
        this.putAclImpl(bucketName, objectKey, acl);
    }

    protected void putBucketAclImpl(String bucketName, AccessControlList acl) throws S3ServiceException {
        String fullKey = bucketName;
        this.putAclImpl(fullKey, null, acl);
    }

    protected void putAclImpl(String bucketName, String objectKey, AccessControlList acl) throws S3ServiceException {
        this.log.debug((Object)("Setting Access Control List for bucketName=" + bucketName + ", objectKey=" + objectKey));
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "text/plain");
        try {
            String aclAsXml = acl.toXml();
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            this.performRestPut(bucketName, objectKey, metadata, requestParameters, (RequestEntity)new StringRequestEntity(aclAsXml, "text/plain", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode ACL XML document", e);
        }
    }

    protected S3Bucket createBucketImpl(String bucketName, String location, AccessControlList acl) throws S3ServiceException {
        this.log.debug((Object)("Creating bucket with name: " + bucketName));
        HashMap<String, String> metadata = new HashMap<String, String>();
        StringRequestEntity requestEntity = null;
        if (location != null) {
            metadata.put("Content-Type", "text/xml");
            try {
                CreateBucketConfiguration config = new CreateBucketConfiguration(location);
                metadata.put("Content-Length", String.valueOf(config.toXml().length()));
                requestEntity = new StringRequestEntity(config.toXml(), "text/xml", "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new S3ServiceException("Unable to encode CreateBucketConfiguration XML document", e);
            }
        }
        Map map = this.createObjectImpl(bucketName, null, null, (RequestEntity)requestEntity, metadata, acl);
        S3Bucket bucket = new S3Bucket(bucketName, location);
        bucket.setAcl(acl);
        bucket.replaceAllMetadata(map);
        return bucket;
    }

    protected void deleteBucketImpl(String bucketName) throws S3ServiceException {
        this.performRestDelete(bucketName, null);
    }

    protected S3Object putObjectImpl(String bucketName, S3Object object) throws S3ServiceException {
        this.log.debug((Object)("Creating Object with key " + object.getKey() + " in bucket " + bucketName));
        Object requestEntity = null;
        if (object.getDataInputStream() != null) {
            if (object.containsMetadata("Content-Length")) {
                this.log.debug((Object)("Uploading object data with Content-Length: " + object.getContentLength()));
                requestEntity = new RepeatableRequestEntity(object.getKey(), object.getDataInputStream(), object.getContentType(), object.getContentLength());
            } else {
                this.log.warn((Object)"Content-Length of data stream not set, will automatically determine data length in memory");
                requestEntity = new InputStreamRequestEntity(object.getDataInputStream(), -2L);
            }
        }
        Map map = this.createObjectImpl(bucketName, object.getKey(), object.getContentType(), (RequestEntity)requestEntity, object.getMetadataMap(), object.getAcl());
        try {
            object.closeDataInputStream();
        }
        catch (IOException e) {
            this.log.warn((Object)("Unable to close data input stream for object '" + object.getKey() + "'"), (Throwable)e);
        }
        object.replaceAllMetadata(map);
        return object;
    }

    protected Map createObjectImpl(String bucketName, String objectKey, String contentType, RequestEntity requestEntity, Map metadata, AccessControlList acl) throws S3ServiceException {
        metadata = metadata == null ? new HashMap<String, String>() : new HashMap(metadata);
        if (contentType != null) {
            metadata.put("Content-Type", contentType);
        } else {
            metadata.put("Content-Type", "application/octet-stream");
        }
        boolean putNonStandardAcl = false;
        if (acl != null) {
            if (AccessControlList.REST_CANNED_PRIVATE.equals(acl)) {
                metadata.put("x-amz-acl", "private");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ.equals(acl)) {
                metadata.put("x-amz-acl", "public-read");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ_WRITE.equals(acl)) {
                metadata.put("x-amz-acl", "public-read-write");
            } else if (AccessControlList.REST_CANNED_AUTHENTICATED_READ.equals(acl)) {
                metadata.put("x-amz-acl", "authenticated-read");
            } else {
                putNonStandardAcl = true;
            }
        }
        this.log.debug((Object)("Creating object bucketName=" + bucketName + ", objectKey=" + objectKey + "." + " Content-Type=" + metadata.get("Content-Type") + " Including data? " + (requestEntity != null) + " Metadata: " + metadata + " ACL: " + acl));
        HttpMethodAndByteCount methodAndByteCount = this.performRestPut(bucketName, objectKey, metadata, null, requestEntity);
        HttpMethodBase httpMethod = methodAndByteCount.getHttpMethod();
        Map<String, String> map = new HashMap<String, String>();
        map.putAll(metadata);
        map.putAll(this.convertHeadersToMap(httpMethod.getResponseHeaders()));
        map.put("Content-Length", String.valueOf(methodAndByteCount.getByteCount()));
        map = ServiceUtils.cleanRestMetadataMap(map);
        if (putNonStandardAcl) {
            this.log.debug((Object)"Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
            this.putAclImpl(bucketName, objectKey, acl);
        }
        return map;
    }

    protected S3Object getObjectDetailsImpl(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        return this.getObjectImpl(true, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, null, null);
    }

    protected S3Object getObjectImpl(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        return this.getObjectImpl(false, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
    }

    private S3Object getObjectImpl(boolean headOnly, String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        int i;
        StringBuffer tags;
        this.log.debug((Object)("Retrieving " + (headOnly ? "Head" : "All") + " information for bucket " + bucketName + " and object " + objectKey));
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (ifModifiedSince != null) {
            requestHeaders.put("If-Modified-Since", ServiceUtils.formatRfc822Date(ifModifiedSince.getTime()));
            this.log.debug((Object)("Only retrieve object if-modified-since:" + ifModifiedSince));
        }
        if (ifUnmodifiedSince != null) {
            requestHeaders.put("If-Unmodified-Since", ServiceUtils.formatRfc822Date(ifUnmodifiedSince.getTime()));
            this.log.debug((Object)("Only retrieve object if-unmodified-since:" + ifUnmodifiedSince));
        }
        if (ifMatchTags != null) {
            tags = new StringBuffer();
            for (i = 0; i < ifMatchTags.length; ++i) {
                if (i > 0) {
                    tags.append(",");
                }
                tags.append(ifMatchTags[i]);
            }
            requestHeaders.put("If-Match", tags.toString());
            this.log.debug((Object)("Only retrieve object by hash if-match:" + tags.toString()));
        }
        if (ifNoneMatchTags != null) {
            tags = new StringBuffer();
            for (i = 0; i < ifNoneMatchTags.length; ++i) {
                if (i > 0) {
                    tags.append(",");
                }
                tags.append(ifNoneMatchTags[i]);
            }
            requestHeaders.put("If-None-Match", tags.toString());
            this.log.debug((Object)("Only retrieve object by hash if-none-match:" + tags.toString()));
        }
        if (byteRangeStart != null || byteRangeEnd != null) {
            String range = "bytes=" + (byteRangeStart != null ? byteRangeStart.toString() : "") + "-" + (byteRangeEnd != null ? byteRangeEnd.toString() : "");
            requestHeaders.put("Range", range);
            this.log.debug((Object)("Only retrieve object if it is within range:" + range));
        }
        HttpMethodBase httpMethod = null;
        httpMethod = headOnly ? this.performRestHead(bucketName, objectKey, null, requestHeaders) : this.performRestGet(bucketName, objectKey, null, requestHeaders);
        HashMap map = new HashMap();
        map.putAll(this.convertHeadersToMap(httpMethod.getResponseHeaders()));
        S3Object responseObject = new S3Object(objectKey);
        responseObject.setBucketName(bucketName);
        responseObject.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(map));
        responseObject.setMetadataComplete(true);
        if (!headOnly) {
            HttpMethodReleaseInputStream releaseIS = new HttpMethodReleaseInputStream((HttpMethod)httpMethod);
            responseObject.setDataInputStream(releaseIS);
        } else {
            this.log.debug((Object)"Releasing HttpMethod after HEAD");
            httpMethod.releaseConnection();
        }
        return responseObject;
    }

    protected String getBucketLocationImpl(String bucketName) throws S3ServiceException {
        this.log.debug((Object)("Retrieving location of Bucket: " + bucketName));
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("location", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
        return new XmlResponsesSaxParser().parseBucketLocationResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod));
    }

    protected S3BucketLoggingStatus getBucketLoggingStatusImpl(String bucketName) throws S3ServiceException {
        this.log.debug((Object)("Retrieving Logging Status for Bucket: " + bucketName));
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("logging", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
        return new XmlResponsesSaxParser().parseLoggingStatusResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getBucketLoggingStatus();
    }

    protected void setBucketLoggingStatusImpl(String bucketName, S3BucketLoggingStatus status) throws S3ServiceException {
        this.log.debug((Object)("Setting Logging Status for bucket: " + bucketName));
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("logging", "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "text/plain");
        try {
            String statusAsXml = status.toXml();
            metadata.put("Content-Length", String.valueOf(statusAsXml.length()));
            this.performRestPut(bucketName, null, metadata, requestParameters, (RequestEntity)new StringRequestEntity(statusAsXml, "text/plain", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode LoggingStatus XML document", e);
        }
    }

    public S3Object putObjectWithSignedUrl(String signedPutUrl, S3Object object) throws S3ServiceException {
        PutMethod putMethod = new PutMethod(signedPutUrl);
        Map renamedMetadata = RestUtils.renameMetadataKeys(object.getMetadataMap());
        this.addMetadataToHeaders((HttpMethodBase)putMethod, renamedMetadata);
        if (!object.containsMetadata("Content-Length")) {
            throw new IllegalStateException("Content-Length must be specified for objects put using signed PUT URLs");
        }
        if (object.getDataInputStream() != null) {
            putMethod.setRequestEntity((RequestEntity)new RepeatableRequestEntity(object.getKey(), object.getDataInputStream(), object.getContentType(), object.getContentLength()));
        }
        this.performRequest((HttpMethodBase)putMethod, 200);
        putMethod.releaseConnection();
        try {
            S3Object uploadedObject = ServiceUtils.buildObjectFromUrl(putMethod.getURI().getHost(), putMethod.getPath());
            object.setBucketName(uploadedObject.getBucketName());
            object.setKey(uploadedObject.getKey());
            try {
                object.setLastModifiedDate(ServiceUtils.parseRfc822Date(putMethod.getResponseHeader("Date").getValue()));
            }
            catch (ParseException e1) {
                this.log.warn((Object)"Unable to interpret date of object PUT in S3", (Throwable)e1);
            }
            try {
                object.closeDataInputStream();
            }
            catch (IOException e) {
                this.log.warn((Object)("Unable to close data input stream for object '" + object.getKey() + "'"), (Throwable)e);
            }
        }
        catch (URIException e) {
            throw new S3ServiceException("Unable to lookup URI for object created with signed PUT", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to determine name of object created with signed PUT", e);
        }
        return object;
    }

    public void deleteObjectWithSignedUrl(String signedDeleteUrl) throws S3ServiceException {
        DeleteMethod deleteMethod = new DeleteMethod(signedDeleteUrl);
        this.performRequest((HttpMethodBase)deleteMethod, 204);
        deleteMethod.releaseConnection();
    }

    public S3Object getObjectWithSignedUrl(String signedGetUrl) throws S3ServiceException {
        return this.getObjectWithSignedUrlImpl(signedGetUrl, false);
    }

    public S3Object getObjectDetailsWithSignedUrl(String signedHeadUrl) throws S3ServiceException {
        return this.getObjectWithSignedUrlImpl(signedHeadUrl, true);
    }

    public AccessControlList getObjectAclWithSignedUrl(String signedAclUrl) throws S3ServiceException {
        GetMethod httpMethod = new GetMethod(signedAclUrl);
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        this.performRequest((HttpMethodBase)httpMethod, 200);
        return new XmlResponsesSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getAccessControlList();
    }

    public void putObjectAclWithSignedUrl(String signedAclUrl, AccessControlList acl) throws S3ServiceException {
        PutMethod putMethod = new PutMethod(signedAclUrl);
        if (acl != null) {
            if (AccessControlList.REST_CANNED_PRIVATE.equals(acl)) {
                putMethod.addRequestHeader("x-amz-acl", "private");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ.equals(acl)) {
                putMethod.addRequestHeader("x-amz-acl", "public-read");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ_WRITE.equals(acl)) {
                putMethod.addRequestHeader("x-amz-acl", "public-read-write");
            } else if (AccessControlList.REST_CANNED_AUTHENTICATED_READ.equals(acl)) {
                putMethod.addRequestHeader("x-amz-acl", "authenticated-read");
            } else {
                try {
                    String aclAsXml = acl.toXml();
                    putMethod.setRequestEntity((RequestEntity)new StringRequestEntity(aclAsXml, "text/xml", "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new S3ServiceException("Unable to encode ACL XML document", e);
                }
            }
        }
        this.performRequest((HttpMethodBase)putMethod, 200);
        putMethod.releaseConnection();
    }

    private S3Object getObjectWithSignedUrlImpl(String signedGetOrHeadUrl, boolean headOnly) throws S3ServiceException {
        Object httpMethod = null;
        httpMethod = headOnly ? new HeadMethod(signedGetOrHeadUrl) : new GetMethod(signedGetOrHeadUrl);
        this.performRequest((HttpMethodBase)httpMethod, 200);
        HashMap map = new HashMap();
        map.putAll(this.convertHeadersToMap(httpMethod.getResponseHeaders()));
        S3Object responseObject = null;
        try {
            responseObject = ServiceUtils.buildObjectFromUrl(httpMethod.getURI().getHost(), httpMethod.getPath().substring(1));
        }
        catch (URIException e) {
            throw new S3ServiceException("Unable to lookup URI for object created with signed PUT", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to determine name of object created with signed PUT", e);
        }
        responseObject.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(map));
        responseObject.setMetadataComplete(true);
        if (!headOnly) {
            HttpMethodReleaseInputStream releaseIS = new HttpMethodReleaseInputStream((HttpMethod)httpMethod);
            responseObject.setDataInputStream(releaseIS);
        } else {
            this.log.debug((Object)"Releasing HttpMethod after HEAD");
            httpMethod.releaseConnection();
        }
        return responseObject;
    }

    private class HttpMethodAndByteCount {
        private HttpMethodBase httpMethod = null;
        private long byteCount = 0L;

        public HttpMethodAndByteCount(HttpMethodBase httpMethod, long byteCount) {
            this.httpMethod = httpMethod;
            this.byteCount = byteCount;
        }

        public HttpMethodBase getHttpMethod() {
            return this.httpMethod;
        }

        public long getByteCount() {
            return this.byteCount;
        }
    }
}

