/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.TLSMessage;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import javax.security.cert.X509Certificate;

public class TLSServerHandler
implements ProfileServer {
    static final boolean bundledJSSE;
    static Method getProtocol;
    static Method getEnabledProtocols;
    static Method setEnabledProtocols;
    static Method getWantClientAuth;
    static Method setWantClientAuth;
    protected SSLSocket ts = null;
    private boolean completed = false;
    private Map env = null;
    private MessageConnection mc = null;
    private String profile = null;
    private Subject subject = null;
    private static final String X500_PRINCIPAL = "javax.security.auth.x500.X500Principal";
    private static final ClassLogger logger;
    static /* synthetic */ Class class$javax$net$ssl$SSLSession;
    static /* synthetic */ Class class$javax$net$ssl$SSLSocket;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;

    static String getProtocol(SSLSession sSLSession) throws IOException {
        try {
            return (String)getProtocol.invoke((Object)sSLSession, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        catch (Throwable throwable) {
            throw (IOException)EnvHelp.initCause(new IOException(throwable.getMessage()), throwable);
        }
    }

    static String[] getEnabledProtocols(SSLSocket sSLSocket) throws IOException {
        try {
            return (String[])getEnabledProtocols.invoke((Object)sSLSocket, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        catch (Throwable throwable) {
            throw (IOException)EnvHelp.initCause(new IOException(throwable.getMessage()), throwable);
        }
    }

    static void setEnabledProtocols(SSLSocket sSLSocket, String[] stringArray) throws IOException {
        try {
            setEnabledProtocols.invoke((Object)sSLSocket, new Object[]{stringArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        catch (Throwable throwable) {
            throw (IOException)EnvHelp.initCause(new IOException(throwable.getMessage()), throwable);
        }
    }

    static Boolean getWantClientAuth(SSLSocket sSLSocket) throws IOException {
        try {
            return (Boolean)getWantClientAuth.invoke((Object)sSLSocket, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        catch (Throwable throwable) {
            throw (IOException)EnvHelp.initCause(new IOException(throwable.getMessage()), throwable);
        }
    }

    static void setWantClientAuth(SSLSocket sSLSocket, Boolean bl) throws IOException {
        try {
            setWantClientAuth.invoke((Object)sSLSocket, bl);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        catch (Throwable throwable) {
            throw (IOException)EnvHelp.initCause(new IOException(throwable.getMessage()), throwable);
        }
    }

    public TLSServerHandler(String string, Map map) {
        this.profile = string;
        this.env = map;
    }

    public void initialize(MessageConnection messageConnection, Subject subject) throws IOException {
        int n;
        String[] stringArray;
        int n2;
        String[] stringArray2;
        String string;
        this.mc = messageConnection;
        this.subject = subject;
        Socket socket = null;
        if (!(messageConnection instanceof SocketConnectionIf)) {
            throw new IOException("Not an instance of SocketConnectionIf");
        }
        socket = ((SocketConnectionIf)((Object)messageConnection)).getSocket();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)this.env.get("jmx.remote.tls.socket.factory");
        if (sSLSocketFactory == null) {
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        String string2 = socket.getInetAddress().getHostName();
        int n3 = socket.getPort();
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Hostname = " + string2);
            logger.trace("initialize", "TLS: Port = " + n3);
        }
        this.ts = (SSLSocket)sSLSocketFactory.createSocket(socket, string2, n3, true);
        this.ts.setUseClientMode(false);
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Socket Client Mode = " + this.ts.getUseClientMode());
        }
        if (bundledJSSE) {
            string = (String)this.env.get("jmx.remote.tls.enabled.protocols");
            if (string != null) {
                stringArray2 = new StringTokenizer(string, " ");
                n2 = stringArray2.countTokens();
                stringArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    stringArray[n] = stringArray2.nextToken();
                }
                TLSServerHandler.setEnabledProtocols(this.ts, stringArray);
            }
            if (logger.traceOn()) {
                logger.trace("initialize", "TLS: Enabled Protocols");
                stringArray2 = TLSServerHandler.getEnabledProtocols(this.ts);
                if (stringArray2 != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringBuffer.append(stringArray2[i]);
                        if (i + 1 >= stringArray2.length) continue;
                        stringBuffer.append(", ");
                    }
                    logger.trace("initialize", "TLS: [" + stringBuffer + "]");
                } else {
                    logger.trace("initialize", "TLS: []");
                }
            }
        }
        if ((string = (String)this.env.get("jmx.remote.tls.enabled.cipher.suites")) != null) {
            stringArray2 = new StringTokenizer(string, " ");
            n2 = stringArray2.countTokens();
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = stringArray2.nextToken();
            }
            this.ts.setEnabledCipherSuites(stringArray);
        }
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Enabled Cipher Suites");
            stringArray2 = this.ts.getEnabledCipherSuites();
            if (stringArray2 != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringBuffer.append(stringArray2[i]);
                    if (i + 1 >= stringArray2.length) continue;
                    stringBuffer.append(", ");
                }
                logger.trace("initialize", "TLS: [" + stringBuffer + "]");
            } else {
                logger.trace("initialize", "TLS: []");
            }
        }
        if ((stringArray2 = (String)this.env.get("jmx.remote.tls.need.client.authentication")) != null) {
            this.ts.setNeedClientAuth(Boolean.valueOf((String)stringArray2));
        }
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Socket Need Client Authentication = " + this.ts.getNeedClientAuth());
        }
        if (bundledJSSE) {
            String string3 = (String)this.env.get("jmx.remote.tls.want.client.authentication");
            if (string3 != null) {
                TLSServerHandler.setWantClientAuth(this.ts, Boolean.valueOf(string3));
            }
            if (logger.traceOn()) {
                logger.trace("initialize", "TLS: Socket Want Client Authentication = " + TLSServerHandler.getWantClientAuth(this.ts));
            }
        }
    }

    public ProfileMessage produceMessage() throws IOException {
        TLSMessage tLSMessage = new TLSMessage(2);
        if (logger.traceOn()) {
            logger.trace("produceMessage", ">>>>> TLS server message <<<<<");
            logger.trace("produceMessage", "Profile Name : " + tLSMessage.getProfileName());
            logger.trace("produceMessage", "Status : " + tLSMessage.getStatus());
        }
        this.completed = true;
        return tLSMessage;
    }

    public void consumeMessage(ProfileMessage profileMessage) throws IOException {
        if (!(profileMessage instanceof TLSMessage)) {
            throw new IOException("Unexpected profile message type: " + profileMessage.getClass().getName());
        }
        TLSMessage tLSMessage = (TLSMessage)profileMessage;
        if (logger.traceOn()) {
            logger.trace("consumeMessage", ">>>>> TLS client message <<<<<");
            logger.trace("consumeMessage", "Profile Name : " + tLSMessage.getProfileName());
            logger.trace("consumeMessage", "Status : " + tLSMessage.getStatus());
        }
        if (tLSMessage.getStatus() != 1) {
            throw new IOException("Unexpected TLS status [" + tLSMessage.getStatus() + "]");
        }
    }

    public boolean isComplete() {
        return this.completed;
    }

    public Subject activate() throws IOException {
        if (logger.traceOn()) {
            logger.trace("activate", ">>>>> TLS handshake <<<<<");
            logger.trace("activate", "TLS: Start TLS Handshake");
        }
        this.ts.startHandshake();
        SSLSession sSLSession = this.ts.getSession();
        if (sSLSession != null) {
            if (logger.traceOn()) {
                logger.trace("activate", "TLS: getCipherSuite = " + sSLSession.getCipherSuite());
                logger.trace("activate", "TLS: getPeerHost = " + sSLSession.getPeerHost());
                if (bundledJSSE) {
                    logger.trace("activate", "TLS: getProtocol = " + TLSServerHandler.getProtocol(sSLSession));
                }
            }
            try {
                X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
                if (x509CertificateArray != null && x509CertificateArray[0] != null) {
                    Object object;
                    Principal principal = x509CertificateArray[0].getSubjectDN();
                    String string = principal.getName();
                    if (bundledJSSE) {
                        try {
                            object = Class.forName(X500_PRINCIPAL);
                            Constructor<?> constructor = ((Class)object).getConstructor(class$java$lang$String == null ? (class$java$lang$String = TLSServerHandler.class$("java.lang.String")) : class$java$lang$String);
                            principal = (Principal)constructor.newInstance(string);
                        }
                        catch (Exception exception) {
                            logger.trace("activate", "TLS: Client Authentication: " + exception.getMessage());
                            logger.debug("activate", exception);
                            logger.trace("activate", "TLS: Client Authentication: Got exception building the javax.security.auth.x500.X500Principal from the principal stored in the client's certificate.");
                            logger.trace("activate", "TLS: Client Authentication: Subject DN = [" + string + "]");
                            logger.trace("activate", "TLS: Client Authentication: Default to JMXPrincipal[" + string + "]");
                            principal = new JMXPrincipal(string);
                        }
                    } else {
                        principal = new JMXPrincipal(string);
                    }
                    object = principal;
                    if (this.subject == null) {
                        this.subject = new Subject();
                    }
                    AccessController.doPrivileged(new PrivilegedAction((Principal)object){
                        private final /* synthetic */ Principal val$principal;
                        {
                            this.val$principal = principal;
                        }

                        public Object run() {
                            TLSServerHandler.this.subject.getPrincipals().add(this.val$principal);
                            return null;
                        }
                    });
                    logger.trace("activate", "TLS: Client Authentication OK! SubjectDN = " + object);
                } else {
                    logger.trace("activate", "TLS: No Client Authentication");
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                logger.trace("activate", "TLS: No Client Authentication: " + sSLPeerUnverifiedException.getMessage());
            }
            logger.trace("activate", "TLS: Finish TLS Handshake");
        }
        ((SocketConnectionIf)((Object)this.mc)).setSocket(this.ts);
        return this.subject;
    }

    public void terminate() throws IOException {
    }

    public String getName() {
        return this.profile;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        boolean bl = false;
        try {
            getProtocol = (class$javax$net$ssl$SSLSession == null ? (class$javax$net$ssl$SSLSession = TLSServerHandler.class$("javax.net.ssl.SSLSession")) : class$javax$net$ssl$SSLSession).getMethod("getProtocol", new Class[0]);
            getEnabledProtocols = (class$javax$net$ssl$SSLSocket == null ? (class$javax$net$ssl$SSLSocket = TLSServerHandler.class$("javax.net.ssl.SSLSocket")) : class$javax$net$ssl$SSLSocket).getMethod("getEnabledProtocols", new Class[0]);
            setEnabledProtocols = (class$javax$net$ssl$SSLSocket == null ? (class$javax$net$ssl$SSLSocket = TLSServerHandler.class$("javax.net.ssl.SSLSocket")) : class$javax$net$ssl$SSLSocket).getMethod("setEnabledProtocols", array$Ljava$lang$String == null ? (array$Ljava$lang$String = TLSServerHandler.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            getWantClientAuth = (class$javax$net$ssl$SSLSocket == null ? (class$javax$net$ssl$SSLSocket = TLSServerHandler.class$("javax.net.ssl.SSLSocket")) : class$javax$net$ssl$SSLSocket).getMethod("getWantClientAuth", new Class[0]);
            setWantClientAuth = (class$javax$net$ssl$SSLSocket == null ? (class$javax$net$ssl$SSLSocket = TLSServerHandler.class$("javax.net.ssl.SSLSocket")) : class$javax$net$ssl$SSLSocket).getMethod("setWantClientAuth", Boolean.TYPE);
        }
        catch (Throwable throwable) {
            bl = true;
        }
        bundledJSSE = !bl;
        logger = new ClassLogger("javax.management.remote.misc", "TLSServerHandler");
    }
}

