/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.util.MessageLogger;

public abstract class AbstractMessageLogger
implements MessageLogger {
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();
    private boolean showProgress = true;

    public final void debug(String string) {
        this.log(string, 4);
    }

    public final void verbose(String string) {
        this.log(string, 3);
    }

    public final void deprecated(String string) {
        this.log("DEPRECATED: " + string, 1);
    }

    public final void info(String string) {
        this.log(string, 2);
    }

    public final void rawinfo(String string) {
        this.rawlog(string, 2);
    }

    public final void warn(String string) {
        this.log("WARN: " + string, 3);
        this.problems.add("WARN:  " + string);
        this.warns.add(string);
    }

    public void error(String string) {
        this.log("ERROR: " + string, 3);
        this.problems.add("\tERROR: " + string);
        this.errors.add(string);
    }

    public final List getProblems() {
        return this.problems;
    }

    public final void sumupProblems() {
        LogOptions.sumupProblems(this);
        this.clearProblems();
    }

    public final void clearProblems() {
        this.problems.clear();
        this.warns.clear();
        this.errors.clear();
    }

    public final List getErrors() {
        return this.errors;
    }

    public final List getWarns() {
        return this.warns;
    }

    public final void progress() {
        if (this.showProgress) {
            this.doProgress();
        }
    }

    public final void endProgress(String string) {
        if (this.showProgress) {
            this.doEndProgress(string);
        }
    }

    protected abstract void doProgress();

    protected abstract void doEndProgress(String var1);
}

