/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMAxisIteratorBase;
import org.apache.xml.dtm.ref.DTMDefaultBaseTraversers;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseIterators
extends DTMDefaultBaseTraversers {
    public DTMDefaultBaseIterators(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing) {
        super(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing);
    }

    public DTMAxisIterator getTypedAxisIterator(int axis, int type) {
        DTMAxisIterator iterator = null;
        switch (axis) {
            case 13: {
                iterator = new TypedSingletonIterator(type);
                break;
            }
            case 3: {
                iterator = new TypedChildrenIterator(type);
                break;
            }
            case 10: {
                return new ParentIterator().setNodeType(type);
            }
            case 0: {
                return new TypedAncestorIterator(type);
            }
            case 1: {
                return new TypedAncestorIterator(type).includeSelf();
            }
            case 2: {
                return new TypedAttributeIterator(type);
            }
            case 4: {
                iterator = new TypedDescendantIterator(type);
                break;
            }
            case 5: {
                iterator = new TypedDescendantIterator(type).includeSelf();
                break;
            }
            case 6: {
                iterator = new TypedFollowingIterator(type);
                break;
            }
            case 11: {
                iterator = new TypedPrecedingIterator(type);
                break;
            }
            case 7: {
                iterator = new TypedFollowingSiblingIterator(type);
                break;
            }
            case 12: {
                iterator = new TypedPrecedingSiblingIterator(type);
                break;
            }
            case 9: {
                iterator = new TypedNamespaceIterator(type);
                break;
            }
            case 19: {
                iterator = new TypedRootIterator(type);
                break;
            }
            default: {
                throw new DTMException(XSLMessages.createMessage(165, new Object[]{Axis.names[axis]}));
            }
        }
        return iterator;
    }

    public DTMAxisIterator getAxisIterator(int axis) {
        DTMAxisIterator iterator = null;
        switch (axis) {
            case 13: {
                iterator = new SingletonIterator();
                break;
            }
            case 3: {
                iterator = new ChildrenIterator();
                break;
            }
            case 10: {
                return new ParentIterator();
            }
            case 0: {
                return new AncestorIterator();
            }
            case 1: {
                return new AncestorIterator().includeSelf();
            }
            case 2: {
                return new AttributeIterator();
            }
            case 4: {
                iterator = new DescendantIterator();
                break;
            }
            case 5: {
                iterator = new DescendantIterator().includeSelf();
                break;
            }
            case 6: {
                iterator = new FollowingIterator();
                break;
            }
            case 11: {
                iterator = new PrecedingIterator();
                break;
            }
            case 7: {
                iterator = new FollowingSiblingIterator();
                break;
            }
            case 12: {
                iterator = new PrecedingSiblingIterator();
                break;
            }
            case 9: {
                iterator = new NamespaceIterator();
                break;
            }
            case 19: {
                iterator = new RootIterator();
                break;
            }
            default: {
                throw new DTMException(XSLMessages.createMessage(166, new Object[]{Axis.names[axis]}));
            }
        }
        return iterator;
    }

    private final class TypedSingletonIterator
    extends SingletonIterator {
        private final int _nodeType;

        public TypedSingletonIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public int next() {
            int result = super.next();
            return DTMDefaultBaseIterators.this.getExpandedTypeID(result) == this._nodeType ? result : -1;
        }
    }

    private class SingletonIterator
    extends InternalAxisIteratorBase {
        private boolean _isConstant;

        public SingletonIterator() {
            this(Integer.MIN_VALUE, false);
        }

        public SingletonIterator(int node) {
            this(node, false);
        }

        public SingletonIterator(int node, boolean constant) {
            this._currentNode = this._startNode = node;
            this._isConstant = constant;
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isConstant) {
                this._currentNode = this._startNode;
                return this.resetPosition();
            }
            if (this._isRestartable) {
                if (this._currentNode == Integer.MIN_VALUE) {
                    this._currentNode = this._startNode = node;
                }
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator reset() {
            if (this._isConstant) {
                this._currentNode = this._startNode;
                return this.resetPosition();
            }
            boolean temp = this._isRestartable;
            this._isRestartable = true;
            this.setStartNode(this._startNode);
            this._isRestartable = temp;
            return this;
        }

        public int next() {
            int result = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(result);
        }
    }

    private class NthDescendantIterator
    extends DescendantIterator {
        int _pos;

        public NthDescendantIterator(int pos) {
            this._pos = pos;
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            int node;
            while ((node = super.next()) != -1) {
                void var1_1;
                node = DTMDefaultBaseIterators.this.makeNodeIdentity((int)var1_1);
                int parent = DTMDefaultBaseIterators.this._parent(node);
                int child = DTMDefaultBaseIterators.this._firstch(parent);
                int pos = 0;
                do {
                    short type;
                    if (1 != (type = DTMDefaultBaseIterators.this._type(child))) continue;
                    ++pos;
                } while (pos < this._pos && (child = DTMDefaultBaseIterators.this._nextsib(child)) != -1);
                if (node != child) continue;
                return node;
            }
            return -1;
        }
    }

    private final class TypedDescendantIterator
    extends DescendantIterator {
        private final int _nodeType;

        public TypedDescendantIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public int next() {
            int node;
            while ((node = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(node) != this._nodeType) {
            }
            return node;
        }
    }

    private class DescendantIterator
    extends InternalAxisIteratorBase {
        private DescendantIterator() {
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                node = DTMDefaultBaseIterators.this.makeNodeIdentity(node);
                this._startNode = node--;
                if (this._includeSelf) {
                    // empty if block
                }
                this._currentNode = node;
                return this.resetPosition();
            }
            return this;
        }

        protected boolean isDescendant(int identity) {
            return this._startNode == identity || DTMDefaultBaseIterators.this._parent(identity) >= this._startNode;
        }

        public int next() {
            int node;
            short type;
            do {
                if (-1 != (type = DTMDefaultBaseIterators.this._type(node = ++this._currentNode)) && this.isDescendant(node)) continue;
                return -1;
            } while (2 == type || 13 == type);
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(node));
        }
    }

    private final class TypedAncestorIterator
    extends AncestorIterator {
        private final int _nodeType;

        public TypedAncestorIterator(int type) {
            this._nodeType = type;
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            int node;
            while ((node = super.next()) != -1) {
                void var1_1;
                if (DTMDefaultBaseIterators.this.getExpandedTypeID((int)var1_1) != this._nodeType) continue;
                return this.returnNode((int)var1_1);
            }
            return -1;
        }

        public int getLast() {
            int last = -1;
            int curr = this._startNode;
            while (curr != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(curr) == this._nodeType) {
                    last = curr;
                }
                curr = DTMDefaultBaseIterators.this.getParent(curr);
            }
            return last;
        }
    }

    private class AncestorIterator
    extends InternalAxisIteratorBase {
        NodeVector m_ancestors = new NodeVector();
        int m_ancestorsPos;
        int m_realStartNode;

        private AncestorIterator() {
        }

        public int getStartNode() {
            return this.m_realStartNode;
        }

        public final boolean isReverse() {
            return true;
        }

        public int getLast() {
            return this._startNode;
        }

        /*
         * WARNING - void declaration
         */
        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                void e;
                AncestorIterator clone = (AncestorIterator)super.clone();
                clone._startNode = this._startNode;
                return e;
            }
            catch (CloneNotSupportedException e) {
                throw new DTMException(XSLMessages.createMessage(167, null));
            }
        }

        public DTMAxisIterator setStartNode(int node) {
            this.m_realStartNode = node;
            if (this._isRestartable) {
                this._startNode = this._includeSelf ? node : DTMDefaultBaseIterators.this.getParent(node);
                node = this._startNode;
                while (node != -1) {
                    this.m_ancestors.addElement(node);
                    node = DTMDefaultBaseIterators.this.getParent(node);
                }
                this.m_ancestorsPos = this.m_ancestors.size() - 1;
                this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator reset() {
            this.m_ancestorsPos = this.m_ancestors.size() - 1;
            this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
            return this.resetPosition();
        }

        public int next() {
            int pos;
            int next = this._currentNode;
            this._currentNode = (pos = --this.m_ancestorsPos) >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
            return this.returnNode(next);
        }
    }

    private final class TypedFollowingIterator
    extends FollowingIterator {
        private final int _nodeType;

        public TypedFollowingIterator(int type) {
            this._nodeType = type;
        }

        public int next() {
            int node;
            while ((node = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(node) != this._nodeType) {
            }
            return this.returnNode(node);
        }
    }

    private class FollowingIterator
    extends InternalAxisIteratorBase {
        DTMAxisTraverser m_traverser;

        public FollowingIterator() {
            this.m_traverser = DTMDefaultBaseIterators.this.getAxisTraverser(6);
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = this.m_traverser.first(node);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int node = this._currentNode;
            this._currentNode = this.m_traverser.next(this._startNode, this._currentNode);
            return this.returnNode(node);
        }
    }

    private final class TypedPrecedingIterator
    extends PrecedingIterator {
        private final int _nodeType;

        public TypedPrecedingIterator(int type) {
            this._nodeType = type;
        }

        public int next() {
            int node;
            while ((node = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(node) != this._nodeType) {
            }
            return node;
        }
    }

    private class PrecedingIterator
    extends InternalAxisIteratorBase {
        private final int _maxAncestors = 8;
        private int[] _stack = new int[8];
        private int _sp;
        private int _oldsp;

        private PrecedingIterator() {
        }

        public boolean isReverse() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                void e;
                PrecedingIterator clone = (PrecedingIterator)super.clone();
                int[] stackCopy = new int[this._stack.length];
                System.arraycopy(this._stack, 0, stackCopy, 0, this._stack.length);
                clone._stack = stackCopy;
                return e;
            }
            catch (CloneNotSupportedException e) {
                throw new DTMException(XSLMessages.createMessage(167, null));
            }
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node = DTMDefaultBaseIterators.this.makeNodeIdentity(node);
                int index = 0;
                this._stack[0] = node;
                int parent = node;
                while ((parent = DTMDefaultBaseIterators.this._parent(parent)) != -1) {
                    if (++index == this._stack.length) {
                        int[] stack = new int[index + 4];
                        System.arraycopy(this._stack, 0, stack, 0, index);
                        this._stack = stack;
                    }
                    this._stack[index] = parent;
                }
                if (index > 0) {
                    --index;
                }
                this._currentNode = this._stack[index];
                this._oldsp = this._sp = index;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            ++this._currentNode;
            while (this._sp >= 0) {
                if (this._currentNode < this._stack[this._sp]) {
                    if (DTMDefaultBaseIterators.this._type(this._currentNode) != 2 && DTMDefaultBaseIterators.this._type(this._currentNode) != 13) {
                        return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(this._currentNode));
                    }
                } else {
                    --this._sp;
                }
                ++this._currentNode;
            }
            return -1;
        }

        public DTMAxisIterator reset() {
            this._sp = this._oldsp;
            return this.resetPosition();
        }
    }

    private final class TypedPrecedingSiblingIterator
    extends PrecedingSiblingIterator {
        private final int _nodeType;

        public TypedPrecedingSiblingIterator(int type) {
            this._nodeType = type;
        }

        public int next() {
            int node;
            while ((node = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(node) != this._nodeType) {
            }
            return node;
        }
    }

    private class PrecedingSiblingIterator
    extends InternalAxisIteratorBase {
        private PrecedingSiblingIterator() {
        }

        public boolean isReverse() {
            return true;
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                if (node == -1) {
                    this._currentNode = node;
                    return this.resetPosition();
                }
                short type = DTMDefaultBaseIterators.this.m_expandedNameTable.getType(DTMDefaultBaseIterators.this.getExpandedTypeID(node));
                if (2 == type || 13 == type) {
                    this._currentNode = node;
                } else {
                    this._currentNode = DTMDefaultBaseIterators.this.getParent(node);
                    this._currentNode = -1 != this._currentNode ? DTMDefaultBaseIterators.this.getFirstChild(this._currentNode) : node;
                }
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._currentNode == this._startNode) {
                return -1;
            }
            int node = this._currentNode;
            this._currentNode = DTMDefaultBaseIterators.this.getNextSibling(node);
            return this.returnNode(node);
        }
    }

    private final class TypedAttributeIterator
    extends InternalAxisIteratorBase {
        private final int _nodeType;

        public TypedAttributeIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                node = DTMDefaultBaseIterators.this.getFirstAttribute(node);
                while (node != -1) {
                    if (DTMDefaultBaseIterators.this.getExpandedTypeID(node) == this._nodeType) break;
                    node = DTMDefaultBaseIterators.this.getNextAttribute(node);
                }
                this._currentNode = node;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int node = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(node);
        }
    }

    private final class AttributeIterator
    extends InternalAxisIteratorBase {
        private AttributeIterator() {
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstAttribute(node);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int node = this._currentNode;
            this._currentNode = DTMDefaultBaseIterators.this.getNextAttribute(node);
            return this.returnNode(node);
        }
    }

    private final class TypedFollowingSiblingIterator
    extends FollowingSiblingIterator {
        private final int _nodeType;

        public TypedFollowingSiblingIterator(int type) {
            this._nodeType = type;
        }

        public int next() {
            int node;
            while ((node = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(node) != this._nodeType) {
            }
            return node;
        }
    }

    private class FollowingSiblingIterator
    extends InternalAxisIteratorBase {
        private FollowingSiblingIterator() {
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._currentNode = this._startNode = node;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            this._currentNode = DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            return this.returnNode(this._currentNode);
        }
    }

    private final class NamespaceAttributeIterator
    extends InternalAxisIteratorBase {
        private final int _nsType;

        public NamespaceAttributeIterator(int nsType) {
            this._nsType = nsType;
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstNamespaceNode(node, false);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int node = this._currentNode;
            if (-1 != node) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextNamespaceNode(this._startNode, node, false);
            }
            return this.returnNode(node);
        }
    }

    private class TypedRootIterator
    extends RootIterator {
        private final int _nodeType;

        public TypedRootIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public int next() {
            int node = super.next();
            while (node != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(node) == this._nodeType) {
                    this._currentNode = node;
                    return this.returnNode(node);
                }
                node = super.next();
            }
            return -1;
        }
    }

    private class RootIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = DTMDefaultBaseIterators.this.getDocumentRoot(node);
                this._currentNode = -1;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._startNode == this._currentNode) {
                return -1;
            }
            this._currentNode = this._startNode;
            return this.returnNode(this._startNode);
        }
    }

    private class TypedNamespaceIterator
    extends NamespaceIterator {
        private final int _nodeType;

        public TypedNamespaceIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public int next() {
            int node = super.next();
            while (node != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(node) == this._nodeType) {
                    this._currentNode = node;
                    return this.returnNode(node);
                }
                node = super.next();
            }
            return -1;
        }
    }

    private class NamespaceIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstNamespaceNode(node, true);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int node = this._currentNode;
            if (-1 != node) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextNamespaceNode(this._startNode, node, true);
            }
            return this.returnNode(node);
        }
    }

    private final class NamespaceChildrenIterator
    extends InternalAxisIteratorBase {
        private final int _nsType;

        public NamespaceChildrenIterator(int type) {
            this._nsType = type;
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = -2;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int node = -2 == this._currentNode ? DTMDefaultBaseIterators.this.getFirstChild(this._startNode) : DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            while (node != -1) {
                if (DTMDefaultBaseIterators.this.getNamespaceType(node) == this._nsType) {
                    this._currentNode = node;
                    return this.returnNode(node);
                }
                node = DTMDefaultBaseIterators.this.getNextSibling(node);
            }
            return -1;
        }
    }

    private final class TypedChildrenIterator
    extends InternalAxisIteratorBase {
        private final int _nodeType;

        public TypedChildrenIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = -2;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int node = -2 == this._currentNode ? DTMDefaultBaseIterators.this.getFirstChild(this._startNode) : DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            while (node != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(node) == this._nodeType) {
                    this._currentNode = node;
                    return this.returnNode(node);
                }
                node = DTMDefaultBaseIterators.this.getNextSibling(node);
            }
            return -1;
        }
    }

    private final class ParentIterator
    extends InternalAxisIteratorBase {
        private int _nodeType = -1;

        private ParentIterator() {
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = DTMDefaultBaseIterators.this.getParent(node);
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator setNodeType(int type) {
            this._nodeType = type;
            return this;
        }

        public int next() {
            int result = this._currentNode;
            result = this._nodeType != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(this._currentNode) != this._nodeType ? -1 : this._currentNode;
            this._currentNode = -1;
            return this.returnNode(result);
        }
    }

    private final class ChildrenIterator
    extends InternalAxisIteratorBase {
        private ChildrenIterator() {
        }

        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = -2;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            this._currentNode = -2 == this._currentNode ? DTMDefaultBaseIterators.this.getFirstChild(this._startNode) : DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            return this.returnNode(this._currentNode);
        }
    }

    private abstract class InternalAxisIteratorBase
    extends DTMAxisIteratorBase {
        protected int _currentNode;

        private InternalAxisIteratorBase() {
        }

        public void setMark() {
            this._markedNode = this._currentNode;
        }

        public void gotoMark() {
            this._currentNode = this._markedNode;
        }
    }
}

