"""
Contains low level wrapper around the chipmunk_ffi methods exported by 
chipmunk_ffi.h as those methods are not automatically generated by the wrapper 
generator.

You usually dont need to use this module directly, instead use the high level binding in pymunk
"""
from ctypes import *
from .vec2d import Vec2d
from ._chipmunk import cpBool, cpFloat
from ._chipmunk import cpBB, cpBody, cpVect, cpArbiter, cpShape, cpConstraint, cpGrooveJoint
from ._chipmunk import chipmunk_lib
from ._chipmunk import function_pointer

cpBodyIsSleeping = (function_pointer(cpBool, POINTER(cpBody))).in_dll(chipmunk_lib, '_cpBodyIsSleeping')
cpBodyIsRogue = (function_pointer(cpBool, POINTER(cpBody))).in_dll(chipmunk_lib, '_cpBodyIsRogue')
cpBodyIsStatic = (function_pointer(cpBool, POINTER(cpBody))).in_dll(chipmunk_lib, '_cpBodyIsStatic')
cpBodyLocal2World = (function_pointer(cpVect, POINTER(cpBody), cpVect)).in_dll(chipmunk_lib, '_cpBodyLocal2World')
cpBodyWorld2Local = (function_pointer(cpVect, POINTER(cpBody), cpVect)).in_dll(chipmunk_lib, '_cpBodyWorld2Local')

cpArbiterGetShapes = (function_pointer(None, POINTER(cpArbiter), POINTER(POINTER(cpShape)), POINTER(POINTER(cpShape)))).in_dll(chipmunk_lib, '_cpArbiterGetShapes')
cpArbiterIsFirstContact = (function_pointer(cpBool, POINTER(cpArbiter))).in_dll(chipmunk_lib, '_cpArbiterIsFirstContact')

cpConstraintGetImpulse = (function_pointer(cpFloat, POINTER(cpConstraint))).in_dll(chipmunk_lib, '_cpConstraintGetImpulse')


cpBBNew = (function_pointer(cpBB, cpFloat, cpFloat, cpFloat, cpFloat)).in_dll(chipmunk_lib, '_cpBBNew')
cpBBIntersects = (function_pointer(c_int, cpBB, cpBB)).in_dll(chipmunk_lib, '_cpBBIntersects')
cpBBContainsBB = (function_pointer(c_int, cpBB, cpBB)).in_dll(chipmunk_lib, '_cpBBContainsBB')
cpBBContainsVect = (function_pointer(c_int, cpBB, cpVect)).in_dll(chipmunk_lib, '_cpBBContainsVect')
cpBBMerge = (function_pointer(cpBB, cpBB, cpBB)).in_dll(chipmunk_lib, '_cpBBMerge')
cpBBExpand = (function_pointer(cpBB, cpBB, cpVect)).in_dll(chipmunk_lib, '_cpBBExpand')

cpShapeGetBB = (function_pointer(cpBB, POINTER(cpShape))).in_dll(chipmunk_lib, '_cpShapeGetBB')

#TODO: Use cpBBClampVect from Chipmunk when its available.
cpfclamp = (function_pointer(cpFloat, cpFloat, cpFloat, cpFloat)).in_dll(chipmunk_lib, '_cpfclamp')
def cpBBClampVect(bb, v):
    return Vec2d(cpfclamp(v.x, bb.l, bb.r), cpfclamp(v.y, bb.b, bb.t))

#unused for now..
#cpGrooveJointGetGrooveA = (function_pointer(cpVect, POINTER(cpGrooveJoint))).in_dll(chipmunk_lib, '_cpGrooveJointGetGrooveA')
#cpGrooveJointGetGrooveB = (function_pointer(cpVect, POINTER(cpGrooveJoint))).in_dll(chipmunk_lib, '_cpGrooveJointGetGrooveA')
