/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;

public class AvoidDuplicateLiteralsRule
extends AbstractRule {
    private static final char DEFAULT_SEPARATOR = ',';
    private static final String EXCEPTION_LIST_PROPERTY = "exceptionlist";
    private static final String SEPARATOR_PROPERTY = "separator";
    private static final String EXCEPTION_FILE_NAME_PROPERTY = "exceptionfile";
    private Map literals = new HashMap();
    private Set exceptions = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object visit(ASTCompilationUnit node, Object data) {
        block14: {
            block15: {
                this.literals.clear();
                if (!this.hasProperty(EXCEPTION_LIST_PROPERTY)) break block15;
                ExceptionParser p = this.hasProperty(SEPARATOR_PROPERTY) ? new ExceptionParser(this.getStringProperty(SEPARATOR_PROPERTY).charAt(0)) : new ExceptionParser(',');
                this.exceptions = p.parse(this.getStringProperty(EXCEPTION_LIST_PROPERTY));
                break block14;
            }
            if (this.hasProperty(EXCEPTION_FILE_NAME_PROPERTY)) {
                String line;
                this.exceptions = new HashSet();
                BufferedReader reader = null;
                reader = new LineNumberReader(new BufferedReader(new FileReader(new File(this.getStringProperty(EXCEPTION_FILE_NAME_PROPERTY)))));
                while ((line = ((LineNumberReader)reader).readLine()) != null) {
                    this.exceptions.add(line);
                }
                Object var6_7 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block14;
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                }
                break block14;
                {
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        var6_7 = null;
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block14;
                        }
                        catch (IOException ioe2) {
                            ioe2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
        super.visit(node, data);
        int threshold = this.getIntProperty("threshold");
        Iterator i = this.literals.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            List occurrences = (List)this.literals.get(key);
            if (occurrences.size() < threshold) continue;
            Object[] args = new Object[]{key, new Integer(occurrences.size()), new Integer(((SimpleNode)occurrences.get(0)).getBeginLine())};
            this.addViolation(data, (Node)((SimpleNode)occurrences.get(0)), args);
        }
        return data;
    }

    public Object visit(ASTLiteral node, Object data) {
        if (node.getImage() == null || node.getImage().indexOf(34) == -1 || node.getImage().length() < 5) {
            return data;
        }
        if (this.exceptions.contains(node.getImage().substring(1, node.getImage().length() - 1))) {
            return data;
        }
        if (this.literals.containsKey(node.getImage())) {
            List occurrences = (List)this.literals.get(node.getImage());
            occurrences.add(node);
        } else {
            ArrayList<ASTLiteral> occurrences = new ArrayList<ASTLiteral>();
            occurrences.add(node);
            this.literals.put(node.getImage(), occurrences);
        }
        return data;
    }

    public static class ExceptionParser {
        private static final char ESCAPE_CHAR = '\\';
        private char delimiter;

        public ExceptionParser(char delimiter) {
            this.delimiter = delimiter;
        }

        public Set parse(String in) {
            HashSet<String> result = new HashSet<String>();
            StringBuffer currentToken = new StringBuffer();
            boolean inEscapeMode = false;
            for (int i = 0; i < in.length(); ++i) {
                if (inEscapeMode) {
                    inEscapeMode = false;
                    currentToken.append(in.charAt(i));
                    continue;
                }
                if (in.charAt(i) == '\\') {
                    inEscapeMode = true;
                    continue;
                }
                if (in.charAt(i) == this.delimiter) {
                    result.add(currentToken.toString());
                    currentToken = new StringBuffer();
                    continue;
                }
                currentToken.append(in.charAt(i));
            }
            if (currentToken.length() > 0) {
                result.add(currentToken.toString());
            }
            return result;
        }
    }
}

