/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.util.NumericConstants;

public class TooManyFields
extends AbstractRule {
    private static final int DEFAULT_MAXFIELDS = 15;
    private Map stats;
    private Map nodes;
    private int maxFields;
    private static final PropertyDescriptor maxFieldsDescriptor = new IntegerProperty("maxfields", "Maximum allowable fields per class", 15, 1.0f);
    private static final Map propertyDescriptorsByName = TooManyFields.asFixedMap(maxFieldsDescriptor);
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;

    public Object visit(ASTCompilationUnit node, Object data) {
        this.maxFields = this.getIntProperty(maxFieldsDescriptor);
        this.stats = new HashMap(5);
        this.nodes = new HashMap(5);
        List l = node.findChildrenOfType(ASTFieldDeclaration.class);
        Iterator<Object> it = l.iterator();
        while (it.hasNext()) {
            ASTClassOrInterfaceDeclaration clazz;
            ASTFieldDeclaration fd = (ASTFieldDeclaration)it.next();
            if (fd.isFinal() && fd.isStatic() || (clazz = (ASTClassOrInterfaceDeclaration)fd.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration == null ? TooManyFields.class$("net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration") : class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration)) == null || clazz.isInterface()) continue;
            this.bumpCounterFor(clazz);
        }
        it = this.stats.keySet().iterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            int val = (Integer)this.stats.get(k);
            SimpleNode n = (SimpleNode)this.nodes.get(k);
            if (val <= this.maxFields) continue;
            this.addViolation(data, n);
        }
        return data;
    }

    private void bumpCounterFor(ASTClassOrInterfaceDeclaration clazz) {
        String key = clazz.getImage();
        if (!this.stats.containsKey(key)) {
            this.stats.put(key, NumericConstants.ZERO);
            this.nodes.put(key, clazz);
        }
        Integer i = new Integer((Integer)this.stats.get(key) + 1);
        this.stats.put(key, i);
    }

    protected Map propertiesByName() {
        return propertyDescriptorsByName;
    }
}

