/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.ast.ASTConditionalExpression;
import net.sourceforge.pmd.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.ast.ASTDoStatement;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.ast.ASTStatement;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTTryStatement;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.stat.StatisticalRule;
import net.sourceforge.pmd.util.NumericConstants;

public class NpathComplexity
extends StatisticalRule {
    private int complexityMultipleOf(SimpleJavaNode node, int npathStart, Object data) {
        int npath = npathStart;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleJavaNode simpleNode = (SimpleJavaNode)node.jjtGetChild(i);
            npath *= ((Integer)simpleNode.jjtAccept(this, data)).intValue();
        }
        return npath;
    }

    private int complexitySumOf(SimpleJavaNode node, int npathStart, Object data) {
        int npath = npathStart;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleJavaNode simpleNode = (SimpleJavaNode)node.jjtGetChild(i);
            npath += ((Integer)simpleNode.jjtAccept(this, data)).intValue();
        }
        return npath;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        int npath = this.complexityMultipleOf(node, 1, data);
        DataPoint point = new DataPoint();
        point.setNode(node);
        point.setScore(1.0 * (double)npath);
        point.setMessage(this.getMessage());
        this.addDataPoint(point);
        return new Integer(npath);
    }

    public Object visit(SimpleJavaNode node, Object data) {
        int npath = this.complexityMultipleOf(node, 1, data);
        return new Integer(npath);
    }

    public Object visit(ASTIfStatement node, Object data) {
        int boolCompIf = NpathComplexity.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        int complexity = 0;
        ArrayList<Node> statementChildren = new ArrayList<Node>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i).getClass() != (class$net$sourceforge$pmd$ast$ASTStatement == null ? NpathComplexity.class$("net.sourceforge.pmd.ast.ASTStatement") : class$net$sourceforge$pmd$ast$ASTStatement)) continue;
            statementChildren.add(node.jjtGetChild(i));
        }
        if (statementChildren.isEmpty() || statementChildren.size() == 1 && node.hasElse() || statementChildren.size() != 1 && !node.hasElse()) {
            throw new IllegalStateException("If node has wrong number of children");
        }
        if (!node.hasElse()) {
            ++complexity;
        }
        Iterator iter = statementChildren.iterator();
        while (iter.hasNext()) {
            SimpleJavaNode element = (SimpleJavaNode)iter.next();
            complexity += ((Integer)element.jjtAccept(this, data)).intValue();
        }
        return new Integer(boolCompIf + complexity);
    }

    public Object visit(ASTWhileStatement node, Object data) {
        int boolCompWhile = NpathComplexity.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        Integer nPathWhile = (Integer)((SimpleJavaNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return new Integer(boolCompWhile + nPathWhile + 1);
    }

    public Object visit(ASTDoStatement node, Object data) {
        int boolCompDo = NpathComplexity.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        Integer nPathDo = (Integer)((SimpleJavaNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return new Integer(boolCompDo + nPathDo + 1);
    }

    public Object visit(ASTForStatement node, Object data) {
        int boolCompFor = NpathComplexity.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        Integer nPathFor = (Integer)((SimpleJavaNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return new Integer(boolCompFor + nPathFor + 1);
    }

    public Object visit(ASTReturnStatement node, Object data) {
        ASTExpression expr = (ASTExpression)node.getFirstChildOfType(ASTExpression.class);
        if (expr == null) {
            return NumericConstants.ONE;
        }
        List andNodes = expr.findChildrenOfType(ASTConditionalAndExpression.class);
        List orNodes = expr.findChildrenOfType(ASTConditionalOrExpression.class);
        int boolCompReturn = andNodes.size() + orNodes.size();
        if (boolCompReturn > 0) {
            return new Integer(boolCompReturn);
        }
        return NumericConstants.ONE;
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        int boolCompSwitch = NpathComplexity.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        int npath = 0;
        int caseRange = 0;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleJavaNode simpleNode = (SimpleJavaNode)node.jjtGetChild(i);
            if (simpleNode instanceof ASTSwitchLabel) {
                npath += caseRange;
                caseRange = 1;
                continue;
            }
            Integer complexity = (Integer)simpleNode.jjtAccept(this, data);
            caseRange *= complexity.intValue();
        }
        return new Integer(boolCompSwitch + (npath += caseRange));
    }

    public Object visit(ASTTryStatement node, Object data) {
        int npath = this.complexitySumOf(node, 0, data);
        return new Integer(npath);
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        if (node.isTernary()) {
            int npath = this.complexitySumOf(node, 0, data);
            return new Integer(npath += 2);
        }
        return NumericConstants.ONE;
    }

    public static int sumExpressionComplexity(ASTExpression expr) {
        SimpleJavaNode element;
        if (expr == null) {
            return 0;
        }
        List andNodes = expr.findChildrenOfType(ASTConditionalAndExpression.class);
        List orNodes = expr.findChildrenOfType(ASTConditionalOrExpression.class);
        int children = 0;
        Iterator iter = orNodes.iterator();
        while (iter.hasNext()) {
            element = (ASTConditionalOrExpression)iter.next();
            children += element.jjtGetNumChildren();
            --children;
        }
        iter = andNodes.iterator();
        while (iter.hasNext()) {
            element = (ASTConditionalAndExpression)iter.next();
            children += element.jjtGetNumChildren();
            --children;
        }
        return children;
    }

    protected void makeViolations(RuleContext ctx, Set p) {
        Iterator points = p.iterator();
        while (points.hasNext()) {
            DataPoint point = (DataPoint)points.next();
            this.addViolation((Object)ctx, (Node)point.getNode(), new String[]{((ASTMethodDeclaration)point.getNode()).getMethodName(), String.valueOf((int)point.getScore())});
        }
    }
}

