/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa.pathfinder;

import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.pathfinder.CurrentPath;
import net.sourceforge.pmd.dfa.pathfinder.Executable;
import net.sourceforge.pmd.dfa.pathfinder.PathElement;

public class DAAPathFinder {
    private static final int MAX_PATHS = 5000;
    private IDataFlowNode rootNode;
    private Executable shim;
    private CurrentPath currentPath = new CurrentPath();
    private DefaultMutableTreeNode stack = new DefaultMutableTreeNode();
    private int maxPaths;

    public DAAPathFinder(IDataFlowNode rootNode, Executable shim) {
        this.rootNode = rootNode;
        this.shim = shim;
        this.maxPaths = 5000;
    }

    public DAAPathFinder(IDataFlowNode rootNode, Executable shim, int maxPaths) {
        this.rootNode = rootNode;
        this.shim = shim;
        this.maxPaths = maxPaths;
    }

    public void run() {
        this.phase1();
    }

    private void phase1() {
        this.currentPath.addLast(this.rootNode);
        int i = 0;
        boolean flag = true;
        do {
            this.phase2(flag);
            this.shim.execute(this.currentPath);
            flag = false;
        } while (++i < this.maxPaths && this.phase3());
    }

    private void phase2(boolean flag) {
        while (!this.currentPath.isEndNode()) {
            if (this.currentPath.isBranch() || this.currentPath.isFirstDoStatement()) {
                if (flag) {
                    this.addNodeToTree();
                }
                flag = true;
                if (this.countLoops() <= 2) {
                    this.addCurrentChild();
                    continue;
                }
                this.addLastChild();
                continue;
            }
            this.addCurrentChild();
        }
    }

    private boolean phase3() {
        while (!this.currentPath.isEmpty()) {
            if (this.currentPath.isBranch()) {
                if (this.countLoops() == 1) {
                    if (this.hasMoreChildren()) {
                        this.incChild();
                        return true;
                    }
                    this.removeFromTree();
                    this.currentPath.removeLast();
                    continue;
                }
                this.removeFromTree();
                this.currentPath.removeLast();
                continue;
            }
            this.currentPath.removeLast();
        }
        return false;
    }

    private boolean hasMoreChildren() {
        PathElement e = (PathElement)this.stack.getLastLeaf().getUserObject();
        return e.currentChild + 1 < e.node.getChildren().size();
    }

    private void addLastChild() {
        PathElement e = (PathElement)this.stack.getLastLeaf().getUserObject();
        for (int i = e.node.getChildren().size() - 1; i >= 0; --i) {
            if (i == e.currentChild) continue;
            this.currentPath.addLast((IDataFlowNode)e.node.getChildren().get(i));
            break;
        }
    }

    private void addCurrentChild() {
        if (this.currentPath.isBranch()) {
            PathElement last = (PathElement)this.stack.getLastLeaf().getUserObject();
            IDataFlowNode inode = this.currentPath.getLast();
            if (inode.getChildren().size() > last.currentChild) {
                IDataFlowNode child = (IDataFlowNode)inode.getChildren().get(last.currentChild);
                this.currentPath.addLast(child);
            }
        } else {
            IDataFlowNode inode = this.currentPath.getLast();
            IDataFlowNode child = (IDataFlowNode)inode.getChildren().get(0);
            this.currentPath.addLast(child);
        }
    }

    private void addNodeToTree() {
        block11: {
            PathElement ref;
            DefaultMutableTreeNode level;
            block10: {
                if (this.currentPath.isFirstDoStatement()) {
                    level = this.stack;
                    IDataFlowNode doBranch = this.currentPath.getDoBranchNodeFromFirstDoStatement();
                    while (level.getChildCount() != 0) {
                        PathElement ref2 = this.isNodeInLevel(level);
                        if (ref2 != null) {
                            this.addRefPseudoPathElement(level, ref2);
                            break block10;
                        }
                        level = this.getLastChildNode(level);
                    }
                    this.addNewPseudoPathElement(level, doBranch);
                }
            }
            if (!this.currentPath.isBranch()) break block11;
            level = this.stack;
            if (this.currentPath.isDoBranchNode()) {
                while (!this.equalsPseudoPathElementWithDoBranchNodeInLevel(level) && (level = this.getLastChildNode(level)).getChildCount() != 0) {
                }
                ref = this.getDoBranchNodeInLevel(level);
                if (ref != null) {
                    this.addNode(level, ref);
                } else {
                    this.addNewPathElement(level);
                }
            } else {
                while (level.getChildCount() != 0) {
                    ref = this.isNodeInLevel(level);
                    if (ref != null) {
                        this.addNode(level, ref);
                        break block11;
                    }
                    level = this.getLastChildNode(level);
                }
                this.addNewPathElement(level);
            }
        }
    }

    private void removeFromTree() {
        DefaultMutableTreeNode last = this.stack.getLastLeaf();
        if (last == null) {
            System.out.println("removeFromTree - last == null");
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)last.getParent();
        if (parent != null) {
            parent.remove(last);
        }
        if ((last = this.stack.getLastLeaf()) == null || last.getUserObject() == null) {
            return;
        }
        PathElement e = (PathElement)last.getUserObject();
        if (e != null && e.isPseudoPathElement()) {
            this.removeFromTree();
        }
    }

    private void addNewPathElement(DefaultMutableTreeNode level) {
        this.addNode(level, new PathElement(this.currentPath.getLast()));
    }

    private void addNewPseudoPathElement(DefaultMutableTreeNode level, IDataFlowNode ref) {
        this.addNode(level, new PathElement(this.currentPath.getLast(), ref));
    }

    private void addRefPseudoPathElement(DefaultMutableTreeNode level, PathElement ref) {
        this.addNode(level, ref);
    }

    private boolean equalsPseudoPathElementWithDoBranchNodeInLevel(DefaultMutableTreeNode level) {
        IDataFlowNode inode = this.currentPath.getLast();
        if (!inode.isType(41)) {
            return false;
        }
        int childCount = level.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)level.getChildAt(i);
            PathElement pe = (PathElement)child.getUserObject();
            if (pe == null || !pe.isPseudoPathElement() || !pe.pseudoRef.equals(inode)) continue;
            return true;
        }
        return false;
    }

    private PathElement getDoBranchNodeInLevel(DefaultMutableTreeNode level) {
        IDataFlowNode inode = this.currentPath.getLast();
        if (!inode.isType(41)) {
            return null;
        }
        int childCount = level.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)level.getChildAt(i);
            PathElement pe = (PathElement)child.getUserObject();
            if (!inode.equals(pe.node)) continue;
            return pe;
        }
        return null;
    }

    private void addNode(DefaultMutableTreeNode level, PathElement element) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        node.setUserObject(element);
        level.add(node);
    }

    private PathElement isNodeInLevel(DefaultMutableTreeNode level) {
        IDataFlowNode inode = this.currentPath.getLast();
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)level.getFirstChild();
        if (child != null) {
            PathElement levelElement = (PathElement)child.getUserObject();
            if (inode.equals(levelElement.node)) {
                return levelElement;
            }
        }
        return null;
    }

    private DefaultMutableTreeNode getLastChildNode(DefaultMutableTreeNode node) {
        if (node.getChildCount() != 0) {
            return (DefaultMutableTreeNode)node.getLastChild();
        }
        return node;
    }

    private int countLoops() {
        DefaultMutableTreeNode treeNode = this.stack.getLastLeaf();
        int counter = 0;
        if (treeNode.getParent() != null) {
            int childCount = treeNode.getParent().getChildCount();
            for (int i = 0; i < childCount; ++i) {
                DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)treeNode.getParent().getChildAt(i);
                PathElement e = (PathElement)tNode.getUserObject();
                if (e == null || e.isPseudoPathElement()) continue;
                ++counter;
            }
        }
        return counter;
    }

    private void incChild() {
        ++((PathElement)this.stack.getLastLeaf().getUserObject()).currentChild;
    }
}

