/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;

public abstract class AbstractRule
extends JavaParserVisitorAdapter
implements Rule {
    protected String name = this.getClass().getName();
    protected Properties properties = new Properties();
    protected String message;
    protected String description;
    protected String example;
    protected String ruleSetName;
    protected boolean include;
    protected boolean usesDFA;
    protected boolean usesTypeResolution;
    protected int priority = 5;
    protected String externalInfoUrl;
    private static final boolean inOldPropertyMode = true;

    protected static Map asFixedMap(PropertyDescriptor[] descriptors) {
        HashMap<String, PropertyDescriptor> descsById = new HashMap<String, PropertyDescriptor>(descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            descsById.put(descriptors[i].name(), descriptors[i]);
        }
        return Collections.unmodifiableMap(descsById);
    }

    protected static Map asFixedMap(PropertyDescriptor descriptor) {
        return AbstractRule.asFixedMap(new PropertyDescriptor[]{descriptor});
    }

    public String getRuleSetName() {
        return this.ruleSetName;
    }

    public void setRuleSetName(String ruleSetName) {
        this.ruleSetName = ruleSetName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void addProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public double[] getDoubleProperties(PropertyDescriptor descriptor) {
        Number[] values = (Number[])this.getProperties(descriptor);
        double[] doubles = new double[values.length];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = values[i].doubleValue();
        }
        return doubles;
    }

    public double getDoubleProperty(String name) {
        return Double.parseDouble(this.properties.getProperty(name));
    }

    public double getDoubleProperty(PropertyDescriptor descriptor) {
        return ((Number)this.getProperty(descriptor)).doubleValue();
    }

    public int[] getIntProperties(PropertyDescriptor descriptor) {
        Number[] values = (Number[])this.getProperties(descriptor);
        int[] ints = new int[values.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = values[i].intValue();
        }
        return ints;
    }

    public int getIntProperty(String name) {
        return Integer.parseInt(this.properties.getProperty(name));
    }

    public int getIntProperty(PropertyDescriptor descriptor) {
        return ((Number)this.getProperty(descriptor)).intValue();
    }

    public Class[] getTypeProperties(PropertyDescriptor descriptor) {
        return (Class[])this.getProperties(descriptor);
    }

    public Class getTypeProperty(PropertyDescriptor descriptor) {
        return (Class)this.getProperty(descriptor);
    }

    public boolean[] getBooleanProperties(PropertyDescriptor descriptor) {
        Boolean[] values = (Boolean[])this.getProperties(descriptor);
        boolean[] bools = new boolean[values.length];
        for (int i = 0; i < bools.length; ++i) {
            bools[i] = values[i];
        }
        return bools;
    }

    public boolean getBooleanProperty(PropertyDescriptor descriptor) {
        return (Boolean)this.getProperty(descriptor);
    }

    public boolean getBooleanProperty(String name) {
        return Boolean.valueOf(this.properties.getProperty(name));
    }

    public void setBooleanProperty(String name, boolean flag) {
        this.properties.setProperty(name, Boolean.toString(flag));
    }

    public String[] getStringProperties(PropertyDescriptor descriptor) {
        return (String[])this.getProperties(descriptor);
    }

    public String getStringProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getStringProperty(PropertyDescriptor descriptor) {
        return (String)this.getProperty(descriptor);
    }

    private Object getProperty(PropertyDescriptor descriptor) {
        String rawValue;
        if (descriptor.maxValueCount() > 1) {
            this.propertyGetError(descriptor, true);
        }
        return (rawValue = this.properties.getProperty(descriptor.name())) == null || rawValue.length() == 0 ? descriptor.defaultValue() : descriptor.valueFrom(rawValue);
    }

    public void setProperty(PropertyDescriptor descriptor, Object value) {
        if (descriptor.maxValueCount() > 1) {
            this.propertySetError(descriptor, true);
        }
        this.properties.setProperty(descriptor.name(), descriptor.asDelimitedString(value));
    }

    private Object[] getProperties(PropertyDescriptor descriptor) {
        String rawValue;
        if (descriptor.maxValueCount() == 1) {
            this.propertyGetError(descriptor, false);
        }
        return (rawValue = this.properties.getProperty(descriptor.name())) == null || rawValue.length() == 0 ? (Object[])descriptor.defaultValue() : (Object[])descriptor.valueFrom(rawValue);
    }

    public void setProperties(PropertyDescriptor descriptor, Object[] values) {
        if (descriptor.maxValueCount() == 1) {
            this.propertySetError(descriptor, false);
        }
        this.properties.setProperty(descriptor.name(), descriptor.asDelimitedString(values));
    }

    private void propertyGetError(PropertyDescriptor descriptor, boolean requestedSingleValue) {
        if (requestedSingleValue) {
            throw new RuntimeException("Cannot retrieve a single value from a multi-value property field");
        }
        throw new RuntimeException("Cannot retrieve multiple values from a single-value property field");
    }

    private void propertySetError(PropertyDescriptor descriptor, boolean setSingleValue) {
        if (setSingleValue) {
            throw new RuntimeException("Cannot set a single value within a multi-value property field");
        }
        throw new RuntimeException("Cannot set multiple values within a single-value property field");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getExternalInfoUrl() {
        return this.externalInfoUrl;
    }

    public void setExternalInfoUrl(String url) {
        this.externalInfoUrl = url;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Rule rule = null;
        boolean equality = this.getClass().getName().equals(o.getClass().getName());
        if (equality) {
            rule = (Rule)o;
            equality = this.getName().equals(rule.getName()) && this.getPriority() == rule.getPriority() && this.getProperties().equals(rule.getProperties());
        }
        return equality;
    }

    public int hashCode() {
        String s = this.getClass().getName() + this.getName() + this.getPriority() + this.getProperties().toString();
        return s.hashCode();
    }

    public void apply(List acus, RuleContext ctx) {
        this.visitAll(acus, ctx);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean include() {
        return this.include;
    }

    public void setInclude(boolean include) {
        this.include = include;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getPriorityName() {
        return PRIORITIES[this.getPriority() - 1];
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setUsesDFA() {
        this.usesDFA = true;
    }

    public boolean usesDFA() {
        return this.usesDFA;
    }

    public void setUsesTypeResolution() {
        this.usesTypeResolution = true;
    }

    public boolean usesTypeResolution() {
        return this.usesTypeResolution;
    }

    protected void visitAll(List acus, RuleContext ctx) {
        Iterator i = acus.iterator();
        while (i.hasNext()) {
            ASTCompilationUnit node = (ASTCompilationUnit)i.next();
            this.visit(node, (Object)ctx);
        }
    }

    protected final void addViolation(Object data, SimpleNode node) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node));
    }

    protected final void addViolationWithMessage(Object data, SimpleNode node, String msg) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node, msg));
    }

    protected final void addViolation(Object data, SimpleNode node, String embed) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node, MessageFormat.format(this.getMessage(), embed)));
    }

    protected final void addViolation(Object data, Node node, Object[] args) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, (SimpleNode)node, MessageFormat.format(this.getMessage(), args)));
    }

    protected final String getDeclaringType(SimpleNode node) {
        ASTClassOrInterfaceDeclaration c = (ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        if (c != null) {
            return c.getImage();
        }
        return null;
    }

    public static boolean isQualifiedName(SimpleNode node) {
        return node.getImage().indexOf(46) != -1;
    }

    public static boolean importsPackage(ASTCompilationUnit node, String packageName) {
        List nodes = node.findChildrenOfType(ASTImportDeclaration.class);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            ASTImportDeclaration n = (ASTImportDeclaration)i.next();
            if (!n.getPackageName().startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    protected Map propertiesByName() {
        return Collections.EMPTY_MAP;
    }

    public PropertyDescriptor propertyDescriptorFor(String propertyName) {
        PropertyDescriptor desc = (PropertyDescriptor)this.propertiesByName().get(propertyName);
        if (desc == null) {
            throw new IllegalArgumentException("unknown property: " + propertyName);
        }
        return desc;
    }
}

