/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.Set;
import net.sourceforge.pmd.properties.AbstractSingleValueProperty;
import net.sourceforge.pmd.properties.ValueParser;
import net.sourceforge.pmd.properties.constraints.PropertyConstraint;

final class GenericPropertyDescriptor<T>
extends AbstractSingleValueProperty<T> {
    private final ValueParser<T> parser;
    private final Class<T> type;
    private final Set<PropertyConstraint<? super T>> constraints;

    GenericPropertyDescriptor(String name, String description, float uiOrder, T defaultValue, Set<PropertyConstraint<? super T>> constraints, ValueParser<T> parser, boolean isDefinedExternally, Class<T> type) {
        super(name, description, defaultValue, uiOrder, isDefinedExternally);
        this.constraints = constraints;
        this.parser = parser;
        this.type = type;
        String dftValueError = this.errorFor(defaultValue);
        if (dftValueError != null) {
            throw new IllegalArgumentException(dftValueError);
        }
    }

    @Override
    public String errorFor(T value) {
        for (PropertyConstraint<T> validator : this.constraints) {
            String error = validator.validate(value);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    @Override
    protected T createFrom(String toParse) {
        return this.parser.valueOf(toParse);
    }
}

