/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.common.collect.MoreIterables;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.Set;

public class FutureContextRule
implements AnnotationContextRule {
    private static final FutureContextRule INSTANCE = new FutureContextRule();
    private static final Set<Equivalence.Wrapper<TypeInfo>> SUPPORTED_TYPES = TypeInfoEquivalence.wrapAll(Sets.newHashSet(TypeInfos.INTEGER, TypeInfos.LONG, TypeInfos.DOUBLE, TypeInfos.DECIMAL, TypeInfos.TIME, TypeInfos.DATE, TypeInfos.DATE_TIME, TypeInfos.BOOLEAN, TypeInfos.STRING, TypeInfos.ID, TypeInfos.BLOB));
    private static final TypeInfoVisitor<Boolean> PARAMETER_TYPE_VISITOR = new TypeInfoVisitor.Default<Boolean>(){

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(ScalarTypeInfo type) {
            return SUPPORTED_TYPES.contains(type.getEquivalenceWrapper());
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            return CollectionTypeInfoUtil.isMapOrCollection(type) && MoreIterables.ensureNone(type.getTypeArguments(), argumentType -> !SUPPORTED_TYPES.contains(argumentType.getEquivalenceWrapper()));
        }
    };
    private static final TypeInfoVisitor<Boolean> RETURN_TYPE_VISITOR = new TypeInfoVisitor.Default<Boolean>(){

        @Override
        protected Boolean _default(TypeInfo type) {
            return type.equals(TypeInfos.VOID);
        }
    };

    private FutureContextRule() {
    }

    public static FutureContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
        AnnotationRuleUtil.validate(context, AnnotationTypeInfos.FUTURE, PARAMETER_TYPE_VISITOR, RETURN_TYPE_VISITOR);
    }

    @Override
    public void validate(FieldContext context) {
        throw new UnexpectedCodePathException();
    }

    @Override
    public void validate(TypeContext context) {
        throw new UnexpectedCodePathException();
    }
}

