/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClassOrInterface;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.ast.ASTUserTrigger;
import net.sourceforge.pmd.lang.ast.QualifiedName;
import org.apache.commons.lang3.StringUtils;

public final class ApexQualifiedName
implements QualifiedName {
    private final String nameSpace;
    private final String[] classes;
    private final String operation;

    private ApexQualifiedName(String nameSpace, String[] classes, String operation) {
        this.nameSpace = nameSpace;
        this.operation = operation;
        this.classes = classes;
    }

    public String getOperation() {
        return this.operation;
    }

    public String[] getClasses() {
        return Arrays.copyOf(this.classes, this.classes.length);
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public boolean isClass() {
        return this.operation == null;
    }

    public boolean isOperation() {
        return this.operation != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nameSpace).append("__");
        sb.append(this.classes[0]);
        if (this.classes.length > 1) {
            sb.append('.').append(this.classes[1]);
        }
        if (this.isOperation()) {
            sb.append("#").append(this.operation);
        }
        return sb.toString();
    }

    public ApexQualifiedName getClassName() {
        if (this.isClass()) {
            return this;
        }
        return new ApexQualifiedName(this.nameSpace, this.classes, null);
    }

    public int hashCode() {
        int result = this.nameSpace.hashCode();
        result = 31 * result + Arrays.hashCode(this.classes);
        result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof ApexQualifiedName && Objects.deepEquals(this.classes, ((ApexQualifiedName)obj).classes) && Objects.equals(this.operation, ((ApexQualifiedName)obj).operation) && Objects.equals(this.nameSpace, ((ApexQualifiedName)obj).nameSpace);
    }

    public static ApexQualifiedName ofString(String toParse) {
        throw new UnsupportedOperationException();
    }

    static ApexQualifiedName ofOuterClass(ASTUserClassOrInterface<?> astUserClass) {
        String ns = astUserClass.getNamespace();
        String[] classes = new String[]{astUserClass.getImage()};
        return new ApexQualifiedName(StringUtils.isEmpty((CharSequence)ns) ? "c" : ns, classes, null);
    }

    static ApexQualifiedName ofNestedClass(ApexQualifiedName parent, ASTUserClassOrInterface astUserClass) {
        String[] classes = Arrays.copyOf(parent.classes, parent.classes.length + 1);
        classes[classes.length - 1] = astUserClass.getImage();
        return new ApexQualifiedName(parent.nameSpace, classes, null);
    }

    static ApexQualifiedName ofOuterEnum(ASTUserEnum astUserEnum) {
        String ns = astUserEnum.getNamespace();
        String[] classes = new String[]{astUserEnum.getImage()};
        return new ApexQualifiedName(StringUtils.isEmpty((CharSequence)ns) ? "c" : ns, classes, null);
    }

    static ApexQualifiedName ofNestedEnum(ApexQualifiedName parent, ASTUserEnum astUserEnum) {
        String[] classes = Arrays.copyOf(parent.classes, parent.classes.length + 1);
        classes[classes.length - 1] = astUserEnum.getImage();
        return new ApexQualifiedName(parent.nameSpace, classes, null);
    }

    private static String getOperationString(ASTMethod node) {
        StringBuilder sb = new StringBuilder();
        sb.append(node.getImage()).append('(');
        List paramTypes = ((Method)node.node).getMethodInfo().getParameterTypes();
        if (!paramTypes.isEmpty()) {
            sb.append(((TypeInfo)paramTypes.get(0)).getApexName());
            for (int i = 1; i < paramTypes.size(); ++i) {
                sb.append(", ").append(((TypeInfo)paramTypes.get(i)).getApexName());
            }
        }
        sb.append(')');
        return sb.toString();
    }

    static ApexQualifiedName ofMethod(ASTMethod node) {
        ASTUserEnum enumParent = (ASTUserEnum)node.getFirstParentOfType(ASTUserEnum.class);
        if (enumParent != null) {
            ApexQualifiedName baseName = enumParent.getQualifiedName();
            return new ApexQualifiedName(baseName.nameSpace, baseName.classes, ApexQualifiedName.getOperationString(node));
        }
        ASTUserClassOrInterface classParent = (ASTUserClassOrInterface)node.getFirstParentOfType(ASTUserClassOrInterface.class);
        if (classParent != null) {
            ApexQualifiedName baseName = classParent.getQualifiedName();
            return new ApexQualifiedName(baseName.nameSpace, baseName.classes, ApexQualifiedName.getOperationString(node));
        }
        ASTUserTrigger triggerParent = (ASTUserTrigger)node.getFirstParentOfType(ASTUserTrigger.class);
        if (triggerParent != null) {
            String ns = triggerParent.getNamespace();
            String targetObj = triggerParent.getTargetName();
            return new ApexQualifiedName(StringUtils.isEmpty((CharSequence)ns) ? "c" : ns, new String[]{"trigger", targetObj}, triggerParent.getImage());
        }
        throw new UnsupportedOperationException();
    }
}

