/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class OldModifiers {
    private static final Map<ModifierOrAnnotationTypeInfo, ModifierType> NEW_TO_OLD_MAPPING = ImmutableMap.builder().put(ModifierTypeInfos.TEST_METHOD, ModifierType.TestMethod).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.IS_TEST), ModifierType.TestMethod).put(ModifierTypeInfos.PUBLIC, ModifierType.PublicIdentifier).put(ModifierTypeInfos.WEB_SERVICE, ModifierType.WebService).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.AURA_ENABLED), ModifierType.AuraEnabled).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.READ_ONLY), ModifierType.ReadOnly).put(ModifierTypeInfos.FINAL, ModifierType.FinalIdentifier).put(ModifierTypeInfos.PRIVATE, ModifierType.PrivateIdentifier).put(ModifierTypeInfos.PROTECTED, ModifierType.ProtectedIdentifier).put(ModifierTypeInfos.ABSTRACT, ModifierType.AbstractIdentifier).put(ModifierTypeInfos.OVERRIDE, ModifierType.MethodOverrides).put(ModifierTypeInfos.STATIC, ModifierType.StaticIdentifier).put(ModifierTypeInfos.VIRTUAL, ModifierType.VirtualIdentifier).put(ModifierTypeInfos.GLOBAL, ModifierType.GlobalIdentifier).put(ModifierTypeInfos.WITH_SHARING, ModifierType.WithSharing).put(ModifierTypeInfos.WITHOUT_SHARING, ModifierType.WithoutSharing).put(ModifierTypeInfos.TRANSIENT, ModifierType.TransientIdentifier).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.FUTURE), ModifierType.Future).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.DEPRECATED), ModifierType.Deprecated).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.ALLOW_CERTIFIED_APEX), ModifierType.AllowCertifiedApex).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.HIDDEN_FROM_DOC), ModifierType.HiddenFromDoc).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.REMOTE_ACTION), ModifierType.RemoteAction).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.REST_RESOURCE), ModifierType.RestResource).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.HTTP_GET), ModifierType.HttpGet).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.HTTP_POST), ModifierType.HttpPost).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.HTTP_PUT), ModifierType.HttpPut).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.HTTP_PATCH), ModifierType.HttpPatch).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.HTTP_DELETE), ModifierType.HttpDelete).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.VISIBLE_API_VERSION), ModifierType.VisibleApiVersion).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.USE_CONNECT_SERIALIZER), ModifierType.UseConnectSerializer).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.USE_CONNECT_DESERIALIZER), ModifierType.UseConnectDeserializer).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.INVOCABLE_METHOD), ModifierType.InvocableMethod).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.INVOCABLE_VARIABLE), ModifierType.InvocableVariable).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.TEST_VISIBLE), ModifierType.TestVisible).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.TEST_SETUP), ModifierType.TestSetup).put((ModifierTypeInfo)((Object)AnnotationTypeInfos.NAMESPACE_ACCESSIBLE), ModifierType.NamespaceAccessible).build();
    private long modifiers = 0L;

    private OldModifiers() {
    }

    public static OldModifiers fromModifiers(ModifierGroup modifiers) {
        OldModifiers oldModifiers = new OldModifiers();
        for (ModifierOrAnnotationTypeInfo modifier : modifiers.all()) {
            ModifierType type = NEW_TO_OLD_MAPPING.get(modifier);
            if (type != null) {
                oldModifiers.set(type);
            }
            if (modifier == AnnotationTypeInfos.SFDC_ONLY && modifiers.get(AnnotationTypeInfos.SFDC_ONLY).getParameter("value").getBooleanValue().booleanValue()) {
                oldModifiers.set(ModifierType.SfdcOnly);
            }
            if (modifier == AnnotationTypeInfos.FUTURE && modifiers.get(AnnotationTypeInfos.FUTURE).getParameter("callout").getBooleanValue().booleanValue()) {
                oldModifiers.set(ModifierType.FutureCallout);
            }
            if (modifier == AnnotationTypeInfos.REMOTE_ACTION && modifiers.get(AnnotationTypeInfos.REMOTE_ACTION).getParameter("callout").getBooleanValue().booleanValue()) {
                oldModifiers.set(ModifierType.RemoteActionCallout);
            }
            if (modifier == AnnotationTypeInfos.TEST_SETUP && modifiers.get(AnnotationTypeInfos.TEST_SETUP).getParameter("onInstall").getBooleanValue().booleanValue()) {
                oldModifiers.set(ModifierType.OnInstallTestSetup);
            }
            if (modifier != AnnotationTypeInfos.IS_TEST) continue;
            ModifierOrAnnotation annotation = modifiers.get(AnnotationTypeInfos.IS_TEST);
            if (annotation.getParameter("onInstall").getBooleanValue().booleanValue()) {
                oldModifiers.set(ModifierType.OnInstallTestMethod);
            }
            if (annotation.getParameter("isParallel").getBooleanValue().booleanValue()) {
                oldModifiers.set(ModifierType.IsParallel);
            }
            if (!annotation.getParameter("seeAllData").getBooleanValue().booleanValue()) continue;
            oldModifiers.set(ModifierType.SeeAllData);
        }
        return oldModifiers;
    }

    public void set(ModifierType bit) {
        this.modifiers |= 1L << bit.ordinal();
    }

    public boolean get(ModifierType bit) {
        return (this.modifiers & 1L << bit.ordinal()) != 0L;
    }

    public long getModifiers() {
        return this.modifiers;
    }

    public static enum ModifierType {
        TestMethod,
        PublicIdentifier,
        WebService,
        AuraEnabled(true),
        ReadOnly(true),
        FinalIdentifier,
        PrivateIdentifier,
        ProtectedIdentifier,
        AbstractIdentifier,
        MethodOverrides,
        StaticIdentifier,
        VirtualIdentifier,
        GlobalIdentifier,
        WithSharing,
        WithoutSharing,
        TransientIdentifier,
        Future(true),
        PublicGetter,
        PrivateGetter,
        GlobalGetter,
        LegacyDefaultVisibilityGetter,
        PublicSetter,
        PrivateSetter,
        GlobalSetter,
        LegacyDefaultVisibilitySetter,
        FutureCallout,
        ProtectedGetter,
        ProtectedSetter,
        Deprecated(true),
        Constructable,
        SfdcOnly(true),
        PrivateApi(true),
        AllowCertifiedApex(true),
        HiddenFromDoc(true),
        RemoteAction(true),
        RestResource(true),
        HttpGet(true),
        HttpPost(true),
        HttpPut(true),
        HttpPatch(true),
        HttpDelete(true),
        SeeAllData,
        OnInstallTestSetup,
        OnInstallTestMethod,
        DisplayLabel,
        ScheduleAccess,
        Schedulable,
        Batchable,
        MessageSetName,
        VisibleApiVersion(true),
        MinApiVersion,
        MaxApiVersion,
        UseConnectSerializer(true),
        UseConnectDeserializer(true),
        InvocableMethod(true),
        InvocableVariable(true),
        TestVisible(true),
        TestSetup(true),
        IsParallel(true),
        RemoteActionCallout,
        NamespaceAccessible(true);

        public final boolean isAnnotation;

        private ModifierType() {
            this(false);
        }

        private ModifierType(boolean annotation) {
            this.isAnnotation = annotation;
        }
    }
}

