/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.xml.XmlParserOptions;
import net.sourceforge.pmd.lang.xml.ast.DOMLineNumbers;
import net.sourceforge.pmd.lang.xml.ast.XmlNode;
import net.sourceforge.pmd.lang.xml.ast.XmlNodeWrapper;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParser {
    protected final XmlParserOptions parserOptions;
    protected Map<Node, XmlNode> nodeCache = new HashMap<Node, XmlNode>();

    public XmlParser(XmlParserOptions parserOptions) {
        this.parserOptions = parserOptions;
    }

    protected Document parseDocument(Reader reader) throws ParseException {
        this.nodeCache.clear();
        try {
            String xmlData = IOUtils.toString((Reader)reader);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(this.parserOptions.isNamespaceAware());
            dbf.setValidating(this.parserOptions.isValidating());
            dbf.setIgnoringComments(this.parserOptions.isIgnoringComments());
            dbf.setIgnoringElementContentWhitespace(this.parserOptions.isIgnoringElementContentWhitespace());
            dbf.setExpandEntityReferences(this.parserOptions.isExpandEntityReferences());
            dbf.setCoalescing(this.parserOptions.isCoalescing());
            dbf.setXIncludeAware(this.parserOptions.isXincludeAware());
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            documentBuilder.setEntityResolver(this.parserOptions.getEntityResolver());
            Document document = documentBuilder.parse(new InputSource(new StringReader(xmlData)));
            DOMLineNumbers lineNumbers = new DOMLineNumbers(document, xmlData);
            lineNumbers.determine();
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public XmlNode parse(Reader reader) {
        Document document = this.parseDocument(reader);
        RootXmlNode root = new RootXmlNode(this, document);
        this.nodeCache.put(document, root);
        return root;
    }

    XmlNode wrapDomNode(Node domNode) {
        XmlNode wrapper = this.nodeCache.get(domNode);
        if (wrapper == null) {
            wrapper = new XmlNodeWrapper(this, domNode);
            this.nodeCache.put(domNode, wrapper);
        }
        return wrapper;
    }

    public static class RootXmlNode
    extends XmlNodeWrapper
    implements RootNode {
        RootXmlNode(XmlParser parser, Document domNode) {
            super(parser, domNode);
        }

        @Override
        public XmlNode wrap(Node domNode) {
            return super.wrap(domNode);
        }

        @Override
        public Document getNode() {
            return (Document)super.getNode();
        }
    }
}

