/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors.codeActions;

import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.impl.codeActions.CodeActionValidations;
import apex.jorje.lsp.impl.visitors.codeActions.MissingMethodScope;
import apex.jorje.lsp.impl.visitors.codeActions.ParameterPlaceholderVisitor;
import apex.jorje.semantic.ast.expression.AssignmentExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import com.google.inject.Inject;

public class DeclareMissingMethodVisitor
extends AstVisitor<MissingMethodScope> {
    private final VisitorFactory visitorFactory;

    @Inject
    DeclareMissingMethodVisitor(VisitorFactory visitorFactory) {
        this.visitorFactory = visitorFactory;
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(MethodCallExpression methodCall, MissingMethodScope scope) {
        super.visitEnd(methodCall, scope);
        if (scope.isSelectionInNode(methodCall) && CodeActionValidations.canDeclareMethod(methodCall)) {
            scope.setMethodCall(methodCall);
            methodCall.getDefiningNode().traverse(new AstVisitor<MissingMethodScope>(){

                @Override
                protected boolean defaultVisit() {
                    return true;
                }

                @Override
                public void visitEnd(VariableDeclaration node, MissingMethodScope scope) {
                    scope.setReturnType(node.getTypeInfoUsed());
                }

                @Override
                public void visitEnd(AssignmentExpression node, MissingMethodScope scope) {
                    scope.setReturnType(node.getLeft().getType());
                }

                @Override
                public void visitEnd(FieldDeclaration node, MissingMethodScope scope) {
                    scope.setReturnType(node.getTypeInfoUsed());
                }
            }, scope);
            ParameterPlaceholderVisitor placeholderVisitor = this.visitorFactory.createParameterPlaceholderVisitor();
            for (Expression e : methodCall.getInputParameters()) {
                e.traverse(placeholderVisitor, scope);
            }
        }
    }
}

