/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.symbols;

import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.symbols.CachingSymbolProvider;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.index.symbol.VirtualSObjectTypeInfo;
import apex.jorje.lsp.impl.index.symbol.VirtualStandardTypeInfo;
import apex.jorje.lsp.impl.utils.TypeInfoCache;
import apex.jorje.semantic.common.TestFlowInterviewTypeInfos;
import apex.jorje.semantic.common.TestSObjectTypeInfos;
import apex.jorje.semantic.common.TestVfTypeInfos;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.common.DynamicTypeNameFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreMaps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.jdt.internal.core.nd.IReader;

@Singleton
public class ApexSymbolProvider
implements CachingSymbolProvider {
    private final ApexCompilerService compilerService;
    private static final Map<String, TypeInfo> FLOW_INTERVIEW_TYPES = TypeInfoTables.bytecodeNameMap(TestFlowInterviewTypeInfos.class, TypeInfo.class);
    private static final Map<String, SObjectTypeInfo> SOBJECT_TYPES = MoreMaps.toImmutableCaseInsensitiveMap(ImmutableMap.builder().put(TestSObjectTypeInfos.ACCOUNT.getApexName(), TestSObjectTypeInfos.ACCOUNT).put(TestSObjectTypeInfos.AGGREGATE_RESULT.getApexName(), TestSObjectTypeInfos.AGGREGATE_RESULT).put(TestSObjectTypeInfos.USER.getApexName(), TestSObjectTypeInfos.USER).put(TestSObjectTypeInfos.BUSINESS_HOURS.getApexName(), TestSObjectTypeInfos.BUSINESS_HOURS).put(TestSObjectTypeInfos.USER_PREFERENCE.getApexName(), TestSObjectTypeInfos.USER_PREFERENCE).put(TestSObjectTypeInfos.USER_PROFILE_FEED.getApexName(), TestSObjectTypeInfos.USER_PROFILE_FEED).put(TestSObjectTypeInfos.OPPORTUNITY.getApexName(), TestSObjectTypeInfos.OPPORTUNITY).put(TestSObjectTypeInfos.CASE.getApexName(), TestSObjectTypeInfos.CASE).put(TestSObjectTypeInfos.NAME.getApexName(), TestSObjectTypeInfos.NAME).put(TestSObjectTypeInfos.CONTACT.getApexName(), TestSObjectTypeInfos.CONTACT).put(TestSObjectTypeInfos.KNOWLEDGE_ARTICLE_VERSION.getApexName(), TestSObjectTypeInfos.KNOWLEDGE_ARTICLE_VERSION).put(TestSObjectTypeInfos.LEAD.getApexName(), TestSObjectTypeInfos.LEAD).build());
    private static final Map<String, TypeInfo> VF_COMPONENT_TYPES = TypeInfoTables.bytecodeNameMap(TestVfTypeInfos.class, TypeInfo.class);
    private final Map<String, SObjectTypeInfo> availableSObjectTypes;
    private final SetMultimap<Namespace, String> labels;
    private final Map<String, String> pageReferences;
    private final Provider<ApexIndex> apexIndexProvider;

    @Inject
    public ApexSymbolProvider(Provider<ApexIndex> apexIndexProvider, ApexCompilerService compilerService) {
        this.apexIndexProvider = apexIndexProvider;
        this.compilerService = compilerService;
        this.availableSObjectTypes = MoreMaps.newCaseInsensitiveMap();
        this.labels = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
        this.pageReferences = MoreMaps.newCaseInsensitiveMap();
    }

    @Override
    @Nullable
    public TypeInfo find(SymbolResolver symbols, TypeInfo referencingType, String fullName) {
        String fullNameLower = fullName.toLowerCase();
        String apexName = fullNameLower.replaceAll("/", ".").replaceAll("\\$", ".");
        if (fullNameLower.startsWith("java/") || fullNameLower.startsWith("com/salesforce/") || fullNameLower.startsWith("com/force/")) {
            return null;
        }
        TypeInfo typeInfo = TypeInfoCache.getTypeInfo(apexName);
        if (typeInfo != null) {
            return typeInfo;
        }
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        try (IReader ignored = apexIndex.getNd().acquireReadLock();){
            ApexTypeId typeId = this.getTypeIdDependentOnNamespace(apexName, referencingType, apexIndex);
            if (typeId != null && typeId.getType() != null) {
                if (!typeId.getType().isSObject()) {
                    Object t = new VirtualStandardTypeInfo.Builder(symbols, this.apexIndexProvider).setApexTypeId(typeId).buildResolved();
                    return t;
                }
                VirtualSObjectTypeInfo info = (VirtualSObjectTypeInfo)new VirtualSObjectTypeInfo.Builder(symbols, this.apexIndexProvider).setApexTypeId(typeId).buildResolved();
                this.availableSObjectTypes.put(apexName, info);
                VirtualSObjectTypeInfo virtualSObjectTypeInfo = info;
                return virtualSObjectTypeInfo;
            }
        }
        return null;
    }

    private ApexTypeId getTypeIdDependentOnNamespace(String apexName, TypeInfo referencingType, ApexIndex apexIndex) {
        ApexTypeId typeId = apexIndex.findExactTypeId(apexName);
        if (typeId == null && referencingType != null) {
            String possibleFullName = String.join((CharSequence)"__", referencingType.getNamespace().toString(), apexName);
            typeId = apexIndex.findExactTypeId(possibleFullName);
        }
        return typeId;
    }

    @Override
    public TypeInfo getVfComponentType(SymbolResolver symbols, TypeInfo referencingType, Namespace namespace, String name) {
        String fullName = DynamicTypeNameFactory.createVfComponentBytecodeName(namespace, name);
        return VF_COMPONENT_TYPES.get(fullName);
    }

    @Override
    public TypeInfo getFlowInterviewType(SymbolResolver symbols, TypeInfo referencingType, Namespace namespace, String name) {
        String fullName = DynamicTypeNameFactory.createFlowInterviewBytecodeName(namespace, name);
        return FLOW_INTERVIEW_TYPES.get(fullName);
    }

    @Override
    public TypeInfo getSObjectType(TypeInfo referencingType, String name) {
        SObjectTypeInfo info = Optional.ofNullable(this.availableSObjectTypes.get(name)).orElse(SOBJECT_TYPES.get(name));
        if (info == null) {
            ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
            try (IReader ignored = apexIndex.getNd().acquireReadLock();){
                ApexTypeId typeId = this.getTypeIdDependentOnNamespace(name, referencingType, apexIndex);
                if (typeId != null && typeId.getType() != null && typeId.getType().isSObject()) {
                    info = (SObjectTypeInfo)new VirtualSObjectTypeInfo.Builder(this.compilerService.getSymbolResolver(), this.apexIndexProvider).setApexTypeId(typeId).buildResolved();
                    this.availableSObjectTypes.put(name, info);
                }
            }
        }
        return info;
    }

    @Override
    public TypeInfo getAggregateResultType(TypeInfo referencingType) {
        return TestSObjectTypeInfos.AGGREGATE_RESULT;
    }

    @Override
    public String getPageReference(TypeInfo referencingType, String name) {
        return this.pageReferences.get(name);
    }

    @Override
    public boolean hasLabelField(TypeInfo referencingType, Namespace namespace, String name) {
        return this.labels.get((Object)namespace).contains(name);
    }

    @Override
    public String getQuickAction(TypeInfo referencingType, String entity, String name) {
        return null;
    }

    @Override
    public void invalidate(String lowerCaseApexName) {
        TypeInfoCache.invalidate(lowerCaseApexName);
        this.availableSObjectTypes.remove(lowerCaseApexName);
    }

    @Override
    public void invalidateAll() {
        TypeInfoCache.invalidateAll();
        this.availableSObjectTypes.clear();
    }

    @VisibleForTesting
    public Map<String, TypeInfo> getUserDefinedTypes() {
        return TypeInfoCache.getUserDefinedTypes();
    }

    @VisibleForTesting
    Map<String, TypeInfo> getBuiltInTypes() {
        return TypeInfoCache.getBuiltInTypes();
    }

    @Override
    public boolean isDynamicTypeNamespace(String namespace) {
        return false;
    }

    @Override
    public boolean isDynamicTypeNamespace(String namespace, String module) {
        return false;
    }
}

