/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl.validators;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;

public class SObjectCollectionValidator
implements BuiltInMethodValidator {
    private static final BuiltInMethodValidator INSTANCE = new SObjectCollectionValidator();

    private SObjectCollectionValidator() {
    }

    public static BuiltInMethodValidator get() {
        return INSTANCE;
    }

    @Override
    public void validate(SymbolResolver symbols, final ValidationScope scope, final MethodCallExpression expression) {
        expression.getMethod().get().getDefiningType().accept(new TypeInfoVisitor.Default<Void>(){

            @Override
            protected Void _default(TypeInfo type) {
                return null;
            }

            @Override
            public Void visit(GenericTypeInfo type) {
                if (CollectionTypeInfoUtil.isMap(type) && CollectionTypeInfoUtil.getValueType(type).getBasicType() != BasicType.SOBJECT) {
                    scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("method.invalid.sobject.map", type));
                } else if (CollectionTypeInfoUtil.isList(type) && CollectionTypeInfoUtil.getElementType(type).getBasicType() != BasicType.SOBJECT) {
                    scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("method.invalid.sobject.list", type));
                }
                return null;
            }
        });
    }
}

