/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.common.base.Result;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.common.iterable.SuperTypeIterable;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.MoreSets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class PostTypeResolveVisitorUtil {
    PostTypeResolveVisitorUtil() {
    }

    static void validateOneAnnotationPerType(Compilation node, SymbolScope scope) {
        HashMap<StandardAnnotationTypeInfo, Integer> map = new HashMap<StandardAnnotationTypeInfo, Integer>();
        map.put(AnnotationTypeInfos.HTTP_DELETE, 0);
        map.put(AnnotationTypeInfos.HTTP_GET, 0);
        map.put(AnnotationTypeInfos.HTTP_PATCH, 0);
        map.put(AnnotationTypeInfos.HTTP_POST, 0);
        map.put(AnnotationTypeInfos.HTTP_PUT, 0);
        map.put(AnnotationTypeInfos.INVOCABLE_METHOD, 0);
        if (VersionUtil.get(node).isGreaterThanOrEqual(Version.V206)) {
            map.put(AnnotationTypeInfos.TEST_SETUP, 0);
        }
        HashMultimap<String, Integer> remoteActions = HashMultimap.create();
        Set<String> webServices = MoreSets.newCaseInsensitiveSet();
        Errors errors = scope.getErrors();
        for (MethodInfo methodInfo : node.getDefiningType().methods().all()) {
            if (methodInfo.getGenerated() != Generated.USER) continue;
            ModifierGroup modifiers = methodInfo.getModifiers();
            if (modifiers.has(AnnotationTypeInfos.HTTP_GET)) {
                map.computeIfPresent(AnnotationTypeInfos.HTTP_GET, (x, y) -> y + 1);
            } else if (modifiers.has(AnnotationTypeInfos.HTTP_POST)) {
                map.computeIfPresent(AnnotationTypeInfos.HTTP_POST, (x, y) -> y + 1);
            } else if (modifiers.has(AnnotationTypeInfos.HTTP_PUT)) {
                map.computeIfPresent(AnnotationTypeInfos.HTTP_PUT, (x, y) -> y + 1);
            } else if (modifiers.has(AnnotationTypeInfos.HTTP_PATCH)) {
                map.computeIfPresent(AnnotationTypeInfos.HTTP_PATCH, (x, y) -> y + 1);
            } else if (modifiers.has(AnnotationTypeInfos.HTTP_DELETE)) {
                map.computeIfPresent(AnnotationTypeInfos.HTTP_DELETE, (x, y) -> y + 1);
            }
            if (modifiers.has(AnnotationTypeInfos.INVOCABLE_METHOD)) {
                map.computeIfPresent(AnnotationTypeInfos.INVOCABLE_METHOD, (x, y) -> y + 1);
            }
            if (modifiers.has(AnnotationTypeInfos.TEST_SETUP)) {
                map.computeIfPresent(AnnotationTypeInfos.TEST_SETUP, (x, y) -> y + 1);
            }
            if (modifiers.has(AnnotationTypeInfos.REMOTE_ACTION)) {
                if (remoteActions.containsEntry(methodInfo.getName(), methodInfo.getParameters().size())) {
                    errors.markInvalid((AstNode)node, I18nSupport.getLabel("duplicate.remote.action.methods"));
                } else {
                    remoteActions.put(methodInfo.getName(), methodInfo.getParameters().size());
                }
            }
            if (!modifiers.has(ModifierTypeInfos.WEB_SERVICE) || webServices.add(methodInfo.getName())) continue;
            errors.markInvalid((AstNode)node, I18nSupport.getLabel("duplicate.web.service.methods", methodInfo));
        }
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            errors.markInvalid((AstNode)node, I18nSupport.getLabel("invalid.multiple.methods.with.modifier", entry.getKey()));
        }
    }

    static void validateNoStaticMethodClashes(UserClass node, SymbolScope scope) {
        TypeInfo definingType = node.getDefiningType();
        block0: for (MethodInfo method : definingType.methods().getInstance()) {
            for (TypeInfo current : new SuperTypeIterable(definingType)) {
                Result<MethodInfo> result = current.methods().getApproximate(node.getDefiningType(), method.getSignature().getName(), method.getSignature().getParameterTypes(), MethodLookupMode.STATICS);
                if (scope.getErrors().addIfError(node, result)) continue block0;
                if (!result.isPresent() || MethodUtil.isInjectedCloneMethod(method) || !Visibility.isMethodVisible(scope.getSymbols().getAccessEvaluator(), node.getDefiningType(), result.get(), Visibility.ReferencedFromTestMethod.NO)) continue;
                scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("cannot.override.static.method", result.get().getSignature(), method.getSignature()));
                continue block0;
            }
        }
    }
}

