/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.ColonExpr;
import apex.jorje.data.soql.NumberClause;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.soql.ColonExprPrinter;
import java.util.Objects;

public class NumberClausePrinter
implements Printer<NumberClause> {
    private static final Printer<NumberClause> INSTANCE = new NumberClausePrinter(ColonExprPrinter.get());
    private final Printer<ColonExpr> colonExprPrinter;

    private NumberClausePrinter(Printer<ColonExpr> colonExprPrinter) {
        this.colonExprPrinter = colonExprPrinter;
    }

    public static Printer<NumberClause> get() {
        return INSTANCE;
    }

    @Override
    public String print(NumberClause x, final PrintContext ctx) {
        return x.match(new NumberClause.MatchBlock<String>(){

            @Override
            public String _case(NumberClause.NumberLiteral x) {
                return Objects.toString(x.number);
            }

            @Override
            public String _case(NumberClause.NumberExpr x) {
                return NumberClausePrinter.this.colonExprPrinter.print(x.expr, ctx);
            }
        });
    }
}

